/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.integration;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.impl.EntityMissingException;
import com.pluginpeople.confluence.csum.api.AuthorizationException;
import com.pluginpeople.confluence.csum.api.DuplicateException;
import com.pluginpeople.confluence.csum.api.GroupActionNotPermittedException;
import com.pluginpeople.confluence.csum.api.ITSpaceGroupUtil;
import com.pluginpeople.confluence.csum.api.SpaceGroupPatternMismatchException;
import com.pluginpeople.confluence.csum.util.SpaceGroupUtil;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Pair;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class ITSpaceGroupUtilImpl
implements ITSpaceGroupUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ITSpaceGroupUtilImpl.class);
    private final SpaceGroupUtil fUtil;
    private final TransactionTemplate fTxTemplate;
    private static final String IN_SPACE = " in space: ";

    @Autowired
    public ITSpaceGroupUtilImpl(SpaceGroupUtil util, @ComponentImport TransactionTemplate txTemplate) {
        this.fUtil = util;
        this.fTxTemplate = txTemplate;
    }

    public Group createGroup(Space space, String group) throws AuthorizationException, DuplicateException, GroupActionNotPermittedException, EntityException {
        Either result = (Either)this.fTxTemplate.execute(() -> {
            try {
                return Either.right((Object)this.fUtil.createSpaceGroup(space, group));
            }
            catch (EntityException | AuthorizationException | DuplicateException | GroupActionNotPermittedException e) {
                LOG.error("Could not create space group: " + (group != null ? group : "null") + IN_SPACE + (Serializable)(space != null ? space : "null"), e);
                return Either.left((Object)e);
            }
        });
        if (result.isLeft()) {
            Exception ex = (Exception)result.left().get();
            if (ex instanceof AuthorizationException) {
                throw (AuthorizationException)((Object)ex);
            }
            if (ex instanceof DuplicateException) {
                throw (DuplicateException)((Object)ex);
            }
            if (ex instanceof GroupActionNotPermittedException) {
                throw (GroupActionNotPermittedException)((Object)ex);
            }
            if (ex instanceof EntityException) {
                throw (EntityException)((Object)ex);
            }
        }
        return (Group)result.getOrNull();
    }

    public Space getSpaceForGroup(String group) {
        return (Space)this.fTxTemplate.execute(() -> this.fUtil.getSpaceForGroup(group));
    }

    public boolean isSpaceGroup(Space space, String group) {
        return this.fUtil.isSpaceGroup(space, group);
    }

    public boolean validateRenameGroup(Space space, String oldName) {
        return (Boolean)this.fTxTemplate.execute(() -> {
            try {
                return this.fUtil.validateRenameGroupIsAllowed(space, oldName);
            }
            catch (EntityException | AuthorizationException | GroupActionNotPermittedException | SpaceGroupPatternMismatchException e) {
                LOG.error("Could not rename space group: " + (oldName != null ? oldName : "null") + IN_SPACE + (Serializable)(space != null ? space : "null"), e);
                return false;
            }
        });
    }

    public boolean deleteGroup(Space space, String group) throws GroupActionNotPermittedException, EntityMissingException, AuthorizationException, SpaceGroupPatternMismatchException {
        Either result = (Either)this.fTxTemplate.execute(() -> {
            try {
                return Either.right((Object)this.fUtil.deleteSpaceGroup(space, group));
            }
            catch (Exception e) {
                LOG.error("Could not delete space group: " + (group != null ? group : "null") + IN_SPACE + (Serializable)(space != null ? space : "null"), (Throwable)e);
                return Either.left((Object)e);
            }
        });
        if (result.isLeft()) {
            Exception ex = (Exception)result.left().get();
            if (ex instanceof GroupActionNotPermittedException) {
                throw (GroupActionNotPermittedException)((Object)ex);
            }
            if (ex instanceof EntityMissingException) {
                throw (EntityMissingException)ex;
            }
            if (ex instanceof AuthorizationException) {
                throw (AuthorizationException)((Object)ex);
            }
            if (ex instanceof SpaceGroupPatternMismatchException) {
                throw (SpaceGroupPatternMismatchException)((Object)ex);
            }
        }
        return (Boolean)result.getOrNull();
    }

    public Pair<Map<String, String>, Map<String, String>> addUsersToGroups(Space space, String groups, String users) throws EntityMissingException, AuthorizationException, SpaceGroupPatternMismatchException {
        Either result = (Either)this.fTxTemplate.execute(() -> {
            try {
                return Either.left(this.fUtil.addUsersToGroups(space, groups, users, ""));
            }
            catch (Exception e) {
                LOG.error("Could not add users: " + (users != null ? users : "null") + ". to groups: " + (groups != null ? groups : "null") + IN_SPACE + (Serializable)(space != null ? space : "null"), (Throwable)e);
                return Either.right((Object)e);
            }
        });
        if (result.isRight()) {
            Exception ex = (Exception)result.right().get();
            if (ex instanceof EntityMissingException) {
                throw (EntityMissingException)ex;
            }
            if (ex instanceof AuthorizationException) {
                throw (AuthorizationException)((Object)ex);
            }
            if (ex instanceof SpaceGroupPatternMismatchException) {
                throw (SpaceGroupPatternMismatchException)((Object)ex);
            }
        }
        return (Pair)result.left().get();
    }

    public void removeUserFromGroup(Space space, String group, String user) throws EntityException, SpaceGroupPatternMismatchException, AuthorizationException {
        Option deleteException = (Option)this.fTxTemplate.execute(() -> {
            try {
                ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
                if (currentUser != null) {
                    this.fUtil.removeGroupMembers(space, group, user, "", currentUser);
                }
            }
            catch (EntityException | AuthorizationException | DuplicateException | SpaceGroupPatternMismatchException e) {
                LOG.error("Could not remove group members. group: " + group + "user: " + (user != null ? user : "null") + IN_SPACE + (Serializable)(space != null ? space : "null"), e);
                return Option.some((Object)e);
            }
            return Option.none();
        });
        if (deleteException.isDefined()) {
            Exception ex = (Exception)deleteException.get();
            if (ex instanceof SpaceGroupPatternMismatchException) {
                throw (SpaceGroupPatternMismatchException)((Object)ex);
            }
            if (ex instanceof AuthorizationException) {
                throw (AuthorizationException)((Object)ex);
            }
            if (ex instanceof EntityMissingException) {
                throw (EntityMissingException)ex;
            }
            if (ex instanceof EntityException) {
                throw (EntityException)((Object)ex);
            }
        }
    }

    public String getFullGroupName(Space space, String groupName) {
        return (String)this.fTxTemplate.execute(() -> this.fUtil.computeSpaceGroupName(space, groupName));
    }

    public List<User> getGroupMembers(Space space, String group) throws AuthorizationException, EntityException, SpaceGroupPatternMismatchException {
        Either result = (Either)this.fTxTemplate.execute(() -> {
            try {
                return Either.right(this.fUtil.getSpaceGroupMembers(space, group));
            }
            catch (EntityException | AuthorizationException | SpaceGroupPatternMismatchException e) {
                return Either.left((Object)e);
            }
        });
        if (result.isLeft()) {
            Exception exception = (Exception)result.left().get();
            if (exception instanceof AuthorizationException) {
                throw (AuthorizationException)((Object)exception);
            }
            if (exception instanceof EntityException) {
                throw (EntityException)((Object)exception);
            }
            if (exception instanceof SpaceGroupPatternMismatchException) {
                throw (SpaceGroupPatternMismatchException)((Object)exception);
            }
        }
        return (List)result.right().get();
    }

    public String[] getSpaceGroupsFromCache(Space space) throws AuthorizationException {
        Either result = (Either)this.fTxTemplate.execute(() -> {
            try {
                return Either.right((Object)this.fUtil.getSpaceGroupsFromCache(space));
            }
            catch (AuthorizationException e) {
                return Either.left((Object)((Object)e));
            }
        });
        if (result.isLeft()) {
            throw (AuthorizationException)((Object)result.left().get());
        }
        return (String[])result.right().getOrNull();
    }

    public String[] refreshSpaceGroupsCache(Space space) throws AuthorizationException {
        Either result = (Either)this.fTxTemplate.execute(() -> {
            try {
                return Either.right((Object)this.fUtil.refreshSpaceGroupsCache(space));
            }
            catch (AuthorizationException e) {
                return Either.left((Object)((Object)e));
            }
        });
        if (result.isLeft()) {
            throw (AuthorizationException)((Object)result.left().get());
        }
        return (String[])result.right().getOrNull();
    }

    public List<String> searchGroupCache(Space space, String query) throws AuthorizationException, EntityException {
        Either result = (Either)this.fTxTemplate.execute(() -> {
            try {
                if (space != null) {
                    return Either.right(this.fUtil.searchGroupCache(space, query));
                }
                return Either.right(this.fUtil.searchGroupsAvoidCache(query));
            }
            catch (EntityException | AuthorizationException e) {
                return Either.left((Object)e);
            }
        });
        if (result.isLeft()) {
            Exception exception = (Exception)result.left().get();
            if (exception instanceof AuthorizationException) {
                throw (AuthorizationException)((Object)exception);
            }
            if (exception instanceof EntityException) {
                throw (EntityException)((Object)exception);
            }
        }
        return (List)result.right().get();
    }
}

