/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.rest;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.security.access.annotations.RequiresLicensedConfluenceAccess;
import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.pluginpeople.confluence.csum.ao.CSUMLdapConfigEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.beans.RequestAuthenticationBean;
import com.pluginpeople.confluence.csum.rest.AbstractCSUMRestResource;
import com.pluginpeople.confluence.csum.rest.beans.GroupSearchResult;
import com.pluginpeople.confluence.csum.rest.beans.UILDAPConfigBean;
import com.pluginpeople.confluence.csum.rest.beans.UserDirectorySearchResult;
import com.pluginpeople.confluence.csum.rest.beans.config.AdminConfigGeneralBean;
import com.pluginpeople.confluence.csum.rest.beans.config.AdminConfigGroupBean;
import com.pluginpeople.confluence.csum.rest.beans.config.AdminConfigUserBean;
import com.pluginpeople.confluence.csum.service.AdminConfigService;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCachedConfig;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/config")
@RequiresLicensedConfluenceAccess
@ReadOnlyAccessAllowed
public class ConfigResource
extends AbstractCSUMRestResource {
    private CrowdService fCrowdSvc;
    private transient CrowdDirectoryService fCrowdDirectoryService;
    private ICSUMActiveObjectService fAos;
    private ICSUMCacheManager fCacheManager;
    private AdminConfigService fAdminConfigService;
    private static final Logger LOG = LoggerFactory.getLogger(ConfigResource.class);

    public ConfigResource(ICSUMCacheManager cacheManager, CrowdDirectoryService crowdDirectoryService, CrowdService crowdService, XsrfTokenService tokenService, ICSUMActiveObjectService aos, CSUMPermissionUtil permissionUtil, SpaceManager spaceManager, AdminConfigService adminConfigService, @ComponentImport AccessModeService accessModeService) {
        super(spaceManager, permissionUtil, tokenService, cacheManager, accessModeService);
        this.fCrowdDirectoryService = crowdDirectoryService;
        this.fCrowdSvc = crowdService;
        this.fAos = aos;
        this.fCacheManager = cacheManager;
        this.fAdminConfigService = adminConfigService;
    }

    @GET
    @Path(value="/getGroupConfig")
    @Produces(value={"application/json"})
    public Response getGroupConfig(@Context HttpServletRequest hsr, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else {
            ICSUMCachedConfig config = this.fCacheManager.getCachedConfig();
            AdminConfigGroupBean adminConfigGroupBean = new AdminConfigGroupBean(config.isGroupActionsPermitted(), config.isGroupAddRemovePermitted(), config.isDlgGrpActPerm(), config.getShowGroupInformation(), config.getGroupPrefixPattern(), config.getGroupSuffixPattern(), config.getGroupNameRegexp(), config.isIgnorePermissionCheck(), config.getMaxUserIDsLimit(), config.getMaxGroupIDsLimit(), config.isHideGroupOperations(), config.isHideUserOperations(), config.isGroupPageProcessing(), config.getBlocklistGroups(), config.isAllowAdminDeleteAudits(), config.isGroupRenamePermitted(), config.isRenameGlobalPermitted(), config.getCleanSpacePermsSelected(), config.getCleanPagePermsSelected(), config.getDisableFileImport(), config.getDisableFileExport());
            response = Response.ok((Object)adminConfigGroupBean).build();
        }
        return response;
    }

    @PUT
    @Path(value="/setGroupConfig")
    @Consumes(value={"application/json"})
    public Response setGroupConfig(@Context HttpServletRequest hsr, AdminConfigGroupBean adminConfigGroupBean, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else {
            List<String> errors = this.fAdminConfigService.validateConfigGroupData(adminConfigGroupBean);
            if (errors.isEmpty()) {
                this.fAos.updateConfigGroup(adminConfigGroupBean);
                response = Response.ok().build();
            } else {
                response = Response.ok(errors).build();
            }
        }
        return response;
    }

    @GET
    @Path(value="/getUserConfig")
    @Produces(value={"application/json"})
    public Response getUserConfig(@Context HttpServletRequest hsr, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else {
            ICSUMCachedConfig config = this.fCacheManager.getCachedConfig();
            AdminConfigUserBean adminConfigUserBean = new AdminConfigUserBean(config.isRemoveUserFromPermGrpPerm(), config.getDisabledUserHandling(), config.getGroupFilter(), config.getGroupFilterBehavior(), config.getAutoJoinGroups(), config.isUserSearchEnabled(), config.getUserDirectories(), config.isCreateUsersEnabled(), config.getExtLdapDirectories(), config.getFullNameFormat(), config.isUserPageProcessing());
            response = Response.ok((Object)adminConfigUserBean).build();
        }
        return response;
    }

    @PUT
    @Path(value="/setUserConfig")
    @Consumes(value={"application/json"})
    public Response setUserConfig(@Context HttpServletRequest hsr, AdminConfigUserBean adminConfigUserBean, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else {
            List<String> errors = this.fAdminConfigService.validateConfigUserData(adminConfigUserBean);
            if (errors.isEmpty()) {
                this.fAos.updateConfigUser(adminConfigUserBean);
                response = Response.ok().build();
            } else {
                response = Response.ok(errors).build();
            }
        }
        return response;
    }

    @GET
    @Path(value="/getLdap")
    @Produces(value={"application/json"})
    public Response getLDAPConfigurations(@Context HttpServletRequest hsr, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else {
            CSUMLdapConfigEntity[] ldapConfigurations;
            ArrayList<UILDAPConfigBean> ldapConfigList = new ArrayList<UILDAPConfigBean>();
            for (CSUMLdapConfigEntity aConfig : ldapConfigurations = this.fAos.getLdapConfigs()) {
                UILDAPConfigBean aLdapBean = new UILDAPConfigBean();
                aLdapBean.setName(aConfig.getLdapConfigName());
                aLdapBean.setId(aConfig.getID());
                ldapConfigList.add(aLdapBean);
            }
            response = Response.ok(ldapConfigList).build();
        }
        return response;
    }

    @GET
    @Path(value="/findLdap")
    @Produces(value={"application/json"})
    public Response getLDAPConfigurations(@Context HttpServletRequest hsr, @QueryParam(value="atl_token") String atlToken, @QueryParam(value="input") String query) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else {
            ArrayList<UILDAPConfigBean> ldapConfigList = new ArrayList<UILDAPConfigBean>();
            if (query != null && !query.isEmpty() && !query.equals("undefined")) {
                String[] ldapIds;
                for (String aLdapIdStr : ldapIds = query.split(",")) {
                    try {
                        int aLdapIdInt = Integer.parseInt(aLdapIdStr);
                        CSUMLdapConfigEntity aConfig = this.fAos.getLdapConfigById(aLdapIdInt);
                        if (aConfig == null) continue;
                        UILDAPConfigBean aLdapBean = new UILDAPConfigBean();
                        aLdapBean.setName(aConfig.getLdapConfigName());
                        aLdapBean.setId(aConfig.getID());
                        ldapConfigList.add(aLdapBean);
                    }
                    catch (NumberFormatException nfe) {
                        LOG.error("Provided LDAP Config Id [" + aLdapIdStr + "] could not be parsed as a valid ID", (Throwable)nfe);
                    }
                }
            }
            response = Response.ok(ldapConfigList).build();
        }
        return response;
    }

    @GET
    @Path(value="/getGeneralConfig")
    @Produces(value={"application/json"})
    public Response getGeneralConfig(@Context HttpServletRequest hsr, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else {
            ICSUMCachedConfig config = this.fCacheManager.getCachedConfig();
            AdminConfigGeneralBean adminConfigGeneralBean = new AdminConfigGeneralBean(config.isPersonalSpaceAllowed(), config.isPluginDown(), config.getPluginDownMsg());
            response = Response.ok((Object)adminConfigGeneralBean).build();
        }
        return response;
    }

    @PUT
    @Path(value="/setGeneralConfig")
    @Consumes(value={"application/json"})
    public Response setGeneralConfig(@Context HttpServletRequest hsr, AdminConfigGeneralBean adminConfigGeneralBean, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else {
            List<String> errors = this.fAdminConfigService.validateConfigGeneralData(adminConfigGeneralBean);
            if (errors.isEmpty()) {
                this.fAos.updateConfigGeneral(adminConfigGeneralBean);
                response = Response.ok().build();
            } else {
                response = Response.ok(errors).build();
            }
        }
        return response;
    }

    @GET
    @Path(value="/searchgroups")
    @Produces(value={"application/json"})
    public Response searchGroups(@Context HttpServletRequest hsr, @QueryParam(value="input") String input, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else {
            input = URLDecoder.decode(input, StandardCharsets.UTF_8);
            ArrayList<String> groupNames = new ArrayList<String>();
            QueryBuilder.PartialEntityQuery allGroupsQuery = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group());
            for (Group group : this.fCrowdSvc.search((Query)allGroupsQuery.with((SearchRestriction)new TermRestriction(GroupTermKeys.NAME, MatchMode.CONTAINS, (Object)input)).returningAtMost(15))) {
                groupNames.add(group.getName());
            }
            GroupSearchResult result = new GroupSearchResult();
            result.setGroups(groupNames);
            response = Response.ok((Object)result).build();
        }
        return response;
    }

    @GET
    @Path(value="/searchUserDirectories")
    @Produces(value={"application/json"})
    public Response searchUserDirectories(@Context HttpServletRequest hsr, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else {
            ArrayList<String> userDirectories = new ArrayList<String>();
            for (Directory directory : this.fCrowdDirectoryService.findAllDirectories()) {
                userDirectories.add(directory.getName());
            }
            UserDirectorySearchResult result = new UserDirectorySearchResult();
            result.setUserDirectories(userDirectories);
            response = Response.ok((Object)result).build();
        }
        return response;
    }

    @GET
    @Path(value="/isRegExpValid")
    public Response isRegExpValid(@Context HttpServletRequest hsr, @QueryParam(value="regExp") String regExp, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else {
            String decodedRegExp = URLDecoder.decode(regExp, StandardCharsets.UTF_8);
            boolean valid = this.fAdminConfigService.isRegExpValid(decodedRegExp);
            response = Response.status((Response.Status)Response.Status.OK).entity((Object)valid).build();
        }
        return response;
    }
}

