/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.action;

import com.atlassian.confluence.compat.api.service.accessmode.AccessModeCompatService;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugins.whitelist.OutboundWhitelist;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.pluginpeople.confluence.csum.action.AbstractCSUMConfigAction;
import com.pluginpeople.confluence.csum.ao.CSUMAuditEntity;
import com.pluginpeople.confluence.csum.ao.CSUMConfigEntity;
import com.pluginpeople.confluence.csum.ao.CSUMLdapConfigEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.LdapDetailsDTO;
import com.pluginpeople.confluence.csum.ldap.DTObuilder;
import com.pluginpeople.confluence.csum.ldap.LDAPException;
import com.pluginpeople.confluence.csum.ldap.LDAPHydrationManager;
import com.pluginpeople.confluence.csum.ldap.LdapConfigComparator;
import com.pluginpeople.confluence.csum.ldap.LdapItemBean;
import com.pluginpeople.confluence.csum.ldap.LdapValidator;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCachedConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.CommunicationException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.bind.JAXBException;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSUMConfigAction
extends AbstractCSUMConfigAction {
    private static final Logger LOG = LoggerFactory.getLogger(CSUMConfigAction.class);
    private static final String DELETING_OLD_AUDIT = "Deleting old CSUM audit history";
    private static final String USER_NOT_GLOBAL_ADMIN = "User is not a global admin";
    private static final String LDAP_EXAMPLE_DIR = "csum/ldap-templates";
    private static final String ON = "on";
    private static final String CRLF = "\r\n";
    private static final String C = ",";
    private static final String Q = "\"";
    private static final String COMMA = ",";
    private static final String SPACE = " ";
    private static final String SPACEKEY = "spacekey";
    private static final String EXPORT_ERROR = "exportError";
    private String fKey;
    private transient XsrfTokenService fTokenService;
    private File fConfluenceLocalHome;
    private transient CrowdDirectoryService fCrowdDirectoryService;
    private boolean fLdapValidateOnSave;
    private transient CSUMLdapConfigEntity[] fLdapConfigs;
    private final transient Map<LdapDetailsDTO, Map<String, String>> fLdapValidationErrors = new HashMap<LdapDetailsDTO, Map<String, String>>();
    private boolean fIsEdit = false;
    private boolean fIsCreate;
    private boolean fIsImport;
    private boolean fIsExport;
    private String fLdapConfigName;
    private String fLdapHostname;
    private int fLdapPort;
    private boolean fLdapUseSSL;
    private String fLdapUsername;
    private String fLdapPassword;
    private String fLdapBaseDN;
    private String fLdapAdditionalUserDN;
    private String fLdapAdditionalGroupDN;
    private String fLdapAdditionalParams;
    private String fLdapObjectClass;
    private String fLdapObjectFilter;
    private String fLdapUserAttr;
    private String fLdapUserFirstNameAttr;
    private String fLdapUserLastNameAttr;
    private String fLdapUserDisplayNameAttr;
    private String fLdapUserEmailAttr;
    private String fLdapUserPasswordAttr;
    private boolean fLdapUsePagedResults;
    private int fLdapResultsPerPage;
    private int fLdapSearchTimeout;
    private int fLdapConnectionTimeout;
    private String fLdapTestLookupUsername;
    private int fConfigId = 0;
    private boolean fImportOK;
    private String fLdapEquivalentDomains;
    private int fSortOrder;
    private String fExtLdapDirectories;
    private boolean fCreateUsersEnabled;
    private transient AccessModeCompatService fAccessModeCompatService;
    private transient OutboundWhitelist fOutboundAllowlist;
    private String fSelectedSpaceKey;

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        super.setBootstrapManager(bootstrapManager);
        this.fConfluenceLocalHome = bootstrapManager.getLocalHome();
    }

    public void setOutboundWhitelist(OutboundWhitelist outboundWhitelist) {
        this.fOutboundAllowlist = outboundWhitelist;
    }

    public void setXsrfTokenService(XsrfTokenService xsrfTokenService) {
        this.fTokenService = xsrfTokenService;
    }

    public void setAccessModeCompatService(AccessModeCompatService compatService) {
        this.fAccessModeCompatService = compatService;
    }

    public void setCrowdDirectoryService(CrowdDirectoryService crowdDirectoryService) {
        this.fCrowdDirectoryService = crowdDirectoryService;
    }

    public void setSelectedSpaceKey(String key) {
        this.fSelectedSpaceKey = key;
    }

    public String getSelectedSpaceKey() {
        return this.fSelectedSpaceKey;
    }

    @Override
    public String doDefault() {
        String ret = "input";
        LOG.debug("CustomPermissionConfigAction - VIEW");
        if (this.isPermitted()) {
            CSUMConfigEntity config = this.fAos.getConfig();
            if (config != null) {
                config.setJiraRestPassword(null);
                this.fAos.saveCSUMConfigEntity(config);
            }
            this.fLdapConfigs = this.getLDAPConfigurations();
            for (int i = 0; i < this.fLdapConfigs.length; ++i) {
                CSUMLdapConfigEntity ldapConfig = this.fLdapConfigs[i];
                LdapDetailsDTO dto = new LdapDetailsDTO();
                try {
                    DTObuilder.updateDto(ldapConfig, dto);
                    LdapValidator validator = new LdapValidator(dto, this.fOutboundAllowlist);
                    validator.validateLdapServer();
                    continue;
                }
                catch (LDAPException | CommunicationException e) {
                    HashMap<String, CallSite> msgs = new HashMap<String, CallSite>();
                    msgs.put("allowlist", (CallSite)((Object)("LDAP Configuration not valid or allowed: " + e.getLocalizedMessage())));
                    this.fLdapValidationErrors.put(dto, msgs);
                    this.addActionError("LDAPException: " + e.getLocalizedMessage());
                }
            }
            ret = "success";
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doGenerateCsvAuditReport() {
        String ret = "success";
        LOG.debug("doGenerateCsvAuditReport - UPDATE");
        File f = null;
        try {
            f = File.createTempFile("csum", "csv", new File(this.fConfluenceLocalHome, "temp"));
            if (!f.exists()) {
                String path = f.getAbsolutePath();
                LOG.error("Unable to create temp file (check local home permissions) : " + path);
            } else {
                this.writeDataToFile(f);
                if (f.length() > 0L) {
                    ret = this.writeOutResponse(f);
                }
            }
        }
        catch (IOException e) {
            LOG.error("Error writing csv audit data", (Throwable)e);
        }
        finally {
            if (f != null) {
                try {
                    Files.delete(f.toPath());
                }
                catch (IOException e) {
                    LOG.error("Unable to delete temp csv audit file: " + f.getAbsolutePath(), (Throwable)e);
                }
            }
        }
        return ret;
    }

    private void writeDataToFile(File f) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(f);){
            ICSUMCachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
            boolean personalSpaceAllowed = cachedConfig != null && cachedConfig.isPersonalSpaceAllowed();
            this.addSpaceEventHeaders(fos);
            List allSpaces = this.getSpaceManager().getAllSpaces();
            ICSUMActiveObjectService ao = this.getAo();
            for (Space aSpace : allSpaces) {
                if (aSpace.isPersonal() && !personalSpaceAllowed) continue;
                CSUMAuditEntity[] spaceEvents = ao.getAuditEvents(aSpace);
                if (spaceEvents != null && spaceEvents.length > 0) {
                    LOG.debug("Processing " + spaceEvents.length + " events from Space: " + (aSpace.getKey() != null ? aSpace.getKey() : "null"));
                    this.writeSpaceEventData(fos, spaceEvents);
                    continue;
                }
                LOG.debug("No audit events found for Space: " + (aSpace.getKey() != null ? aSpace.getKey() : "null"));
            }
        }
    }

    private String writeOutResponse(File f) {
        String ret;
        HttpServletResponse response = ServletActionContext.getResponse();
        try (FileInputStream fis = new FileInputStream(f);
             ServletOutputStream os = response.getOutputStream();){
            byte[] data = IOUtils.toByteArray((InputStream)fis);
            String filename = "csum-auditing-" + new Timestamp(System.currentTimeMillis()).toLocalDateTime().toString().replace(":", "_") + ".csv";
            response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + Q);
            response.setContentType("text/csv");
            response.setContentLength(data.length);
            response.setStatus(200);
            os.write(data);
            os.flush();
            ret = null;
        }
        catch (IOException e) {
            LOG.error("A problem occurred during Auditing CSV export", (Throwable)e);
            ret = "success";
        }
        return ret;
    }

    private void addSpaceEventHeaders(FileOutputStream fos) throws IOException {
        String csvline = "\"EV_ID\",\"EV_DATE\",\"EV_TIME\",\"EV_USER\",\"EV_TYPE\",\"EV_OUTCOME\",\"SPACE_KEY\",\"SPACE_NAME\",\"GROUP_NAME\",\"USER_NAME\",\"USER_FULLNAME\"\r\n";
        fos.write(csvline.getBytes());
    }

    private void writeSpaceEventData(OutputStream os, CSUMAuditEntity[] spaceEvents) throws IOException {
        for (CSUMAuditEntity e : spaceEvents) {
            StringBuilder csvline = new StringBuilder();
            csvline.append(e.getID());
            String eTs = e.getCreatedDate() != null ? e.getCreatedDate().toLocalDateTime().toString() : "";
            csvline.append(",").append(eTs, 0, eTs.indexOf(84));
            if (eTs.indexOf(46) != -1) {
                csvline.append(",").append(eTs, eTs.indexOf(84) + 1, eTs.lastIndexOf(46));
            } else {
                csvline.append(",").append(eTs.substring(eTs.indexOf(84) + 1));
            }
            ConfluenceUser createdBy = this.getUserAccessor().getUserByKey(new UserKey(e.getCreatedByUserKey()));
            csvline.append(",").append(createdBy != null ? createdBy.getName() : "");
            String rawOperationType = e.getOperationType() != null ? e.getOperationType() : "";
            csvline.append(",").append(rawOperationType.replace(",", SPACE));
            String rawEventOutcome = e.getEventOutcome() != null ? e.getEventOutcome() : "";
            csvline.append(",").append(rawEventOutcome.replace(",", SPACE));
            String rawSpaceKey = e.getSpaceKey() != null ? e.getSpaceKey() : "";
            csvline.append(",").append(rawSpaceKey);
            csvline.append(",").append(rawSpaceKey.replace(",", SPACE));
            String rawGroupName = e.getGroupName() != null ? e.getGroupName() : "";
            csvline.append(",").append(rawGroupName.replace(",", SPACE));
            ConfluenceUser contextUser = null;
            if (e.getContextUserKey() != null) {
                contextUser = this.getUserAccessor().getUserByKey(new UserKey(e.getContextUserKey()));
            }
            if (contextUser != null) {
                csvline.append(",").append(contextUser.getName());
                String fullname = contextUser.getFullName();
                if (fullname != null) {
                    csvline.append(",").append(fullname.replace(",", SPACE));
                } else {
                    csvline.append(",");
                }
            } else {
                csvline.append(",,");
            }
            csvline.append(CRLF);
            os.write(csvline.toString().getBytes(StandardCharsets.UTF_8));
        }
    }

    public String doUpdate() {
        String ret = "success";
        return ret;
    }

    public String doClearCache() {
        this.fCacheManager.flushAll();
        return "success";
    }

    public String getActionName(String fullClassName) {
        return "Configure Custom Space User Management Plugin";
    }

    public List<Space> getSpaces() {
        return this.getSpaceManager().getAllSpaces();
    }

    public ICSUMActiveObjectService.CSUMOperationType[] getOperations() {
        return ICSUMActiveObjectService.CSUMOperationType.values();
    }

    public String doDeleteOldHistory() {
        String ret = null;
        ConfluenceUser currentUser = this.getAuthenticatedUser();
        if (this.permissionManager.isConfluenceAdministrator(currentUser)) {
            LOG.info(DELETING_OLD_AUDIT);
            this.getAo().deleteAllAuditEntities(30);
            ret = "success";
        } else {
            this.addActionError(USER_NOT_GLOBAL_ADMIN);
            ret = "error";
        }
        return ret;
    }

    public String doDeleteAllHistory() {
        String ret;
        ConfluenceUser currentUser = this.getAuthenticatedUser();
        if (this.permissionManager.isConfluenceAdministrator(currentUser)) {
            LOG.info(DELETING_OLD_AUDIT);
            this.getAo().deleteAllAuditEntities(0);
            ret = "success";
        } else {
            this.addActionError(USER_NOT_GLOBAL_ADMIN);
            ret = "error";
        }
        return ret;
    }

    public String doDeleteAllHistoryForSpace() {
        String ret;
        String selectedSpaceKey = this.getSelectedSpaceKey();
        if (selectedSpaceKey != null) {
            Space space = this.getSpaceManager().getSpace(selectedSpaceKey);
            if (space != null) {
                ConfluenceUser currentUser = this.getAuthenticatedUser();
                if (this.fPermissionManager.isConfluenceAdministrator(currentUser) || this.fPermissionManager.hasPermission(currentUser, Permission.ADMINISTER, (Object)space)) {
                    LOG.info(DELETING_OLD_AUDIT);
                    int i = this.fAos.deleteAllAuditEntitiesForSpace(space);
                    LOG.info("Completed deletion of " + i + " records for space: " + space.getLowerKey());
                    ret = "success";
                } else {
                    this.addActionError(USER_NOT_GLOBAL_ADMIN);
                    ret = "error";
                }
            } else {
                this.addActionError("No Space found");
                ret = "error";
            }
        } else {
            this.addActionError("No Space Key found");
            ret = "error";
        }
        return ret;
    }

    public int sizeof(String[] arr) {
        return arr.length;
    }

    public String encodeGroupName(String groupName) {
        groupName = groupName != null ? URLEncoder.encode(groupName) : "null";
        return groupName;
    }

    public String doDeleteCachedSpaceGroup() {
        String ret = null;
        ConfluenceUser currentUser = this.getAuthenticatedUser();
        if (this.permissionManager.isConfluenceAdministrator(currentUser)) {
            Space aSpace = this.getSpaceManager().getSpace(this.fKey);
            if (aSpace != null) {
                this.fCacheManager.invalidateSpaceGroups(aSpace);
            }
            ret = "success";
        } else {
            this.addActionError(USER_NOT_GLOBAL_ADMIN);
            ret = "error";
        }
        return ret;
    }

    public String doRefreshAllSpaceGroups() {
        String ret = null;
        ConfluenceUser currentUser = this.getAuthenticatedUser();
        if (this.permissionManager.isConfluenceAdministrator(currentUser)) {
            this.fCacheManager.invalidateAllSpaceGroups();
            ret = "success";
        } else {
            this.addActionError(USER_NOT_GLOBAL_ADMIN);
            ret = "error";
        }
        return ret;
    }

    public String doRefreshCachedSpaceGroup() {
        String ret = null;
        ConfluenceUser currentUser = this.getAuthenticatedUser();
        if (this.permissionManager.isConfluenceAdministrator(currentUser)) {
            Space aSpace = this.getSpaceManager().getSpace(this.fKey);
            if (aSpace != null) {
                this.fCacheManager.invalidateSpaceGroups(aSpace);
            }
            ret = "success";
        } else {
            this.addActionError(USER_NOT_GLOBAL_ADMIN);
            ret = "error";
        }
        return ret;
    }

    public void setKey(String key) {
        this.fKey = this.getNulled(key);
    }

    public void setGroupName(String groupName) {
    }

    public void setExternalLdapDirectories(String[] values) {
        if (values.length == 0) {
            this.fExtLdapDirectories = null;
        } else {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < values.length; ++j) {
                sb.append(values[j]);
                if (j + 1 >= values.length) continue;
                sb.append(',');
            }
            this.fExtLdapDirectories = sb.toString();
        }
    }

    public boolean isEditLdapAction() {
        return this.fIsEdit;
    }

    public boolean isCreateAction() {
        return this.fIsCreate;
    }

    public boolean isImportAction() {
        return this.fIsImport;
    }

    public boolean isExportAction() {
        return this.fIsExport;
    }

    public String doEditLdap() {
        String ret = "error";
        this.fIsEdit = true;
        if (this.isLicenseValid()) {
            this.fLdapConfigs = this.getLDAPConfigurations();
            ret = "success";
        }
        return ret;
    }

    public String doUpdateLdap() {
        String ret = "error";
        if (this.isLicenseValid() && this.fConfigId > 0 && this.updateLdapConfig()) {
            this.fLdapConfigs = this.getLDAPConfigurations();
            ret = "success";
        }
        return ret;
    }

    private LdapItemBean buildDto() {
        LdapItemBean dto = new LdapItemBean();
        dto.setAdditionalGroupDN(this.fLdapAdditionalGroupDN);
        dto.setAdditionalParams(this.fLdapAdditionalParams);
        dto.setAdditionalUserDN(this.fLdapAdditionalUserDN);
        dto.setBaseDN(this.fLdapBaseDN);
        dto.setConnectionTimeout(this.fLdapConnectionTimeout);
        dto.setEquivalentMailDomains(this.fLdapEquivalentDomains);
        dto.setHostname(this.fLdapHostname);
        dto.setLdapConfigName(this.fLdapConfigName);
        dto.setObjectClass(this.fLdapObjectClass);
        dto.setObjectFilter(this.fLdapObjectFilter);
        dto.setPassword(this.fLdapPassword);
        dto.setPort(this.fLdapPort);
        dto.setResultsPerPage(this.fLdapResultsPerPage);
        dto.setSearchTimeout(this.fLdapSearchTimeout);
        dto.setTestLookupUsername(this.fLdapTestLookupUsername);
        dto.setUsePagedResults(this.fLdapUsePagedResults);
        dto.setUserDisplayNameAttr(this.fLdapUserDisplayNameAttr);
        dto.setUserEmailAttr(this.fLdapUserEmailAttr);
        dto.setUserFirstNameAttr(this.fLdapUserFirstNameAttr);
        dto.setUserLastNameAttr(this.fLdapUserLastNameAttr);
        dto.setUsername(this.fLdapUsername);
        dto.setUserPasswordAttr(this.fLdapUserPasswordAttr);
        dto.setUsernameAttr(this.fLdapUserAttr);
        dto.setSortOrder(this.fSortOrder);
        dto.setUseSSL(this.fLdapUseSSL);
        dto.setValidateOnSave(this.fLdapValidateOnSave);
        return dto;
    }

    public String doCreateNewAdLdap() throws JAXBException, IOException {
        String ret = null;
        if (this.isLicenseValid()) {
            String resourceName = "example-ldap-activedirectory.xml";
            String asXml = null;
            try (InputStream resourceAsStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("csum/ldap-templates/" + resourceName);){
                if (resourceAsStream != null) {
                    LOG.info("Creating by Active Directory example");
                    asXml = IOUtils.toString((InputStream)resourceAsStream, (Charset)StandardCharsets.UTF_8);
                }
            }
            if (asXml == null || asXml.isEmpty()) {
                this.addActionError("notfound", new Object[]{"The example file could not be found, please raise a bug report"});
            } else {
                LDAPHydrationManager pm = new LDAPHydrationManager(this.getAo());
                CSUMLdapConfigEntity configEntity = pm.restoreLDAPFromXml(asXml);
                this.fConfigId = configEntity.getID();
                this.fIsEdit = false;
            }
            ret = "success";
        }
        return ret;
    }

    public String doCreateNewApacheLdap() throws JAXBException, IOException {
        String ret = null;
        if (this.isLicenseValid()) {
            String resourceName = "example-ldap-apachedirectory.xml";
            String asXml = null;
            try (InputStream resourceAsStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("csum/ldap-templates/" + resourceName);){
                if (resourceAsStream != null) {
                    asXml = IOUtils.toString((InputStream)resourceAsStream, (Charset)StandardCharsets.UTF_8);
                }
            }
            if (asXml == null || asXml.isEmpty()) {
                this.addActionError("notfound", new Object[]{"The example file could not be found, please raise a bug report"});
            } else {
                LOG.info("Creating by Apache Directory example");
                LDAPHydrationManager pm = new LDAPHydrationManager(this.getAo());
                CSUMLdapConfigEntity configEntity = pm.restoreLDAPFromXml(asXml);
                this.fConfigId = configEntity.getID();
                this.fIsEdit = true;
            }
            ret = "input";
        }
        return ret;
    }

    public boolean isImportOK() {
        return this.fImportOK;
    }

    public String doImport() {
        String ret = null;
        if (this.isLicenseValid()) {
            this.fIsImport = true;
            ret = "input";
        }
        return ret;
    }

    @StrutsParameter
    public String doUploadLdapXML() {
        String ret;
        block16: {
            if (!this.isLicenseValid()) {
                return null;
            }
            ret = null;
            try {
                if (ServletFileUpload.isMultipartContent((HttpServletRequest)this.getCurrentRequest())) {
                    ServletFileUpload fileUpload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
                    HttpSession session = this.getCurrentSession();
                    if (session == null) {
                        throw new FileUploadException("HTTP session was found to be null");
                    }
                    List fileItems = fileUpload.parseRequest(this.getCurrentRequest());
                    if (!fileItems.isEmpty() && !((FileItem)fileItems.get(0)).isFormField()) {
                        String asXml;
                        DiskFileItem fileItem = (DiskFileItem)fileItems.get(0);
                        try (InputStream inputStream = fileItem.getInputStream();){
                            asXml = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                        }
                        if (asXml == null || asXml.length() == 0) {
                            this.addActionError("upload", new Object[]{"The upload was empty, unable to import."});
                        } else {
                            LDAPHydrationManager pm = new LDAPHydrationManager(this.getAo());
                            pm.restoreLDAPFromXml(asXml);
                            ServletActionContext.getResponse().sendRedirect("viewconfig.action?importOK=true");
                        }
                        break block16;
                    }
                    throw new FileUploadException("No file was found as a result of parsing request");
                }
                throw new FileUploadException("Request does not contain multipart content");
            }
            catch (Exception e) {
                this.addActionError("uploadLdapFail", new Object[]{"Failed to upload the LDAP Config, something went wrong: " + e.getLocalizedMessage()});
                if (e.getCause() != null) {
                    this.addActionError("uploadFailCause", new Object[]{"Caused by: " + e.getCause().getLocalizedMessage()});
                }
                ret = "success";
            }
        }
        return ret;
    }

    public String doExportLdap() {
        String ret;
        block12: {
            ret = null;
            if (this.isLicenseValid()) {
                CSUMLdapConfigEntity ldapConfig = this.getLdapConfig();
                LDAPHydrationManager pm = new LDAPHydrationManager(this.getAo());
                try {
                    String xmlData = pm.exportLDAPAsXml(ldapConfig);
                    if (xmlData != null) {
                        byte[] data = xmlData.getBytes();
                        HttpServletResponse response = ServletActionContext.getResponse();
                        String filename = "csum-ldap-" + ldapConfig.getID() + ".xml";
                        response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + Q);
                        response.setContentType("application/octet-stream");
                        response.setContentLength(data.length);
                        response.setStatus(200);
                        try (ServletOutputStream os = response.getOutputStream();){
                            os.write(data);
                            os.flush();
                            response.sendRedirect("viewconfig.action");
                            break block12;
                        }
                        catch (IOException e) {
                            LOG.error("doExport failed due to an IOException: " + e.getLocalizedMessage(), (Throwable)e);
                            this.addActionError(EXPORT_ERROR, new Object[]{"A problem occurred during LDAP XML export (" + e.getLocalizedMessage() + ") , please check the logs and raise an issue"});
                            ret = "success";
                        }
                        break block12;
                    }
                    this.addActionError(EXPORT_ERROR, new Object[]{"Unable to generate LDAP export XML, please check the logs and raise an issue"});
                    ret = "success";
                }
                catch (JAXBException e) {
                    LOG.error("doExport failed due to a JAXBException: " + e.getLocalizedMessage(), (Throwable)e);
                    this.addActionError(EXPORT_ERROR, new Object[]{e.getLocalizedMessage()});
                    ret = "success";
                }
            }
        }
        return ret;
    }

    public String doDeleteLdap() {
        String ret = null;
        if (this.isLicenseValid()) {
            if (this.fConfigId > 0 && !this.isLdapConfigActive(this.fConfigId)) {
                CSUMLdapConfigEntity toDelete = this.getAo().getLdapConfigById(this.fConfigId);
                if (toDelete != null) {
                    this.getAo().delete(toDelete);
                } else {
                    String msg = "doDelete failed for entity#" + this.fConfigId + ", not found.";
                    LOG.error(msg);
                    this.addActionError("deleteError", new Object[]{msg});
                }
            }
            ret = "success";
        }
        return ret;
    }

    public String doCopyLdap() {
        String ret = null;
        if (this.isLicenseValid()) {
            if (this.fConfigId > 0) {
                this.getAo().copyLdapConfig(this.fConfigId);
            }
            ret = "success";
        }
        return ret;
    }

    public boolean hasLdapConfigs() {
        return this.fLdapConfigs != null && this.fLdapConfigs.length != 0;
    }

    public boolean isLdapConfigurationValid(CSUMLdapConfigEntity config) {
        boolean ret = false;
        LOG.info("isLdapConfigurationValid: " + (config != null ? config : "null"));
        if (config != null) {
            LdapDetailsDTO dto = new LdapDetailsDTO();
            try {
                DTObuilder.updateDto(config, dto);
                LdapValidator validator = new LdapValidator(dto, this.fOutboundAllowlist);
                validator.validateLdapServer();
                ret = this.isLdapConfigurationValid(dto, config.getAdditionalParams());
            }
            catch (LDAPException | CommunicationException e) {
                HashMap<String, CallSite> msgs = new HashMap<String, CallSite>();
                msgs.put("allowlist", (CallSite)((Object)("LDAP Configuration not valid or allowed: " + e.getLocalizedMessage())));
                this.fLdapValidationErrors.put(dto, msgs);
            }
        }
        return ret;
    }

    public boolean isLdapConfigurationValid(LdapDetailsDTO dto, String additionalParams) {
        LOG.info("isLdapConfigurationValid: " + (dto != null ? dto : "null") + " for [" + (dto != null ? (dto.getLdapConfigName() != null ? dto.getLdapConfigName() : "null") : "null") + "] : " + (dto != null ? (dto.getLdapHostname() != null ? dto.getLdapHostname() : "null") : "null") + ":" + (Serializable)(dto != null ? (dto.getLdapPort() != 0 ? Integer.valueOf(dto.getLdapPort()) : "0") : "null"));
        HashMap<String, Object> errors = new HashMap<String, Object>();
        boolean isValid = false;
        Properties p = new Properties();
        if (dto != null) {
            block19: {
                if (additionalParams != null) {
                    try {
                        p.load(new StringReader(additionalParams));
                        LOG.info("Loaded " + p.size() + " values from additional params");
                    }
                    catch (IOException e1) {
                        LOG.error("Unable to load ldap additional parameters as a property file: " + e1.getLocalizedMessage(), (Throwable)e1);
                        errors.put("ldap", "Unable to load additional params: " + e1.getLocalizedMessage());
                    }
                    HashMap<Object, String> additionalPropertiesMap = new HashMap<Object, String>();
                    for (Object o : p.keySet()) {
                        String string;
                        String aKey = (String)o;
                        if (aKey == null || (string = p.getProperty(aKey)) == null) continue;
                        additionalPropertiesMap.put(aKey, string);
                    }
                    dto.setLdapAdditionalParams(additionalPropertiesMap);
                }
                try {
                    if (dto.getLdapHostname() == null) {
                        errors.put("ldapHostname", "The hostname was empty");
                    }
                    if (dto.getLdapPort() == 0) {
                        errors.put("ldapPort", "The port was empty");
                    }
                    if (dto.getLdapPassword() != null && dto.getLdapPassword() == null) {
                        errors.put("ldapPassword", "Password is empty");
                    }
                    try {
                        int timeout = dto.getLdapConnectionTimeout();
                        if (timeout <= 0 || timeout > 300000) {
                            errors.put("ldapConnectionTimeout", "Connect timeout is not in the range: 0 > val < 300000 (5mins)");
                        }
                    }
                    catch (NumberFormatException nfe) {
                        errors.put("ldapConnectionTimeout", nfe.getLocalizedMessage());
                    }
                    try {
                        int timeout = dto.getLdapSearchTimeout();
                        if (timeout <= 0 || timeout > 300000) {
                            errors.put("ldapSearchTimeout", "search timeout is not in the range: 0 > val < 300000 (5mins)");
                        }
                    }
                    catch (NumberFormatException nfe) {
                        errors.put("ldapSearchTimeout", nfe.getLocalizedMessage());
                    }
                    Map<LdapDetailsDTO, Map<String, String>> validationErrors = this.getValidationErrors();
                    boolean thisConfigValidationError = false;
                    for (Map.Entry entry : validationErrors.entrySet()) {
                        LdapDetailsDTO key = (LdapDetailsDTO)entry.getKey();
                        if (dto.getID() != key.getID()) continue;
                        thisConfigValidationError = true;
                        break;
                    }
                    if (!thisConfigValidationError) {
                        LdapValidator lv = new LdapValidator(dto, this.fOutboundAllowlist);
                        isValid = lv.validateLdapServer();
                        LOG.info("Validation success: " + isValid);
                    }
                }
                catch (Exception ldape) {
                    errors.put("Exception", ldape.getLocalizedMessage());
                    if (ldape.getCause() == null) break block19;
                    errors.put("exceptionCause", ldape.getCause().getLocalizedMessage());
                }
            }
            if (errors.size() > 0) {
                this.fLdapValidationErrors.put(dto, errors);
            }
            LOG.info("LDAP Configuration validation result: " + isValid);
        }
        return isValid;
    }

    public Map<LdapDetailsDTO, Map<String, String>> getValidationErrors() {
        return this.fLdapValidationErrors;
    }

    public boolean isLdapValidationErrors() {
        CSUMLdapConfigEntity[] allConfigs = this.getLDAPConfigurations();
        if (allConfigs != null) {
            for (CSUMLdapConfigEntity config : allConfigs) {
                this.isLdapConfigurationValid(config);
            }
        }
        return this.fLdapValidationErrors.size() > 0;
    }

    public CSUMLdapConfigEntity[] getLDAPConfigurations() {
        if (this.fLdapConfigs == null || this.fLdapConfigs.length == 0) {
            this.fLdapConfigs = this.fAos.getLdapConfigs();
            if (this.fLdapConfigs.length > 0) {
                if (this.fLdapConfigs.length > 1) {
                    ArrayList<CSUMLdapConfigEntity> list = new ArrayList<CSUMLdapConfigEntity>(Arrays.asList(this.fLdapConfigs));
                    list.sort(new LdapConfigComparator());
                    list.toArray(this.fLdapConfigs);
                }
                return this.fLdapConfigs;
            }
            return new CSUMLdapConfigEntity[0];
        }
        return this.fLdapConfigs;
    }

    private boolean updateLdapConfig() {
        boolean wasUpdated = false;
        if (this.fConfigId > 0) {
            LdapItemBean bean = this.buildDto();
            try {
                if (this.fLdapValidateOnSave) {
                    LdapValidator validator = new LdapValidator(bean, this.fOutboundAllowlist);
                    validator.validateLdapServer();
                }
                this.getAo().updateLdapConfig(this.fConfigId, bean);
                wasUpdated = true;
            }
            catch (CommunicationException e) {
                this.addActionError("CommunicationException: " + e.getLocalizedMessage());
            }
            catch (LDAPException e) {
                this.addActionError("LDAPException: " + e.getLocalizedMessage());
            }
        }
        return wasUpdated;
    }

    @StrutsParameter
    public void setLdapValidateOnSave(String value) {
        this.fLdapValidateOnSave = value.equalsIgnoreCase(ON);
    }

    @StrutsParameter
    public void setLdapConfigName(String name) {
        this.fLdapConfigName = this.getNulled(name);
    }

    @StrutsParameter
    public void setHostname(String hostname) {
        this.fLdapHostname = this.getNulled(hostname);
    }

    @StrutsParameter
    public void setPort(int port) {
        this.fLdapPort = port;
    }

    @StrutsParameter
    public void setUseSSL(String value) {
        this.fLdapUseSSL = value.equalsIgnoreCase(ON);
    }

    @StrutsParameter
    public void setUsername(String username) {
        this.fLdapUsername = this.getNulled(username);
    }

    @StrutsParameter
    public void setPassword(String password) {
        this.fLdapPassword = this.getNulled(password);
    }

    @StrutsParameter
    public void setTestLookupUsername(String username) {
        this.fLdapTestLookupUsername = this.getNulled(username);
    }

    @StrutsParameter
    public void setBaseDN(String baseDN) {
        this.fLdapBaseDN = this.getNulled(baseDN);
    }

    @StrutsParameter
    public void setAdditionalUserDN(String userDN) {
        this.fLdapAdditionalUserDN = this.getNulled(userDN);
    }

    @StrutsParameter
    public void setAdditionalGroupDN(String groupDN) {
        this.fLdapAdditionalGroupDN = this.getNulled(groupDN);
    }

    @StrutsParameter
    public void setObjectClass(String objClass) {
        this.fLdapObjectClass = this.getNulled(objClass);
    }

    @StrutsParameter
    public void setObjectFilter(String objFilter) {
        this.fLdapObjectFilter = this.getNulled(objFilter);
    }

    @StrutsParameter
    public void setUsernameAttr(String userAttr) {
        this.fLdapUserAttr = this.getNulled(userAttr);
    }

    @StrutsParameter
    public void setUserFirstNameAttr(String firstNameAttr) {
        this.fLdapUserFirstNameAttr = this.getNulled(firstNameAttr);
    }

    @StrutsParameter
    public void setUserLastNameAttr(String lastNameAttr) {
        this.fLdapUserLastNameAttr = this.getNulled(lastNameAttr);
    }

    @StrutsParameter
    public void setUserDisplayNameAttr(String displayNameAttr) {
        this.fLdapUserDisplayNameAttr = this.getNulled(displayNameAttr);
    }

    @StrutsParameter
    public void setUserEmailAttr(String emailAttr) {
        this.fLdapUserEmailAttr = this.getNulled(emailAttr);
    }

    public void setUserPasswordAttr(String passwordAttr) {
        this.fLdapUserPasswordAttr = this.getNulled(passwordAttr);
    }

    public void setEquivalentMailDomains(String equivDomains) {
        this.fLdapEquivalentDomains = this.getNulled(equivDomains);
    }

    public void setUsePagedResults(String value) {
        this.fLdapUsePagedResults = value.equalsIgnoreCase(ON);
    }

    public void setResultsPerPage(int resultSize) {
        this.fLdapResultsPerPage = resultSize;
    }

    @StrutsParameter
    public void setSearchTimeout(int timeout) {
        this.fLdapSearchTimeout = timeout;
    }

    @StrutsParameter
    public void setConnectionTimeout(int timeout) {
        this.fLdapConnectionTimeout = timeout;
    }

    @StrutsParameter
    public void setAdditionalParams(String paramMap) {
        this.fLdapAdditionalParams = this.getNulled(paramMap);
    }

    public String getMaskedPassword(String raw) {
        StringBuilder out = new StringBuilder();
        if (raw != null) {
            int len = raw.length();
            for (int i = 0; i < len; ++i) {
                out.append("*");
            }
        }
        return out.toString();
    }

    @StrutsParameter
    public void setId(String id) {
        if (id.trim().length() > 0) {
            this.fConfigId = Integer.parseInt(id);
        }
    }

    public CSUMLdapConfigEntity getLdapConfig() {
        CSUMLdapConfigEntity e = null;
        if (this.fConfigId > 0) {
            e = this.getAo().getLdapConfigById(this.fConfigId);
        }
        return e;
    }

    @StrutsParameter
    public void setSortOrder(String order) {
        this.fSortOrder = Integer.parseInt(order);
    }

    public boolean isLdapConfigActive(int ldapConfigId) {
        String ldapIds;
        ICSUMCachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
        String string = ldapIds = cachedConfig != null ? cachedConfig.getExtLdapDirectories() : null;
        if (ldapIds != null && !ldapIds.isEmpty()) {
            for (String id : ldapIds.split(",")) {
                try {
                    if (ldapConfigId == Integer.parseInt(id)) {
                        return true;
                    }
                }
                catch (NumberFormatException nfe) {
                    LOG.error("Could not parse LdapConfigId [" + ldapConfigId + "]. Not valid id:", (Throwable)nfe);
                }
            }
        }
        return false;
    }

    public boolean isAnyInactiveLdapConfigs() {
        boolean isAnyInactiveConfigs = false;
        ICSUMCachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
        String ldapIds = cachedConfig != null ? cachedConfig.getExtLdapDirectories() : null;
        CSUMLdapConfigEntity[] ldapConfigs = this.fAos.getLdapConfigs();
        if (ldapConfigs != null && ldapConfigs.length > 0) {
            if (ldapIds != null && !ldapIds.isEmpty()) {
                String[] activeConfigs = ldapIds.split(",");
                if (ldapConfigs.length != activeConfigs.length) {
                    isAnyInactiveConfigs = true;
                }
            } else {
                isAnyInactiveConfigs = true;
            }
        }
        return isAnyInactiveConfigs;
    }

    public boolean isDcReadOnly() {
        return this.fAccessModeCompatService.isReadOnlyAccessModeEnabled();
    }

    public Map<String, Object> getContextMap() {
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (confluenceUser != null) {
            Map<String, String> keyValues = this.getResourceBundleMessageSourceExtension().getKeyValues(this.getLocaleManager().getLocale((User)confluenceUser));
            contextMap.put("messages", keyValues);
            contextMap.put("loggedInUserName", confluenceUser.getName());
        }
        return contextMap;
    }

    @HtmlSafe
    public String getContextAsJson() {
        return new JSONObject(this.getContextMap()).toString();
    }

    private static enum LDAPFlavours {
        APACHEDIRECTORY,
        ACTIVEDIRECTORY;

    }
}

