/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.service;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.service.cache.CSUMCachedDlgGroup;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCachedConfig;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCachedDlgGroup;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCachedSpaceGroups;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCachedUserAuthDlgGroups;
import com.pluginpeople.confluence.csum.service.loader.CSUMAuthUserCacheLoader;
import com.pluginpeople.confluence.csum.service.loader.CSUMConfigCacheLoader;
import com.pluginpeople.confluence.csum.service.loader.CSUMSpaceGroupCacheLoader;
import com.pluginpeople.confluence.csum.util.DlgEntryXmlStrConv;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultCSUMCacheManagerImpl
implements ICSUMCacheManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCSUMCacheManagerImpl.class);
    private static boolean gInitialized = false;
    private static final int CONFIG_CACHE_DEFAULT_EXPIRY = 24;
    private static final int SPACE_CACHE_DEFAULT_EXPIRY = 12;
    private static final int AUTH_CACHE_DEFAULT_EXPIRY = 5;
    private static final int SYS_VAR_GROUP_MAX_DEFAULT = 1000;
    private static final String CACHE_EXTENSION_STRING = ".cache";
    private static final String SYS_VAR_GROUP_MAX = "csum.cache.group.max";
    private final ICSUMActiveObjectService fCao;
    private final CacheManager fConfluenceCacheManager;
    private final UserAccessor fUserAccessor;
    private final SpacePermissionManager fSpacePermissionManager;
    private final SpaceManager fSpaceManager;
    private static Cache<String, ICSUMCachedConfig> gConfigCache;
    private static Cache<String, ICSUMCachedSpaceGroups> gSpaceGroupCache;
    private static Cache<String, ICSUMCachedUserAuthDlgGroups> gDlgUserAuthGroupsCache;
    private int fMaxGroupsPerCacheEntry;

    @Autowired
    public DefaultCSUMCacheManagerImpl(ICSUMActiveObjectService aos, @ComponentImport CacheManager cacheManager, @ComponentImport UserAccessor userAccessor, SpacePermissionManager spacePermissionManager, @ComponentImport SpaceManager spaceManager) {
        this.fCao = aos;
        this.fConfluenceCacheManager = cacheManager;
        this.fUserAccessor = userAccessor;
        this.fSpacePermissionManager = spacePermissionManager;
        this.fSpaceManager = spaceManager;
    }

    @Override
    public void initCachesIfRequired() {
        if (!gInitialized) {
            LOG.debug("cacheInit()");
            this.fMaxGroupsPerCacheEntry = this.getCacheEntryGroupMaximum();
            CSUMConfigCacheLoader csumConfigCacheLoader = new CSUMConfigCacheLoader(this.fCao);
            gConfigCache = this.fConfluenceCacheManager.getCache(ICSUMCachedConfig.class.getName() + CACHE_EXTENSION_STRING, (CacheLoader)csumConfigCacheLoader, new CacheSettingsBuilder().remote().replicateViaInvalidation().replicateAsynchronously().maxEntries(1).expireAfterAccess(24L, TimeUnit.HOURS).flushable().build());
            CSUMSpaceGroupCacheLoader csumSpaceGroupCacheLoader = new CSUMSpaceGroupCacheLoader(this.fCao, this, this.fMaxGroupsPerCacheEntry, this.fUserAccessor, this.fSpaceManager, this.fSpacePermissionManager);
            gSpaceGroupCache = this.fConfluenceCacheManager.getCache(ICSUMCachedSpaceGroups.class.getName() + CACHE_EXTENSION_STRING, (CacheLoader)csumSpaceGroupCacheLoader, new CacheSettingsBuilder().remote().replicateViaInvalidation().replicateAsynchronously().maxEntries(this.fMaxGroupsPerCacheEntry).expireAfterAccess(12L, TimeUnit.HOURS).flushable().build());
            CSUMAuthUserCacheLoader csumAuthUserCacheLoader = new CSUMAuthUserCacheLoader(this.fCao, this.fUserAccessor);
            gDlgUserAuthGroupsCache = this.fConfluenceCacheManager.getCache(ICSUMCachedDlgGroup.class.getName() + CACHE_EXTENSION_STRING, (CacheLoader)csumAuthUserCacheLoader, new CacheSettingsBuilder().remote().replicateViaInvalidation().replicateAsynchronously().maxEntries(1000).expireAfterAccess(5L, TimeUnit.MINUTES).flushable().build());
            gInitialized = true;
        }
    }

    @Override
    public void flushAll() {
        this.invalidateCachedConfig();
        this.invalidateAllSpaceGroups();
        this.invalidateDlgGroupsForAllUsers();
        LOG.debug("flushAll() complete");
    }

    @Override
    public ICSUMCachedConfig getCachedConfig() {
        ICSUMCachedConfig cachedConfig = null;
        if (gConfigCache != null) {
            cachedConfig = (ICSUMCachedConfig)gConfigCache.get((Object)"ignored");
        }
        return cachedConfig;
    }

    @Override
    public void invalidateCachedConfig() {
        if (gConfigCache != null && !gConfigCache.getKeys().isEmpty()) {
            gConfigCache.removeAll();
        }
    }

    @Override
    public int getCacheEntryGroupMaximum() {
        if (this.fMaxGroupsPerCacheEntry != 0) {
            return this.fMaxGroupsPerCacheEntry;
        }
        int ret = 1000;
        String envVar = null;
        String sysProp = null;
        try {
            envVar = System.getenv(SYS_VAR_GROUP_MAX);
            sysProp = System.getProperty(SYS_VAR_GROUP_MAX);
        }
        catch (Exception e) {
            LOG.error("Exception occurred while retrieving CSUM system property", (Throwable)e);
        }
        try {
            if (envVar != null) {
                ret = Integer.parseInt(envVar);
            } else if (sysProp != null) {
                ret = Integer.parseInt(sysProp);
            }
        }
        catch (NumberFormatException nfe) {
            LOG.error("Could not parse int for sys property: csum.cache.group.max");
        }
        return ret;
    }

    @Override
    public String[] getCachedSpaceGroups(Space space) {
        String[] val;
        String[] ret = ArrayUtils.EMPTY_STRING_ARRAY;
        ICSUMCachedSpaceGroups entry = (ICSUMCachedSpaceGroups)gSpaceGroupCache.get((Object)space.getLowerKey());
        if (entry != null && (val = entry.getSpaceGroups()) != null && val.length > 0) {
            ret = val;
        }
        return ret;
    }

    @Override
    public String[] getPagedSpaceGroups(Space space, int maxGroupRetrieval, int offset, String searchVal) {
        String[] ret = ArrayUtils.EMPTY_STRING_ARRAY;
        ICSUMCachedSpaceGroups entry = (ICSUMCachedSpaceGroups)gSpaceGroupCache.get((Object)space.getLowerKey());
        if (entry != null) {
            if (searchVal != null && !searchVal.isEmpty()) {
                ret = this.findPagedGroups(maxGroupRetrieval, searchVal, ret, entry);
            } else {
                String[] val = entry.getPagedSpaceGroups(maxGroupRetrieval, offset);
                if (val != null && val.length > 0) {
                    ret = val;
                }
            }
        }
        return ret;
    }

    private String[] findPagedGroups(int maxGroupRetrieval, String searchVal, String[] ret, ICSUMCachedSpaceGroups entry) {
        String[] val = entry.getSpaceGroups();
        if (val != null && val.length > 0) {
            ArrayList<String> filteredGroups = new ArrayList<String>();
            for (String group : val) {
                if (filteredGroups.size() == maxGroupRetrieval) break;
                if (!group.contains(searchVal)) continue;
                filteredGroups.add(group);
            }
            ret = filteredGroups.toArray(new String[0]);
        }
        return ret;
    }

    @Override
    public void invalidateAllSpaceGroups() {
        if (gSpaceGroupCache != null && !gSpaceGroupCache.getKeys().isEmpty()) {
            gSpaceGroupCache.removeAll();
        }
    }

    @Override
    public void invalidateSpaceGroups(Space space) {
        gSpaceGroupCache.remove((Object)space.getLowerKey());
    }

    @Override
    public String[] getDlgGroupsForUser(ConfluenceUser user) {
        String[] result = new String[]{};
        String userKeyStr = user.getKey().getStringValue();
        ICSUMCachedUserAuthDlgGroups dlgGroupsCacheEntry = (ICSUMCachedUserAuthDlgGroups)gDlgUserAuthGroupsCache.get((Object)userKeyStr);
        if (dlgGroupsCacheEntry != null) {
            String[] stringDlgGroups = new String[dlgGroupsCacheEntry.getTotalDelegatedGroups()];
            CSUMCachedDlgGroup[] dlgGroups = dlgGroupsCacheEntry.getDelegatedGroups();
            int index = 0;
            for (CSUMCachedDlgGroup dlgGroup : dlgGroups) {
                try {
                    String stringDlgGroup = DlgEntryXmlStrConv.beanToString(dlgGroup);
                    if (stringDlgGroup == null) continue;
                    stringDlgGroups[index] = stringDlgGroup;
                    ++index;
                }
                catch (JAXBException e) {
                    LOG.error("JAXBException when converting cached delegated group entry to String", (Throwable)e);
                }
            }
            result = stringDlgGroups;
        }
        return result;
    }

    @Override
    public String[] getPagedDlgGroupsForUser(ConfluenceUser user, int maxRows, int offset) {
        String[] result = new String[]{};
        String[] initialArrayOfDlgGroups = this.getDlgGroupsForUser(user);
        String[] arrayFromOffset = Arrays.copyOfRange(initialArrayOfDlgGroups, offset, result.length);
        result = Arrays.copyOf(arrayFromOffset, maxRows);
        return result;
    }

    @Override
    public int getTotalDlgGroupCountForUser(ConfluenceUser user) {
        String userKeyStr = user.getKey().getStringValue();
        ICSUMCachedUserAuthDlgGroups dlgGroupsCacheEntry = (ICSUMCachedUserAuthDlgGroups)gDlgUserAuthGroupsCache.get((Object)userKeyStr);
        return dlgGroupsCacheEntry != null ? dlgGroupsCacheEntry.getTotalDelegatedGroups() : 0;
    }

    @Override
    public int getFilteredDlgGroupCountForUser(ConfluenceUser user, String searchVal) {
        int result = 0;
        String userKeyStr = user.getKey().getStringValue();
        ICSUMCachedUserAuthDlgGroups dlgGroupsCacheEntry = (ICSUMCachedUserAuthDlgGroups)gDlgUserAuthGroupsCache.get((Object)userKeyStr);
        if (dlgGroupsCacheEntry != null) {
            CSUMCachedDlgGroup[] dlgGroups;
            for (CSUMCachedDlgGroup dlgGroup : dlgGroups = dlgGroupsCacheEntry.getDelegatedGroups()) {
                String dlgGroupName = dlgGroup.getGroupName();
                if (!StringUtils.isNotEmpty((CharSequence)dlgGroupName) || !dlgGroupName.contains(searchVal)) continue;
                ++result;
            }
        }
        return result;
    }

    @Override
    public void invalidateDlgGroupsForAllUsers() {
        if (gDlgUserAuthGroupsCache != null && !gDlgUserAuthGroupsCache.getKeys().isEmpty()) {
            gDlgUserAuthGroupsCache.removeAll();
        }
    }

    @Override
    public void invalidateDlgGroupsForUser(ConfluenceUser user) {
        UserKey userKey;
        if (user != null && (userKey = user.getKey()) != null) {
            gDlgUserAuthGroupsCache.remove((Object)userKey.getStringValue());
        }
    }
}

