/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.rest;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.security.access.annotations.RequiresLicensedConfluenceAccess;
import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.pluginpeople.confluence.csum.ao.CSUMTaskEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.AuthorizationException;
import com.pluginpeople.confluence.csum.api.DuplicateException;
import com.pluginpeople.confluence.csum.api.GroupActionNotPermittedException;
import com.pluginpeople.confluence.csum.api.InvalidSpaceException;
import com.pluginpeople.confluence.csum.api.SpaceGroupPatternMismatchException;
import com.pluginpeople.confluence.csum.api.beans.RequestAuthenticationBean;
import com.pluginpeople.confluence.csum.rest.AbstractCSUMRestResource;
import com.pluginpeople.confluence.csum.rest.beans.DataTableGroupList;
import com.pluginpeople.confluence.csum.rest.beans.DataTableUserList;
import com.pluginpeople.confluence.csum.rest.beans.ExceptionBean;
import com.pluginpeople.confluence.csum.rest.beans.GroupInformationBean;
import com.pluginpeople.confluence.csum.rest.beans.Select2ResponseBean;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.task.TaskManager;
import com.pluginpeople.confluence.csum.task.TaskType;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import com.pluginpeople.confluence.csum.util.GroupUtil;
import com.pluginpeople.confluence.csum.util.SpaceGroupUtil;
import io.atlassian.fugue.Pair;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/space/group")
@ReadOnlyAccessAllowed
@RequiresLicensedConfluenceAccess
public class SpaceGroupResource
extends AbstractCSUMRestResource {
    private static final Logger LOG = LoggerFactory.getLogger(SpaceGroupResource.class);
    private static final String NOT_AUTHORIZED_FOR_THIS_ACTION = " is not authorized for this action";
    private static final String SPACE_KEY = "Space key: ";
    private static final String IS_NOT_ASSOCIATED_WITH_GROUP = " is not associated with group: ";
    private static final String QUEUED = "queued";
    private static final String UPLOADING = "uploading";
    private static final String RUNNING = "running";
    private final ICSUMCacheManager fCacheManager;
    private final UserAccessor fUserAccessor;
    private final GroupManager fGm;
    private final GroupUtil fGroupUtil;
    private final SpaceGroupUtil fSpaceGroupUtil;
    private final I18nResolver fI18n;
    private final PluginAccessor fPluginAccessor;
    private final TaskManager fTaskManager;
    private final ICSUMActiveObjectService fAos;
    private final CrowdDirectoryService fCrowdDirectoryService;
    private final DirectoryManager fCrowdDirectoryManager;

    public SpaceGroupResource(@ComponentImport SpaceManager spaceManager, SpaceGroupUtil grpUtil, @ComponentImport CrowdDirectoryService crowdDirectoryService, @ComponentImport I18nResolver i18n, @ComponentImport XsrfTokenService tokenService, @ComponentImport DirectoryManager crowdDirectoryManager, ICSUMCacheManager cacheManager, CSUMPermissionUtil permissionUtil, @ComponentImport UserAccessor userAccessor, @ComponentImport GroupManager gm, GroupUtil groupUtil, @ComponentImport PluginAccessor pluginAccessor, TaskManager taskManager, ICSUMActiveObjectService ao, @ComponentImport AccessModeService accessModeService) {
        super(spaceManager, permissionUtil, tokenService, cacheManager, accessModeService);
        this.fPluginAccessor = pluginAccessor;
        this.fSpaceGroupUtil = grpUtil;
        this.fI18n = i18n;
        this.fCacheManager = cacheManager;
        this.fUserAccessor = userAccessor;
        this.fGm = gm;
        this.fGroupUtil = groupUtil;
        this.fTaskManager = taskManager;
        this.fAos = ao;
        this.fCrowdDirectoryService = crowdDirectoryService;
        this.fCrowdDirectoryManager = crowdDirectoryManager;
    }

    @GET
    @Path(value="/check/group")
    @Produces(value={"application/json"})
    public Response checkGroupExists(@Context HttpServletRequest hsr, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="groupName") String partialGroupName, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, spaceKey, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        } else {
            Space validSpace = this.getValidSpaceFromSpaceKey(spaceKey);
            if (validSpace == null) {
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            } else if (partialGroupName == null) {
                response = Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            } else {
                try {
                    String groupName = this.fSpaceGroupUtil.computeSpaceGroupName(validSpace, partialGroupName);
                    Group group = this.fGm.getGroup(groupName);
                    response = group != null ? Response.status((Response.Status)Response.Status.NOT_MODIFIED).build() : Response.status((Response.Status)Response.Status.OK).build();
                }
                catch (EntityException e) {
                    LOG.error("EntityException triggered Space group validation: " + e.getLocalizedMessage(), (Throwable)e);
                    response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                }
            }
        }
        return response;
    }

    @POST
    @Path(value="/rename")
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response renameSpaceGroup(@Context HttpServletRequest hsr, @FormParam(value="spaceKey") String spaceKey, @FormParam(value="from") String oldGroupStr, @FormParam(value="to") String newGroupStr, @FormParam(value="renameScope") String renameScope, @FormParam(value="cleanSpacePermsScope") String cleanSpacePermsScope, @FormParam(value="cleanPagePermsScope") String cleanPagePermsScope, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, spaceKey, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        } else {
            Space validSpace = this.getValidSpaceFromSpaceKey(spaceKey);
            if (validSpace == null) {
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)spaceKey).build();
            } else {
                try {
                    boolean matchesGroupNameRegex = this.fSpaceGroupUtil.doesMatchRegex(newGroupStr);
                    if (!matchesGroupNameRegex) {
                        response = Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
                    } else {
                        String newGroupName = this.fSpaceGroupUtil.computeSpaceGroupName(validSpace, newGroupStr);
                        if (!this.fTaskManager.getActiveRenameTaskWithEitherGroup(validSpace, oldGroupStr, newGroupName)) {
                            response = Response.notModified().build();
                        } else {
                            boolean renameValid = this.fSpaceGroupUtil.validateRenameGroupIsAllowed(validSpace, oldGroupStr);
                            if (renameValid) {
                                ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
                                CSUMTaskEntity taskEntity = this.fAos.createTaskEntity(TaskType.GROUP_RENAME_PERMISSIONS_TRANSFER, validSpace.getKey(), currentUser.getName());
                                taskEntity.setOriginalGroupName(oldGroupStr);
                                taskEntity.setNewGroupName(newGroupName);
                                taskEntity.setRenameScope(renameScope);
                                taskEntity.setCleanSpacePermsScope(cleanSpacePermsScope);
                                taskEntity.setCleanPagePermsScope(cleanPagePermsScope);
                                this.fAos.saveTaskEntity(taskEntity);
                                Integer successfulTask = this.fTaskManager.processTask(TaskType.GROUP_RENAME_PERMISSIONS_TRANSFER, validSpace, oldGroupStr, taskEntity, newGroupName, currentUser, renameScope, cleanSpacePermsScope, cleanPagePermsScope);
                                if (successfulTask > 0) {
                                    response = Response.ok((Object)newGroupStr, (String)"text/plain").build();
                                } else {
                                    LOG.error("Group Rename Task did not process successfully, TaskEntity not created");
                                    response = Response.serverError().build();
                                }
                            } else {
                                response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                            }
                        }
                    }
                }
                catch (SpaceGroupPatternMismatchException e) {
                    LOG.error(SPACE_KEY + spaceKey + IS_NOT_ASSOCIATED_WITH_GROUP + oldGroupStr, (Throwable)e);
                    response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)spaceKey).build();
                }
                catch (AuthorizationException | GroupActionNotPermittedException e) {
                    LOG.error(AuthenticatedUserThreadLocal.getUsername() + NOT_AUTHORIZED_FOR_THIS_ACTION, e);
                    ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                    response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)exceptionBean).build();
                }
                catch (EntityException e) {
                    ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                    response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exceptionBean).build();
                }
                catch (Exception e) {
                    LOG.error("Unhandled error when renaming " + oldGroupStr + " in space: " + spaceKey, (Throwable)e);
                    ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                    response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exceptionBean).build();
                }
            }
        }
        return response;
    }

    @GET
    @Path(value="/groupInfo")
    @Produces(value={"application/json"})
    public Response getSpaceGroupInfo(@Context HttpServletRequest hsr, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="groupName") String groupName, @QueryParam(value="atl_token") String atlToken) {
        Response response = Response.notModified().build();
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, spaceKey, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else if (groupName != null) {
            boolean isShowGroupInfo;
            boolean bl = isShowGroupInfo = this.fCacheManager.getCachedConfig() != null && this.fCacheManager.getCachedConfig().getShowGroupInformation();
            if (isShowGroupInfo) {
                try {
                    com.atlassian.crowd.model.group.Group group = null;
                    String groupSourceDirectory = "";
                    String groupDescription = "";
                    List allDirectories = this.fCrowdDirectoryService.findAllDirectories();
                    for (Directory aDirectory : allDirectories) {
                        try {
                            group = this.fCrowdDirectoryManager.findGroupByName(aDirectory.getId().longValue(), groupName);
                            groupSourceDirectory = aDirectory.getName() != null ? aDirectory.getName() : "";
                            groupDescription = group.getDescription() != null ? group.getDescription() : "";
                            break;
                        }
                        catch (GroupNotFoundException groupNotFoundException) {
                        }
                    }
                    GroupInformationBean groupInformationBean = new GroupInformationBean(groupSourceDirectory, groupDescription);
                    response = Response.ok((Object)groupInformationBean).build();
                }
                catch (DirectoryNotFoundException e) {
                    LOG.error("DirectoryNotFoundException exception while attempting to retrieve group with the name: " + groupName + ". Exception: " + e);
                    ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                    response = Response.status((Response.Status)Response.Status.SEE_OTHER).entity((Object)exceptionBean).build();
                }
                catch (OperationFailedException e) {
                    LOG.error("OperationFailedException exception while attempting to retrieve group with the name: " + groupName + ". Exception: " + e);
                    ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                    response = Response.status((Response.Status)Response.Status.SEE_OTHER).entity((Object)exceptionBean).build();
                }
            }
        }
        return response;
    }

    @GET
    @Path(value="/queuedTasks")
    @Produces(value={"application/json"})
    public Response spaceQueuedOrRunningGroupRenameTasks(@Context HttpServletRequest hsr, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, spaceKey, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        } else {
            boolean allTasksFinished = true;
            Space currentSpace = this.getValidSpaceFromSpaceKey(spaceKey);
            if (currentSpace == null) {
                response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            } else {
                CSUMTaskEntity[] tasks;
                for (CSUMTaskEntity task : tasks = this.fTaskManager.getTaskRecords(currentSpace)) {
                    if (!task.getTaskType().equals(TaskType.GROUP_RENAME_PERMISSIONS_TRANSFER.getName()) || !task.getStatus().equals(QUEUED) && !task.getStatus().equals(RUNNING)) continue;
                    allTasksFinished = false;
                    break;
                }
                response = allTasksFinished ? Response.ok((Object)Boolean.TRUE).build() : Response.ok((Object)Boolean.FALSE).build();
            }
        }
        return response;
    }

    @GET
    @Path(value="/groupTasksUnderway")
    @Produces(value={"application/json"})
    public Response anyTasksUnderwayForSpaceGroup(@Context HttpServletRequest hsr, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="groupName") String groupName, @QueryParam(value="atl_token") String atlToken) {
        Response response = null;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, spaceKey, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        } else {
            Space currentSpace = this.getValidSpaceFromSpaceKey(spaceKey);
            if (currentSpace == null) {
                response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            } else {
                CSUMTaskEntity[] tasks;
                for (CSUMTaskEntity task : tasks = this.fTaskManager.getTaskRecords(currentSpace)) {
                    boolean isGroupNameInvolved;
                    boolean isRenameTask = task.getTaskType().equals(TaskType.GROUP_RENAME_PERMISSIONS_TRANSFER.getName());
                    if (!isRenameTask) continue;
                    boolean isTaskInProgress = task.getStatus().equals(QUEUED) || task.getStatus().equals(RUNNING) || task.getStatus().equals(UPLOADING);
                    boolean bl = isGroupNameInvolved = task.getOriginalGroupName().equals(groupName) || task.getNewGroupName().equals(groupName);
                    if (!isTaskInProgress || !isGroupNameInvolved) continue;
                    response = Response.ok((Object)Boolean.TRUE).build();
                    break;
                }
                if (response == null) {
                    response = Response.ok((Object)Boolean.FALSE).build();
                }
            }
        }
        return response;
    }

    @DELETE
    @Path(value="/delete")
    @Produces(value={"application/json"})
    public Response deleteSpaceGroup(@Context HttpServletRequest hsr, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="spaceGroup") String spaceGroup, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, spaceKey, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        } else {
            Space validSpace = this.getValidSpaceFromSpaceKey(spaceKey);
            if (validSpace == null) {
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)spaceKey).build();
            } else {
                try {
                    response = this.fSpaceGroupUtil.deleteSpaceGroup(validSpace, spaceGroup) ? Response.ok().build() : Response.notModified().build();
                }
                catch (EntityException e) {
                    ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                    response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exceptionBean).build();
                }
                catch (AuthorizationException e) {
                    LOG.error(AuthenticatedUserThreadLocal.getUsername() + NOT_AUTHORIZED_FOR_THIS_ACTION, (Throwable)e);
                    response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                }
                catch (GroupActionNotPermittedException e) {
                    LOG.error("Group actions disabled in CSUM config for space: " + spaceKey, (Throwable)e);
                    response = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
                }
                catch (SpaceGroupPatternMismatchException e) {
                    LOG.error(SPACE_KEY + spaceKey + IS_NOT_ASSOCIATED_WITH_GROUP + spaceGroup, (Throwable)e);
                    response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)spaceKey).build();
                }
                catch (Exception e) {
                    LOG.error("Unhandled error occurred when deleting space group: " + spaceGroup, (Throwable)e);
                    ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                    response = Response.status((Response.Status)Response.Status.SEE_OTHER).entity((Object)exceptionBean).build();
                }
            }
        }
        return response;
    }

    @PUT
    @Path(value="/create")
    @Produces(value={"application/json"})
    public Response createSpaceGroup(@Context HttpServletRequest hsr, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="spaceGroup") String spaceGroup, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, spaceKey, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        } else {
            boolean matchesGroupNameRegex = this.fSpaceGroupUtil.doesMatchRegex(spaceGroup);
            if (!matchesGroupNameRegex) {
                response = Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
            } else {
                Space validSpace = this.getValidSpaceFromSpaceKey(spaceKey);
                if (validSpace == null) {
                    response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)spaceKey).build();
                } else {
                    try {
                        Group created = this.fSpaceGroupUtil.createSpaceGroup(validSpace, spaceGroup);
                        response = created != null ? Response.ok().build() : Response.serverError().build();
                    }
                    catch (DuplicateException e) {
                        LOG.error("space group " + spaceGroup + " already exists", (Throwable)e);
                        response = Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
                    }
                    catch (AuthorizationException e) {
                        LOG.error(AuthenticatedUserThreadLocal.getUsername() + NOT_AUTHORIZED_FOR_THIS_ACTION, (Throwable)e);
                        response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                    }
                    catch (GroupActionNotPermittedException e) {
                        LOG.error("Group actions disabled in CSUM config for space: " + spaceKey, (Throwable)e);
                        response = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
                    }
                    catch (EntityException e) {
                        LOG.error("Error fetching existing space groups", (Throwable)e);
                        ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                        response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exceptionBean).build();
                    }
                    catch (Exception e) {
                        LOG.error("Unhandled error occurred when creating space group: " + spaceGroup, (Throwable)e);
                        ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                        response = Response.status((Response.Status)Response.Status.SEE_OTHER).entity((Object)exceptionBean).build();
                    }
                }
            }
        }
        return response;
    }

    @GET
    @Path(value="/groups")
    @Produces(value={"application/json"})
    public Response getSpaceGroups(@Context HttpServletRequest hsr, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="atl_token") String atlToken, @QueryParam(value="draw") int draw, @QueryParam(value="start") int start, @QueryParam(value="length") int length, @QueryParam(value="searchVal") String search, @QueryParam(value="isGroupProc") boolean isServerSideProcEnabled) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, spaceKey, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        } else {
            Space validSpace = this.getValidSpaceFromSpaceKey(spaceKey);
            if (validSpace == null) {
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            } else {
                try {
                    String[] spaceGroups = isServerSideProcEnabled && length > 0 ? this.fSpaceGroupUtil.getPagedSpaceGroupsFromCache(validSpace, length, start, search) : this.fSpaceGroupUtil.getSpaceGroupsFromCache(validSpace);
                    if (spaceGroups != null) {
                        boolean reachedCacheSizeLimit = (spaceGroups = this.fSpaceGroupUtil.removeGlobalGroups(spaceGroups).toArray(new String[0])).length == this.fCacheManager.getCacheEntryGroupMaximum();
                        String[][] data = new String[spaceGroups.length][];
                        for (int i = 0; i < spaceGroups.length; ++i) {
                            data[i] = new String[]{spaceGroups[i]};
                        }
                        int totalRecords = this.fSpaceGroupUtil.getTotalGroupsCount(validSpace);
                        int filteredRecords = this.fSpaceGroupUtil.getFilteredGroupsCount(validSpace, search);
                        DataTableGroupList dataTableFormat = new DataTableGroupList(data, reachedCacheSizeLimit, draw, filteredRecords, totalRecords);
                        response = Response.ok((Object)dataTableFormat).build();
                    } else {
                        LOG.error("Could not find spaceGroups using given SpaceKey:" + spaceKey);
                        response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                    }
                }
                catch (AuthorizationException e) {
                    LOG.error(AuthenticatedUserThreadLocal.getUsername() + NOT_AUTHORIZED_FOR_THIS_ACTION, (Throwable)e);
                    response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
                }
            }
        }
        return response;
    }

    @GET
    @Path(value="/all/groups")
    @Produces(value={"application/json"})
    public Response getAllSpaceGroupsForTargetSpace(@Context HttpServletRequest hsr, @QueryParam(value="currentSpaceKey") String currentSpaceKey, @QueryParam(value="selectedSpace") String selectedSpaceKey, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, currentSpaceKey, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        } else {
            Space currentSpace = this.getValidSpaceFromSpaceKey(currentSpaceKey);
            Space selectedSpace = this.getValidSpaceFromSpaceKey(selectedSpaceKey);
            if (currentSpace == null || selectedSpace == null) {
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            } else {
                try {
                    String[] spaceGroups = this.fSpaceGroupUtil.getSpaceGroupsFromCache(selectedSpace);
                    spaceGroups = this.fSpaceGroupUtil.removeBlocklistedGroups(spaceGroups).toArray(new String[0]);
                    spaceGroups = this.fSpaceGroupUtil.removeGlobalGroups(spaceGroups).toArray(new String[0]);
                    boolean reachedCacheSizeLimit = spaceGroups.length == this.fCacheManager.getCacheEntryGroupMaximum();
                    String[][] data = new String[spaceGroups.length][];
                    for (int i = 0; i < spaceGroups.length; ++i) {
                        String members;
                        Group group = this.fGm.getGroup(spaceGroups[i]);
                        if (group != null) {
                            members = String.valueOf(this.fUserAccessor.getMemberNamesAsList(group).size());
                        } else {
                            members = "Error fetching group info";
                            LOG.error("Error fetching groups members because the group could no be found in confluence");
                        }
                        data[i] = new String[]{spaceGroups[i], members};
                    }
                    DataTableGroupList dataTableFormat = new DataTableGroupList(data, reachedCacheSizeLimit);
                    response = Response.ok((Object)dataTableFormat).build();
                }
                catch (AuthorizationException e) {
                    LOG.error(AuthenticatedUserThreadLocal.getUsername() + NOT_AUTHORIZED_FOR_THIS_ACTION, (Throwable)e);
                    response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
                }
                catch (Exception e) {
                    LOG.error("There was an unexpected exception thrown trying to get groups for import for space: " + selectedSpaceKey, (Throwable)e);
                    response = Response.status((Response.Status)Response.Status.FORBIDDEN).build();
                }
            }
        }
        return response;
    }

    @GET
    @Path(value="/members")
    @Produces(value={"application/json"})
    public Response getGroupMembers(@Context HttpServletRequest hsr, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="spaceGroup") String spaceGroup, @QueryParam(value="atl_token") String atlToken, @QueryParam(value="highlightedGroup") String selectedGroup, @QueryParam(value="isUserProc") boolean isServerSideProcEnabled, @QueryParam(value="draw") int draw, @QueryParam(value="start") int offset, @QueryParam(value="length") int maxRows, @QueryParam(value="searchVal") String searchVal) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, spaceKey, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        } else {
            Space validSpace = this.getValidSpaceFromSpaceKey(spaceKey);
            if (validSpace == null) {
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            } else {
                try {
                    response = this.retrieveGroupMembers(spaceGroup, isServerSideProcEnabled, draw, offset, maxRows, searchVal, validSpace);
                }
                catch (EntityException e) {
                    LOG.error("Unable to fetch group/users when getting group members for space group: " + spaceGroup, (Throwable)e);
                    response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
                }
                catch (AuthorizationException e) {
                    LOG.error(AuthenticatedUserThreadLocal.getUsername() + NOT_AUTHORIZED_FOR_THIS_ACTION, (Throwable)e);
                    response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
                }
                catch (SpaceGroupPatternMismatchException e) {
                    LOG.error("Problem with spacekey: " + spaceKey, (Throwable)e);
                    response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
                }
            }
        }
        return response;
    }

    private Response retrieveGroupMembers(String spaceGroup, boolean isServerSideProcEnabled, int draw, int offset, int maxRows, String searchVal, Space aSpace) throws AuthorizationException, EntityException, SpaceGroupPatternMismatchException {
        Response response;
        if (this.serverSideGroupSelected(spaceGroup)) {
            List<User> memberList = isServerSideProcEnabled && maxRows > 0 ? this.fSpaceGroupUtil.getPagedSpaceGroupMembers(aSpace, spaceGroup, maxRows, offset, searchVal) : this.fSpaceGroupUtil.getSpaceGroupMembers(aSpace, spaceGroup);
            User[] arr = new User[memberList.size()];
            memberList.toArray(arr);
            int totalRecords = this.fSpaceGroupUtil.getTotalMembersCount(spaceGroup);
            int filteredRecords = this.fSpaceGroupUtil.getFilteredMembersCount(spaceGroup, searchVal);
            DataTableUserList dataTableFormat = new DataTableUserList(arr, this.fUserAccessor, this.fGm, this.fCacheManager, this.fGroupUtil, draw, totalRecords, filteredRecords);
            response = Response.ok((Object)dataTableFormat).build();
        } else {
            User[] arr = new User[]{};
            int filteredRecords = arr.length;
            int totalRecords = arr.length;
            DataTableUserList dataTableFormat = new DataTableUserList(arr, this.fUserAccessor, this.fGm, this.fCacheManager, this.fGroupUtil, draw, totalRecords, filteredRecords);
            response = Response.ok((Object)dataTableFormat).build();
        }
        return response;
    }

    @DELETE
    @Path(value="/member")
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response removeUsersFromGroups(@Context HttpServletRequest hsr, @FormParam(value="spaceKey") String spaceKey, @FormParam(value="spaceGroups") String spaceGroups, @FormParam(value="userNames") String spaceGroupMembers, @FormParam(value="viaMembership") String viaMembershipGroups, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, spaceKey, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        } else if (spaceGroups == null || spaceGroupMembers == null && viaMembershipGroups == null) {
            LOG.error("Insufficient data: spaceKey=" + spaceKey + ", spaceGroups=" + spaceGroups + ", spaceGroupMembers=" + spaceGroupMembers + "}, viaMembershipGroups=" + viaMembershipGroups);
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.fI18n.getText("space.not.found", new Serializable[]{spaceKey})).build();
        } else {
            Space validSpace = this.getValidSpaceFromSpaceKey(spaceKey);
            if (validSpace == null) {
                response = Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)spaceKey).build();
            } else {
                try {
                    ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
                    if (currentUser != null) {
                        List<String> failedToRemove = this.fSpaceGroupUtil.removeGroupMembers(validSpace, spaceGroups, spaceGroupMembers, viaMembershipGroups, currentUser);
                        response = Response.ok(failedToRemove).build();
                    } else {
                        response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                    }
                }
                catch (AuthorizationException e) {
                    LOG.error(AuthenticatedUserThreadLocal.getUsername() + NOT_AUTHORIZED_FOR_THIS_ACTION, (Throwable)e);
                    response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                }
                catch (SpaceGroupPatternMismatchException e) {
                    LOG.error("Problem with spacekey: " + spaceKey, (Throwable)e);
                    response = Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
                }
                catch (EntityException e) {
                    LOG.error("Could not find users/groups: " + spaceGroups + ", " + spaceGroupMembers, (Throwable)e);
                    ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                    response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exceptionBean).build();
                }
                catch (Exception e) {
                    LOG.error("Could not remove " + spaceGroupMembers + " from group: " + spaceGroups, (Throwable)e);
                    ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                    response = Response.status((Response.Status)Response.Status.SEE_OTHER).entity((Object)exceptionBean).build();
                }
            }
        }
        return response;
    }

    @GET
    @Path(value="/search")
    @Produces(value={"application/json"})
    public Response searchForSpaceGroups(@Context HttpServletRequest hsr, @QueryParam(value="query") String query, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, spaceKey, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        } else {
            Space aSpace = this.getValidSpaceFromSpaceKey(spaceKey);
            try {
                List<String> groupList = aSpace != null ? this.fSpaceGroupUtil.searchGroupCache(aSpace, query) : this.fSpaceGroupUtil.searchGroupsAvoidCache(query);
                String[] groupArr = new String[groupList.size()];
                groupList.toArray(groupArr);
                groupArr = this.fSpaceGroupUtil.removeBlocklistedGroups(groupArr).toArray(new String[0]);
                groupArr = this.fSpaceGroupUtil.removeGlobalGroups(groupArr).toArray(new String[0]);
                List<Select2ResponseBean> result = this.getSelect2OptionsForArray(groupArr);
                response = Response.ok(result).build();
            }
            catch (AuthorizationException e) {
                LOG.error(AuthenticatedUserThreadLocal.getUsername() + NOT_AUTHORIZED_FOR_THIS_ACTION, (Throwable)e);
                response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
            }
            catch (EntityException e) {
                LOG.error("Unable to get group with prefix: " + (query != null ? query : "null"), (Throwable)e);
                response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
            }
        }
        return response;
    }

    @GET
    @Path(value="/search/all")
    @Produces(value={"application/json"})
    public Response searchAllGroups(@Context HttpServletRequest hsr, @DefaultValue(value="") @QueryParam(value="prefix") String groupPrefix, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, spaceKey, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        } else {
            try {
                List<String> groupList = this.fSpaceGroupUtil.performGroupSearch(groupPrefix, 100);
                String[] groupArr = new String[groupList.size()];
                groupList.toArray(groupArr);
                groupArr = this.fSpaceGroupUtil.removeBlocklistedGroups(groupArr).toArray(new String[0]);
                groupArr = this.fSpaceGroupUtil.removeGlobalGroups(groupArr).toArray(new String[0]);
                List<Select2ResponseBean> result = this.getSelect2OptionsForArray(groupArr);
                response = Response.ok(result).build();
            }
            catch (EntityException e) {
                LOG.error("could not find group(s) with prefix: " + groupPrefix, (Throwable)e);
                response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
            }
            catch (Exception e) {
                LOG.error("Error searching for group with search term: " + (groupPrefix != null ? groupPrefix : "null"), (Throwable)e);
                ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exceptionBean).build();
            }
        }
        return response;
    }

    @PUT
    @Path(value="/members/add")
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response addMembersToGroups(@Context HttpServletRequest hsr, @FormParam(value="spaceKey") String spaceKey, @FormParam(value="spaceGroups") String spaceGroups, @FormParam(value="spaceUsers") String spaceUsers, @FormParam(value="importViaGroups") String importViaGroups, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, spaceKey, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        } else if (!(spaceUsers != null && !spaceUsers.trim().isEmpty() || importViaGroups != null && !importViaGroups.trim().isEmpty() || spaceGroups != null && !spaceGroups.trim().isEmpty())) {
            LOG.error("No groups or users specified: spaceGroups=" + spaceGroups + ", importViaGroups = null, spaceUsers=null");
            response = Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        } else {
            Space validSpace = this.getValidSpaceFromSpaceKey(spaceKey);
            if (validSpace == null) {
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)spaceKey).build();
            } else {
                try {
                    Pair<Map<String, String>, Map<String, String>> invalidUsersAndGroups = this.fSpaceGroupUtil.addUsersToGroups(validSpace, spaceGroups, spaceUsers, importViaGroups);
                    response = Response.ok((Object)invalidUsersAndGroups.left()).build();
                }
                catch (AuthorizationException e) {
                    LOG.error(AuthenticatedUserThreadLocal.getUsername() + NOT_AUTHORIZED_FOR_THIS_ACTION);
                    ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                    response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)exceptionBean).build();
                }
                catch (EntityException e) {
                    LOG.error("Unable to get group/user for : " + spaceGroups, (Throwable)e);
                    ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                    response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exceptionBean).build();
                }
                catch (SpaceGroupPatternMismatchException e) {
                    LOG.error(SPACE_KEY + spaceKey + IS_NOT_ASSOCIATED_WITH_GROUP, (Throwable)e);
                    response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)spaceKey).build();
                }
                catch (Exception e) {
                    LOG.error("Unhandled error when adding users: " + spaceUsers + " to groups: " + spaceGroups, (Throwable)e);
                    ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                    response = Response.status((Response.Status)Response.Status.SEE_OTHER).entity((Object)exceptionBean).build();
                }
            }
        }
        return response;
    }

    @DELETE
    @Path(value="cache")
    @Produces(value={"application/json"})
    public Response clearSpaceCache(@Context HttpServletRequest hsr, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, spaceKey, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else {
            Space validSpace = this.getValidSpaceFromSpaceKey(spaceKey);
            if (validSpace == null) {
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            } else {
                this.fCacheManager.invalidateSpaceGroups(validSpace);
                response = Response.ok().build();
            }
        }
        return response;
    }

    @GET
    @Path(value="/matchesRegexp")
    @Produces(value={"application/json"})
    public Response getGroupNameMatchesRegExp(@Context HttpServletRequest hsr, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="groupName") String groupName, @QueryParam(value="atl_token") String atlToken) {
        boolean matchesGroupNameRegex;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, spaceKey, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        Response response = !rab.isAuthenticated() ? Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build() : (!(matchesGroupNameRegex = this.fSpaceGroupUtil.doesMatchRegex(groupName)) ? Response.ok((Object)"false").build() : Response.ok((Object)"true").build());
        return response;
    }

    private boolean serverSideGroupSelected(String spaceGroup) {
        return spaceGroup != null && !spaceGroup.equals("null");
    }

    private Space getValidSpaceFromSpaceKey(@QueryParam(value="spaceKey") String spaceKey) {
        Space validSpace = null;
        try {
            validSpace = this.getValidSpaceFromKey(spaceKey);
        }
        catch (InvalidSpaceException e) {
            LOG.error("Invalid Space, could not find Space using spacekey: " + spaceKey, (Throwable)e);
        }
        return validSpace;
    }
}

