AJS.$(document).ready( function(){

	let isExpanded = true;
	//Expand each Result by clicking on them
	AJS.$('body').on("click", '.mod-header', function(e) {
		e.preventDefault();
		$(this).next().toggle();
		isExpanded = isExpanded !== true;
		let svgElement = $(this).children("#svgRotate");
		rotateSvg(isExpanded, svgElement);
	});

	//to rotate the arrow icon
	function rotateSvg(isExpanded, element) {
			if (isExpanded === false){
				AJS.$(element).css({'transform': 'rotate(0deg'});
			} else {
				AJS.$(element).css({'transform': 'rotate(-90deg'});
			}
	}

	//Expand all Results by clicking buttons in top right
	AJS.$('.jemh-minimise').click(function(e) {
		AJS.$('.mod-content').toggle(false);
		e.preventDefault();
		AJS.$('.svg').css({'transform': 'rotate(-90deg'});
	});

	AJS.$('.jemh-expand').click(function(e) {
		AJS.$('.mod-content').toggle(true);
		e.preventDefault();
		AJS.$('.svg').css({'transform': 'rotate(0deg'});
	});

	let atlToken = AJS.Meta.get("atl-token");

	if ( AJS.$('#csumLdapQueryForm') === null || AJS.$('#ldapFilter') === null )
	{
		console.log('not running LDAP js, content not loaded.');
		return;
	}

	console.log('LDAP query.js loaded');
	
	function htmlEncode(value){
  		return AJS.$('<div/>').text(value).html();
	}

	function addAttributeRow(anAttIdx, attributes, valueMap) {
		let anAtt=attributes[anAttIdx];
		let newRow='\n\t\t<tr><th style="width: 100px;">'+anAtt+'</th><td>';
		if (valueMap[anAtt].length>1) {
			newRow+='<ul>';
			for( let aValueIdx in valueMap[anAtt]) {
				newRow+='<li>'+htmlEncode(valueMap[anAtt][aValueIdx])+'</li>';
			}
			newRow+='</ul>';
		} else {
			newRow+=htmlEncode(valueMap[anAtt][0]);
		}
		newRow+='</td></tr>';
 	    return newRow;	
	}
	
	function isUser(valueMap) {
		let isUser=false;
		let classes=valueMap['objectClass'];
		if (classes) {
			for( let i in classes) {
				if (classes[i]==='user') {
					isUser=true;
					break;
				}
			}
		}
		return isUser;
	}
	
	function isGroup(valueMap) {

		let isGroup=false;
		let classes=valueMap['objectClass'];
		if (classes) {
			for( let i in classes) {
				if (classes[i]==='group') {
					isGroup=true;
					break;
				}
			}
		}
		return isGroup;
	}
	
	function renderSummary(resultIndex, attributes, valueMap)
	{
		let typeIndicator='';
		if (isUser(valueMap)) {
			typeIndicator='<span class="aui-icon aui-icon-small aui-iconfont-user" title="User"></span>';
		} else if (isGroup(valueMap)) {
			typeIndicator='<span class="aui-icon aui-icon-small aui-iconfont-group" title="Group"></span>';
		}

		let summary=typeIndicator+' '+resultIndex;

	 	for( let anAttIdx in attributes) {
			let anAtt=attributes[anAttIdx];
	 		if (anAtt==='cn') {
	 	    	summary+=', cn='+htmlEncode(valueMap[anAtt][0]);
	 	    	break;
	 	    }	 	    
	 	}
		
	 	for( let anAttIdx in attributes) {
			let anAtt=attributes[anAttIdx];
	 		if (anAtt==='sAMAccountName') {
	 	    	summary+=', sAMAccountName='+htmlEncode(valueMap[anAtt][0]);
	 	    	break;
	 	    }	 	    
	 	}
	 	
	 	for( let anAttIdx in attributes) {
			let anAtt=attributes[anAttIdx];
	 		if (anAtt==='mail') {
	 	    	summary+=', mail='+htmlEncode(valueMap[anAtt][0]);
	 	    	break;
	 	    }
		}	 	
	 			
		return summary;
	}
	
	function renderActionList(valueMap) {
		let listHtml='';
		if (isGroup(valueMap) && valueMap['mail']) {
			let mailAttr=valueMap['mail'];
			let mailAddress=mailAttr[0];
			listHtml+='&nbsp;<A HREF="#"><span data-email="'+AJS.escapeHtml(mailAddress)
				+'" data-configId="'+AJS.$("#ldapFilterConfig option:selected").val()
				+'" data-expand="'+AJS.$("#expandAttributes").val()
				+'" title="Export registered Confluence users within groups and sub-groups" class="aui-icon aui-icon-small aui-iconfont-bp-jira jemh-ldap-user-export"></span></A>';
		}
		return listHtml;
	}

	function renderExpandableResult(resultIndex, attributes, valueMap, subResults) {

		let expandableResult = '';
		expandableResult += '	<div class="module jemh-toggle-wrap toggle-wrap" id="jemh-result' + resultIndex + '-module" style="width:100%">';
		expandableResult += '		<div id="result' + resultIndex + '-module_heading" class="mod-header" style="padding: 5px">';
		expandableResult += '       	<svg class="svg" id="svgRotate" xmlns="http://www.w3.org/2000/svg" width="14" height="14" style="display: inline; transform: rotate(-90deg);"><path fill="#344563" fill-rule="evenodd" d="M3.3 4.8a1 1 0 0 0 0 1.4l3 3c.1.2.4.3.7.3s.6-.1.8-.3l3-3c.3-.4.3-1 0-1.4a1 1 0 0 0-1.5 0L7 7.1 4.7 4.8a1 1 0 0 0-1.4 0z"/></svg>';
		expandableResult += '			<h3 class="toggle-title" style="display: inline">' + renderSummary(resultIndex, attributes, valueMap) + '</h3>';
		expandableResult += '         ' + renderActionList(valueMap);
		expandableResult += '		</div>';
		expandableResult += '		<div class="mod-content" style="display: none;">';
		expandableResult += '		<table class="aui table-row-hover">';

		for (let anAttIdx in attributes) {
			expandableResult += addAttributeRow(anAttIdx, attributes, valueMap);
		}

		if (subResults && subResults.length > 0) {
			expandableResult += '       <tr>';
			expandableResult += '         <th>Sub Results</th>';
			expandableResult += '         <td>';
			expandableResult += '		      <table class="aui table-row-hover">';
			expandableResult += '             <tr>';
			expandableResult += '               <td style="width: 100%;">';
			expandableResult += '               <p>There are ' + subResults.length + ' expanded users/groups:</p>';

			for (let subResultIdx in subResults) {
				//console.log('adding record row '+resultIndex+' sub-result '+(+subResultIdx +1)+' of '+subResults.length);

				let subResult = subResults[subResultIdx];
				let atts = subResult.attributes;
				let values = subResult.values;
				let nextLevelSubResults = subResult.subResults;
				let renderId = (+subResultIdx + +1);
				expandableResult += renderExpandableResult(renderId, atts, values, nextLevelSubResults);
			}

			expandableResult += '             </td>';
			expandableResult += '           </tr>';
			expandableResult += '		    </table>';
			expandableResult += '       </td>';
			expandableResult += '       </tr>';
		}

		expandableResult += '		</table>';
		expandableResult += '		</div>';
		expandableResult += '	</div>';

		return expandableResult;
	}
	
	function handlePost() {
	
		AJS.$("#queryFailureDiv").empty();
		AJS.$("#queryResultsDiv").html("<p>Processing...</p>");

		let postData = AJS.$('#csumLdapQueryForm').serialize();
		let formUrl = AJS.$('#csumLdapQueryForm').attr('action') + '?atl_token=' + atlToken;

	  	
		//contentType: sent to the server as a header
		//dataType is the response
		let jqXHR = AJS.$.ajax({
			type: "POST",
			url: formUrl,
			dataType: "text",
			data: postData,
			timeout: 60000
		});
				
	  	jqXHR.done(function(data) {
			if(data){
				let jsonObj = JSON.parse(data);
				let jsonError = jsonObj.error;

				if (jsonError !== "")
				{
				  console.log("error: " + jsonError);
				}

				AJS.$('#queryResultsDiv').html('<p>There were '+jsonObj.results.length+' top-level records returned in '+jsonObj.queryTime+'mS:</p>');

				//console.log("Post returned with: "+jsonObj.results.length+" results");

				for( let resultIdx in jsonObj.results) {
				  let record = jsonObj.results[resultIdx];
				  let atts = record.attributes;
				  let values = record.values;
				  let subResults = record.subResults;
				  let resultIndex = (+resultIdx + +1);
				  let rowData = renderExpandableResult(resultIndex, atts, values, subResults);
				  AJS.$('#queryResultsDiv').append(rowData);
				}
			}
	  	}).fail(function(data, textStatus, errorMessage) {
			//console.log("RUN fail: textStatus="+textStatus+", errorMessage: "+errorMessage);
			AJS.$('#queryResultsDiv').empty();
			
			AJS.messages.generic("#queryFailureDiv", {
			   title:"LDAP Query Post failure",
			   body: '<p>Query failed, status: '+htmlEncode(textStatus)+', error: '+htmlEncode(errorMessage)+', response: '+htmlEncode(data.responseText)+'</p>'
			});			
	  	});
	}

	function validateFilter(filter)
	{
		let bracketsMatch = (filter.split('(').length === filter.split(')').length);
		if (bracketsMatch === false) {
			console.log("filter failed bracket check: "+filter);
			AJS.$("#queryFailureDiv").empty();
			AJS.messages.generic("#queryFailureDiv", {
				title:"Bracket mismatch",
				body: '<p>Filters must have matched open "(" and close ")" brackets, eg <pre>(&(mail=*)(sAMAccountName=andy))</pre></p>'
			});
		}

		return bracketsMatch;
	}

	function runQueryIfValid() {

		let ldapConfigId=AJS.$("#ldapFilterConfig option:selected").val();
		let filter=AJS.$("#ldapFilter").val().trim();
		let maxResults=AJS.$("#maxResults").val().trim();
		if (ldapConfigId !== 0 && maxResults.length > 0 && filter.length > 0 && validateFilter(filter)) {
			console.log('filter is valid, posting');
			handlePost();
		}
	}

	function resetSelect() {

		let ldapConfigId=AJS.$("#ldapFilterConfig option:selected").val();
		console.log('ldapConfigId: '+ldapConfigId);
		if (ldapConfigId !== 0 )
		{
			//console.log('LDAP config selected');
			AJS.$("#ldapFilter").removeAttr('disabled');
			AJS.$('#queryResultsDiv').empty();
			let filter=AJS.$("#ldapFilter").val().trim();
			if (filter.length===0) {
				AJS.$("#ldapFilter").val("(sAMAccountName=*)");
			}
			runQueryIfValid();
		}
		else
		{
			//console.log('LDAP config cleared');
			AJS.$("#ldapFilter").attr('disabled','disabled');
			AJS.$('#queryResultsDiv').html('<p>Select an LDAP configuration in order to enter an LDAP filter</p>');
		}
	}

	if ( AJS.$('.ldapIdConfigResultRow').length>0) {

		resetSelect();

		AJS.$("#ldapQueryRefresh").click(function () {
			runQueryIfValid();
		});

		let changeTimeout = null;
		AJS.$(".ldap-query-field").on("input", function () {
			clearTimeout(changeTimeout);
			changeTimeout = setTimeout(runQueryIfValid, 250);
		});

		AJS.$("#ldapFilterConfig").change(function () {
			resetSelect();
			runQueryIfValid();
		});

		//
		// Expand/Collapse on click of LDAP Details
		//

		AJS.$(".shortLdapContent").click(function() {
			let data=AJS.$(this).attr('data');
			console.log('click on shortLdapContent desc #'+data);

			AJS.$('.fullLdapContent[data='+data+']').removeAttr('hidden');
			AJS.$('.shortLdapContent[data='+data+']').attr('hidden','hidden');
		});
		AJS.$(".fullLdapContent").click(function() {
			let data=AJS.$(this).attr('data');
			console.log('click on fullLdapContent desc #'+data);

			AJS.$('.fullLdapContent[data='+data+']').attr('hidden', 'hidden');
			AJS.$('.shortLdapContent[data='+data+']').removeAttr('hidden');
		});

	}
});
