/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.service.cache;

import com.atlassian.user.Group;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCachedSpaceGroups;
import java.util.List;

public class CSUMCachedSpaceGroups
implements ICSUMCachedSpaceGroups {
    private final String spaceKey;
    private String[] spaceGroups;

    public CSUMCachedSpaceGroups(String spaceKey, List<Group> groups) {
        this.spaceKey = spaceKey.toLowerCase();
        if (groups != null) {
            this.spaceGroups = new String[groups.size()];
            int i = 0;
            for (Group group : groups) {
                this.spaceGroups[i++] = group.getName();
            }
        }
    }

    @Override
    public String getSpaceKey() {
        return this.spaceKey;
    }

    @Override
    public String[] getSpaceGroups() {
        return this.spaceGroups;
    }

    @Override
    public String[] getPagedSpaceGroups(int maxGroupRetrieval, int offset) {
        String[] foundGroups = new String[maxGroupRetrieval];
        int count = 0;
        for (int i = 0; i < maxGroupRetrieval; ++i) {
            if (offset + i >= this.spaceGroups.length) continue;
            foundGroups[i] = this.spaceGroups[offset + i];
            ++count;
        }
        String[] ret = new String[count];
        System.arraycopy(foundGroups, 0, ret, 0, count);
        return ret;
    }
}

