/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.service;

import com.atlassian.core.util.ClassLoaderUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.pluginpeople.confluence.csum.service.Settings;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Component;

@Component
public class ResourceBundleMessageSourceExtension
extends ResourceBundleMessageSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceBundleMessageSourceExtension.class);
    private static final Pattern NUMBER_PARAMETER_PATTERN = Pattern.compile("\\{(\\d+)\\}");
    private Map<String, String> localesAndBaseNames;
    private String RESOURCES_PATH;
    private String pluginKey;
    private LoadingCache<Locale, Map<String, String>> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Locale, Map<String, String>>(){

        public Map<String, String> load(Locale locale) {
            AbstractMap messagesForCurrentLocale = new HashMap<String, String>();
            for (String key : ResourceBundleMessageSourceExtension.this.localesAndBaseNames.keySet()) {
                TreeMap<String, String> treeMap = new TreeMap<String, String>();
                ResourceBundle bundle = ResourceBundleMessageSourceExtension.this.doGetBundle(ResourceBundleMessageSourceExtension.this.localesAndBaseNames.get(key), new Locale(key));
                if (bundle == null) continue;
                for (String messageKey : bundle.keySet()) {
                    treeMap.put(StringUtils.removeStart((String)messageKey, (String)(ResourceBundleMessageSourceExtension.this.pluginKey + ".")), ResourceBundleMessageSourceExtension.this.processMessage(ResourceBundleMessageSourceExtension.this.getStringOrNull(bundle, messageKey)));
                }
                ResourceBundleMessageSourceExtension.this.cache.put((Object)new Locale(key), treeMap);
                if (!locale.toString().equalsIgnoreCase(key)) continue;
                messagesForCurrentLocale = treeMap;
            }
            return messagesForCurrentLocale;
        }
    });

    @Autowired
    public ResourceBundleMessageSourceExtension(Settings settings) {
        this.RESOURCES_PATH = settings.getResourcesPath();
        this.setLocalesAndBaseNames(settings.getResourcesBasenames());
        this.pluginKey = settings.getPluginKey();
    }

    public Map<String, String> getKeyValues(Locale locale) {
        if (!this.localesAndBaseNames.containsKey(locale.toString())) {
            locale = new Locale("en_GB");
        }
        try {
            return (Map)this.cache.get((Object)locale);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Messages for locale " + locale + " could not be loaded: " + e.getMessage(), e);
        }
    }

    private String processMessage(String message) {
        try {
            String processed = NUMBER_PARAMETER_PATTERN.matcher(message).replaceAll("{{_$1}}");
            return processed.replaceAll("''", "'");
        }
        catch (Exception e) {
            LOGGER.error("Message " + message + " could not be processed. " + e.getClass().getName() + " " + StringUtils.defaultIfEmpty((String)e.getMessage(), (String)""), (Throwable)e);
            return message;
        }
    }

    protected ResourceBundle doGetBundle(String basename, Locale locale) throws MissingResourceException {
        PropertyResourceBundle propertyResourceBundle;
        block10: {
            String propertyFile = this.RESOURCES_PATH + basename + ".properties";
            Class<?> thisClass = ((Object)((Object)this)).getClass();
            InputStream resource = ClassLoaderUtils.getResourceAsStream((String)propertyFile, thisClass);
            try {
                LOGGER.info("Loading resource bundle {} locale {}", (Object)basename, (Object)locale);
                if (resource == null) {
                    throw new IllegalStateException("Resource  " + propertyFile + " not found!!");
                }
                propertyResourceBundle = new PropertyResourceBundle(resource);
                if (resource == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (resource != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Resource  " + propertyFile + " not found!!", e);
                }
                catch (RuntimeException e) {
                    String msg = StringUtils.defaultIfEmpty((String)e.getMessage(), (String)"");
                    LOGGER.error("Resource Bundle " + basename + " could not be loaded. " + e.getClass().getName() + " " + msg, (Throwable)e);
                    throw e;
                }
            }
            resource.close();
        }
        return propertyResourceBundle;
    }

    public void setLocalesAndBaseNames(Map<String, String> localesAndBaseNames) {
        this.localesAndBaseNames = localesAndBaseNames;
    }
}

