/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.rest;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.access.annotations.RequiresLicensedConfluenceAccess;
import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.plugins.rest.common.security.RequiresXsrfCheck;
import com.pluginpeople.confluence.csum.ao.CSUMLdapConfigEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.rest.AbstractCSUMRestResource;
import com.pluginpeople.confluence.csum.rest.beans.GroupSearchResult;
import com.pluginpeople.confluence.csum.rest.beans.UILDAPConfigBean;
import com.pluginpeople.confluence.csum.rest.beans.UserDirectorySearchResult;
import com.pluginpeople.confluence.csum.rest.beans.config.AdminConfigGeneralBean;
import com.pluginpeople.confluence.csum.rest.beans.config.AdminConfigGroupBean;
import com.pluginpeople.confluence.csum.rest.beans.config.AdminConfigUserBean;
import com.pluginpeople.confluence.csum.service.AdminConfigService;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCachedConfig;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriUtils;

@ReadOnlyAccessAllowed
@Path(value="/config")
@RequiresLicensedConfluenceAccess
public class ConfigResource
extends AbstractCSUMRestResource {
    private CrowdService fCrowdSvc;
    private transient CrowdDirectoryService fCrowdDirectoryService;
    private ICSUMActiveObjectService fAos;
    private ICSUMCacheManager fCacheManager;
    private AdminConfigService fAdminConfigService;
    private static final Logger LOG = LoggerFactory.getLogger(ConfigResource.class);
    private static final String UTF_8 = "UTF-8";

    public ConfigResource(ICSUMCacheManager cacheManager, CrowdDirectoryService crowdDirectoryService, CrowdService crowdService, XsrfTokenService tokenService, ICSUMActiveObjectService aos, CSUMPermissionUtil permissionUtil, SpaceManager spaceManager, PermissionManager permissionManager, AdminConfigService adminConfigService) {
        super(spaceManager, permissionUtil, tokenService, permissionManager, cacheManager);
        this.fCrowdDirectoryService = crowdDirectoryService;
        this.fCrowdSvc = crowdService;
        this.fAos = aos;
        this.fCacheManager = cacheManager;
        this.fAdminConfigService = adminConfigService;
    }

    @RequiresXsrfCheck
    @GET
    @Path(value="/getGroupConfig")
    @Produces(value={"application/json"})
    public Response getGroupConfig(@Context HttpServletRequest hsr, @QueryParam(value="atl_token") String atlToken) {
        if (this.isTokenInvalid(hsr)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ICSUMCachedConfig config = this.fCacheManager.getCachedConfig();
        AdminConfigGroupBean adminConfigGroupBean = new AdminConfigGroupBean(config.isGroupActionsPermitted(), config.isGroupAddRemovePermitted(), config.isDlgGrpActPerm(), config.getShowGroupInformation(), config.getGroupPrefixPattern(), config.getGroupSuffixPattern(), config.getGroupNameRegexp(), config.isIgnorePermissionCheck(), config.getMaxUserIDsLimit(), config.getMaxGroupIDsLimit(), config.isHideGroupOperations(), config.isHideUserOperations(), config.isGroupPageProcessing(), config.getBlocklistGroups(), config.isAllowAdminDeleteAudits(), config.isGroupRenamePermitted(), config.isRenameGlobalPermitted(), config.getCleanSpacePermsSelected(), config.getCleanPagePermsSelected(), config.getDisableFileImport(), config.getDisableFileExport());
        Response result = Response.ok((Object)adminConfigGroupBean).build();
        return result;
    }

    @RequiresXsrfCheck
    @PUT
    @Path(value="/setGroupConfig")
    @Consumes(value={"application/json"})
    public Response setGroupConfig(@Context HttpServletRequest hsr, AdminConfigGroupBean adminConfigGroupBean, @QueryParam(value="atl_token") String atlToken) {
        Response result;
        if (this.isTokenInvalid(hsr)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        List<String> errors = this.fAdminConfigService.validateConfigGroupData(adminConfigGroupBean);
        if (errors.isEmpty()) {
            this.fAos.updateConfigGroup(adminConfigGroupBean);
            result = Response.ok().build();
        } else {
            result = Response.ok(errors).build();
        }
        return result;
    }

    @RequiresXsrfCheck
    @GET
    @Path(value="/getUserConfig")
    @Produces(value={"application/json"})
    public Response getUserConfig(@Context HttpServletRequest hsr, @QueryParam(value="atl_token") String atlToken) {
        if (this.isTokenInvalid(hsr)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ICSUMCachedConfig config = this.fCacheManager.getCachedConfig();
        AdminConfigUserBean adminConfigUserBean = new AdminConfigUserBean(config.isRemoveUserFromPermGrpPerm(), config.getDisabledUserHandling(), config.getGroupFilter(), config.getGroupFilterBehavior(), config.getAutoJoinGroups(), config.isUserSearchEnabled(), config.getUserDirectories(), config.isCreateUsersEnabled(), config.getExtLdapDirectories(), config.getFullNameFormat(), config.isUserPageProcessing());
        Response result = Response.ok((Object)adminConfigUserBean).build();
        return result;
    }

    @RequiresXsrfCheck
    @PUT
    @Path(value="/setUserConfig")
    @Consumes(value={"application/json"})
    public Response setUserConfig(@Context HttpServletRequest hsr, AdminConfigUserBean adminConfigUserBean, @QueryParam(value="atl_token") String atlToken) {
        Response result;
        if (this.isTokenInvalid(hsr)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        List<String> errors = this.fAdminConfigService.validateConfigUserData(adminConfigUserBean);
        if (errors.isEmpty()) {
            this.fAos.updateConfigUser(adminConfigUserBean);
            result = Response.ok().build();
        } else {
            result = Response.ok(errors).build();
        }
        return result;
    }

    @RequiresXsrfCheck
    @GET
    @Path(value="/getLdap")
    @Produces(value={"application/json"})
    public Response getLDAPConfigurations(@Context HttpServletRequest hsr, @QueryParam(value="atl_token") String atlToken) {
        CSUMLdapConfigEntity[] ldapConfigurations;
        if (this.isTokenInvalid(hsr)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ArrayList<UILDAPConfigBean> ldapConfigList = new ArrayList<UILDAPConfigBean>();
        for (CSUMLdapConfigEntity aConfig : ldapConfigurations = this.fAos.getLdapConfigs()) {
            UILDAPConfigBean aLdapBean = new UILDAPConfigBean();
            aLdapBean.setName(aConfig.getLdapConfigName());
            aLdapBean.setId(aConfig.getID());
            ldapConfigList.add(aLdapBean);
        }
        Response result = Response.ok(ldapConfigList).build();
        return result;
    }

    @RequiresXsrfCheck
    @GET
    @Path(value="/findLdap")
    @Produces(value={"application/json"})
    public Response getLDAPConfigurations(@Context HttpServletRequest hsr, @QueryParam(value="atl_token") String atlToken, @QueryParam(value="input") String query) {
        if (this.isTokenInvalid(hsr)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ArrayList<UILDAPConfigBean> ldapConfigList = new ArrayList<UILDAPConfigBean>();
        if (query != null && !query.isEmpty() && !query.equals("undefined")) {
            String[] ldapIds;
            for (String aLdapIdStr : ldapIds = query.split(",")) {
                try {
                    int aLdapIdInt = Integer.parseInt(aLdapIdStr);
                    CSUMLdapConfigEntity aConfig = this.fAos.getLdapConfigById(aLdapIdInt);
                    if (aConfig == null) continue;
                    UILDAPConfigBean aLdapBean = new UILDAPConfigBean();
                    aLdapBean.setName(aConfig.getLdapConfigName());
                    aLdapBean.setId(aConfig.getID());
                    ldapConfigList.add(aLdapBean);
                }
                catch (NumberFormatException nfe) {
                    LOG.error("Provided LDAP Config Id [" + aLdapIdStr + "] could not be parsed as a valid ID", (Throwable)nfe);
                }
            }
        }
        Response result = Response.ok(ldapConfigList).build();
        return result;
    }

    @RequiresXsrfCheck
    @GET
    @Path(value="/getGeneralConfig")
    @Produces(value={"application/json"})
    public Response getGeneralConfig(@Context HttpServletRequest hsr, @QueryParam(value="atl_token") String atlToken) {
        if (this.isTokenInvalid(hsr)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ICSUMCachedConfig config = this.fCacheManager.getCachedConfig();
        AdminConfigGeneralBean adminConfigGeneralBean = new AdminConfigGeneralBean(config.isPersonalSpaceAllowed(), config.isPluginDown(), config.getPluginDownMsg());
        Response result = Response.ok((Object)adminConfigGeneralBean).build();
        return result;
    }

    @RequiresXsrfCheck
    @PUT
    @Path(value="/setGeneralConfig")
    @Consumes(value={"application/json"})
    public Response setGeneralConfig(@Context HttpServletRequest hsr, AdminConfigGeneralBean adminConfigGeneralBean, @QueryParam(value="atl_token") String atlToken) {
        Response result;
        if (this.isTokenInvalid(hsr)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        List<String> errors = this.fAdminConfigService.validateConfigGeneralData(adminConfigGeneralBean);
        if (errors.isEmpty()) {
            this.fAos.updateConfigGeneral(adminConfigGeneralBean);
            result = Response.ok().build();
        } else {
            result = Response.ok(errors).build();
        }
        return result;
    }

    @RequiresXsrfCheck
    @GET
    @Path(value="/searchgroups")
    @Produces(value={"application/json"})
    public Response searchGroups(@Context HttpServletRequest hsr, @QueryParam(value="input") String input, @QueryParam(value="atl_token") String atlToken) {
        if (this.isTokenInvalid(hsr)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        input = UriUtils.decode((String)input, (String)UTF_8);
        ArrayList<String> groupNames = new ArrayList<String>();
        QueryBuilder.PartialEntityQuery allGroupsQuery = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group());
        for (Group group : this.fCrowdSvc.search((Query)allGroupsQuery.with((SearchRestriction)new TermRestriction(GroupTermKeys.NAME, MatchMode.CONTAINS, (Object)input)).returningAtMost(15))) {
            groupNames.add(group.getName());
        }
        GroupSearchResult result = new GroupSearchResult();
        result.setGroups(groupNames);
        return Response.ok((Object)result).build();
    }

    @RequiresXsrfCheck
    @GET
    @Path(value="/searchUserDirectories")
    @Produces(value={"application/json"})
    public Response searchUserDirectories(@Context HttpServletRequest hsr, @QueryParam(value="atl_token") String atlToken) {
        if (this.isTokenInvalid(hsr)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ArrayList<String> userDirectories = new ArrayList<String>();
        for (Directory directory : this.fCrowdDirectoryService.findAllDirectories()) {
            userDirectories.add(directory.getName());
        }
        UserDirectorySearchResult result = new UserDirectorySearchResult();
        result.setUserDirectories(userDirectories);
        return Response.ok((Object)result).build();
    }

    @RequiresXsrfCheck
    @GET
    @Path(value="/isRegExpValid")
    public Response isRegExpValid(@Context HttpServletRequest hsr, @QueryParam(value="regExp") String regExp, @QueryParam(value="atl_token") String atlToken) {
        if (this.isTokenInvalid(hsr)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        String decodedRegExp = UriUtils.decode((String)regExp, (String)UTF_8);
        boolean valid = this.fAdminConfigService.isRegExpValid(decodedRegExp);
        return Response.ok((Object)valid).build();
    }
}

