/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.publicapi.rest;

import com.atlassian.annotations.PublicApi;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.EntityException;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.AuthorizationException;
import com.pluginpeople.confluence.csum.api.InvalidSpaceException;
import com.pluginpeople.confluence.csum.api.RemoveAllUsersException;
import com.pluginpeople.confluence.csum.api.beans.JSONAddUserResultBean;
import com.pluginpeople.confluence.csum.rest.AbstractCSUMRestResource;
import com.pluginpeople.confluence.csum.rest.beans.ExceptionBean;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCachedConfig;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import com.pluginpeople.confluence.csum.util.DlgGroupManager;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/public/dlggroup")
@PublicApi
public class PublicCSUMDlgGroupResource
extends AbstractCSUMRestResource {
    private static final Logger LOG = LoggerFactory.getLogger(PublicCSUMDlgGroupResource.class);
    ICSUMActiveObjectService fAos;
    ICSUMCacheManager fCacheManager;
    private final PluginAccessor fPluginAccessor;
    private final DlgGroupManager fDgm;
    private static final String EMPTY_STRING = "";

    public PublicCSUMDlgGroupResource(@ComponentImport SpaceManager spaceManager, ICSUMActiveObjectService aos, CSUMPermissionUtil permissionUtil, XsrfTokenService tokenService, PermissionManager permissionManager, @ComponentImport PluginAccessor pluginAccessor, DlgGroupManager dGm, ICSUMCacheManager cacheManager) {
        super(spaceManager, permissionUtil, tokenService, permissionManager, cacheManager);
        this.fAos = aos;
        this.fPluginAccessor = pluginAccessor;
        this.fDgm = dGm;
        this.fCacheManager = cacheManager;
    }

    @PUT
    @Path(value="/addusers")
    @Produces(value={"application/json"})
    public Response addUsersToGroups(@QueryParam(value="spaceKey") String spaceKeyStr, @QueryParam(value="dlgGroups") String dlgGroupsStr, @QueryParam(value="spaceUsers") String spaceUsersStr, @QueryParam(value="importViaGroups") String importViaGroupsStr) {
        Space validSpace;
        String spaceKey = spaceKeyStr != null ? spaceKeyStr : EMPTY_STRING;
        String dlgGroups = dlgGroupsStr != null ? dlgGroupsStr : EMPTY_STRING;
        String spaceUsers = spaceUsersStr != null ? spaceUsersStr : EMPTY_STRING;
        String importViaGroups = importViaGroupsStr != null ? importViaGroupsStr : EMPTY_STRING;
        try {
            validSpace = this.getValidSpaceFromKey(spaceKey);
        }
        catch (InvalidSpaceException e) {
            LOG.error("Invalid Space, could not find Space using spacekey: " + spaceKey, (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)spaceKey).build();
        }
        boolean isPermitted = this.isPermitted(validSpace);
        if (!isPermitted) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (dlgGroups.trim().isEmpty() || spaceUsers.trim().isEmpty() && importViaGroups.trim().isEmpty()) {
            LOG.error("No groups or users specified: spaceGroups=" + dlgGroups + ", spaceUsers=" + spaceUsers);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        ICSUMCachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
        Response response = cachedConfig != null && cachedConfig.isDlgGrpActPerm() ? this.addDlgUsersToGroup(spaceKey, dlgGroups, spaceUsers, importViaGroups, validSpace) : Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        return response;
    }

    private Response addDlgUsersToGroup(String spaceKey, String dlgGroups, String spaceUsers, String importViaGroups, Space validSpace) {
        Response response;
        try {
            JSONAddUserResultBean[] result = this.fDgm.addUsersToGroups(validSpace, dlgGroups, spaceUsers, importViaGroups);
            response = Response.ok((Object)result).build();
        }
        catch (AuthorizationException e) {
            LOG.error(AuthenticatedUserThreadLocal.getUsername() + " is not authorized to add users to delegated groups: " + dlgGroups);
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (EntityException e) {
            LOG.error("Could not get group members for space: " + spaceKey, (Throwable)e);
            ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exceptionBean).build();
        }
        catch (Exception e) {
            LOG.error("Unhandled error when adding users: " + (!spaceUsers.equals(EMPTY_STRING) ? spaceUsers : "null") + " to group(s): " + dlgGroups + ", " + (!importViaGroups.equals(EMPTY_STRING) ? importViaGroups : "null"), (Throwable)e);
            ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
            response = Response.status((Response.Status)Response.Status.SEE_OTHER).entity((Object)exceptionBean).build();
        }
        return response;
    }

    @DELETE
    @Path(value="/removeusers")
    @Produces(value={"application/json"})
    public Response removeGroupMembers(@QueryParam(value="spaceKey") String spaceKeyStr, @QueryParam(value="dlgGroups") String dlgGroupsStr, @QueryParam(value="spaceUsers") String spaceUsersStr, @QueryParam(value="importViaGroups") String importViaGroupsStr) throws EntityException {
        Space validSpace;
        String spaceKey = spaceKeyStr != null ? spaceKeyStr : EMPTY_STRING;
        String dlgGroups = dlgGroupsStr != null ? dlgGroupsStr : EMPTY_STRING;
        String spaceUsers = spaceUsersStr != null ? spaceUsersStr : EMPTY_STRING;
        String importViaGroups = importViaGroupsStr != null ? importViaGroupsStr : EMPTY_STRING;
        try {
            validSpace = this.getValidSpaceFromKey(spaceKey);
        }
        catch (InvalidSpaceException e) {
            LOG.error("Invalid Space, could not find Space using spacekey: " + spaceKey, (Throwable)e);
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)spaceKey).build();
        }
        boolean isPermitted = this.isPermitted(validSpace);
        if (!isPermitted) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (dlgGroups.trim().isEmpty() || spaceUsers.trim().isEmpty() && importViaGroups.trim().isEmpty()) {
            LOG.error("No groups or users specified: spaceGroups=" + dlgGroups + ", spaceUsers=" + spaceUsers);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        if (this.fDgm.isRemovingLastUser(dlgGroups, spaceUsers, validSpace)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ICSUMCachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
        Response response = cachedConfig != null && cachedConfig.isDlgGrpActPerm() ? this.removeDlgUsersFromGroup(dlgGroups, spaceUsers, importViaGroups, validSpace) : Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        return response;
    }

    private Response removeDlgUsersFromGroup(String dlgGroups, String spaceUsers, String importViaGroups, Space validSpace) {
        Response response;
        try {
            List<String> failedToRemove = this.fDgm.removeUsersSpaceDlgGroups(dlgGroups, spaceUsers, importViaGroups, validSpace);
            response = Response.ok(failedToRemove).build();
        }
        catch (RemoveAllUsersException e) {
            LOG.error("Attempting to remove last member from group(s): " + dlgGroups);
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
        }
        catch (AuthorizationException e) {
            LOG.error(AuthenticatedUserThreadLocal.getUsername() + " is not authorized to remove users from delegated groups: " + dlgGroups);
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            LOG.error("Unhandled error when removing group members: " + (!spaceUsers.equals(EMPTY_STRING) ? spaceUsers : "null") + " from: " + dlgGroups + ", " + (!importViaGroups.equals(EMPTY_STRING) ? importViaGroups : "null"), (Throwable)e);
            ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
            response = Response.status((Response.Status)Response.Status.SEE_OTHER).entity((Object)exceptionBean).build();
        }
        return response;
    }
}

