/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.publicapi.components;

import com.atlassian.annotations.PublicApi;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.AuthorizationException;
import com.pluginpeople.confluence.csum.api.IPublicCSUMDlgSpaceGroupManager;
import com.pluginpeople.confluence.csum.api.RemoveAllUsersException;
import com.pluginpeople.confluence.csum.api.beans.JSONAddUserResultBean;
import com.pluginpeople.confluence.csum.service.cache.CSUMCachedDlgGroup;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCachedConfig;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import com.pluginpeople.confluence.csum.util.DlgEntryXmlStrConv;
import com.pluginpeople.confluence.csum.util.SpaceGroupUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
@PublicApi
public class PublicCSUMDlgSpaceGroupUtil
implements IPublicCSUMDlgSpaceGroupManager {
    private static final Logger LOG = LoggerFactory.getLogger(PublicCSUMDlgSpaceGroupUtil.class);
    private final ICSUMActiveObjectService fICActiveObjectService;
    private final ICSUMCacheManager fCacheManager;
    private final I18nResolver fI18n;
    private final GroupManager fGroupManager;
    private final CSUMPermissionUtil fPermissionUtil;
    private final SpaceGroupUtil fSpaceGroupUtil;
    private final UserAccessor fUserAccessor;
    private final SpaceManager fSpaceManager;
    ICSUMActiveObjectService fAos;
    private static final String COMMA_STRING = ",";
    private static final String MEMBERSHIP_REASON = "membership";
    private static final String USE_CONFLUENCE = "USECONFLUENCE";
    private static final String ADMINISTRATE_CONFLUENCE = "ADMINISTRATECONFLUENCE";

    @Autowired
    public PublicCSUMDlgSpaceGroupUtil(ICSUMActiveObjectService iCActiveObjectService, ICSUMCacheManager cacheManager, @ComponentImport I18nResolver i18N, @ComponentImport UserAccessor userAccessor, @ComponentImport GroupManager groupManager, CSUMPermissionUtil permissionUtil, SpaceGroupUtil spaceGroupUtil, ICSUMActiveObjectService aos, @ComponentImport SpaceManager spaceManager) {
        this.fICActiveObjectService = iCActiveObjectService;
        this.fCacheManager = cacheManager;
        this.fI18n = i18N;
        this.fGroupManager = groupManager;
        this.fPermissionUtil = permissionUtil;
        this.fSpaceGroupUtil = spaceGroupUtil;
        this.fAos = aos;
        this.fUserAccessor = userAccessor;
        this.fSpaceManager = spaceManager;
    }

    public JSONAddUserResultBean[] addUsersToGroups(Space space, String groupNames, String userNames, String importViaGroups) throws AuthorizationException, EntityException {
        String[] groupNameArr = groupNames.split(COMMA_STRING);
        ICSUMActiveObjectService.CSUMOperationType operationType = ICSUMActiveObjectService.CSUMOperationType.addUserToGroup;
        this.checkUserAuthorization(space, Arrays.asList(groupNameArr), operationType);
        ArrayList<String> unSuccessfulUsers = new ArrayList<String>();
        ArrayList<String> unSuccessfulUserNames = new ArrayList<String>();
        ArrayList<String> unSuccessfulUserReasons = new ArrayList<String>();
        ArrayList<JSONAddUserResultBean> groupResults = new ArrayList<JSONAddUserResultBean>();
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        try {
            String autoJoinGroupsStr;
            ArrayList<Group> groups = new ArrayList<Group>();
            for (String groupName : groupNameArr) {
                groups.add(this.fGroupManager.getGroup(groupName));
            }
            SpaceGroupUtil.OperationResult<ConfluenceUser> userValidationResult = this.fSpaceGroupUtil.validateCSVUsers(space, userNames, importViaGroups.split(COMMA_STRING));
            int totalUsers = userValidationResult.successes.size() + userValidationResult.failures.size();
            ICSUMCachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
            String string = autoJoinGroupsStr = cachedConfig != null ? cachedConfig.getAutoJoinGroups() : null;
            if (autoJoinGroupsStr != null && !autoJoinGroupsStr.isEmpty()) {
                String[] autoJoinGroupArr;
                for (String groupName : autoJoinGroupArr = autoJoinGroupsStr.split(COMMA_STRING)) {
                    Group autoGroup = this.fGroupManager.getGroup(groupName);
                    if (autoGroup == null || groups.contains(autoGroup)) continue;
                    groups.add(autoGroup);
                }
            }
            for (Group aGroup : groups) {
                if (aGroup == null) continue;
                int successfulUsersCounter = 0;
                unSuccessfulUsers.clear();
                unSuccessfulUserNames.clear();
                unSuccessfulUserReasons.clear();
                for (ConfluenceUser aUser : userValidationResult.successes) {
                    Objects.requireNonNull(aUser);
                    Objects.requireNonNull(aGroup);
                    String userKey = aUser.getKey().getStringValue();
                    String userName = aUser.getName();
                    if (!this.fGroupManager.hasMembership(aGroup, (User)aUser)) {
                        this.fGroupManager.addMembership(aGroup, (User)aUser);
                        this.fICActiveObjectService.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.addUserToGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.success, space, aGroup.getName(), userKey, currentUser.getName(), null, null, null);
                        ++successfulUsersCounter;
                        continue;
                    }
                    unSuccessfulUsers.add(userKey);
                    unSuccessfulUserNames.add(userName);
                    unSuccessfulUserReasons.add(MEMBERSHIP_REASON);
                }
                JSONAddUserResultBean groupData = new JSONAddUserResultBean(aGroup.getName(), successfulUsersCounter, unSuccessfulUsers.toArray(new String[0]), unSuccessfulUserNames.toArray(new String[0]), unSuccessfulUserReasons.toArray(new String[0]), totalUsers);
                groupResults.add(groupData);
            }
        }
        catch (EntityException e) {
            this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.addUserToGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, null, null, currentUser.getName(), e.getLocalizedMessage(), null, null);
            LOG.error("Exception during addition of space group members", (Throwable)e);
            throw e;
        }
        return groupResults.toArray(new JSONAddUserResultBean[0]);
    }

    public List<String> removeUsersSpaceDlgGroups(String dlgGroups, String userNames, String membershipGroups, String spaceKey) throws RemoveAllUsersException, EntityException, AuthorizationException {
        String usersToStr;
        List<String> groups = Arrays.asList(dlgGroups.split(COMMA_STRING));
        ICSUMActiveObjectService.CSUMOperationType operationType = ICSUMActiveObjectService.CSUMOperationType.removeUserFromGroup;
        this.checkUserAuthorization(this.fSpaceManager.getSpace(spaceKey), groups, operationType);
        HashSet<ConfluenceUser> userList = new HashSet<ConfluenceUser>();
        if (userNames != null && !userNames.isEmpty()) {
            String[] users;
            for (String userName : users = userNames.split(COMMA_STRING)) {
                userList.add(this.fUserAccessor.getUserByName(userName));
            }
        }
        if (membershipGroups != null && !membershipGroups.isEmpty()) {
            String[] membershipGroupArr;
            for (String groupName : membershipGroupArr = membershipGroups.split(COMMA_STRING)) {
                if (groups.contains(groupName) && this.isSystemGroup(groupName)) {
                    String msg = "Trying to remove members of " + groupName + " by removing members with membership of " + groupName;
                    this.fICActiveObjectService.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeUserFromGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, this.fSpaceManager.getSpace(spaceKey), groupName, null, AuthenticatedUserThreadLocal.getUsername(), msg, null, null);
                    LOG.error(msg);
                    throw new RemoveAllUsersException(this.fI18n.getText("csum.error.remove.last.user"));
                }
                Group group = this.fGroupManager.getGroup(groupName);
                if (group == null) continue;
                for (ConfluenceUser userObject : this.fUserAccessor.getMembers(group)) {
                    userList.add(userObject);
                }
            }
        }
        if (!(usersToStr = userList.stream().map(Entity::getName).collect(Collectors.joining(COMMA_STRING))).isEmpty() && this.isRemovingLastUser(dlgGroups, usersToStr, spaceKey)) {
            throw new RemoveAllUsersException(this.fI18n.getText("csum.error.remove.last.user"));
        }
        Space space = this.fSpaceManager.getSpace(spaceKey);
        ArrayList<Group> groupList = new ArrayList<Group>();
        for (String groupName : groups) {
            groupList.add(this.fGroupManager.getGroup(groupName));
        }
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        ArrayList<String> failedToRemove = new ArrayList<String>();
        for (Group groupObj : groupList) {
            String groupName = groupObj.getName();
            for (ConfluenceUser userObj : userList) {
                if (this.fGroupManager.hasMembership(groupObj, (User)userObj)) {
                    this.fGroupManager.removeMembership(groupObj, (User)userObj);
                    String msg = "User removed from group: " + groupName;
                    this.fICActiveObjectService.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeUserFromGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.success, space, groupName, userObj.getKey().getStringValue(), currentUser.getName(), msg, null, null);
                    LOG.debug(msg);
                    continue;
                }
                failedToRemove.add(userObj.getName());
            }
        }
        return failedToRemove;
    }

    private boolean isSystemGroup(String groupName) throws EntityException {
        boolean matched = false;
        Group aGroup = this.fGroupManager.getGroup(groupName);
        if (this.fPermissionUtil.hasPermission(aGroup, USE_CONFLUENCE) || this.fPermissionUtil.hasPermission(aGroup, ADMINISTRATE_CONFLUENCE)) {
            matched = true;
        }
        return matched;
    }

    private boolean isRemovingLastUser(String dlgGroups, String userNames, String spaceKey) throws EntityException {
        boolean removingAllUsers = false;
        ArrayList<ConfluenceUser> activeUsers = new ArrayList<ConfluenceUser>();
        ArrayList<ConfluenceUser> disabledUsers = new ArrayList<ConfluenceUser>();
        HashSet<Group> allGroupsSet = new HashSet<Group>();
        String[] dlgGroupArr = dlgGroups.split(COMMA_STRING);
        if (userNames != null) {
            List<String> userNamesList = Arrays.asList(userNames.split(COMMA_STRING));
            for (String groupName : dlgGroupArr) {
                allGroupsSet.add(this.fGroupManager.getGroup(groupName));
            }
            for (Group currentGroup : allGroupsSet) {
                disabledUsers.clear();
                activeUsers.clear();
                if (this.fPermissionUtil.hasPermission(currentGroup, USE_CONFLUENCE) || this.fPermissionUtil.hasPermission(currentGroup, ADMINISTRATE_CONFLUENCE)) {
                    for (String userName : userNamesList) {
                        ConfluenceUser user = this.fUserAccessor.getUserByName(userName);
                        if (this.fUserAccessor.isDeactivated((User)user)) {
                            disabledUsers.add(user);
                            continue;
                        }
                        activeUsers.add(user);
                    }
                    removingAllUsers = this.isRemovingAllUsers(userNamesList, activeUsers, disabledUsers, currentGroup);
                }
                if (!removingAllUsers) continue;
                String msg = "Trying to remove all members from a system group: " + currentGroup;
                this.fICActiveObjectService.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeUserFromGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, this.fSpaceManager.getSpace(spaceKey), currentGroup.getName(), null, AuthenticatedUserThreadLocal.getUsername(), msg, null, null);
                LOG.error(msg);
                break;
            }
        }
        return removingAllUsers;
    }

    private boolean isRemovingAllUsers(List<String> userNamesList, List<ConfluenceUser> users, List<ConfluenceUser> disabledUsers, Group group) {
        List members = this.fUserAccessor.getMemberNamesAsList(group);
        int numOfUsersInGroup = members.size();
        return numOfUsersInGroup == users.size() + disabledUsers.size() || this.isRemovingAllActiveUsers(userNamesList, members);
    }

    private void checkUserAuthorization(Space space, List<String> groups, ICSUMActiveObjectService.CSUMOperationType operationType) throws AuthorizationException {
        if (!this.fPermissionUtil.isAuthorized(space) || this.isNotDelegatedForAllGroups(groups)) {
            String msg = "UNAUTHORIZED access attempt by user: " + AuthenticatedUserThreadLocal.getUsername();
            this.fICActiveObjectService.createAuditEntity(operationType, ICSUMActiveObjectService.CSUMAuditEventOutcome.unauthorized, space, null, null, AuthenticatedUserThreadLocal.getUsername(), msg, null, null);
            LOG.error(msg);
            throw new AuthorizationException(this.fI18n.getText("notpermitted"));
        }
    }

    private boolean isRemovingAllActiveUsers(List<String> userNamesList, List<String> allUserNames) {
        ArrayList<String> activeUsers = new ArrayList<String>();
        for (String userName : allUserNames) {
            if (this.fUserAccessor.isDeactivated(userName)) continue;
            activeUsers.add(userName);
        }
        return userNamesList.containsAll(activeUsers);
    }

    private boolean isNotDelegatedForAllGroups(@Nonnull List<String> groupNames) {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        ArrayList<String> delegatedGroups = new ArrayList<String>();
        try {
            for (String s : this.getDlgGroupsForUser(currentUser)) {
                CSUMCachedDlgGroup csumCachedDlgGroup = DlgEntryXmlStrConv.stringToBean(s);
                String groupName = csumCachedDlgGroup.getGroupName();
                delegatedGroups.add(groupName);
            }
        }
        catch (JAXBException e) {
            LOG.error("Exception during delegated group cache value conversion", (Throwable)e);
        }
        LOG.warn(currentUser.getName() + "'s delegated groups are: " + delegatedGroups);
        LOG.warn(currentUser.getName() + "'s delegated groups expected to contain are: " + groupNames);
        return !delegatedGroups.containsAll(groupNames);
    }

    @Nonnull
    private List<String> getDlgGroupsForUser(ConfluenceUser remoteUser) {
        return Arrays.asList(this.fCacheManager.getDlgGroupsForUser(remoteUser));
    }
}

