/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.integration;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.pluginpeople.confluence.csum.ao.CSUMAuditEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.ITAuditingManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class ITAuditingManagerImpl
implements ITAuditingManager {
    private final ICSUMActiveObjectService fAos;

    @Autowired
    public ITAuditingManagerImpl(ICSUMActiveObjectService aos) {
        this.fAos = aos;
    }

    public int getNumberOfAuditEventsForSpace(Space space) {
        CSUMAuditEntity[] auditEntities = this.fAos.getAuditEvents(space);
        if (auditEntities == null) {
            auditEntities = new CSUMAuditEntity[]{};
        }
        return auditEntities.length;
    }

    public void createAuditEntityForSpace(Space space) {
        this.fAos.createAuditEntityForSpace(space);
    }

    public void createOldAuditEntityForSpace(Space space) {
        this.fAos.createOldAuditEntityForSpace(space);
    }

    public void deleteAllAuditEntities() {
        this.fAos.deleteAllAuditEntities(0);
    }

    public void attemptDeleteOldSpaceAuditHistory(Space space) {
        this.fAos.deleteAuditEntities(space, 30);
    }

    public String getLatestAuditStatusForSpace(Space space) {
        String result = "invalid";
        CSUMAuditEntity[] auditEntities = this.fAos.getAuditEvents(space);
        if (auditEntities != null && auditEntities.length != 0) {
            CSUMAuditEntity latestAuditEntity = auditEntities[0];
            result = latestAuditEntity.getEventOutcome();
        }
        return result;
    }
}

