/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.rest;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.access.annotations.RequiresLicensedConfluenceAccess;
import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.user.EntityException;
import com.pluginpeople.confluence.csum.api.AuthorizationException;
import com.pluginpeople.confluence.csum.rest.AbstractCSUMRestResource;
import com.pluginpeople.confluence.csum.rest.beans.DataTableUserList;
import com.pluginpeople.confluence.csum.rest.beans.UserSearchResult;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import com.pluginpeople.confluence.csum.util.DlgGroupManager;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ReadOnlyAccessAllowed
@RequiresLicensedConfluenceAccess
@Path(value="/dlguser")
public class DelegatedUserResource
extends AbstractCSUMRestResource {
    private static final Logger LOG = LoggerFactory.getLogger(DelegatedUserResource.class);
    private final DlgGroupManager fDgm;

    public DelegatedUserResource(XsrfTokenService tokenService, CSUMPermissionUtil permissionUtil, DlgGroupManager dGm, SpaceManager spaceManager, PermissionManager permissionManager, ICSUMCacheManager cacheManager) {
        super(spaceManager, permissionUtil, tokenService, permissionManager, cacheManager);
        this.fDgm = dGm;
    }

    @GET
    @Path(value="/list/auth")
    @Produces(value={"application/json"})
    public Response listAuthUsers(@Context HttpServletRequest hsr, @QueryParam(value="dlggroupid") int dlgGroupId, @QueryParam(value="atl_token") String atlToken) throws EntityException {
        Response response;
        if (this.isTokenInvalidOrNotGlobalAdmin(hsr)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            DataTableUserList dataTableFormat = this.fDgm.listAuthUsers(dlgGroupId);
            response = Response.ok((Object)dataTableFormat).build();
        }
        catch (EntityException e) {
            LOG.error("Error getting list of authorized users for: " + (dlgGroupId > 0 ? this.fDgm.getDlgGroup(dlgGroupId).getGroupName() : "null"), (Throwable)e);
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
        }
        return response;
    }

    @GET
    @Path(value="/searchauthusers")
    @Produces(value={"application/json"})
    public Response searchAuthUsers(@Context HttpServletRequest hsr, @QueryParam(value="query") String query, @QueryParam(value="atl_token") String atlToken) {
        if (this.isTokenInvalidOrNotGlobalAdmin(hsr)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        UserSearchResult[] result = this.fDgm.searchAuthUsers(query);
        return Response.ok((Object)result).build();
    }

    @GET
    @Path(value="/searchauthusersfromgroup")
    @Produces(value={"application/json"})
    public Response searchAuthUsersFromGroup(@Context HttpServletRequest hsr, @QueryParam(value="query") String query, @QueryParam(value="dlggroupid") int dlgGroupId, @QueryParam(value="atl_token") String atlToken) {
        if (this.isTokenInvalidOrNotGlobalAdmin(hsr)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        UserSearchResult[] result = null;
        try {
            result = this.fDgm.searchAuthUsersFromGroup(query, dlgGroupId);
        }
        catch (AuthorizationException e) {
            LOG.error("Authorization Exception, could not search auth users without an authorized user", (Throwable)e);
        }
        return Response.ok((Object)result).build();
    }
}

