/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.integration;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.pluginpeople.confluence.csum.ao.CSUMConfigEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.ITConfigManager;
import com.pluginpeople.confluence.csum.api.beans.ConfigBean;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.service.cache.ICachedConfig;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class ITConfigManagerImpl
implements ITConfigManager {
    private ICSUMCacheManager fCacheManager;
    private ICSUMActiveObjectService fAos;
    private TransactionTemplate fTxTemplate;

    @Autowired
    public ITConfigManagerImpl(ICSUMCacheManager cacheManager, ICSUMActiveObjectService aos, @ComponentImport TransactionTemplate txTemplate) {
        this.fCacheManager = cacheManager;
        this.fAos = aos;
        this.fTxTemplate = txTemplate;
    }

    public ConfigBean getConfiguration() {
        ICachedConfig current = (ICachedConfig)this.fTxTemplate.execute((TransactionCallback)new TransactionCallback<ICachedConfig>(){

            public ICachedConfig doInTransaction() {
                return ITConfigManagerImpl.this.fCacheManager.getCachedConfig();
            }
        });
        ConfigBean bean = new ConfigBean();
        bean.setAutoJoinGroups(current.getAutoJoinGroups());
        bean.setGroupActionsPermitted(current.isGroupActionsPermitted());
        bean.setGroupAddRemovePermitted(current.isGroupAddRemovePermitted());
        bean.setGroupRenamePermitted(current.isGroupRenamePermitted());
        bean.setRenameGlobalPermitted(current.isRenameGlobalPermitted());
        bean.setCleanSpacePermsSelected(current.getCleanSpacePermsSelected());
        bean.setCleanPagePermsSelected(current.getCleanPagePermsSelected());
        bean.setRemoveUserFromPermGrpPerm(current.isRemoveUserFromPermGrpPerm());
        bean.setDlgGrpActPerm(current.isDlgGrpActPerm());
        bean.setShowGroupInformation(current.getShowGroupInformation());
        bean.setGroupPrefixPattern(current.getGroupPrefixPattern());
        bean.setGroupSuffixPattern(current.getGroupSuffixPattern());
        bean.setGroupNameRegexp(current.getGroupNameRegexp());
        bean.setJiraRestPassword(current.getJiraRestPassword());
        bean.setJiraRestUrl(current.getJiraRestUrl());
        bean.setJiraRestUsername(current.getJiraRestUsername());
        bean.setMaxGroupIDsLimit(current.getMaxGroupIDsLimit());
        bean.setMaxUserIDsLimit(current.getMaxUserIDsLimit());
        bean.setPersonalSpaceAllowed(current.isPersonalSpaceAllowed());
        bean.setPluginDown(current.isPluginDown());
        bean.setPluginDownMsg(current.getPluginDownMsg());
        bean.setProviderType(current.getProviderType());
        bean.setUserManagerLocation(current.getUserManagerLocation());
        bean.setUserSearchEnabled(current.isUserSearchEnabled());
        bean.setUserDirectories(current.getUserDirectories());
        bean.setExtLdapDirectories(current.getExtLdapDirectories());
        bean.setDisabledUserHandling(current.getDisabledUserHandling());
        bean.setBlocklistGroups(current.getBlocklistGroups());
        bean.setGroupFilter(current.getGroupFilter());
        bean.setGroupFilterBehavior(current.getGroupFilterBehavior());
        bean.setCreateUsersEnabled(current.isCreateUsersEnabled());
        bean.setHideUserOperations(current.isHideUserOperations());
        bean.setHideGroupOperations(current.isHideGroupOperations());
        bean.setAllowAdminDeleteAudits(current.isAllowAdminDeleteAudits());
        bean.setGroupPageProcessing(current.isGroupPageProcessing());
        bean.setUserPageProcessing(current.isUserPageProcessing());
        return bean;
    }

    public void setConfiguration(final ConfigBean config) {
        this.fTxTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction() {
                CSUMConfigEntity entity = ITConfigManagerImpl.this.fAos.getConfig();
                String oldPrefix = entity.getGroupPrefixPattern();
                String oldSuffix = entity.getGroupSuffixPattern();
                entity.setAutoJoinGroups(config.getAutoJoinGroups());
                entity.setGroupActionsPermitted(config.isGroupActionsPermitted());
                entity.setGroupAddRemovePermitted(config.isGroupAddRemovePermitted());
                entity.setGroupRenamePermitted(config.isGroupRenamePermitted());
                entity.setRenameGlobalPermitted(config.isRenameGlobalPermitted());
                entity.setCleanSpacePermsSelected(config.getCleanSpacePermsSelected());
                entity.setCleanPagePermsSelected(config.getCleanPagePermsSelected());
                entity.setRemoveUserFromPermGrpPerm(config.isRemoveUserFromPermGrpPerm());
                entity.setDlgGrpActPerm(config.isDlgGrpActPerm());
                entity.setShowGroupInformation(config.getShowGroupInformation());
                entity.setGroupPrefixPattern(config.getGroupPrefixPattern());
                entity.setGroupSuffixPattern(config.getGroupSuffixPattern());
                entity.setGroupNameRegexp(config.getGroupNameRegexp());
                entity.setJiraRestPassword(config.getJiraRestPassword());
                entity.setJiraRestUrl(config.getJiraRestUrl());
                entity.setJiraRestUsername(config.getJiraRestUsername());
                entity.setMaxGroupIDsLimit(config.getMaxGroupIDsLimit());
                entity.setMaxUserIDsLimit(config.getMaxUserIDsLimit());
                entity.setPersonalSpaceAllowed(config.isPersonalSpaceAllowed());
                entity.setPluginDown(config.isPluginDown());
                entity.setPluginDownMsg(config.getPluginDownMsg());
                entity.setProviderType(config.getProviderType());
                entity.setUserManagerLocation(config.getUserManagerLocation());
                entity.setUserSearchEnabled(config.isUserSearchEnabled());
                entity.setDisabledUserHandling(config.getDisabledUserHandling());
                entity.setBlocklistGroups(config.getBlocklistGroups());
                entity.setGroupFilter(config.getGroupFilter());
                entity.setGroupFilterBehavior(config.getGroupFilterBehavior());
                entity.setCreateUsersEnabled(config.isCreateUsersEnabled());
                entity.setUserDirectories(config.getUserDirectories());
                entity.setExtLdapDirectories(config.getExtLdapDirectories());
                entity.setHideUserOperations(config.isHideUserOperations());
                entity.setHideGroupOperations(config.isHideGroupOperations());
                entity.setAllowAdminDeleteAudits(config.isAllowAdminDeleteAudits());
                entity.setGroupPageProcessing(config.isGroupPageProcessing());
                entity.setUserPageProcessing(config.isUserPageProcessing());
                entity.save();
                ITConfigManagerImpl.this.fCacheManager.updateCachedConfig(entity);
                if (!Objects.equals(oldPrefix, config.getGroupPrefixPattern()) || !Objects.equals(oldSuffix, config.getGroupSuffixPattern())) {
                    ITConfigManagerImpl.this.fCacheManager.flushAll();
                }
                return null;
            }
        });
    }
}

