/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.rest;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.security.access.annotations.RequiresLicensedConfluenceAccess;
import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.pluginpeople.confluence.csum.api.InvalidSpaceException;
import com.pluginpeople.confluence.csum.api.beans.RequestAuthenticationBean;
import com.pluginpeople.confluence.csum.rest.AbstractCSUMRestResource;
import com.pluginpeople.confluence.csum.rest.beans.JSONCloneGroupsResult;
import com.pluginpeople.confluence.csum.rest.beans.SpaceSearchResult;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import com.pluginpeople.confluence.csum.util.CloneSpaceGroupUtil;
import com.pluginpeople.confluence.csum.util.SpaceGroupUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresLicensedConfluenceAccess
@ReadOnlyAccessAllowed
@Path(value="/space")
public class SpaceResource
extends AbstractCSUMRestResource {
    private static final Logger LOG = LoggerFactory.getLogger(SpaceResource.class);
    private final SpaceGroupUtil fSpaceGroupUtil;
    private final CloneSpaceGroupUtil fCloneSpaceGroupUtil;

    public SpaceResource(@ComponentImport SpaceManager spaceManager, @ComponentImport XsrfTokenService tokenService, CSUMPermissionUtil permissionUtil, CloneSpaceGroupUtil cloneSpaceGroupUtil, SpaceGroupUtil grpUtil, ICSUMCacheManager cacheManager, @ComponentImport AccessModeService accessModeService) {
        super(spaceManager, permissionUtil, tokenService, cacheManager, accessModeService);
        this.fSpaceGroupUtil = grpUtil;
        this.fCloneSpaceGroupUtil = cloneSpaceGroupUtil;
    }

    @POST
    @Path(value="/clone")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response cloneGroupsAndUsers(@Context HttpServletRequest hsr, @QueryParam(value="atl_token") String atlToken, @FormParam(value="currentSpaceKey") String currentSpaceKey, @FormParam(value="groupsToClone") String groupsToCloneCsv, @FormParam(value="targetSpaceKey") String cloneFromSpaceKey, @FormParam(value="cloneUsers") boolean cloneUsers) {
        Response response;
        RequestAuthenticationBean currentRab = this.authenticateEndpointForAdmin(hsr, currentSpaceKey, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        RequestAuthenticationBean targetRab = this.authenticateEndpointForAdmin(hsr, cloneFromSpaceKey, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!currentRab.isAuthenticated() || !targetRab.isAuthenticated()) {
            LOG.debug("Request user was authenticated to Clone FROM Space [" + cloneFromSpaceKey + "]: [" + targetRab.isAuthenticated() + "], and Clone TO Space [" + currentSpaceKey + "]: [" + currentRab.isAuthenticated() + "]");
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        } else if (this.invalidPrefixAndSuffix()) {
            LOG.debug("Neither the prefix or suffix is set in the CSUM config");
            response = Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        } else {
            boolean currentSpaceValid = false;
            boolean targetSpaceValid = false;
            try {
                currentSpaceValid = this.getValidSpaceFromKey(currentSpaceKey) != null;
                targetSpaceValid = this.getValidSpaceFromKey(cloneFromSpaceKey) != null;
            }
            catch (InvalidSpaceException e) {
                LOG.error("InvalidSpaceException: " + e.getLocalizedMessage(), (Throwable)e);
            }
            if (!currentSpaceValid || !targetSpaceValid) {
                response = Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)(!currentSpaceValid ? currentSpaceKey : cloneFromSpaceKey)).build();
            } else {
                JSONCloneGroupsResult ret = this.fCloneSpaceGroupUtil.cloneGroupsAndUsers(currentSpaceKey, cloneFromSpaceKey, groupsToCloneCsv, cloneUsers);
                response = Response.ok((Object)ret).build();
            }
        }
        return response;
    }

    @POST
    @Path(value="/search")
    @Produces(value={"application/json"})
    public Response searchSpaces(@Context HttpServletRequest hsr, @FormParam(value="spaceKey") String spaceKey, @QueryParam(value="atl_token") String atlToken, @FormParam(value="term") String term, @FormParam(value="pageLimit") int pageLimit) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, spaceKey, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        } else if (spaceKey != null) {
            boolean isValidSpace = false;
            try {
                isValidSpace = this.getValidSpaceFromKey(spaceKey) != null;
            }
            catch (InvalidSpaceException e) {
                LOG.error("InvalidSpaceException: " + e.getLocalizedMessage(), (Throwable)e);
            }
            if (!isValidSpace) {
                response = Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)spaceKey).build();
            } else {
                List<SpaceSearchResult> results = this.fSpaceGroupUtil.searchForSpaces(term, pageLimit);
                response = Response.ok(results).build();
            }
        } else {
            List<SpaceSearchResult> results = this.fSpaceGroupUtil.searchForSpaces(term, pageLimit);
            response = Response.ok(results).build();
        }
        return response;
    }
}

