/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.util.jira;

import com.pluginpeople.confluence.csum.legacy.LogUtil;
import com.pluginpeople.confluence.csum.legacy.ServiceAuthenticationException;
import com.pluginpeople.confluence.csum.legacy.ServiceContext;
import com.pluginpeople.confluence.csum.service.CustomPermissionConfigurable;
import com.pluginpeople.confluence.csum.util.jira.JiraServiceAuthenticationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JiraRestUtil {
    private static final Log LOG = LogFactory.getLog(JiraRestUtil.class);
    private static String fUser;
    private static String fPass;
    private static String fUrl;

    public static JiraServiceAuthenticationContext login(ServiceContext serviceContext) throws ServiceAuthenticationException {
        JiraServiceAuthenticationContext jiraServiceAuthenticationContext = new JiraServiceAuthenticationContext();
        LOG.info((Object)"login()");
        try {
            CustomPermissionConfigurable config = serviceContext.getCustomPermissionConfigurable();
            fUrl = config.getJiraRestUrl();
            fUser = config.getJiraRestUsername();
            fPass = config.getJiraRestPassword();
        }
        catch (Exception t) {
            LogUtil.errorWithRemoteUserInfo(LOG, "Failed Jira SOAP Authentication!", t);
            throw new ServiceAuthenticationException("Failed Jira SOAP Authentication!", t);
        }
        return jiraServiceAuthenticationContext;
    }

    public static void logout(JiraServiceAuthenticationContext jiraServiceAuthenticationContext) throws ServiceAuthenticationException {
        LOG.info((Object)"logout()");
    }
}

