/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.service;

import com.atlassian.confluence.event.events.space.SpaceRemoveEvent;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.EntityException;
import com.pluginpeople.confluence.csum.ao.CSUMActiveObjectServiceImpl;
import com.pluginpeople.confluence.csum.ao.CSUMAuditEntity;
import com.pluginpeople.confluence.csum.ao.CSUMConfigEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.DuplicateException;
import com.pluginpeople.confluence.csum.api.beans.DlgGroupBean;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.util.DlgGroupManager;
import com.pluginpeople.confluence.csum.util.SpaceGroupUtil;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EntityDeletionListener
implements DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(EntityDeletionListener.class);
    private final DlgGroupManager fDgm;
    private final ICSUMActiveObjectService fICActiveObjectService;
    private final TransactionTemplate fTxTemplate;
    private final CSUMActiveObjectServiceImpl fCaos;
    Map<String, Long> fIssuedAuditEvents = new HashMap<String, Long>();
    private final ICSUMCacheManager fCacheManager;
    private final SpaceGroupUtil fSpaceGroupUtil;
    private final EventPublisher fEventPublisher;

    @Autowired
    public EntityDeletionListener(ICSUMCacheManager cacheManager, SpaceGroupUtil sgu, @ComponentImport EventPublisher eventPublisher, DlgGroupManager dlgGroupManager, ICSUMActiveObjectService icsumActiveObjectService, @ComponentImport TransactionTemplate txTemplate, CSUMActiveObjectServiceImpl csumActiveObjectService) {
        this.fCacheManager = cacheManager;
        this.fSpaceGroupUtil = sgu;
        this.fEventPublisher = eventPublisher;
        this.fEventPublisher.register((Object)this);
        this.fDgm = dlgGroupManager;
        this.fICActiveObjectService = icsumActiveObjectService;
        this.fTxTemplate = txTemplate;
        this.fCaos = csumActiveObjectService;
    }

    @EventListener
    public void groupDeleted(GroupDeletedEvent deleted) throws DuplicateException, EntityException {
        this.deleteSpaceGroupFromCache(deleted);
        this.deleteDlgGrpAndRemAuth(deleted);
        this.removeFromBlocklistGroups(deleted);
        this.removeFromGroupFilter(deleted);
        this.logIfDeletedExternally(deleted);
    }

    private void logIfDeletedExternally(GroupDeletedEvent deleted) {
        if (this.hasBeenFired(deleted)) {
            return;
        }
        boolean deletedByCsum = false;
        String groupName = deleted.getGroupName();
        if (groupName != null) {
            Query query = Query.select().where("GROUP_NAME = ?", new Object[]{groupName}).limit(10);
            CSUMAuditEntity[] auditEventEntities = this.fCaos.getAuditEvents(query);
            LocalDateTime now = LocalDateTime.now();
            Timestamp tenSecondsBefore = Timestamp.valueOf(now.minus(10L, ChronoUnit.SECONDS));
            for (CSUMAuditEntity auditEventEntity : auditEventEntities) {
                String operationType = auditEventEntity.getOperationType();
                if (!auditEventEntity.getCreatedDate().after(tenSecondsBefore) || operationType == null || !operationType.equalsIgnoreCase("removeGroup") && !operationType.equalsIgnoreCase("removeRemoteGroup")) continue;
                deletedByCsum = true;
                break;
            }
            if (!deletedByCsum) {
                String msg = groupName + " was manually deleted by " + AuthenticatedUserThreadLocal.getUsername();
                this.fCaos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.groupDeletedExternally, ICSUMActiveObjectService.CSUMAuditEventOutcome.success, null, groupName, null, AuthenticatedUserThreadLocal.getUsername(), msg, null, null);
                LOG.debug(msg);
            }
        }
    }

    private boolean hasBeenFired(GroupDeletedEvent deleted) {
        String groupName = deleted.getGroupName();
        long timestamp = deleted.getTimestamp();
        boolean hasBeenFired = false;
        if (this.fIssuedAuditEvents.containsKey(groupName) && timestamp - this.fIssuedAuditEvents.get(groupName) < 500L) {
            hasBeenFired = true;
        }
        this.fIssuedAuditEvents.put(groupName, timestamp);
        if (this.fIssuedAuditEvents.size() > 10) {
            this.fIssuedAuditEvents.entrySet().stream().min(Comparator.comparingLong(Map.Entry::getValue)).ifPresent(entry -> this.fIssuedAuditEvents.remove(entry.getKey()));
        }
        return hasBeenFired;
    }

    private void removeFromGroupFilter(GroupDeletedEvent deleted) {
        String groupFilterCsv = this.fCacheManager.getGroupFilter();
        if (groupFilterCsv == null || groupFilterCsv.isEmpty() || groupFilterCsv.equalsIgnoreCase("none")) {
            return;
        }
        boolean removed = false;
        String[] groupNames = groupFilterCsv.split(",");
        HashSet<String> groupNameSet = new HashSet<String>(Arrays.asList(groupNames));
        for (String groupName : groupNames) {
            String deletedGroupName = deleted.getGroupName();
            if (!deletedGroupName.equalsIgnoreCase(groupName)) continue;
            groupNameSet.remove(groupName);
            removed = true;
            String msg = deletedGroupName + " removed from filter because it has been deleted by " + AuthenticatedUserThreadLocal.getUsername();
            this.fCaos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removedFromFilter, ICSUMActiveObjectService.CSUMAuditEventOutcome.success, null, deletedGroupName, null, AuthenticatedUserThreadLocal.getUsername(), msg, null, null);
            LOG.debug(msg);
        }
        if (removed) {
            CSUMConfigEntity config = (CSUMConfigEntity)this.fTxTemplate.execute((TransactionCallback)new TransactionCallback<CSUMConfigEntity>(){

                public CSUMConfigEntity doInTransaction() {
                    return EntityDeletionListener.this.fICActiveObjectService.getConfig();
                }
            });
            String filterString = groupNameSet.isEmpty() ? "none" : String.join((CharSequence)",", groupNameSet);
            config.setGroupFilter(filterString);
            config.save();
            this.fCacheManager.flushAll();
        }
    }

    private void removeFromBlocklistGroups(GroupDeletedEvent deleted) {
        String blocklistGroupsCsv = this.fCacheManager.getBlocklistGroups();
        if (blocklistGroupsCsv.equalsIgnoreCase("none")) {
            return;
        }
        boolean removed = false;
        String[] groupNames = blocklistGroupsCsv.split(Pattern.quote("|"));
        HashSet<String> groupNameSet = new HashSet<String>(Arrays.asList(groupNames));
        for (String groupName : groupNames) {
            String deletedGroupName = deleted.getGroupName();
            if (!deletedGroupName.equalsIgnoreCase(groupName)) continue;
            groupNameSet.remove(groupName);
            removed = true;
            String msg = deletedGroupName + " removed from blocklisted groups because it has been deleted by " + AuthenticatedUserThreadLocal.getUsername();
            this.fCaos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removedFromBlocklistedGroups, ICSUMActiveObjectService.CSUMAuditEventOutcome.success, null, deletedGroupName, null, AuthenticatedUserThreadLocal.getUsername(), msg, null, null);
            LOG.debug(msg);
        }
        if (removed) {
            CSUMConfigEntity config = (CSUMConfigEntity)this.fTxTemplate.execute((TransactionCallback)new TransactionCallback<CSUMConfigEntity>(){

                public CSUMConfigEntity doInTransaction() {
                    return EntityDeletionListener.this.fICActiveObjectService.getConfig();
                }
            });
            String filterString = groupNameSet.isEmpty() ? "none" : String.join((CharSequence)"|", groupNameSet);
            config.setBlocklistGroups(filterString);
            config.save();
            this.fCacheManager.flushAll();
        }
    }

    @EventListener
    public void spaceDeleted(SpaceRemoveEvent deletedSpace) {
        LOG.debug("spaceDeleted() purging cache CSUM spaceGroups");
        long tStart = System.currentTimeMillis();
        this.fCacheManager.deleteSpaceGroups(deletedSpace.getSpace());
        LOG.debug("spaceDeleted() done.  Took " + (System.currentTimeMillis() - tStart) + "mS");
    }

    public void destroy() {
        this.fEventPublisher.unregister((Object)this);
    }

    public void deleteSpaceGroupFromCache(GroupDeletedEvent deleted) {
        LOG.debug("groupDeleted() removing group from cache CSUM spaceGroups");
        long tStart = System.currentTimeMillis();
        String groupName = deleted.getGroupName();
        Space aSpace = this.fSpaceGroupUtil.getSpaceForGroup(groupName);
        if (aSpace != null) {
            this.fCacheManager.deleteSpaceGroup(aSpace, groupName);
            LOG.debug("Space [" + aSpace.getKey() + "] group [" + groupName + "] deleted : " + aSpace + "\ngroupDeleted() done.  Took " + (System.currentTimeMillis() - tStart) + "mS");
        }
    }

    public void deleteDlgGrpAndRemAuth(GroupDeletedEvent deleted) throws DuplicateException, EntityException {
        String groupName = deleted.getGroupName();
        if (this.fCaos.getDelegatedGroup(groupName) != null) {
            DlgGroupBean dlgGroup = this.fDgm.getDlgGroupBean(groupName);
            if (dlgGroup != null && dlgGroup.getDlgGroupEntityId() != 0) {
                this.fDgm.deleteDlgGroup(dlgGroup, "via-event-listener");
            }
            this.fDgm.unauthorizeGroup(deleted.getGroupName());
        }
    }
}

