/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.task;

import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.pluginpeople.confluence.csum.ao.CSUMTaskEntity;
import com.pluginpeople.confluence.csum.task.CSVRecordLengthException;
import com.pluginpeople.confluence.csum.task.IAbstractTask;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.input.BOMInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTask
implements IAbstractTask {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTask.class);
    private TransactionTemplate fTxTemplate;
    private char delimiter;

    public final void setTxTemplate(TransactionTemplate template) {
        this.fTxTemplate = template;
    }

    public final void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    @Override
    public void run(int id) throws Exception {
        long timeStart = System.currentTimeMillis();
        try {
            this.processCsv(id);
        }
        catch (Exception e) {
            LOG.error("Problem processing CSV in job with id: " + id);
            throw e;
        }
        long timeEnd = System.currentTimeMillis();
        long duration = timeEnd - timeStart;
        LOG.debug("time taken: " + duration + "ms");
    }

    private void processCsv(int id) {
        int failCount = 0;
        int successCount = 0;
        AtomicBoolean successfulOperation = new AtomicBoolean(false);
        File file = new File(this.getFilePath());
        try (FileInputStream fis = new FileInputStream(file);
             BOMInputStream bis = new BOMInputStream((InputStream)fis);
             InputStreamReader isr = new InputStreamReader((InputStream)bis);
             BufferedReader br = new BufferedReader(isr);
             CSVParser parser = CSVParser.parse((Reader)br, (CSVFormat)CSVFormat.DEFAULT.withDelimiter(this.delimiter));){
            int counter = 0;
            boolean isFirstRecord = true;
            for (CSVRecord csvRecord : parser) {
                if (isFirstRecord) {
                    LOG.debug("First Record of file processing. The row contains " + csvRecord.size() + " values (Expecting 2).");
                }
                this.verifyValidRecord(csvRecord);
                if (isFirstRecord) {
                    LOG.debug("Record is valid, user: " + csvRecord.get(0).trim() + " and group: " + csvRecord.get(1).trim());
                }
                ++counter;
                Optional<Exception> result = this.executeCsvLineProcess(id, successfulOperation, csvRecord);
                if (successfulOperation.get()) {
                    ++successCount;
                } else {
                    ++failCount;
                }
                if (result.isPresent()) {
                    throw result.get();
                }
                this.delayThread();
                if (Thread.currentThread().isInterrupted()) break;
                isFirstRecord = false;
            }
            LOG.debug("Out of a total of: " + counter + " records processed, there were " + successCount + " Successful and " + failCount + " Failed records");
        }
        catch (Exception e) {
            LOG.error("InputStream could not be CSV parsed, full csv file may not have been completed.");
        }
    }

    private Optional<Exception> executeCsvLineProcess(int id, AtomicBoolean successfulOperation, CSVRecord csvRecord) {
        return (Optional)this.fTxTemplate.execute(() -> {
            try {
                boolean processSuccess = this.processRecord(csvRecord, id);
                successfulOperation.set(processSuccess);
            }
            catch (Exception e) {
                LOG.error("Problem processing record: " + csvRecord + " with id: " + id, (Throwable)e);
                return Optional.of(e);
            }
            return Optional.empty();
        });
    }

    private void verifyValidRecord(CSVRecord csvRecord) throws CSVRecordLengthException {
        if (csvRecord.size() != this.getExpectedFieldCount()) {
            LOG.error("CSV Record size was: " + csvRecord.size() + " when it is meant to be: " + this.getExpectedFieldCount() + ". Delimiter is:" + this.delimiter);
            throw new CSVRecordLengthException(this.getExpectedFieldCount(), csvRecord.size());
        }
    }

    private void delayThread() {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public abstract int getExpectedFieldCount();

    public abstract boolean willNotify();

    public static void saveTaskEntity(CSUMTaskEntity taskEntity, boolean isSuccessfulUser, String successfulUsersStr, String unsuccessfulUsersStr, String userNameVal) {
        if (isSuccessfulUser) {
            taskEntity.setSuccessfulTotal(taskEntity.getSuccessfulTotal() + 1);
            String val = successfulUsersStr == null ? userNameVal : successfulUsersStr + ", " + userNameVal;
            taskEntity.setSuccessfulUsers(val);
            LOG.debug("Adding successful user: " + userNameVal + ". Successful total now: " + taskEntity.getSuccessfulTotal());
        } else {
            taskEntity.setUnsuccessfulTotal(taskEntity.getUnsuccessfulTotal() + 1);
            String val = unsuccessfulUsersStr == null ? userNameVal : unsuccessfulUsersStr + ", " + userNameVal;
            taskEntity.setUnsuccessfulUsers(val);
            LOG.debug("Adding unsuccessful user: " + userNameVal + ". Unsuccessful total now: " + taskEntity.getUnsuccessfulTotal());
            if (taskEntity.getTaskType().equals("removeMembers")) {
                taskEntity.setMessage("Failed to remove user(s) as they could not be found, the group is blocklisted by your system admin or because removal of current user from global permission groups is prevented in your CSUM configuration");
            } else if (taskEntity.getTaskType().equals("addMembers")) {
                taskEntity.setMessage("Failed to add user(s) due to already having group membership or the group is blocklisted by your system admin");
            }
        }
        taskEntity.save();
    }
}

