/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.rest;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.security.access.annotations.RequiresLicensedConfluenceAccess;
import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.pluginpeople.confluence.csum.ao.CSUMBadGroupToolStatus;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.beans.RequestAuthenticationBean;
import com.pluginpeople.confluence.csum.rest.AbstractCSUMRestResource;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import com.pluginpeople.confluence.csum.util.CSUMToolManager;
import com.pluginpeople.confluence.csum.util.OpStatus;
import com.pluginpeople.confluence.csum.util.ToolRequest;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="tools")
@RequiresLicensedConfluenceAccess
@ReadOnlyAccessAllowed
@Deprecated
public class ToolsResource
extends AbstractCSUMRestResource {
    private ICSUMActiveObjectService fAo;
    private CSUMToolManager fToolAccessMgr;

    public ToolsResource(CSUMToolManager toolMgr, ICSUMActiveObjectService ao, SpaceManager spaceManager, CSUMPermissionUtil permissionUtil, XsrfTokenService tokenService, ICSUMCacheManager cacheManager, @ComponentImport AccessModeService accessModeService) {
        super(spaceManager, permissionUtil, tokenService, cacheManager, accessModeService);
        this.fAo = ao;
        this.fToolAccessMgr = toolMgr;
    }

    @GET
    @Path(value="groupnamefixer/status")
    @Produces(value={"application/json"})
    public Response getClusterGroupFixerStatus(@Context HttpServletRequest hsr) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else {
            this.fToolAccessMgr.resetIfTaskStuck();
            CSUMBadGroupToolStatus clusterStatus = this.fAo.getBadGroupToolStatus();
            if (clusterStatus != null) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("status", clusterStatus.getStatus());
                data.put("user", clusterStatus.getInitUser());
                data.put("updated", clusterStatus.getLastUpdated());
                if (OpStatus.RUNNING.name().equals(clusterStatus.getStatus())) {
                    data.put("localFinderRunning", this.fToolAccessMgr.isRunningOnLocalNode(CSUMToolManager.ToolKey.BAD_GROUP_FINDER));
                    data.put("localFixerRunning", this.fToolAccessMgr.isRunningOnLocalNode(CSUMToolManager.ToolKey.BADGROUP_FIXER));
                }
                response = Response.ok(data).build();
            } else {
                response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
        }
        return response;
    }

    @GET
    @Path(value="groupnamefixer/knowngroups")
    @Produces(value={"application/json"})
    public Response getKnownBadGroupCount(@Context HttpServletRequest hsr) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else {
            int existingCount = this.fAo.getBadGroupCount();
            response = Response.ok((Object)existingCount).build();
        }
        return response;
    }

    @GET
    @Path(value="groupnamefixer/find")
    @Produces(value={"text/plain"})
    public Response startBadGroupNameFinder(@Context HttpServletRequest hsr) {
        ToolRequest req;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        Response response = !rab.isAuthenticated() ? Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build() : ((req = this.fToolAccessMgr.requestBadGroupFinderLaunch()).isSuccess() ? Response.status((Response.Status)Response.Status.ACCEPTED).build() : Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)req.getMessage()).build());
        return response;
    }

    @DELETE
    @Path(value="groupnamefixer/find")
    @Produces(value={"text/plain"})
    public Response stopBadGroupNameFinder(@Context HttpServletRequest hsr) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else {
            this.fToolAccessMgr.requestBadGroupFinderStop();
            response = Response.ok().build();
        }
        return response;
    }

    @GET
    @Path(value="groupnamefixer/find/progress")
    @Produces(value={"application/json"})
    public Response getBadGroupNameFinderProgress(@Context HttpServletRequest hsr) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else {
            Map<String, Object> finderProgress = this.fToolAccessMgr.getBadGroupFinderProgress();
            response = Response.ok(finderProgress).build();
        }
        return response;
    }

    @GET
    @Path(value="groupnamefixer/fix")
    @Produces(value={"text/plain"})
    public Response startBadGroupNameFixer(@Context HttpServletRequest hsr) {
        ToolRequest req;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        Response response = !rab.isAuthenticated() ? Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build() : ((req = this.fToolAccessMgr.requestBadGroupFixerLaunch()).isSuccess() ? Response.status((Response.Status)Response.Status.ACCEPTED).build() : Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)req.getMessage()).build());
        return response;
    }

    @DELETE
    @Path(value="groupnamefixer/fix")
    @Produces(value={"text/plain"})
    public Response stopBadGroupNameFixer(@Context HttpServletRequest hsr) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else {
            this.fToolAccessMgr.requestBadGroupFixerStop();
            response = Response.ok().build();
        }
        return response;
    }

    @GET
    @Path(value="groupnamefixer/fix/progress")
    @Produces(value={"application/json"})
    public Response getBadGroupNameFixerProgress(@Context HttpServletRequest hsr) {
        Response response;
        RequestAuthenticationBean rab = this.authenticateEndpointForAdmin(hsr, null, AbstractCSUMRestResource.READ_ONLY_MODE_ACCESS.allow);
        if (!rab.isAuthenticated()) {
            response = Response.status((int)rab.getResponseCode()).entity((Object)rab.getRejectReason()).build();
        } else {
            Map<String, Object> fixerProgress = this.fToolAccessMgr.getBadGroupFixerProgress();
            response = Response.ok(fixerProgress).build();
        }
        return response;
    }
}

