/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.rest;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.pluginpeople.confluence.csum.api.InvalidSpaceException;
import com.pluginpeople.confluence.csum.api.beans.RequestAuthenticationBean;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.service.cache.ICachedConfig;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;

public abstract class AbstractCSUMRestResource {
    private final SpaceManager fSpaceManager;
    private final CSUMPermissionUtil fCPermissionUtil;
    private final XsrfTokenService fTokenService;
    private final ICSUMCacheManager fCacheManager;
    private final AccessModeService fAccessModeService;
    public static final String INVALID_SPACE_ERROR = "Invalid Space, could not find Space using spacekey: ";
    public static final String INVALID_TOKEN_MESSAGE = "Invalid XSRF: Request not authenticated";
    public static final String INVALID_ADMIN_MESSAGE = "Authenticated User lacks valid permissions";
    public static final String INVALID_LICENSE_MESSAGE = "Instance lacks valid CSUM license";
    public static final String READ_ONLY_MESSAGE = "Access to this request is blocked during 'Read Only' mode";

    public AbstractCSUMRestResource(SpaceManager spaceManager, CSUMPermissionUtil permissionUtil, XsrfTokenService tokenService, ICSUMCacheManager cacheManager, AccessModeService accessModeService) {
        this.fSpaceManager = spaceManager;
        this.fCPermissionUtil = permissionUtil;
        this.fTokenService = tokenService;
        this.fCacheManager = cacheManager;
        this.fAccessModeService = accessModeService;
    }

    protected final boolean isTokenValid(HttpServletRequest hsr) {
        return this.fTokenService.validateToken(hsr).isEmpty();
    }

    protected final boolean invalidPrefixAndSuffix() {
        boolean result = true;
        ICachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
        if (cachedConfig != null) {
            String cachedPrefix = cachedConfig.getGroupPrefixPattern();
            String cachedSuffix = cachedConfig.getGroupSuffixPattern();
            if (cachedPrefix != null || cachedSuffix != null) {
                result = false;
            }
        }
        return result;
    }

    protected final RequestAuthenticationBean authenticateEndpointForPublicApi(Space space, READ_ONLY_MODE_ACCESS readOnlyModeAccess) {
        RequestAuthenticationBean rab = null;
        if (this.fCPermissionUtil.isLicenseValid()) {
            rab = this.validatePublicAccess(space, readOnlyModeAccess);
        } else {
            rab = new RequestAuthenticationBean();
            rab.setRejectReason(INVALID_LICENSE_MESSAGE);
        }
        return rab;
    }

    private RequestAuthenticationBean validatePublicAccess(Space space, READ_ONLY_MODE_ACCESS readOnlyModeAccess) {
        boolean isAdmin;
        RequestAuthenticationBean rab = new RequestAuthenticationBean();
        boolean isSysAdmin = this.fCPermissionUtil.isGlobalAdmin();
        boolean isSpaceAdmin = this.fCPermissionUtil.isAuthorized(space);
        boolean bl = isAdmin = isSysAdmin || isSpaceAdmin;
        if (isAdmin) {
            if (this.isMethodAccessibleInCurrentMode(readOnlyModeAccess)) {
                rab.setIsAuthenticated(true);
                rab.setResponseCode(Response.Status.OK.getStatusCode());
            } else {
                rab.setRejectReason(READ_ONLY_MESSAGE);
            }
        } else {
            rab.setRejectReason(INVALID_ADMIN_MESSAGE);
        }
        return rab;
    }

    protected final boolean isMethodAccessibleInCurrentMode(READ_ONLY_MODE_ACCESS readOnlyModeAccess) {
        boolean isMethodAccessibleInMode = true;
        if (this.fAccessModeService.isReadOnlyAccessModeEnabled() && (readOnlyModeAccess == null || readOnlyModeAccess == READ_ONLY_MODE_ACCESS.deny)) {
            isMethodAccessibleInMode = false;
        }
        return isMethodAccessibleInMode;
    }

    protected final RequestAuthenticationBean authenticateEndpointForAdmin(HttpServletRequest hsr, String spaceKey, READ_ONLY_MODE_ACCESS readOnlyModeAccess) {
        RequestAuthenticationBean rab = null;
        if (this.fCPermissionUtil.isLicenseValid()) {
            rab = this.validateInternalAccess(hsr, spaceKey, readOnlyModeAccess);
        } else {
            rab = new RequestAuthenticationBean();
            rab.setRejectReason(INVALID_LICENSE_MESSAGE);
        }
        return rab;
    }

    private RequestAuthenticationBean validateInternalAccess(HttpServletRequest hsr, String spaceKey, READ_ONLY_MODE_ACCESS readOnlyModeAccess) {
        RequestAuthenticationBean rab = new RequestAuthenticationBean();
        if (this.isTokenValid(hsr)) {
            if (this.isValidAdmin(spaceKey)) {
                if (this.isMethodAccessibleInCurrentMode(readOnlyModeAccess)) {
                    rab.setIsAuthenticated(true);
                    rab.setResponseCode(Response.Status.OK.getStatusCode());
                } else {
                    rab.setRejectReason(READ_ONLY_MESSAGE);
                }
            } else {
                rab.setRejectReason(INVALID_ADMIN_MESSAGE);
            }
        } else {
            rab.setRejectReason(INVALID_TOKEN_MESSAGE);
        }
        return rab;
    }

    private boolean isValidAdmin(String spaceKey) {
        Space space;
        boolean isAdmin = false;
        isAdmin = spaceKey != null && !spaceKey.isEmpty() ? (space = this.fSpaceManager.getSpace(spaceKey)) != null && this.fCPermissionUtil.isAuthorized(space) : this.fCPermissionUtil.isGlobalAdmin();
        return isAdmin;
    }

    protected Space getValidSpaceFromKey(String spaceKey) throws InvalidSpaceException {
        Space space;
        if (spaceKey != null && !spaceKey.isEmpty()) {
            space = this.fSpaceManager.getSpace(spaceKey);
            if (space == null) {
                throw new InvalidSpaceException("Bad Space Key despite passing Resource SpaceKey checks, using key: " + spaceKey);
            }
        } else {
            throw new InvalidSpaceException("SpaceKey was null, unable to find a space without a given spacekey");
        }
        Space ret = space;
        return ret;
    }

    protected static enum READ_ONLY_MODE_ACCESS {
        allow,
        deny;

    }
}

