/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.publicapi.components;

import com.atlassian.annotations.PublicApi;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.util.RandomGenerator;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.impl.EntityMissingException;
import com.atlassian.user.security.password.Credential;
import com.pluginpeople.confluence.csum.ao.CSUMAuditEntity;
import com.pluginpeople.confluence.csum.ao.CSUMLdapConfigEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.AuthorizationException;
import com.pluginpeople.confluence.csum.api.DuplicateException;
import com.pluginpeople.confluence.csum.api.GroupActionNotPermittedException;
import com.pluginpeople.confluence.csum.api.IPublicCSUMSpaceGroupManager;
import com.pluginpeople.confluence.csum.api.LdapDetailsDTO;
import com.pluginpeople.confluence.csum.api.SpaceGroupPatternMismatchException;
import com.pluginpeople.confluence.csum.ldap.LDAPException;
import com.pluginpeople.confluence.csum.ldap.LDAPLookupUtil;
import com.pluginpeople.confluence.csum.ldap.LDAPUser;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.service.cache.ICachedConfig;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import io.atlassian.fugue.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
@PublicApi
public class PublicCSUMSpaceGroupUtil
implements IPublicCSUMSpaceGroupManager {
    private static final Logger LOG = LoggerFactory.getLogger(PublicCSUMSpaceGroupUtil.class);
    private final ContentPermissionManager fContentPermManager;
    private final ICSUMCacheManager fCacheManager;
    private final GroupManager fGroupManager;
    private final I18nResolver fI18n;
    private final CSUMPermissionUtil fPermissionUtil;
    private final UserManager fUserManager;
    private final UserAccessor fUserAccessor;
    ICSUMActiveObjectService fAos;
    public static final String COMMA = ",";
    public static final String DEFAULT_REGEXP = ".*";
    public static final String NAME_EQUAL = ", name=";
    private static final int RANDOM_PASSWORD_LENGTH = 22;
    private static final String NOT_PERMITTED = "not.permitted.description";
    private static final String GROUP_ACTIONS_DISABLED = "csum.action.group.disabled";
    private static final String NO_PATTERN_MATCH = "csum.display.alert.no.pattern.match";
    private static final String NOT_AUTHORISED = "csum.error.not.authorized";
    private static final String UNAUTHORISED_USER_ATTEMPT = "UNAUTHORIZED access attempt by user: ";
    private static final String GROUP_PERMISSION_FAILURE = "Group Action Permission failure by user: ";
    private static final String AUDIT_EVENT_CREATED_WITH_ID = ". Audit event created with ID: ";
    private static final String USER_SPACE_GROUP_PATTERN_MISMATCH = "SpaceGroupPatternMismatchException by user: ";
    private static final String FOR_ADDING = " for adding users to groups";
    private static final String SPACE_GROUP_NAME_EQUALS = ", spaceGroupName=";
    private static final String USERNAME_CSV_EQUALS = ", userNameCsv=";

    @Autowired
    public PublicCSUMSpaceGroupUtil(ICSUMCacheManager cacheManager, @ComponentImport GroupManager groupMgr, @ComponentImport UserManager userMgr, ICSUMActiveObjectService aos, @ComponentImport I18nResolver i18n, CSUMPermissionUtil permissionUtil, @ComponentImport UserAccessor userAccessor, @ComponentImport ContentPermissionManager contentPermManager) {
        this.fCacheManager = cacheManager;
        this.fGroupManager = groupMgr;
        this.fUserManager = userMgr;
        this.fAos = aos;
        this.fI18n = i18n;
        this.fPermissionUtil = permissionUtil;
        this.fUserAccessor = userAccessor;
        this.fContentPermManager = contentPermManager;
    }

    public Group createSpaceGroup(Space space, String groupName) throws AuthorizationException, GroupActionNotPermittedException, DuplicateException, EntityException {
        Group createdGroup = null;
        if (!this.fPermissionUtil.isAuthorized(space)) {
            CSUMAuditEntity auditEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.createGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.unauthorized, space, null, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText("NOT_AUTHORISED"), null, null);
            LOG.error(UNAUTHORISED_USER_ATTEMPT + AuthenticatedUserThreadLocal.getUsername() + " for Space Group creation. Audit event created with ID: " + auditEntity.getID());
            throw new AuthorizationException(this.fI18n.getText(NOT_PERMITTED));
        }
        if (!this.fCacheManager.getCachedConfig().isGroupActionsPermitted()) {
            CSUMAuditEntity auditEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.createGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.unauthorized, space, null, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText("GROUP_ACTIONS_DISABLED"), null, null);
            LOG.error(GROUP_PERMISSION_FAILURE + AuthenticatedUserThreadLocal.getUsername() + " for Space Group creation. Audit event created with ID: " + auditEntity.getID());
            throw new GroupActionNotPermittedException(this.fI18n.getText(GROUP_ACTIONS_DISABLED));
        }
        if (!this.doesMatchRegex(groupName)) {
            CSUMAuditEntity auditEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.createGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.unauthorized, space, null, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText("csum.configure.group.name.regexp"), null, null);
            LOG.error(this.fI18n.getText("csum.configure.group.name.regexp") + AuthenticatedUserThreadLocal.getUsername() + " for Space Group creation. Audit event created with ID: " + auditEntity.getID());
            throw new GroupActionNotPermittedException(this.fI18n.getText("csum.configure.group.name.regexp"));
        }
        String fullGroupName = this.computeSpaceGroupName(space, groupName);
        if (fullGroupName != null) {
            if (this.fGroupManager.getGroup(fullGroupName) != null) {
                CSUMAuditEntity auditEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.createGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, null, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText("csum.error.duplicate.group", new Serializable[]{fullGroupName}), null, null);
                LOG.error("DuplicateException by user: " + AuthenticatedUserThreadLocal.getUsername() + " for Space Group creation of duplicate Group: " + this.fGroupManager.getGroup(fullGroupName) + "Audit event created with ID: " + auditEntity.getID());
                throw new DuplicateException(this.fI18n.getText("csum.error.duplicate.group", new Serializable[]{fullGroupName}));
            }
            createdGroup = this.fGroupManager.createGroup(fullGroupName);
            LOG.debug("Group created: " + createdGroup.getName());
            this.addViewSpacePermission(space, createdGroup);
            this.addSpaceGroupToCache(space, fullGroupName);
            this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.createGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.success, space, fullGroupName, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText("csum.auditing.operation.createGroup"), null, null);
        } else {
            LOG.error("Group name was empty");
        }
        return createdGroup;
    }

    private boolean doesMatchRegex(String groupName) {
        String groupNameRegexp;
        ICachedConfig config;
        boolean groupNameMatchesRegexp = true;
        if (groupName != null && (config = this.fCacheManager.getCachedConfig()) != null && (groupNameRegexp = config.getGroupNameRegexp()) != null && !groupNameRegexp.isEmpty() && !groupNameRegexp.equalsIgnoreCase(DEFAULT_REGEXP)) {
            try {
                Pattern regexpPattern = Pattern.compile(groupNameRegexp);
                Matcher regexpMatcher = regexpPattern.matcher(groupName);
                boolean isMatch = regexpMatcher.matches();
                if (!isMatch) {
                    groupNameMatchesRegexp = false;
                }
            }
            catch (PatternSyntaxException e) {
                LOG.error("Exception when attempting to use Group name RegExp from config. The RegExp may be invalid");
                groupNameMatchesRegexp = false;
            }
        }
        return groupNameMatchesRegexp;
    }

    public boolean deleteSpaceGroup(Space space, String groupName) throws AuthorizationException, SpaceGroupPatternMismatchException, GroupActionNotPermittedException, EntityException {
        boolean success;
        if (!this.fPermissionUtil.isAuthorized(space)) {
            CSUMAuditEntity auditEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.unauthorized, space, groupName, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText(NOT_AUTHORISED), null, null);
            LOG.error(UNAUTHORISED_USER_ATTEMPT + AuthenticatedUserThreadLocal.getUsername() + " for Space Group deletion. Audit event created with ID: " + auditEntity.getID());
            throw new AuthorizationException(this.fI18n.getText(NOT_PERMITTED));
        }
        if (!this.isSpaceGroup(space, groupName)) {
            CSUMAuditEntity auditEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, groupName, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText(NO_PATTERN_MATCH), null, null);
            LOG.error(USER_SPACE_GROUP_PATTERN_MISMATCH + AuthenticatedUserThreadLocal.getUsername() + " for Space Group deletion via pattern. Audit event created with ID: " + auditEntity.getID());
            throw new SpaceGroupPatternMismatchException(this.fI18n.getText(NO_PATTERN_MATCH) + ": " + groupName);
        }
        if (!this.fCacheManager.getCachedConfig().isGroupActionsPermitted()) {
            CSUMAuditEntity auditEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.unauthorized, space, groupName, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText(GROUP_ACTIONS_DISABLED), null, null);
            LOG.error(GROUP_PERMISSION_FAILURE + AuthenticatedUserThreadLocal.getUsername() + " for Space Group deletion. Audit event created with ID: " + auditEntity.getID());
            throw new GroupActionNotPermittedException(this.fI18n.getText(GROUP_ACTIONS_DISABLED));
        }
        this.validateSpaceGroups(space, groupName);
        try {
            Group group = this.fGroupManager.getGroup(groupName);
            if (group == null) {
                String msg = "Unable to find user group for deletion with name: " + groupName;
                this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, groupName, null, AuthenticatedUserThreadLocal.getUsername(), msg, null, null);
                LOG.error(msg);
                throw new EntityMissingException("Group was not found with groupName: " + groupName);
            }
            this.fContentPermManager.removeAllGroupPermissions(group.getName());
            this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.success, space, groupName, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText("csum.auditing.operation.removeGroup"), null, null);
            this.removeAllPermissions(group);
            this.fGroupManager.removeGroup(group);
            this.cleanupGroupCache(space);
            success = true;
        }
        catch (EntityException eme) {
            this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, groupName, null, AuthenticatedUserThreadLocal.getUsername(), eme.getLocalizedMessage(), null, null);
            LOG.error("Error getting group for delete: " + groupName, (Throwable)eme);
            throw eme;
        }
        return success;
    }

    public void removeGroupMembers(Space space, @Nonnull String spaceGroupCsv, String userNameCsv, String membershipGroupsCsv) throws AuthorizationException, SpaceGroupPatternMismatchException, EntityException {
        if (!this.fPermissionUtil.isAuthorized(space)) {
            CSUMAuditEntity failedDeleteEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeUserFromGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.unauthorized, space, null, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText(NOT_AUTHORISED), null, null);
            LOG.error(UNAUTHORISED_USER_ATTEMPT + AuthenticatedUserThreadLocal.getUsername() + " for removing Group members. Audit event created with ID: " + failedDeleteEntity.getID());
            throw new AuthorizationException(this.fI18n.getText(NOT_PERMITTED));
        }
        String[] spaceGroupNames = spaceGroupCsv.split(COMMA);
        this.validateSpaceGroups(space, spaceGroupNames);
        for (String spaceGroupName : spaceGroupNames) {
            Group spaceGroup;
            if (!this.isSpaceGroup(space, spaceGroupName) && !this.fPermissionUtil.isGlobalAdmin()) {
                CSUMAuditEntity auditEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeUserFromGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, spaceGroupName, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText(NO_PATTERN_MATCH), null, null);
                LOG.error(USER_SPACE_GROUP_PATTERN_MISMATCH + AuthenticatedUserThreadLocal.getUsername() + " for removing Space Group members from group with original name: " + spaceGroupName + AUDIT_EVENT_CREATED_WITH_ID + auditEntity.getID());
                throw new SpaceGroupPatternMismatchException(this.fI18n.getText(NO_PATTERN_MATCH) + ": " + spaceGroupName);
            }
            try {
                spaceGroup = this.fGroupManager.getGroup(spaceGroupName);
            }
            catch (EntityException ee) {
                this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeUserFromGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, spaceGroupName, null, AuthenticatedUserThreadLocal.getUsername(), ee.getLocalizedMessage(), null, null);
                LOG.error("removeGroupMembers() EntityException during getGroup [space=" + space.getKey() + SPACE_GROUP_NAME_EQUALS + spaceGroupName + USERNAME_CSV_EQUALS + userNameCsv + ", " + membershipGroupsCsv + "] : " + ee.getLocalizedMessage(), (Throwable)ee);
                throw ee;
            }
            if (!membershipGroupsCsv.isEmpty() || !userNameCsv.isEmpty()) {
                Set<ConfluenceUser> usersToRemove = this.getUsersToRemove(userNameCsv, membershipGroupsCsv);
                for (ConfluenceUser user : usersToRemove) {
                    try {
                        this.fGroupManager.removeMembership(spaceGroup, (User)user);
                        this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeUserFromGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.success, space, spaceGroup.getName(), user.getKey().getStringValue(), AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText("csum.auditing.operation.removeUserFromGroup"), null, null);
                    }
                    catch (EntityException ee) {
                        this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeUserFromGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, spaceGroup.getName(), user.getKey().getStringValue(), AuthenticatedUserThreadLocal.getUsername(), ee.getLocalizedMessage(), null, null);
                        LOG.error("removeGroupMembers() EntityException during removeMembership() [space=" + space.getKey() + SPACE_GROUP_NAME_EQUALS + spaceGroupName + USERNAME_CSV_EQUALS + userNameCsv + ", " + membershipGroupsCsv + "] : " + ee.getLocalizedMessage(), (Throwable)ee);
                        throw ee;
                    }
                    catch (Exception exc) {
                        this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeUserFromGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, spaceGroup.getName(), user.getKey().getStringValue(), AuthenticatedUserThreadLocal.getUsername(), exc.getLocalizedMessage(), null, null);
                        LOG.error("removeGroupMembers() Exception during removeMembership() [space=" + space.getKey() + SPACE_GROUP_NAME_EQUALS + spaceGroupName + USERNAME_CSV_EQUALS + userNameCsv + ", " + membershipGroupsCsv + "] : " + exc.getLocalizedMessage(), (Throwable)exc);
                        throw exc;
                    }
                }
                continue;
            }
            this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeUserFromGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, spaceGroupName, null, AuthenticatedUserThreadLocal.getUsername(), null, null, null);
        }
    }

    private Set<ConfluenceUser> getUsersToRemove(String userNameCsv, String membershipGroupsCsv) {
        HashSet<ConfluenceUser> usersToRemove = new HashSet<ConfluenceUser>();
        if (!membershipGroupsCsv.isEmpty()) {
            String[] groupNames;
            for (String groupName : groupNames = membershipGroupsCsv.split(COMMA)) {
                try {
                    Group group = this.fGroupManager.getGroup(groupName);
                    if (group == null) continue;
                    Iterable members = this.fUserAccessor.getMembers(group);
                    members.forEach(usersToRemove::add);
                }
                catch (EntityException ee) {
                    this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeUserFromGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, null, groupName, null, null, ee.getLocalizedMessage(), null, null);
                    LOG.error("Unable to locate group [" + groupName + "] " + ee.getLocalizedMessage(), (Throwable)ee);
                }
            }
        }
        if (!userNameCsv.isEmpty()) {
            String[] userNames;
            for (String userName : userNames = userNameCsv.split(COMMA)) {
                ConfluenceUser aUser = this.fUserAccessor.getUserByName(userName);
                if (aUser != null) {
                    usersToRemove.add(aUser);
                    continue;
                }
                String msg = "CSUM was not able to locate the user by name [" + userName + "], does the user actually exit in Confluence? If multiple users have been set, exclude this user and retry to narrow the identify problem users.";
                LOG.error(msg);
            }
        }
        return usersToRemove;
    }

    private void removeAllPermissions(Group g) {
        List<SpacePermission> allocatedPerms = this.fPermissionUtil.getPermissions(g.getName());
        for (SpacePermission aPermission : allocatedPerms) {
            this.fPermissionUtil.removePermission(aPermission);
        }
    }

    private void cleanupGroupCache(Space aSpace) throws EntityException {
        String[] cachedGroups = this.fCacheManager.getSpaceGroups(aSpace);
        ArrayList<String> nonmatch = new ArrayList<String>();
        for (String cachedGroup : cachedGroups) {
            if (this.fGroupManager.getGroup(cachedGroup) == null) continue;
            nonmatch.add(cachedGroup);
        }
        String[] updatedGroups = new String[nonmatch.size()];
        nonmatch.toArray(updatedGroups);
        this.fCacheManager.setSpaceGroups(aSpace, updatedGroups);
    }

    public Pair<List<String>, List<String>> addUsersToGroups(Space space, String spaceGroups, String spaceUsers, String importViaGroups) throws AuthorizationException, EntityException, SpaceGroupPatternMismatchException {
        if (!this.fPermissionUtil.isAuthorized(space)) {
            CSUMAuditEntity failedDeleteEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.addUserToGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.unauthorized, space, null, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText(NOT_AUTHORISED), null, null);
            LOG.error(UNAUTHORISED_USER_ATTEMPT + AuthenticatedUserThreadLocal.getUsername() + " for adding users to groups. Audit event created with ID: " + failedDeleteEntity.getID());
            throw new AuthorizationException(this.fI18n.getText(NOT_PERMITTED));
        }
        for (String string : spaceGroups.split(COMMA)) {
            if (this.isSpaceGroup(space, string)) continue;
            CSUMAuditEntity auditEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.addUserToGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, string, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText(NO_PATTERN_MATCH), null, null);
            LOG.error(USER_SPACE_GROUP_PATTERN_MISMATCH + AuthenticatedUserThreadLocal.getUsername() + " for adding users to groups with original name: " + string + AUDIT_EVENT_CREATED_WITH_ID + auditEntity.getID());
            throw new SpaceGroupPatternMismatchException(this.fI18n.getText(NO_PATTERN_MATCH) + ": " + string);
        }
        String[] groupArr = spaceGroups.split(COMMA);
        ArrayList<Group> groups = new ArrayList<Group>();
        ArrayList<String> invalidGroups = new ArrayList<String>();
        for (String string : groupArr) {
            Group group = this.fGroupManager.getGroup(string);
            if (group != null) {
                groups.add(group);
                continue;
            }
            invalidGroups.add(string);
        }
        ArrayList<Group> arrayList = new ArrayList<Group>();
        String autoJoinGroupsStr = this.fCacheManager.getCachedConfig().getAutoJoinGroups();
        if (autoJoinGroupsStr != null && !autoJoinGroupsStr.isEmpty()) {
            String[] autoJoinGroupArr;
            for (String groupName : autoJoinGroupArr = autoJoinGroupsStr.split(COMMA)) {
                Group autoGroup = this.fGroupManager.getGroup(groupName);
                if (autoGroup != null) {
                    arrayList.add(autoGroup);
                    continue;
                }
                invalidGroups.add(groupName);
            }
        }
        OperationResult<ConfluenceUser> operationResult = this.validateCSVUsers(space, spaceUsers, importViaGroups.split(COMMA));
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        try {
            for (Group aGroup : groups) {
                for (ConfluenceUser aUser : operationResult.successes) {
                    this.addSingleUserToGroup(aUser, aGroup, space, currentUser, false);
                }
            }
            for (Group bGroup : arrayList) {
                for (ConfluenceUser aUser : operationResult.successes) {
                    this.addSingleUserToGroup(aUser, bGroup, space, currentUser, true);
                }
            }
        }
        catch (EntityException e) {
            this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.addUserToGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, null, null, currentUser.getName(), e.getLocalizedMessage(), null, null);
            LOG.error("Exception during addition of space group members. Related Space: " + space.getName(), (Throwable)e);
            throw e;
        }
        return new Pair(operationResult.failures, invalidGroups);
    }

    private OperationResult<Group> validateSpaceGroups(Space space, String ... spaceGroupsArr) throws EntityException {
        String[] cachedGroups = this.fCacheManager.getSpaceGroups(space);
        ArrayList<Group> valid = new ArrayList<Group>();
        ArrayList<String> invalid = new ArrayList<String>();
        try {
            for (String aSpaceGroup : spaceGroupsArr) {
                boolean groupMatch = false;
                for (String cachedGroup : cachedGroups) {
                    if (!cachedGroup.equalsIgnoreCase(aSpaceGroup.trim())) continue;
                    groupMatch = true;
                    break;
                }
                if (!groupMatch) {
                    invalid.add(aSpaceGroup);
                    continue;
                }
                Group group = this.fGroupManager.getGroup(aSpaceGroup);
                if (group != null) {
                    valid.add(group);
                    continue;
                }
                invalid.add(aSpaceGroup);
            }
        }
        catch (EntityException e) {
            LOG.error("Exception occurred during validation of groups for operation", (Throwable)e);
            throw e;
        }
        return new OperationResult<Group>(valid, invalid);
    }

    private OperationResult<ConfluenceUser> validateCSVUsers(Space forSpace, String usersCSV, @Nonnull String[] importViaGroups) throws EntityException {
        String[] allUsers;
        ArrayList<ConfluenceUser> validUsers = new ArrayList<ConfluenceUser>();
        ArrayList<String> invalidUsers = new ArrayList<String>();
        String[] spaceUsersArr = usersCSV != null ? usersCSV.split(COMMA) : new String[]{};
        if (importViaGroups.length > 0) {
            String[] usersFromImport = this.getGroupMemberNamesViaImport(importViaGroups);
            int spaceUsersArrLen = spaceUsersArr.length;
            int usersFromImportLen = usersFromImport.length;
            allUsers = new String[spaceUsersArrLen + usersFromImportLen];
            System.arraycopy(spaceUsersArr, 0, allUsers, 0, spaceUsersArrLen);
            System.arraycopy(usersFromImport, 0, allUsers, spaceUsersArrLen, usersFromImportLen);
        } else {
            allUsers = spaceUsersArr;
        }
        try {
            ICachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
            for (String aSpaceUsersArr : allUsers) {
                String userStr = aSpaceUsersArr.trim();
                if (userStr.isEmpty()) continue;
                ConfluenceUser aUser = this.fUserAccessor.getUserByName(userStr);
                if (aUser != null) {
                    LOG.debug("Found valid User with name: " + userStr);
                    validUsers.add(aUser);
                    continue;
                }
                if (cachedConfig.isCreateUsersEnabled()) {
                    LOG.debug("User with name: " + userStr + " not found, but createUsers enabled - attempting to create user via LDAP config");
                    this.attemptNewLDAPUserCreation(forSpace, validUsers, invalidUsers, userStr);
                    continue;
                }
                LOG.debug("UserAccessor could not find user with name: " + userStr);
                invalidUsers.add(userStr);
            }
        }
        catch (Exception e) {
            LOG.error("Exception occurred during validation of users for operation", (Throwable)e);
        }
        return new OperationResult<ConfluenceUser>(validUsers, invalidUsers);
    }

    private String[] getGroupMemberNamesViaImport(@Nonnull String[] importViaGroups) throws EntityException {
        ArrayList userNames = new ArrayList();
        if (!importViaGroups[0].equalsIgnoreCase("")) {
            for (String groupName : importViaGroups) {
                try {
                    Group groupObj = this.fGroupManager.getGroup(groupName);
                    List memberNames = this.fUserAccessor.getMemberNamesAsList(groupObj);
                    userNames.addAll(memberNames);
                }
                catch (EntityException e) {
                    LOG.error("Failed to get group from confluence: " + groupName);
                    throw e;
                }
            }
        }
        return userNames.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attemptNewLDAPUserCreation(Space forSpace, List<ConfluenceUser> validUsers, List<String> invalidUsers, String userStr) {
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        ConfluenceUser aUser = null;
        try {
            Thread.currentThread().setContextClassLoader(Session.class.getClassLoader());
            aUser = this.createUserViaExternalLdap(forSpace, userStr);
        }
        catch (Exception e) {
            LOG.error("Couldn't lookup LDAP user " + userStr + ": " + e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tcl);
        }
        if (aUser != null) {
            validUsers.add(aUser);
        } else {
            invalidUsers.add(userStr);
        }
    }

    private ConfluenceUser createUserViaExternalLdap(Space forSpace, String username) throws LDAPException {
        if (!this.fUserManager.isCreative()) {
            LOG.error("Users can't be created right now: " + username);
            return null;
        }
        ICachedConfig config = this.fAos.getCachedConfig();
        String ldapCsvIds = config.getExtLdapDirectories();
        if (ldapCsvIds == null || ldapCsvIds.isEmpty()) {
            LOG.info("No external LDAP configs defined for user creation");
            return null;
        }
        CSUMLdapConfigEntity[] allLdapConfigs = this.fAos.getLdapConfigs();
        if (allLdapConfigs == null || allLdapConfigs.length <= 0) {
            return null;
        }
        HashSet<Long> selectedLdapDirectories = new HashSet<Long>();
        String csvAutoJoinGroups = config.getAutoJoinGroups();
        String[] autoJoinGroups = null;
        if (csvAutoJoinGroups != null) {
            autoJoinGroups = csvAutoJoinGroups.split(COMMA);
            for (int i = 0; i < autoJoinGroups.length; ++i) {
                autoJoinGroups[i] = autoJoinGroups[i].trim();
            }
        }
        String[] ldapCsvIdsArr = ldapCsvIds.split(COMMA);
        for (String atlToken : ldapCsvIdsArr) {
            selectedLdapDirectories.add(Long.valueOf(atlToken));
        }
        for (CSUMLdapConfigEntity anLdapConfig : allLdapConfigs) {
            if (!selectedLdapDirectories.contains(anLdapConfig.getID())) continue;
            LOG.info("Checking ext ldap: id=" + anLdapConfig.getID() + NAME_EQUAL + anLdapConfig.getLdapConfigName());
            LdapDetailsDTO dto = this.fAos.getLdapDto(anLdapConfig);
            LDAPLookupUtil lookupUtil = new LDAPLookupUtil(dto);
            List<LDAPUser> ldapResults = lookupUtil.searchFor("(" + dto.getLdapUserAttr() + "=" + username + ")");
            if (ldapResults == null || ldapResults.isEmpty()) {
                LOG.debug("Searched for user '" + username + "' in ldap repo #" + anLdapConfig.getID() + " but was not found through username attr: " + anLdapConfig.getUsernameAttr());
                continue;
            }
            LDAPUser ldapUser = ldapResults.get(0);
            if (ldapUser == null) continue;
            ConfluenceUser createdUser = this.createUser(forSpace, anLdapConfig, ldapUser);
            if (createdUser == null) {
                throw new LDAPException("Unable to create user from LDAP configuration: " + ldapUser.getUserId());
            }
            if (autoJoinGroups != null) {
                for (String autoJoinGroup : autoJoinGroups) {
                    try {
                        Group group = this.fGroupManager.getGroup(autoJoinGroup);
                        if (group != null) {
                            this.fGroupManager.addMembership(group, (User)createdUser);
                            this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.addUserToGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.success, forSpace, group.getName(), createdUser.getKey().getStringValue(), AuthenticatedUserThreadLocal.getUsername(), "auto-joined group", null, null);
                            continue;
                        }
                        this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.addUserToGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, forSpace, autoJoinGroup, createdUser.getKey().getStringValue(), AuthenticatedUserThreadLocal.getUsername(), "group not found", null, null);
                    }
                    catch (EntityException | IllegalArgumentException ee) {
                        this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.addUserToGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, forSpace, autoJoinGroup, createdUser.getKey().getStringValue(), AuthenticatedUserThreadLocal.getUsername(), ee.getLocalizedMessage(), null, null);
                    }
                }
            }
            return createdUser;
        }
        return null;
    }

    @Nullable
    private ConfluenceUser createUser(Space forSpace, CSUMLdapConfigEntity anLdapConfig, LDAPUser ldapUser) {
        String randomPassword = RandomGenerator.randomString((int)22, (boolean)true);
        DefaultUser userTemplate = new DefaultUser(ldapUser.getUserId(), ldapUser.getFullName(), ldapUser.getEmail());
        ConfluenceUser createdUser = this.fUserAccessor.createUser((User)userTemplate, Credential.unencrypted((String)randomPassword));
        if (createdUser != null) {
            LOG.info("Successfully created user [" + createdUser.getName() + "/ " + createdUser.getFullName() + "/ " + createdUser.getEmail() + "]");
            String summary = "Created user from external ldap [id=" + anLdapConfig.getID() + NAME_EQUAL + anLdapConfig.getLdapConfigName() + "]";
            this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.createUser, ICSUMActiveObjectService.CSUMAuditEventOutcome.success, forSpace, null, createdUser.getKey().getStringValue(), AuthenticatedUserThreadLocal.getUsername(), summary, null, null);
        }
        return createdUser;
    }

    private void addSingleUserToGroup(@Nonnull ConfluenceUser user, @Nonnull Group group, Space space, ConfluenceUser currentUser, boolean isAutoJoin) throws EntityException {
        try {
            Objects.requireNonNull(user);
            Objects.requireNonNull(group);
            if ((this.isSpaceGroup(space, group.getName()) || isAutoJoin) && !this.fGroupManager.hasMembership(group, (User)user)) {
                this.fGroupManager.addMembership(group, (User)user);
                this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.addUserToGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.success, space, group.getName(), user.getKey().getStringValue(), currentUser.getName(), null, null, null);
            } else if (!this.isSpaceGroup(space, group.getName()) && !isAutoJoin) {
                LOG.info("User: " + user.getName() + " not added to group: " + group.getName() + ". Group is not a Space Group or listed as an auto-join group.");
            } else if (this.fGroupManager.hasMembership(group, (User)user)) {
                LOG.info("User: " + user.getName() + " already has group membership for Group: " + group);
            } else {
                LOG.error("User should have been added, but did not for some unknown reason");
                this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.addUserToGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, group.getName(), user.getKey().getStringValue(), currentUser.getName(), null, null, null);
            }
        }
        catch (EntityException e) {
            LOG.error("EntityException when adding user: " + user.getName() + " to group: " + group.getName(), (Throwable)e);
            this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.addUserToGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, group.getName(), user.getKey().getStringValue(), currentUser.getName(), null, null, null);
            throw e;
        }
        catch (Exception e) {
            LOG.error("Exception adding user: " + user.getName() + " to group: " + group.getName(), (Throwable)e);
            this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.addUserToGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, group.getName(), user.getKey().getStringValue(), currentUser.getName(), null, null, null);
        }
    }

    private boolean isSpaceGroup(Space aSpace, String groupName) {
        ICachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
        String prefix = cachedConfig.getGroupPrefixPattern();
        String suffix = cachedConfig.getGroupSuffixPattern();
        String lcGroupName = groupName.toLowerCase();
        String prefixStr = prefix != null ? prefix.replace("SPACEKEY", aSpace.getLowerKey()) : "";
        String suffixStr = suffix != null ? suffix.replace("SPACEKEY", aSpace.getLowerKey()) : "";
        boolean isPrefixMatch = prefix == null || lcGroupName.startsWith(prefixStr);
        boolean isSuffixMatch = isPrefixMatch && (suffix == null || lcGroupName.endsWith(suffixStr));
        return isPrefixMatch && isSuffixMatch;
    }

    private String computeSpaceGroupName(Space aSpace, String groupName) {
        String fullGroupName = null;
        ICachedConfig config = this.fCacheManager.getCachedConfig();
        String prefix = config.getGroupPrefixPattern();
        String suffix = config.getGroupSuffixPattern();
        if (aSpace != null) {
            fullGroupName = ((prefix != null ? prefix.trim().replace("SPACEKEY", aSpace.getLowerKey()) : "") + groupName.trim() + (suffix != null ? suffix.trim().replace("SPACEKEY", aSpace.getLowerKey()) : "")).toLowerCase();
        } else {
            LOG.debug("computeSpaceGroupName() Space was not set");
        }
        return fullGroupName;
    }

    private void addSpaceGroupToCache(Space aSpace, String fullGroupName) {
        String[] cachedGroups;
        for (String group : cachedGroups = this.fCacheManager.getSpaceGroups(aSpace)) {
            if (!fullGroupName.equals(group)) continue;
            return;
        }
        int arrsize = cachedGroups.length + 1;
        String[] updatedGroups = new String[arrsize];
        System.arraycopy(cachedGroups, 0, updatedGroups, 0, cachedGroups.length);
        updatedGroups[updatedGroups.length - 1] = fullGroupName;
        this.fCacheManager.setSpaceGroups(aSpace, updatedGroups);
    }

    private void addViewSpacePermission(Space aSpace, Group g) {
        SpacePermission perm = new SpacePermission("VIEWSPACE", aSpace, g.getName());
        perm.setCreator(AuthenticatedUserThreadLocal.get());
        perm.setCreationDate(new Date());
        perm.setLastModifier(AuthenticatedUserThreadLocal.get());
        perm.setLastModificationDate(new Date());
        aSpace.addPermission(perm);
        this.fPermissionUtil.savePermission(perm);
        LOG.debug("added viewspace perm to " + g.getName());
    }

    public static class OperationResult<S> {
        public final List<S> successes;
        public final List<String> failures;

        public OperationResult(List<S> success, List<String> fail) {
            this.successes = success;
            this.failures = fail;
        }

        public List<String> getFailures() {
            return this.failures;
        }

        public List<S> getSuccesses() {
            return this.successes;
        }
    }
}

