/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.rest;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.access.annotations.RequiresLicensedConfluenceAccess;
import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.spaces.SpaceManager;
import com.pluginpeople.confluence.csum.ao.CSUMBadGroupToolStatus;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.rest.AbstractCSUMRestResource;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import com.pluginpeople.confluence.csum.util.CSUMToolManager;
import com.pluginpeople.confluence.csum.util.OpStatus;
import com.pluginpeople.confluence.csum.util.ToolRequest;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@ReadOnlyAccessAllowed
@Path(value="tools")
@RequiresLicensedConfluenceAccess
public class ToolsResource
extends AbstractCSUMRestResource {
    private ICSUMActiveObjectService fAo;
    private CSUMToolManager fToolAccessMgr;

    public ToolsResource(CSUMToolManager toolMgr, PermissionManager pm, ICSUMActiveObjectService ao, SpaceManager spaceManager, CSUMPermissionUtil permissionUtil, XsrfTokenService tokenService, ICSUMCacheManager cacheManager) {
        super(spaceManager, permissionUtil, tokenService, pm, cacheManager);
        this.fAo = ao;
        this.fToolAccessMgr = toolMgr;
    }

    @GET
    @Path(value="groupnamefixer/status")
    @Produces(value={"application/json"})
    public Response getClusterGroupFixerStatus(@Context HttpServletRequest hsr) {
        Response response;
        if (this.isTokenInvalid(hsr) || !this.isCurrentUserAdminOrSystemAdmin()) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.fToolAccessMgr.resetIfTaskStuck();
        CSUMBadGroupToolStatus clusterStatus = this.fAo.getBadGroupToolStatus();
        if (clusterStatus != null) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("status", clusterStatus.getStatus());
            data.put("user", clusterStatus.getInitUser());
            data.put("updated", clusterStatus.getLastUpdated());
            if (OpStatus.RUNNING.name().equals(clusterStatus.getStatus())) {
                data.put("localFinderRunning", this.fToolAccessMgr.isRunningOnLocalNode(CSUMToolManager.ToolKey.BAD_GROUP_FINDER));
                data.put("localFixerRunning", this.fToolAccessMgr.isRunningOnLocalNode(CSUMToolManager.ToolKey.BADGROUP_FIXER));
            }
            response = Response.ok(data).build();
        } else {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return response;
    }

    @GET
    @Path(value="groupnamefixer/knowngroups")
    @Produces(value={"application/json"})
    public Response getKnownBadGroupCount(@Context HttpServletRequest hsr) {
        if (this.isTokenInvalid(hsr) || !this.isCurrentUserAdminOrSystemAdmin()) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        int existingCount = this.fAo.getBadGroupCount();
        Response response = Response.ok((Object)existingCount).build();
        return response;
    }

    @GET
    @Path(value="groupnamefixer/find")
    @Produces(value={"text/plain"})
    public Response startBadGroupNameFinder(@Context HttpServletRequest hsr) {
        if (this.isTokenInvalid(hsr) || !this.isCurrentUserAdminOrSystemAdmin()) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Response response = null;
        ToolRequest req = this.fToolAccessMgr.requestBadGroupFinderLaunch();
        response = req.isSuccess() ? Response.status((Response.Status)Response.Status.ACCEPTED).build() : Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)req.getMessage()).build();
        return response;
    }

    @DELETE
    @Path(value="groupnamefixer/find")
    @Produces(value={"text/plain"})
    public Response stopBadGroupNameFinder(@Context HttpServletRequest hsr) {
        if (this.isTokenInvalid(hsr) || !this.isCurrentUserAdminOrSystemAdmin()) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.fToolAccessMgr.requestBadGroupFinderStop();
        Response response = Response.ok().build();
        return response;
    }

    @GET
    @Path(value="groupnamefixer/find/progress")
    @Produces(value={"application/json"})
    public Response getBadGroupNameFinderProgress(@Context HttpServletRequest hsr) {
        if (this.isTokenInvalid(hsr) || !this.isCurrentUserAdminOrSystemAdmin()) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Map<String, Object> finderProgress = this.fToolAccessMgr.getBadGroupFinderProgress();
        Response response = Response.ok(finderProgress).build();
        return response;
    }

    @GET
    @Path(value="groupnamefixer/fix")
    @Produces(value={"text/plain"})
    public Response startBadGroupNameFixer(@Context HttpServletRequest hsr) {
        if (this.isTokenInvalid(hsr) || !this.isCurrentUserAdminOrSystemAdmin()) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Response response = null;
        ToolRequest req = this.fToolAccessMgr.requestBadGroupFixerLaunch();
        response = req.isSuccess() ? Response.status((Response.Status)Response.Status.ACCEPTED).build() : Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)req.getMessage()).build();
        return response;
    }

    @DELETE
    @Path(value="groupnamefixer/fix")
    @Produces(value={"text/plain"})
    public Response stopBadGroupNameFixer(@Context HttpServletRequest hsr) {
        if (this.isTokenInvalid(hsr) || !this.isCurrentUserAdminOrSystemAdmin()) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.fToolAccessMgr.requestBadGroupFixerStop();
        Response response = Response.ok().build();
        return response;
    }

    @GET
    @Path(value="groupnamefixer/fix/progress")
    @Produces(value={"application/json"})
    public Response getBadGroupNameFixerProgress(@Context HttpServletRequest hsr) {
        if (this.isTokenInvalid(hsr) || !this.isCurrentUserAdminOrSystemAdmin()) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Map<String, Object> fixerProgress = this.fToolAccessMgr.getBadGroupFixerProgress();
        Response response = Response.ok(fixerProgress).build();
        return response;
    }
}

