/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.integration;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.google.gson.Gson;
import com.pluginpeople.confluence.csum.api.ITRestRequestUtil;
import com.pluginpeople.confluence.csum.api.beans.RequestResponseBean;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.entity.mime.StringBody;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.utils.Base64;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class ITRestRequestUtilImpl
implements ITRestRequestUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ITRestRequestUtilImpl.class);
    private static final String ATL_TOKEN_PARAMETER = "atl_token";

    @Autowired
    public ITRestRequestUtilImpl() {
    }

    public RequestResponseBean executeRequest(ITRestRequestUtil.METHOD_TYPE type, String baseUrl, String restUrl, String authString, boolean isUseAtlToken, Map<String, String> payload) throws IOException {
        RequestResponseBean ret = new RequestResponseBean();
        if (authString != null) {
            String authHeader = "Basic " + new String(Base64.encodeBase64((byte[])authString.getBytes(StandardCharsets.ISO_8859_1)));
            try (CloseableHttpClient client = HttpClientBuilder.create().build();){
                String atlToken = isUseAtlToken ? this.getAtlTokenForClient(client, baseUrl, authHeader) : null;
                BasicClassicHttpRequest request = null;
                String url = baseUrl + restUrl;
                if (isUseAtlToken) {
                    url = url + "&atl_token=" + atlToken;
                }
                switch (type) {
                    case GET: {
                        request = new BasicClassicHttpRequest(Method.GET, url);
                        break;
                    }
                    case PUT: {
                        request = new BasicClassicHttpRequest(Method.PUT, url);
                        break;
                    }
                    case DELETE: {
                        request = new BasicClassicHttpRequest(Method.DELETE, url);
                        break;
                    }
                }
                if (request != null) {
                    request.setHeader("Authorization", (Object)authHeader);
                    ret = this.executeResponseForClient(client, (ClassicHttpRequest)request);
                }
            }
            catch (IOException ioe) {
                LOG.error("Failed to execute REST Request", (Throwable)ioe);
                throw ioe;
            }
        }
        return ret;
    }

    public RequestResponseBean executePostRequest(String baseUrl, String restUrl, String authString, boolean isUseAtlToken, Map<String, String> payload, ITRestRequestUtil.CONSUMED_MEDIA_TYPE mediaType) throws IOException {
        RequestResponseBean ret;
        block29: {
            ret = new RequestResponseBean();
            if (authString == null) break block29;
            String authHeader = "Basic " + Base64.encodeBase64String((byte[])authString.getBytes());
            try (CloseableHttpClient client = HttpClientBuilder.create().build();){
                String atlToken = isUseAtlToken ? this.getAtlTokenForClient(client, baseUrl, authHeader) : null;
                BasicClassicHttpRequest request = null;
                String url = baseUrl + restUrl;
                if (payload == null) {
                    payload = new HashMap<String, String>();
                }
                switch (mediaType) {
                    case MULTIPART_FORM_DATA: {
                        HttpEntity formData;
                        if (isUseAtlToken) {
                            url = url + "?atl_token=" + atlToken;
                        }
                        request = new BasicClassicHttpRequest(Method.POST, url);
                        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
                        entityBuilder.setMode(HttpMultipartMode.EXTENDED);
                        for (Map.Entry<String, String> entry : payload.entrySet()) {
                            StringBody entryValue = new StringBody(entry.getValue(), ContentType.MULTIPART_FORM_DATA);
                            entityBuilder.addPart(entry.getKey(), (ContentBody)entryValue);
                        }
                        try (HttpEntity entity = entityBuilder.build();){
                            formData = entity;
                        }
                        request.setEntity(formData);
                        break;
                    }
                    case URL_ENCODED: {
                        if (isUseAtlToken) {
                            payload.put(ATL_TOKEN_PARAMETER, atlToken);
                        }
                        ArrayList<BasicNameValuePair> urlParams = new ArrayList<BasicNameValuePair>();
                        for (Map.Entry<String, String> entry : payload.entrySet()) {
                            urlParams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                        }
                        request = new BasicClassicHttpRequest(Method.POST, url);
                        request.setEntity((HttpEntity)new UrlEncodedFormEntity(urlParams));
                        break;
                    }
                    case APPLICATION_JSON: {
                        if (isUseAtlToken) {
                            payload.put(ATL_TOKEN_PARAMETER, atlToken);
                        }
                        request = new BasicClassicHttpRequest(Method.POST, url);
                        Gson gson = new Gson();
                        String json = gson.toJson(payload);
                        StringEntity jsonPayload = new StringEntity(json);
                        request.setEntity((HttpEntity)jsonPayload);
                        break;
                    }
                    case QUERY_PARAMETERS: {
                        if (isUseAtlToken) {
                            payload.put(ATL_TOKEN_PARAMETER, atlToken);
                        }
                        StringBuilder queryParameterStringBuilder = new StringBuilder();
                        for (Map.Entry<String, String> entry : payload.entrySet()) {
                            queryParameterStringBuilder.append("&").append(entry.getKey()).append("=").append(entry.getValue());
                        }
                        String queryParamString = queryParameterStringBuilder.toString().replaceFirst("&", "?");
                        request = new BasicClassicHttpRequest(Method.POST, url + queryParamString);
                        break;
                    }
                }
                if (request != null) {
                    request.setHeader("Authorization", (Object)authHeader);
                    ret = this.executeResponseForClient(client, (ClassicHttpRequest)request);
                }
            }
            catch (IOException ioe) {
                throw new IOException("Failed to execute REST Request", ioe);
            }
        }
        return ret;
    }

    private RequestResponseBean executeResponseForClient(CloseableHttpClient client, ClassicHttpRequest request) throws IOException {
        return (RequestResponseBean)client.execute(request, response -> {
            RequestResponseBean responseBean = new RequestResponseBean();
            responseBean.setStatusCode(response.getCode());
            responseBean.setReasonPhrase(response.getReasonPhrase());
            if (response.getEntity() != null) {
                try (InputStream in = response.getEntity().getContent();){
                    responseBean.setContent(IOUtils.toString((InputStream)in, (Charset)StandardCharsets.ISO_8859_1));
                }
                catch (IOException ioe) {
                    LOG.error("Failed to parse Request Response content [" + response.getReasonPhrase() + "]", (Throwable)ioe);
                }
            }
            response.close();
            return responseBean;
        });
    }

    private String getAtlTokenForClient(CloseableHttpClient client, String baseUrl, String authHeader) throws IOException {
        String atlToken = null;
        BasicClassicHttpRequest httpGet = new BasicClassicHttpRequest(Method.GET, baseUrl);
        httpGet.setHeader("Authorization", (Object)authHeader);
        atlToken = (String)client.execute((ClassicHttpRequest)httpGet, response -> {
            Element token = null;
            if (response.getEntity() != null && response.getEntity().getContent() != null) {
                Document doc = Jsoup.parse((String)IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8));
                response.close();
                token = doc.getElementById("atlassian-token");
            }
            response.close();
            return token != null ? token.attributes().get("content") : null;
        });
        return atlToken;
    }
}

