let csumAdminDelegGroupDataTable;
let csumAdminAuthUserDataTable;
let csumAdminAuthGroupDataTable;

AJS.$(document).ready(function () {
    console.log('CSUM Delegated config starting...');

    let atlToken = AJS.Meta.get("atl-token");
    let dlgGroupPerms = AJS.$("#dlgGroupPerms").val() === "true";
    let readOnly = AJS.$("#readOnly").val() === "true";
    let contextPath = AJS.contextPath();
    let groupTabLoaded = false;
    let userTabLoaded = false;
    let renderedData;

    function getResponseTextOrDefault(jqXHR, def) {
        let responseText = jqXHR.responseText;
        if (responseText) {
            if (responseText === "bad-space-key"){
                return '<p>' + AJS.I18n.getText("csum.spacetools.bad.space.key") + '</p>';
            } else {
                return '<p>' + AJS.escapeHtml(responseText) + '</p>';
            }
        }
        return '<p>' + def + '</p>';
    }

    function markMatch(text, term, markup) {
        let match = csumStripDiacritics(text.toUpperCase()).indexOf(csumStripDiacritics(term.toUpperCase())), tl = term.length;

        if (match < 0) {
            markup.push(AJS.escapeHtml(text));
            return;
        }

        markup.push(AJS.escapeHtml(text.substring(0, match)));
        markup.push("<span class='select2-match'>");
        markup.push(AJS.escapeHtml(text.substring(match, match + tl)));
        markup.push("</span>");
        markup.push(AJS.escapeHtml(text.substring(match + tl, text.length)));
    }

    //this function only needs to be present in one of the javascript files per set of tabs
    $.fn.dataTable.ext.errMode = function (settings, tn, message) {
        console.error(message);
        AJS.flag({
            type: "error",
            title: AJS.I18n.getText('csum.error.datatable.timeout.title'),
            body: AJS.I18n.getText('csum.error.datatable.timeout') +
                '<ul class="aui-nav-actions-list">' +
                '<li><a class="aui-button aui-button-link" href="' + contextPath + '/admin/plugins/csum-config-actions/viewconfig.action">Reload page</a></li>' +
                '</ul>'
        });
    };

    function invalidateCache() {
        AJS.$.ajax({
            type: "delete",
            url: contextPath + '/rest/csum/latest/dlggroup/cache?atl_token=' + atlToken,
            //data: { atlToken: atlToken },
                beforeSend: function () {
                    AJS.$('#csumForceRefresh').attr("disabled", true);
                },
                success: function (data, textStatus) {
                    if (textStatus === "nocontent") {
                        console.error('error: delete cache failed, status: ' + textStatus);
                        AJS.flag({
                            type: "error",
                            title: AJS.I18n.getText('csum.common.delete.cache') + ': ' + jqXHR.statusText,
                            body: AJS.I18n.getText('csum.error.delete.cache')
                        });
                    }
                },
                error: function (jqXHR) {
                    AJS.flag({
                        type: "error",
                        title: jqXHR.statusText,
                        body: getResponseTextOrDefault(jqXHR, AJS.I18n.getText('action.error') + ': ' + jqXHR.status)
                    });
                },
                complete: function () {
                    AJS.$('#csumForceRefresh').removeAttr("disabled");
                }
            });
    }

    //button attribute assignment
    function enableRemoveGroupButton() {
        AJS.$('#removeDlgGrpButton').removeAttr('disabled');
    }

    function disableRemoveGroupButton() {
        AJS.$('#removeDlgGrpButton').attr('disabled', 'disabled');
    }

    function enableAuthorizeButton() {
        AJS.$('#authorizeButton').removeAttr('disabled');
    }

    function disableAuthorizeButton() {
        AJS.$('#authorizeButton').attr('disabled', 'disabled');
    }

    function enableDeAuthorizeButton() {
        AJS.$('#deauthorizeButton').removeAttr('disabled');
    }

    function disableDeAuthorizeButton() {
        AJS.$('#deauthorizeButton').attr('disabled', 'disabled');
    }

    //check which tab is active so database isn't hit more than required
    function loadTab() {
        let dlgGroup = csumAdminDelegGroupDataTable.row('.selected').data();

        if (AJS.$('#aui-uid-5').attr('aria-selected') === 'true') {
            loadAuthUsers(dlgGroup);
            userTabLoaded = true;
        } else {
            loadAuthGroups(dlgGroup);
            groupTabLoaded = true;
        }
    }

    function hookGroupActionBtnEnabler() {
        csumAdminDelegGroupDataTable.on("select deselect", function (e, dt, type) {
            if (type === "row") {
                if (csumAdminDelegGroupDataTable.rows({selected: true}).data().length > 0) {

                    loadTab();

                    enableAuthorizeButton();
                    enableDeAuthorizeButton();

                    if (dlgGroupPerms && !readOnly) {
                        enableRemoveGroupButton();
                    }
                } else {
                    groupTabLoaded = false;
                    userTabLoaded = false;

                    disableDeAuthorizeButton();
                    disableRemoveGroupButton();
                    disableAuthorizeButton();

                    csumAdminAuthGroupDataTable.clear().draw();
                    csumAdminAuthUserDataTable.clear().draw();

                    AJS.$('#csumSelectedDlgGroupNameHeading').val('').text('');
                }
            }
        });
    }

    function hookTabLoadOnFocus() {
        AJS.$("#usersTab").click(function () {
            if (!userTabLoaded && csumAdminDelegGroupDataTable.rows({selected: true}).data().length > 0) {
                loadAuthUsers(csumAdminDelegGroupDataTable.row('.selected').data());
                userTabLoaded = true;
            }
        });
        AJS.$("#groupsTab").click(function () {
            if (!groupTabLoaded && csumAdminDelegGroupDataTable.rows({selected: true}).data().length > 0) {
                loadAuthGroups(csumAdminDelegGroupDataTable.row('.selected').data());
                groupTabLoaded = true;
            }
        });
    }

    function hookAddGroup() {
        AJS.$("#addDlgGrpButton").click(function () {
            openAddGroupDialog();
        });

        AJS.$("#csumAddConfirmBtn").click(function (e) {
            e.preventDefault();

            submitAddGroups();
            AJS.$("#csumAddGroupPicker").val('');
            AJS.$("#csumAddGroupPicker").select2('data', []);
            AJS.dialog2("#csumAddGroupDialog").hide();
        });

        AJS.$("#csumAddGroupCancelBtn").click(function () {
            AJS.dialog2("#csumAddGroupDialog").hide();
            AJS.$("#csumAddGroupPicker").val('');
            AJS.$("#csumAddGroupPicker").select2('data', []);
        });
        AJS.$('#csumAddGroupPicker').on('input change', function () {
            let targetGroups = AJS.$('#csumAddGroupPicker').val();
            if (targetGroups && targetGroups.trim().length > 0) {
                AJS.$('#csumAddConfirmBtn').removeAttr('disabled');
            } else {
                AJS.$('#csumAddConfirmBtn').attr('disabled', 'disabled');
            }
        });
    }

    function hookRemoveGroup() {

        AJS.$("#removeDlgGrpButton").click(function () {
            let dlgGroup = csumAdminDelegGroupDataTable.row('.selected').data();
            openRemoveGroupDialog(dlgGroup);
        });

        AJS.$("#csumRemoveCancelBtn").click(function () {
            AJS.dialog2("#csumRemoveDialog").hide();
        });

        AJS.$("#csumRemoveConfirmBtn").click(function () {
            let dlgGroup = csumAdminDelegGroupDataTable.row('.selected').data();
            submitRemoveGroup(dlgGroup);

            let groupTableRows = csumAdminAuthGroupDataTable.rows().count();
            let userTableRows = csumAdminAuthUserDataTable.rows().count();

            for (let i = 0; i < groupTableRows; i++) {
                csumAdminAuthGroupDataTable.row(0).remove().draw(true);
            }
            for (let i = 0; i < userTableRows; i++) {
                csumAdminAuthUserDataTable.row(0).remove().draw(true);
            }
        });
    }

    function hookAuthorize() {
        AJS.$('#authorizeButton').click(function (e) {
            e.preventDefault();

            let dlgGroupId = csumAdminDelegGroupDataTable.row('.selected').data()[0];
            let dlgGroupName = csumAdminDelegGroupDataTable.row('.selected').data()[1];

            console.log("Adding group: " + dlgGroupName);

            AJS.$("#dlgImportGroupPicker").val("");
            AJS.$("#dlgImportGroupPicker").select2('data', []);
            AJS.$("#csumAuthGroupPicker").val("");
            AJS.$("#csumAuthGroupPicker").select2('data', []);


            openAuthorizeDialog(dlgGroupId, dlgGroupName);
        });
        AJS.$("#csumAuthorizeCancelBtn").click(function () {
            AJS.dialog2("#csumAuthPopupDialog").hide();
            //reset input fields.
            AJS.$("#csumAuthUserPicker").val("");
            AJS.$("#csumAuthUserPicker.csum-user-search").select2('data', []);
        });
        AJS.$("#csumAuthSubmitButton").click(function (event) {
            event.preventDefault();

            let targetDlgGroupId = AJS.$('#delegatedGroup').val();
            let targetGroups = AJS.$('#csumAuthGroupPicker').val();
            let targetUsers = AJS.$('#csumAuthUserPicker').val();
            let importViaGroups = AJS.$('#dlgImportGroupPicker').val();

            submitAuthorize(targetDlgGroupId, targetGroups, targetUsers, importViaGroups);

            AJS.$("#csumAuthUserPicker").val("");
            AJS.$("#csumAuthUserPicker.csum-user-search").select2('data', []);
            return false;
        });
        AJS.$('#csumAuthGroupPicker, #csumAuthUserPicker, #dlgImportGroupPicker').on('input change', function () {
            let targetGroups = AJS.$('#csumAuthGroupPicker').val();
            let selectedDlgGroup = csumAdminDelegGroupDataTable.row('.selected').data()[1];
            let isSelfAuthActive = false;
            let splitGroups = targetGroups.split(',');
            for(let i = 0; i < splitGroups.length; i++) {
                if (splitGroups[i] === selectedDlgGroup) {
                    isSelfAuthActive = true;
                }
            }

            if (isSelfAuthActive) {
                AJS.$('#csumSelfAuthAdvisory').show();
            } else {
                AJS.$('#csumSelfAuthAdvisory').hide();
            }
            let targetUsers = AJS.$('#csumAuthUserPicker').val();
            let importViaGroups = AJS.$('#dlgImportGroupPicker').val();
            if ((targetGroups && targetGroups.trim().length > 0) || (targetUsers && targetUsers.trim().length > 0) || (importViaGroups && importViaGroups.trim().length > 0)) {
                AJS.$('#csumAuthSubmitButton').removeAttr('disabled');
            } else {
                AJS.$('#csumAuthSubmitButton').attr('disabled', 'disabled');
            }
        });

        let userSearchUrl = contextPath + '/rest/csum/latest/dlguser/searchauthusers';

        AJS.$("#csumAuthUserPicker.csum-user-search").auiSelect2({
            placeholder: AJS.I18n.getText('find.users'),
            minimumInputLength: 3,
            multiple: true,
            ajax: {
                url: userSearchUrl,
                dataType: 'json',
                quietMillis: 350,
                data: function (term) {
                    return {
                        query: term,
                        atl_token: atlToken,
                        page_limit: 25
                    };
                },
                results: function (data) {
                    return {results: data.users};
                }
            },
            formatResult: function (result, container, query) {
                let markup = [];
                let text = result.fullname + " (" + result.email + ", " + result.username + ")";
                markMatch(text, query.term, markup, result.source);
                return markup.join("");
            },
            formatSelection: function (item) {
                return item.fullname;
            },
            id: function (item) {
                return item.username;
            }
        });
        //disallow 'return' to submit, when input empty
        AJS.$("#csumAuthGroupPicker, #csumAuthUserPicker").bind("keypress", function (e) {
            if (e.keyCode === 13) {
                return false;
            }
        });
    }

    function hookDeAuthorize() {
        AJS.$('#deauthorizeButton').click(function () {

            AJS.$("#csumDeauthUserPicker").val("");
            AJS.$("#csumDeauthUserPicker.csum-user-search").select2('data', []);
            AJS.$("#csumDeauthGroupPicker").val("");
            AJS.$("#csumDeauthGroupPicker.csum-group-search").select2('data', []);
            AJS.$("#removeViaMembershipGroupPicker").val("");
            AJS.$("#removeViaMembershipGroupPicker").select2('data', []);

            let i;
            let groupNames = [];
            let userNames = [];
            let selectedGroupRowCount = csumAdminAuthGroupDataTable.rows({selected: true}).count();
            let selectedUserRowCount = csumAdminAuthUserDataTable.rows({selected: true}).count()

            console.log('there are ' + selectedGroupRowCount + ' groups selected, and ' + selectedUserRowCount + ' users selected');

            if ( selectedGroupRowCount > 0 ) {
                for ( i = 0; i < selectedGroupRowCount; i++) {
                    let selectedGroupName = csumAdminAuthGroupDataTable.rows({selected: true}).data()[i][0]
                    console.log("Adding group: " + selectedGroupName);
                    groupNames.push(selectedGroupName);
                }
            }
            if ( selectedUserRowCount > 0 ) {
                for ( i = 0; i < selectedUserRowCount; i++) {
                    let selectedUserName = csumAdminAuthUserDataTable.rows({selected: true}).data()[i];
                    console.log("adding user: " +selectedUserName);
                    userNames.push(selectedUserName);
                }
            }

            let dlgGroup = csumAdminDelegGroupDataTable.row('.selected').data();

            openDeauthorizeDialog(userNames, groupNames, dlgGroup);
        });

        AJS.$("#csumDeauthorizeCancelBtn").click(function (e) {
            //reset input fields.
            e.preventDefault();
            AJS.$("#csumDeauthGroupPicker").auiSelect2('data', []);
            AJS.$("#csumDeauthUserPicker").auiSelect2('data', []);
            AJS.$("#removeViaMembershipGroupPicker").auiSelect2('data', []);

            AJS.dialog2("#csumDeauthPopupDialog").hide();
            AJS.$('#csumClearAllGroupsButton').attr('disabled', 'disabled');
            AJS.$('#csumClearAllUsersButton').attr('disabled', 'disabled');
        });

        AJS.$("#csumDeauthSubmitButton").click(function (event) {
            event.preventDefault();
            let dlgGroup = csumAdminDelegGroupDataTable.row('.selected').data();
            let targetUsers = AJS.$('#csumDeauthUserPicker').val();
            let targetGroups = AJS.$('#csumDeauthGroupPicker').val();
            let targetViaMembership = AJS.$('#removeViaMembershipGroupPicker').val();

            submitDeAuthorize(dlgGroup, targetUsers, targetGroups, targetViaMembership);

            AJS.$('#csumClearAllGroupsButton').attr('disabled', 'disabled');
            AJS.$('#csumClearAllUsersButton').attr('disabled', 'disabled');

            return false;
        });

        AJS.$('#csumDeauthGroupPicker, #csumDeauthUserPicker, #removeViaMembershipGroupPicker').on('input change', function () {
            let targetGroups = AJS.$('#csumDeauthGroupPicker').val();
            let targetUsers = AJS.$('#csumDeauthUserPicker').val();
            let targetViaMembership = AJS.$('#removeViaMembershipGroupPicker').val();

            let selectedDlgGroup = csumAdminDelegGroupDataTable.row('.selected').data()[1];
            let isSelfAuthActive = false;
            let splitGroups = targetGroups.split(',');
            for(let i = 0; i < splitGroups.length; i++) {
                if (splitGroups[i] === selectedDlgGroup) {
                    isSelfAuthActive = true;
                }
            }

            if (isSelfAuthActive) {
                AJS.$('#csumSelfDeAuthAdvisory').show();
            } else {
                AJS.$('#csumSelfDeAuthAdvisory').hide();
            }

            if ((targetGroups && targetGroups.trim().length > 0) || (targetUsers && targetUsers.trim().length > 0) ||
                (targetViaMembership && targetViaMembership.trim().length > 0)) {
                AJS.$('#csumDeauthSubmitButton').removeAttr('disabled');
            } else {
                AJS.$('#csumDeauthSubmitButton').attr('disabled', 'disabled');
            }
        });

        //disallow return to submit,when empty
        AJS.$("#csumDeauthGroupPicker, #csumDeauthUserPicker").bind("keypress", function (e) {
            if (e.keyCode === 13) {
                return false;
            }
        });
        AJS.$('#csumDeauthGroupPicker, #csumDeauthUserPicker').on('input change', function () {
            let targetGroups = AJS.$('#csumDeauthGroupPicker').val();
            let targetUsers = AJS.$('#csumDeauthUserPicker').val();
            if (targetGroups && targetGroups.trim().length > 0) {
                AJS.$('#csumClearAllGroupsButton').removeAttr('disabled');
            } else {
                AJS.$('#csumClearAllGroupsButton').attr('disabled', 'disabled');
            }
            if (targetUsers && targetUsers.trim().length > 0) {
                AJS.$('#csumClearAllUsersButton').removeAttr('disabled');
            } else {
                AJS.$('#csumClearAllUsersButton').attr('disabled', 'disabled');
            }
        });
    }

    function hookCacheRefresh() {
        AJS.$('#csumForceRefresh').click(function () {
            AJS.dialog2('#csumInvalidateCacheDialog').show();
        });
        AJS.$('#csumInvalidateCacheConfirmBtn').click(function (e) {
            e.preventDefault();
            invalidateCache();
            AJS.dialog2('#csumInvalidateCacheDialog').hide();
        });
        AJS.$('#csumInvalidateCacheCancelBtn').click(function () {
            AJS.dialog2('#csumInvalidateCacheDialog').hide();
        });
    }

    function hookFillAndClearButtons(dlgGroupId) {

        AJS.$('#csumFillAllGroupsButton').click(function (event) {
            event.preventDefault();

            let url = contextPath + "/rest/csum/latest/dlggroup/fill/auth";

            AJS.$.ajax({
                type: "get",
                url: url,
                data: {dlggroupid: dlgGroupId, atl_token: atlToken},
                dataType: "json",
                success: function (data, textStatus) {
                    if (textStatus === "success") {

                        let selectedDlgGroup = csumAdminDelegGroupDataTable.row('.selected').data()[1];
                        let isSelfAuthActive = false;
                        for(let i = 0; i < data.length; i++) {
                            if (data[i] === selectedDlgGroup) {
                                isSelfAuthActive = true;
                            }
                        }

                        if (isSelfAuthActive) {
                            AJS.$('#csumSelfDeAuthAdvisory').show();
                        } else {
                            AJS.$('#csumSelfDeAuthAdvisory').hide();
                        }

                        AJS.$("#csumDeauthGroupPicker").auiSelect2('data', data);

                        if (data.length > 0) {
                            AJS.$('#csumDeauthSubmitButton').removeAttr('disabled');
                            AJS.$('#csumClearAllGroupsButton').removeAttr('disabled');
                        } else {
                            AJS.messages.info('#csumPopupMessagesDeauth', {
                                body: '<p>' + AJS.I18n.getText('csum.info.fill.groups') + '</p>',
                                fadeout: true
                            });
                        }
                    } else if (textStatus === "nocontent") {
                        console.error('error: fill groups failed, status: ' + textStatus);
                        AJS.flag({
                            type: "error",
                            title: AJS.I18n.getText('csum.common.fill.groups') + ': ' + jqXHR.statusText,
                            body: AJS.I18n.getText('csum.error.fill.groups')
                        });
                    }

                },
                error: function () {
                    AJS.flag({
                        type: 'error',
                        title: AJS.I18n.getText('csum.error.fill.groups'),
                        body: '<p>' + AJS.I18n.getText('csum.error.server.data.mismatch') + '</p>',
                    });
                }
            });
        });

        AJS.$('#csumClearAllGroupsButton').click(function (event) {
            event.preventDefault();
            AJS.$("#csumDeauthGroupPicker").auiSelect2('data', []);
            AJS.$('#csumClearAllGroupsButton').attr('disabled', 'disabled');

            if (AJS.$("#csumDeauthUserPicker").val() === '') {
                AJS.$('#csumDeauthSubmitButton').attr('disabled', 'disabled');
            }
        });

        AJS.$('#csumFillAllUsersButton').click(function (event) {
            event.preventDefault();
            let url = contextPath + "/rest/csum/latest/dlguser/searchauthusersfromgroup";

            AJS.$.ajax({
                type: "get",
                url: url,
                data: {query: "*", dlggroupid: dlgGroupId, atl_token: atlToken},
                dataType: "json",
                success: function (data, textStatus, errorMessage) {
                    AJS.$("#csumDeauthUserPicker").auiSelect2('data', data.users);

                    if (data.users.length > 0) {
                        AJS.$('#csumDeauthSubmitButton').removeAttr('disabled');
                        AJS.$('#csumClearAllUsersButton').removeAttr('disabled');
                    } else {
                        AJS.messages.info('#csumPopupMessagesDeauth', {
                            body: '<p>' + AJS.I18n.getText('csum.info.fill.users') + '</p>',
                            fadeout: true
                        });
                    }
                    if (textStatus === "nocontent") {
                        console.error('error: user fill failed, status: ' + textStatus);
                        AJS.flag({
                            type: "error",
                            title: AJS.I18n.getText('csum.common.fill.users') + ': ' + errorMessage.statusText,
                            body: AJS.I18n.getText('cannot.add.group.membership.failed')
                        });
                    }
                },
                error: function () {
                    AJS.flag({
                        type: 'error',
                        title: AJS.I18n.getText('csum.error.fill.users'),
                        body: '<p>' + AJS.I18n.getText('csum.error.server.data.mismatch') + '</p>'
                    });
                },
                formatSelection: function (item) {
                    return item.username;
                },
                id: function (item) {
                    return item.username;
                }
            });
        });
        AJS.$('#csumClearAllUsersButton').click(function (event) {
            event.preventDefault();
            AJS.$("#csumDeauthUserPicker").auiSelect2('data', []);
            AJS.$('#csumClearAllUsersButton').attr('disabled', 'disabled');

            if (AJS.$("#csumDeauthGroupPicker").val() === '') {
                AJS.$('#csumDeauthSubmitButton').attr('disabled', 'disabled');
            }
        });
    }

    function messageAddGroup(data) {
        let successCount;
        let failureCount = data.duplicateGroups.length;

        if (data.successfulGroups.length > 0 && data.duplicateGroups.length === 0) {
            csumAdminDelegGroupDataTable.ajax.reload(null, false);

            AJS.flag({
                type: 'success',
                title: AJS.I18n.getText('csum.successful.operation'),
                close: 'auto'
            });
        } else if (data.duplicateGroups.length > 0 && data.successfulGroups.length > 0) {

            let failedGroups;

            if (10 > failureCount > 0) {
                failedGroups = data.duplicateGroups[0].name;
                for (let i = 1; i < failureCount; i++) {
                    failedGroups = failedGroups.concat(", ", data.duplicateGroups[i].name)
                }
            } else if (failureCount > 10) {
                failedGroups = data.duplicateGroups[0].name;
                for (let j = 1; j < 10; j++) {
                    failedGroups = failedGroups.concat(", ", data.duplicateGroups[j].name)
                }
                failedGroups = failedGroups.concat(" + ", (failureCount - 10).toString(), " more.");
            }


            successCount = data.successfulGroups.length;
            let total = successCount + failureCount;

            AJS.flag({
                type: 'error',
                title: AJS.I18n.getText('csum.part.error.dlg.add.group', total, failureCount) + ': ' + failedGroups
            });
        } else {
            AJS.flag({
                type: 'error',
                title: AJS.I18n.getText('csum.error.dlg.add.group.nosuccess', failureCount)
            });
        }
    }

    function stringifyFailures(failureCount, failures) {
        let failedEntities;
        if (10 > failureCount > 0) {

            failedEntities = failures[0];
            for (let i = 1; i < failureCount; i++) {
                failedEntities = failedEntities.concat(", ", failures[i])
            }
        } else if (failureCount > 10) {
            failedEntities = failures[0];
            for (let j = 1; j < 10; j++) {
                failedEntities = failedEntities.concat(", ", failures[j])
            }
            failedEntities = failedEntities.concat(" + ", (failureCount - 10).toString(), " more.");
        }
        return failedEntities;
    }

    function messageAuthorize(data) {

        let groupFailureCount = data.groupAuthFailures.length;
        let userFailureCount = data.userAuthFailures.length;
        let dlgGroup = csumAdminDelegGroupDataTable.row('.selected').data();

        //full success
        if ((groupFailureCount === 0 && userFailureCount === 0) && (data.groupAuthSuccesses > 0 || data.userAuthSuccesses > 0)) {
            AJS.flag({
                type: 'success',
                title: AJS.I18n.getText('csum.successful.operation'),
                close: 'auto'
            });

            loadAuthGroups(dlgGroup);
            loadAuthUsers(dlgGroup);
        }

        //setup group failure string
        let failedGroups = stringifyFailures(groupFailureCount, data.groupAuthFailures);

        //setup user failure string
        let failedUsers = stringifyFailures(userFailureCount, data.userAuthFailures);

        //partial group success
        if (groupFailureCount > 0 && data.groupAuthSuccesses > 0) {

            loadAuthGroups(dlgGroup);

            let total = groupFailureCount + data.groupAuthSuccesses;

            AJS.flag({
                type: 'error',
                title: AJS.I18n.getText('csum.part.error.dlg.auth.group', total, groupFailureCount) + ': ' + failedGroups
            });

            //complete group failure
        } else if (groupFailureCount > 0 && data.groupAuthSuccesses === 0) {
            AJS.flag({
                type: 'error',
                title: AJS.I18n.getText('csum.error.dlg.auth.group', groupFailureCount)
            });
        }

        //partial user success
        if (userFailureCount > 0 && data.userAuthSuccesses > 0) {

            loadAuthUsers(dlgGroup);

            let total = userFailureCount + data.userAuthSuccesses;

            AJS.flag({
                type: 'error',
                title: AJS.I18n.getText('csum.part.errordlg.auth.user', total, userFailureCount) + ': ' + failedUsers,
            });

            //complete user failure
        } else if (userFailureCount > 0 && data.userAuthSuccesses === 0) {
            AJS.flag({
                type: 'error',
                title: AJS.I18n.getText('csum.error.dlg.auth.user', userFailureCount)
            });
        }
    }

    function messageDeAuthorize(data) {
        let userFailureCount = data[0].length;
        let groupFailureCount = data[1].length;
        let dlgGroup = csumAdminDelegGroupDataTable.row('.selected').data();
        //full success
        let groupSuccessCount = data[2][0];
        let userSuccessCount = data[2][1];
        if ((groupFailureCount === 0 && userFailureCount === 0) && (groupSuccessCount > 0 || userSuccessCount > 0)) {
            AJS.flag({
                type: 'success',
                title: AJS.I18n.getText('csum.successful.operation'),
                close: 'auto'
            });

            loadAuthGroups(dlgGroup);
            loadAuthUsers(dlgGroup);
        }
        //setup group failure string
        let failedGroups = stringifyFailures(groupFailureCount, data[1]);

        //setup user failure string
        let failedUsers = stringifyFailures(userFailureCount, data[0]);

        //partial group success
        if (groupFailureCount > 0 && groupSuccessCount > 0) {

            loadAuthGroups(dlgGroup);

            let total = groupFailureCount + parseInt(groupSuccessCount);

            AJS.flag({
                type: 'error',
                title: AJS.I18n.getText('csum.part.error.dlg.deauth.group', total, groupFailureCount) + ': ' + failedGroups
            });

            //complete group failure
        } else if (groupFailureCount > 0 && groupSuccessCount === "0") {
            AJS.flag({
                type: 'error',
                title: AJS.I18n.getText('csum.error.dlg.deauth.group', groupFailureCount)
            });
        }

        //partial user success
        if (userFailureCount > 0 && userSuccessCount > 0) {

            loadAuthUsers(dlgGroup);

            let total = userFailureCount + parseInt(userSuccessCount);

            AJS.flag({
                type: 'error',
                title: AJS.I18n.getText('csum.part.error.dlg.deauth.user', total, userFailureCount) + ': ' + failedUsers,
            });

            //complete user failure
        } else if (userFailureCount > 0 && userSuccessCount === "0") {
            AJS.flag({
                type: 'error',
                title: AJS.I18n.getText('csum.error.dlg.deauth.user', userFailureCount)
            });
        }

    }

    function errorFlag(i18nTitle, i18nBody, jqXHR) {
        let jqStatus;

        if (jqXHR) {
            jqStatus = jqXHR.statusText;
        } else {
            jqStatus = 'error';
        }

        AJS.flag({
            type: "error",
            title: i18nTitle + ': ' +  jqStatus,
            body: getResponseTextOrDefault(jqXHR, i18nBody)
        });
    }

    function unhandledError(i18nTitle){
        AJS.flag({
            type: "error",
            title: i18nTitle + ': error',
            body: AJS.I18n.getText('csum.error.generic.unknown')
        });
    }

    function hookCloseExceptionDialog() {
        AJS.$('#dlgExceptionDialogClose').click(function (e) {
            e.preventDefault();
            AJS.$("#dlgStackTrace").toggle(false);
            AJS.$("#dlgShowStack").text(AJS.I18n.getText("logged.event.see.more"));
            AJS.$("#dlgExceptionDialog").attr("class", "aui-layer aui-dialog2 aui-dialog2-medium aui-dialog2-warning")
            AJS.dialog2("#dlgExceptionDialog").hide();

            AJS.$('#dlgExceptionName').text("");
            AJS.$('#dlgExceptionMessage').text("");
            AJS.$('#dlgStackTrace').text("");
            AJS.$('#dlgCsumVersion').text("");
            AJS.$('#dlgExceptionHeader').text("");
        });
    }

    function hookShowStackButton() {
        AJS.$("#dlgShowStack").click(function (e) {
            e.preventDefault();

            AJS.$("#dlgStackTrace").toggle();

            if (AJS.$("#dlgShowStack").text() === AJS.I18n.getText("logged.event.see.more")) {
                AJS.$("#dlgShowStack").text(AJS.I18n.getText("logged.event.see.less"));
                AJS.$("#dlgExceptionDialog").attr("class", "aui-layer aui-dialog2 aui-dialog2-xlarge aui-dialog2-warning");
            } else {
                AJS.$("#dlgShowStack").text(AJS.I18n.getText("logged.event.see.more"));
                AJS.$("#dlgExceptionDialog").attr("class", "aui-layer aui-dialog2 aui-dialog2-medium aui-dialog2-warning");
            }
        });
    }

    function openExceptionDialog(JSONPayload, dialog, operationName) {

        let exceptionName = JSONPayload.exceptionName;
        let exceptionMessage = JSONPayload.exceptionMessage;
        let stackTrace = JSONPayload.stackTrace;
        let pluginVersion = JSONPayload.pluginVersion;

        AJS.dialog2(dialog).hide();

        AJS.$('#dlgExceptionName').text(exceptionName);
        AJS.$('#dlgExceptionMessage').text(exceptionMessage);
        AJS.$('#dlgStackTrace').text(stackTrace);
        AJS.$('#dlgCsumVersion').text("CSUM " + pluginVersion);
        AJS.$('#dlgExceptionHeader').text(AJS.I18n.getText("csum.error.exception.header", operationName));

        AJS.dialog2("#dlgExceptionDialog").show();
    }

    function submitAddGroups() {
        let operationName = "Add group(s)";
        let groupNames = AJS.$("#csumAddGroupPicker").val();
        let restEndpoint = contextPath + "/rest/csum/latest/dlggroup/add?atl_token=" + atlToken;

        AJS.$.ajax({
            type: "post",
            url: restEndpoint,
            data: {groupnames: groupNames},
            success: function (data, textStatus, errorMessage) {
                if (textStatus === "success") {
                    messageAddGroup(data);
                } else if (textStatus === 'notmodified') {
                    console.error('Add group failed, status: ' + textStatus + ', errorMessage: ' + errorMessage);
                    AJS.flag({
                        type: 'error',
                        title: AJS.I18n.getText('action.error') + ': ' + AJS.I18n.getText('csum.action.group.delegate.pick'),
                        body: '<p>' + AJS.I18n.getText('group.exists') + '</p>'
                    });
                }
            },
            statusCode: {
                204: function () {
                    unhandledError(AJS.I18n.getText('csum.action.group.delegate.pick'));
                },
                303: function(jqXHR) {
                    let json = jqXHR.responseJSON;
                    if (json != null) {
                        openExceptionDialog(json, "#csumAddGroupDialog", operationName);
                    } else {
                        unhandledError(AJS.I18n.getText('csum.action.group.delegate.pick'));
                    }
                },
                401: function (jqXHR) {
                    errorFlag(AJS.I18n.getText('csum.action.group.delegate.pick'), AJS.I18n.getText('csum.error.not.authorized'), jqXHR);
                },
                412: function (jqXHR) {
                    errorFlag(AJS.I18n.getText('csum.action.group.disabled'), AJS.I18n.getText('csum.action.group.disabled'), jqXHR);
                }
            },
            complete: function () {
                AJS.$("#csumAddGroupDialog").hide();
            }
        });
    }

    function submitAuthorize(dlgGroupId, groups, userNames, importViaGroups) {

        if (groups === "") {
            groups = undefined;
        }
        if (userNames === "") {
            userNames = undefined;
        }
        if (importViaGroups === "") {
            importViaGroups = undefined;
        }

        let endpointUrl = contextPath + "/rest/csum/latest/dlggroup/authorize?atl_token=" + atlToken;
        AJS.$.ajax({
            type: "post",
            url: endpointUrl,
            data: {dlggroupid: dlgGroupId, groups: groups, userNames: userNames, importViaGroups: importViaGroups},
            beforeSend: function() {
                AJS.$('#csumAuthorizeSpinner').show();
                AJS.$('#csumAuthPopupDialog :button').attr("disabled", true);
            },
            success: function (data, textStatus, jqXHR) {
                if (textStatus === "success") {
                    messageAuthorize(data)
                } else if (textStatus === "nocontent") {
                    console.error('error: user-authorisation failed, status: ' + textStatus);
                    AJS.flag({
                        type: "error",
                        title: AJS.I18n.getText('add.members') + ': ' + jqXHR.statusText,
                        body: AJS.I18n.getText('cannot.add.group.membership.failed')
                    });
                }
            },
            statusCode: {
                401: function (jqXHR) {
                    errorFlag(AJS.I18n.getText('csum.action.dlg.authorize'), AJS.I18n.getText('csum.error.auth'), jqXHR);
                },
                500: function (jqXHR) {
                    let json = jqXHR.responseJSON;
                    if (json != null) {
                        openExceptionDialog(json, "#csumAuthPopupDialog", "Authorize group(s)/user(s)");
                    } else {
                        unhandledError(AJS.I18n.getText('csum.action.dlg.authorize'));
                    }
                }
            },
            complete: function() {
                AJS.dialog2("#csumAuthPopupDialog").hide();
                AJS.$('#csumAuthorizeSpinner').hide();
                AJS.$('#csumAuthPopupDialog :button').removeAttr("disabled");
            }
        });
    }

    function submitDeAuthorize(dlgGroup, userNames, groupNames, targetViaMembership) {
        let endpointUrl = contextPath + '/rest/csum/latest/dlggroup/deauthorize?dlggroupid=' + encodeURIComponent(dlgGroup[0]) + '&usernames=' + encodeURIComponent(userNames) + '&groupnames=' + encodeURIComponent(groupNames) + '&targetviamembership=' + encodeURIComponent(targetViaMembership) + '&atl_token=' + atlToken;

        AJS.$.ajax({
            type: "delete",
            url: endpointUrl,
            contentType: "application/json; charset=utf-8",
            beforeSend: function () {
                AJS.$('#csumDeAuthSpinner').show();
                AJS.$('#csumDeauthPopupDialog :button').attr("disabled", true);
            },
            success: function (data, textStatus) {
                if (textStatus === 'success') {
                    messageDeAuthorize(data);
                } else if (textStatus === 'notmodified') {
                    console.error('group deauthorize failed, status: ' + textStatus + ', errorMessage: ' + textStatus);
                    AJS.flag({
                        type: 'error',
                        title: AJS.I18n.getText('action.error') + ': ' + AJS.I18n.getText('csum.display.label.deauthorize'),
                        body: '<p>' + AJS.I18n.getText('csum.error.deauth') + '</p>'
                    });
                }
            },
            statusCode: {
                401: function (jqXHR) {
                    errorFlag(AJS.I18n.getText('csum.display.label.deauthorize'), AJS.I18n.getText('csum.error.not.authorized'), jqXHR);
                },
                500: function (jqXHR) {
                    let json = jqXHR.responseJSON;

                    if (json != null) {
                        openExceptionDialog(json, "#csumDeauthPopupDialog", "De-authorize group(s)/user(s)");
                    } else {
                        unhandledError(AJS.I18n.getText('csum.display.label.deauthorize'));
                    }
                }
            },
            complete: function () {
                AJS.dialog2("#csumDeauthPopupDialog").hide();
                if (groupNames && groupNames !== "") {
                    loadAuthGroups(dlgGroup);
                }
                if (userNames && userNames !== "" || targetViaMembership !== "") {
                    loadAuthUsers(dlgGroup)
                }
                AJS.$('#csumDeAuthSpinner').hide();
                AJS.$('#csumDeauthPopupDialog :button').removeAttr("disabled");
            }
        });
    }

    function submitRemoveGroup(dlgGroup) {
        let endpointUrl = contextPath + "/rest/csum/latest/dlggroup/group/remove?dlggroupid=" + encodeURIComponent(dlgGroup[0]) + "&atl_token=" + atlToken;
        AJS.$.ajax({
            type: "delete",
            url: endpointUrl,
            contentType: "application/json; charset=utf-8",
            beforeSend: function () {
                AJS.$('#csumRemoveSpinner').show();
                AJS.$('#csumRemoveDialog :button').attr("disabled", true);
                disableAuthorizeButton();
                disableDeAuthorizeButton();
            },
            success: function (data, textStatus) {
                if (textStatus === 'success') {
                    disableRemoveGroupButton();
                    csumAdminDelegGroupDataTable.row('.selected').remove().draw(true);

                    AJS.flag({
                        type: 'success',
                        title: AJS.I18n.getText('csum.successful.operation'),
                        close: 'auto'
                    });
                } else if (textStatus === 'notmodified') {
                    console.error('group delete failed, status: ' + textStatus + ', errorMessage: ' + textStatus);
                    AJS.flag({
                        type: 'error',
                        title: AJS.I18n.getText('action.error') + ': ' + AJS.I18n.getText('title.remove.group'),
                        body: '<p>' + AJS.I18n.getText('cannot.remove.group', dlgGroup[1]) + '</p>'
                    });
                }
                AJS.$('#csumSelectedDlgGroupNameHeading').val('').text('');
            },
            statusCode: {
                204: function () {
                    unhandledError(AJS.I18n.getText('csum.action.dlg.group.remove'));
                },
                401: function (jqXHR) {
                    errorFlag(AJS.I18n.getText('csum.action.dlg.group.remove'), AJS.I18n.getText('csum.error.not.authorized'), jqXHR);
                },
                412: function (jqXHR) {
                    errorFlag(AJS.I18n.getText('csum.action.dlg.group.remove'), AJS.I18n.getText('csum.display.alert.invalid.space.key'), jqXHR);
                },
                500: function (jqXHR) {
                    let json = jqXHR.responseJSON;

                    if (json != null) {
                        openExceptionDialog(json, "#csumRemoveDialog", "Remove group");
                    }
                }
            },
            complete: function () {
                AJS.dialog2("#csumRemoveDialog").hide();
                AJS.$('#csumRemoveSpinner').hide();
                AJS.$('#csumRemoveDialog :button').removeAttr("disabled");
            }
        });
    }

    function openAddGroupDialog() {
        AJS.$('#csumAddConfirmBtn').attr('disabled', 'disabled');
        AJS.dialog2("#csumAddGroupDialog").show();

        AJS.$("#csumSelectedGroupNameHeading").text('');

        let url = contextPath + "/rest/csum/latest/dlggroup/search";
        let select2 = AJS.$("#csumAddGroupPicker").auiSelect2({
            placeholder: "Select a Group",
            minimumInputLength: 3,
            multiple: true,
            ajax: {
                url: url,
                placeholder: "Search for a group",
                dataType: 'json',
                quietMillis: 300,
                data: function (term) {
                    return {
                        prefix: term,
                        atl_token: atlToken
                    };
                },
                results: function (data) {
                    return {
                        results: data.groups
                    };
                }
            },
            formatResult: function (item) {
                if (item.id) {
                    return AJS.escapeHtml(item.id);
                } else {
                    return AJS.escapeHtml(item);
                }
            },
            formatSelection: function (item) {
                if (item.id) {
                    return AJS.escapeHtml(item.id);
                } else {
                    return AJS.escapeHtml(item);
                }
            },
            id: function (item) {
                if (item.id) {
                    return item.id;
                } else {
                    return item;
                }
            }
        });
        select2.select2("open");
    }

    function openRemoveGroupDialog(dlgGroup) {
        let endpointUrl = contextPath + "/rest/csum/latest/dlggroup/count/auth";
        AJS.$.ajax({
            type: "get",
            url: endpointUrl,
            data: {dlggroupid: dlgGroup[0], atl_token: atlToken},
            dataType: "json",
            success: function (data, textStatus, errorMessage) {
                if (textStatus === "success") {
                    let theVal = AJS.I18n.getText('csum.action.dlg.group.remove.info', AJS.escapeHtml(dlgGroup[1]), data.groupCountData.data, data.userCountData.data);

                    AJS.$("#csumRemoveGroupContent").html(theVal);
                    AJS.dialog2("#csumRemoveDialog").show();
                    AJS.$('#csumRemoveSpinner').hide();
                } else if (textStatus === "nocontent") {
                    console.error('error: failed to get numeric values for confirmation message, status: ' + textStatus);
                    AJS.flag({
                        type: "error",
                        title: AJS.I18n.getText('csum.common.contextual.data') + ': ' + errorMessage.statusText,
                        body: AJS.I18n.getText('csum.error.remove.dlg.group.contextual')
                    });
                }
            },
            error: function () {
                AJS.flag({
                    type: 'error',
                    title: AJS.I18n.getText('csum.error.find.auth'),
                    body: '<p>' + AJS.I18n.getText('csum.error.server.data.mismatch') + '</p>'
                });
            }
        });
    }

    function openAuthorizeDialog(dlgGroupId, dlgGroupName) {
        AJS.$('#csumAuthSubmitButton').attr('disabled', 'disabled');
        AJS.dialog2("#csumAuthPopupDialog").show();
        AJS.$('#csumAuthorizeSpinner').hide();
        AJS.$('#csumSelfAuthAdvisory').hide();
        let selectedGroup = '';
        AJS.$("#csumDelegatedGroupAuthHeading").text(dlgGroupName).show();
        AJS.$("#delegatedGroup").val(dlgGroupId);

        let url = contextPath + "/rest/csum/latest/dlggroup/search";
        AJS.$("#csumAuthGroupPicker").auiSelect2({
            placeholder: AJS.I18n.getText('find.groups'),
            minimumInputLength: 3,
            multiple: true,
            ajax: {
                url: url,
                dataType: 'json',
                quietMillis: 350,
                data: function (term) {
                    return {
                        prefix: term,
                        dlggroupid: dlgGroupId,
                        atl_token: atlToken
                    };
                },
                results: function (data) {
                    return {
                        results: data.groups,
                        text: function (item) {
                            return AJS.escapeHtml(item);
                        },
                        id: function (item) {
                            return item;
                        }
                    };
                }
            },
            initSelection: function (element, callback) {
                let data = [];
                if (selectedGroup !== '') {
                    data.push({id: selectedGroup, text: AJS.escapeHtml(selectedGroup)});
                }
                callback(data);
            },
            formatResult: function (item) {
                if (item.id) {
                    return AJS.escapeHtml(item.id);
                } else {
                    return AJS.escapeHtml(item);
                }
            },
            formatSelection: function (item) {
                if (item.id) {
                    return AJS.escapeHtml(item.id);
                } else {
                    return AJS.escapeHtml(item);
                }
            },
            id: function (item) {
                if (item.id) {
                    return item.id;
                } else {
                    return item;
                }
            }
        }).select2('val', []);

        let importGroupSearchUrl = contextPath + '/rest/csum/latest/dlggroup/search';

        AJS.$("#dlgImportGroupPicker").auiSelect2({
            placeholder: AJS.I18n.getText('find.groups'),
            minimumInputLength: 3,
            multiple: true,
            ajax: {
                url: importGroupSearchUrl,
                dataType: 'json',
                quietMillis: 350,
                data: function (term) {
                    return {
                        prefix: term,
                        atl_token: atlToken
                    };
                },
                results: function (data) {
                    return {
                        results: data.groups,
                        text: function (item) {
                            return AJS.escapeHtml(item);
                        },
                        id: function (item) {
                            return item;
                        }
                    };
                }
            },
            formatResult: function (item) {
                if (item.id) {
                    return AJS.escapeHtml(item.id);
                } else {
                    return AJS.escapeHtml(item);
                }
            },
            formatSelection: function (item) {
                if (item.id) {
                    return AJS.escapeHtml(item.id);
                } else {
                    return AJS.escapeHtml(item);
                }
            },
            id: function (item) {
                if (item.id) {
                    return item.id;
                } else {
                    return item;
                }
            }
        });
    }

    function openDeauthorizeDialog(userNames, groupNames, dlgGroup) {

        hookFillAndClearButtons(dlgGroup[0]);

        //check if users groups have been auto-filled
        if (userNames.length > 0) {
            AJS.$('#csumClearAllUsersButton').removeAttr('disabled');
        }
        if (groupNames.length > 0) {
            AJS.$('#csumClearAllGroupsButton').removeAttr('disabled');
        }

        /*AJS.$('#csumDeauthSubmitButton').removeAttr('disabled');*/
        AJS.$('#csumSelfDeAuthAdvisory').hide();

        AJS.$('#csumDeauthSubmitButton').attr('disabled', 'disabled');

        AJS.$("#deauthCsumSelectedGroupNameHeading").text(dlgGroup[1]).show();
        AJS.$("#delegatedGroup").val(dlgGroup[0]);

        let url = contextPath + "/rest/csum/latest/dlggroup/searchauthusersfromgroup";
        AJS.$("#csumDeauthGroupPicker").auiSelect2({
            placeholder: AJS.I18n.getText('find.groups'),
            minimumInputLength: 3,
            multiple: true,
            ajax: {
                url: url,
                dataType: 'json',
                quietMillis: 350,
                data: function (term) {
                    return {
                        prefix: term,
                        dlggroupid: dlgGroup[0],
                        atl_token: atlToken
                    };
                },
                results: function (data) {
                    return {
                        results: data.groups,
                        text: function (item) {
                            return AJS.escapeHtml(item);
                        },
                        id: function (item) {
                            return item;
                        }
                    };
                }
            },
            initSelection: function (element, callback) {
                let data = [];
                if (groupNames.length > 0) {
                    for (let i = 0; i < groupNames.length; i++) {
                        data.push({id: groupNames[i], text: AJS.escapeHtml(groupNames[i])});
                    }
                    AJS.$('#csumDeauthSubmitButton').removeAttr('disabled');
                }
                callback(data);
            },
            formatResult: function (item) {
                if (item.id) {
                    return AJS.escapeHtml(item.id);
                } else {
                    return AJS.escapeHtml(item);
                }
            },
            formatSelection: function (item) {
                if (item.id) {
                    return AJS.escapeHtml(item.id);
                } else {
                    return AJS.escapeHtml(item);
                }
            },
            id: function (item) {
                if (item.id) {
                    return item.id;
                } else {
                    return item;
                }
            }
        }).select2('val', []);

        let userSearchUrl = contextPath + '/rest/csum/latest/dlguser/searchauthusersfromgroup';

        AJS.$("#csumDeauthUserPicker.csum-user-search").auiSelect2({
            placeholder: AJS.I18n.getText('find.users'),
            minimumInputLength: 3,
            multiple: true,
            ajax: {
                url: userSearchUrl,
                dataType: 'json',
                quietMillis: 350,
                data: function (term) {
                    return {
                        query: term,
                        dlggroupid: dlgGroup[0],
                        page_limit: 25,
                        atl_token: atlToken
                    };
                },
                results: function (data) {
                    return {results: data.users};
                }
            },
            initSelection: function (element, callback) {
                let data = [];
                if (userNames.length > 0) {
                    for (let i = 0; i < userNames.length; i++) {
                        data.push({username: userNames[i][1], fullname: userNames[i][0]});
                    }
                    AJS.$('#csumDeauthSubmitButton').removeAttr('disabled');
                }
                callback(data);
            },
            formatResult: function (result, container, query) {
                let markup = [];
                let text = result.fullname + " (" + result.email + ", " + result.username + ")";
                markMatch(text, query.term, markup, result.source);
                return markup.join("");
            },
            formatSelection: function (item) {
                return item.username;
            },
            id: function (item) {
                return item.username;
            }
        }).select2('val', []);

        let removeViaMembership = contextPath + '/rest/csum/latest/dlggroup/search';

        AJS.$("#removeViaMembershipGroupPicker").auiSelect2({
            placeholder: AJS.I18n.getText('find.groups'),
            minimumInputLength: 3,
            multiple: true,
            ajax: {
                url: removeViaMembership,
                dataType: 'json',
                quietMillis: 350,
                data: function (term) {
                    return {
                        prefix: term,
                        atl_token: atlToken
                    };
                },
                results: function (data) {
                    return {
                        results: data.groups,
                        text: function (item) {
                            return AJS.escapeHtml(item);
                        },
                        id: function (item) {
                            return item;
                        }
                    };
                }
            },
            formatResult: function (item) {
                if (item.id) {
                    return AJS.escapeHtml(item.id);
                } else {
                    return AJS.escapeHtml(item);
                }
            },
            formatSelection: function (item) {
                if (item.id) {
                    return AJS.escapeHtml(item.id);
                } else {
                    return AJS.escapeHtml(item);
                }
            },
            id: function (item) {
                if (item.id) {
                    return item.id;
                } else {
                    return item;
                }
            }
        });

        AJS.dialog2("#csumDeauthPopupDialog").show();
        AJS.$('#csumDeAuthSpinner').hide();
    }

    function loadGroups() {
        let restEndpoint = contextPath + "/rest/csum/latest/dlggroup/list/groups?atl_token=" + atlToken;
        let spinTimer = setTimeout(function () {
            AJS.$('#csumGroupTable_wrapper').hide();
            AJS.$('#csumGroupSpinner').show();
        }, 250);

        csumAdminDelegGroupDataTable.ajax.url(restEndpoint).load(function (response) {
            clearTimeout(spinTimer);
            AJS.$('#csumGroupSpinner').hide();
            AJS.$('#csumGroupTable_wrapper').show();
            if (response.cacheLimitReached) {
                AJS.flag({
                    type: "warning",
                    title: AJS.I18n.getText('csum.cache.grouplimit.reached'),
                    body: AJS.I18n.getText('csum.cache.grouplimit.reached.desc'),
                    close: "auto"
                });
            }
        }, false);
    }

    // https://www.datatables.net/examples/api/select_single_row.html
    function loadAuthUsers(dlgGroup) {
        if (!dlgGroup.length > 0) {
            dlgGroup[1] = csumAdminDelegGroupDataTable.row(0).data()[1];
        }
        let endpointUrl = contextPath + "/rest/csum/latest/dlguser/list/auth?dlggroupid=" + encodeURIComponent(dlgGroup[0]) + "&atl_token=" + atlToken;
        AJS.$('#csumAuthUsersTable_wrapper').hide();
        AJS.$('.csum-dlg-long-load-message').hide();
        AJS.$("#csumSelectedDlgGroupNameHeading").text(dlgGroup[1]).show();

        let longLoadTimer = setTimeout(function () {
            AJS.$('.csum-dlg-long-load-message').fadeIn('fast');
        }, 30000);

        let spinTimer = setTimeout(function () {
            AJS.$('#csumDlgUsersSpinner').show();
        }, 250);

        csumAdminAuthUserDataTable.ajax.url(endpointUrl).load(function () {
            clearTimeout(spinTimer);
            clearTimeout(longLoadTimer);
            AJS.$('#csumDlgUsersSpinner').hide();
            AJS.$('.csum-dlg-long-load-message').hide();
            AJS.$('#csumAuthUsersTable_wrapper').show();
        }, false);
    }

    function loadAuthGroups(dlgGroup) {
        if (dlgGroup.length === 0) {
            dlgGroup[1] = csumAdminDelegGroupDataTable.row(0).data()[1];
        }
        let endpointUrl = contextPath + "/rest/csum/latest/dlggroup/list/auth?dlggroupid=" + encodeURIComponent(dlgGroup[0]) + "&atl_token=" + atlToken;

        let longLoadTimer = setTimeout(function () {
            AJS.$('.authGroupLongLoadMessage').fadeIn('fast');
        }, 30000);

        let spinTimer = setTimeout(function () {
            AJS.$('#csumAuthGroupSpinner').show();
        }, 250);

        csumAdminAuthGroupDataTable.ajax.url(endpointUrl).load(function () {
            clearTimeout(spinTimer);
            clearTimeout(longLoadTimer);
            AJS.$('#csumAuthGroupSpinner').hide();
            AJS.$('.csum-dlg-long-load-message').hide();
            AJS.$('#csumAuthGroupsTable_wrapper').show();
        }, false);
    }

    AJS.$('.selfManagedAlert').tooltip({
        title: function () {
            return AJS.I18n.getText('csum.dlg.group.self.managed.tooltip');
        }
    });

    //init buttons
    disableRemoveGroupButton();
    disableAuthorizeButton();
    disableDeAuthorizeButton();

    // init datatable
    csumAdminDelegGroupDataTable = AJS.$('#csumGroupTable').DataTable({
        select: 'single',
        lengthMenu: [[10, 50, 100, -1], [10, 50, 100, "All"]],
        columns: [
            {
                "data": [1],
                "render": function (data, type) {
                    if (type === 'display') {
                        data = AJS.escapeHtml(data);
                    }
                    return data
                }
            }
        ],
        language: {
            "emptyTable": AJS.I18n.getText('there.are.no.groups'),
            "info": AJS.I18n.getText('search.result.hidden.query', '_START_', '_END_', '_TOTAL_'),
            "infoEmpty": AJS.I18n.getText('search.result.hidden.query', '0', '0', '0'),
            "infoFiltered": AJS.I18n.getText('total.results.display', '_MAX_'),
            "lengthMenu": AJS.I18n.getText('show.word') + " _MENU_",
            "paginate": {"next": AJS.I18n.getText('aui.next.name'), "previous": AJS.I18n.getText('aui.prev.name')},
            "search": AJS.I18n.getText('search.name'),
            "select": {"rows": ""},
            "zeroRecords": AJS.I18n.getText('no.groups.found')
        }
    });
    csumAdminAuthGroupDataTable = AJS.$('#csumAuthGroupTable').DataTable({
        //serverSide: true,
        select: true,
        lengthMenu: [[10, 50, 100, -1], [10, 50, 100, "All"]],
        columns: [
            {
                "data": [0],
                "render": function (data, type) {
                    let renderedData = "";
                    let selfManagedLozenge = `&nbsp;<span class="aui-lozenge aui-lozenge-subtle aui-lozenge-moved selfManagedAlert">Self-Managed Group</span>`;
                    if (type === 'display') {
                        if (data === AJS.$("#csumSelectedDlgGroupNameHeading").text()) {
                            renderedData = renderedData + AJS.escapeHtml(data) + selfManagedLozenge;
                        } else {
                            renderedData = renderedData + AJS.escapeHtml(data);
                        }
                    } else {
                        renderedData = renderedData + data;
                    }
                    return renderedData;
                }
            }
        ],
        language: {
            "emptyTable": AJS.I18n.getText('there.are.no.groups'),
            "info": AJS.I18n.getText('search.result.hidden.query', '_START_', '_END_', '_TOTAL_'),
            "infoEmpty": AJS.I18n.getText('search.result.hidden.query', '0', '0', '0'),
            "infoFiltered": AJS.I18n.getText('total.results.display', '_MAX_'),
            "lengthMenu": AJS.I18n.getText('show.word') + " _MENU_",
            "paginate": {"next": AJS.I18n.getText('aui.next.name'), "previous": AJS.I18n.getText('aui.prev.name')},
            "search": AJS.I18n.getText('search.name'),
            "select": {"rows": {_: AJS.I18n.getText('text.selected') + ": %d", 0: ""}},
            "zeroRecords": AJS.I18n.getText('no.groups.found')
        }
    });

    let lastNameVisible = (AJS.$('#fullNameFormat').val() && AJS.$('#fullNameFormat').val() !== 'none');
    csumAdminAuthUserDataTable = AJS.$('#csumAuthUsersTable').DataTable({
        select: true,
        lengthMenu: [[10, 50, 100, -1], [10, 50, 100, "All"]],
        columns: [
            {
                "data": [0],
                "render": function (data, type, row) {
                    renderedData = "";
                    if (type === 'display') {
                        renderedData = '<a href="' + AJS.contextPath() + '/users/viewuserprofile.action?username=' + row[2] + '">' + data + '</a>';
                    } else renderedData = data;
                    return renderedData;
                }
            },
            {
                "data": [1],
                "visible": lastNameVisible,
                "render": function (data, type) {
                    renderedData = "";
                    if (type === 'display' && data !== null) {
                        renderedData = '<span>' + data + '</span>';
                    } else renderedData = data;
                    return renderedData;
                }
            },
            {
                "data": [2],
                "render": function (data, type, row) {
                    renderedData = "";
                    if (row[4] === "true") {
                        renderedData = '<span style="text-decoration-line: line-through">' + data + '</span>';
                    } else if (row[5] !== "false") {
                        renderedData = '<span style="text-decoration-line: line-through">' + data + '</span>';
                    } else {
                        renderedData = data;
                    }
                    return renderedData;
                }
            },
            {
                "data": [3],
                "render": function (data, type, row) {
                    renderedData = "";
                    if (type === 'display') {
                        renderedData = '<a href="mailto:' + data + '">' + data + '</a>';
                    }
                    if (row[4] === "true") {
                        renderedData = '<span style="text-decoration-line: line-through">' + renderedData + '</span>';
                    } else if (row[5] !== "false") {
                        renderedData = '<span style="text-decoration-line: line-through">' + data + '</span>';
                    } else renderedData = data;
                    return renderedData;
                }
            },
            {
                "data": [5],
                "width": "25%",
                "render": function (data, type, row) {
                    renderedData = "";
                    if (row[4] === "true") {
                        renderedData = '<span class="aui-lozenge aui-lozenge-subtle">deactivated</span>';
                    }
                    if (row[5] !== "false") {
                        renderedData = renderedData + '<span class="aui-lozenge aui-lozenge-moved aui-lozenge-subtle" title="Not a member of ' + row[5] + '">FILTERED</span>';
                    }
                    return renderedData;
                }
            }
        ],
        language: {
            "emptyTable": AJS.I18n.getText('no.users.found'),
            "info": AJS.I18n.getText('search.result.hidden.query', '_START_', '_END_', '_TOTAL_'),
            "infoEmpty": AJS.I18n.getText('search.result.hidden.query', '0', '0', '0'),
            "infoFiltered": AJS.I18n.getText('total.results.display', '_MAX_'),
            "lengthMenu": AJS.I18n.getText('show.word') + " _MENU_",
            "paginate": {"next": AJS.I18n.getText('aui.next.name'), "previous": AJS.I18n.getText('aui.prev.name')},
            "search": AJS.I18n.getText('search.name'),
            "select": {"rows": {_: AJS.I18n.getText('text.selected') + ": %d", 0: ""}},
            "zeroRecords": AJS.I18n.getText('error.invalid.search.nouser')
        }
    });

    hookDeAuthorize();
    loadGroups();
    hookAddGroup();
    hookRemoveGroup();
    hookAuthorize();
    hookGroupActionBtnEnabler();
    hookCacheRefresh();
    hookTabLoadOnFocus();
    hookCloseExceptionDialog();
    hookShowStackButton();
});