/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.task;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.pluginpeople.confluence.csum.ao.CSUMTaskEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.AuthorizationException;
import com.pluginpeople.confluence.csum.api.DuplicateException;
import com.pluginpeople.confluence.csum.api.SpaceGroupPatternMismatchException;
import com.pluginpeople.confluence.csum.task.AbstractTask;
import com.pluginpeople.confluence.csum.task.TaskType;
import com.pluginpeople.confluence.csum.util.SpaceGroupUtil;
import java.util.List;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveUsersTask
extends AbstractTask {
    private static final Logger LOG = LoggerFactory.getLogger(RemoveUsersTask.class);
    private final GroupManager fGroupManager;
    private final SpaceGroupUtil fSpaceGroupUtil;
    private final String fFilePath;
    private final ConfluenceUser fInitiator;
    private final Space fSpace;
    private final ICSUMActiveObjectService fAos;
    private final boolean fWillNotify;

    public RemoveUsersTask(String filePath, ConfluenceUser initiator, Space space, GroupManager groupManager, SpaceGroupUtil spaceGroupUtil, ICSUMActiveObjectService aos, boolean willNotify) {
        this.fInitiator = initiator;
        this.fSpace = space;
        this.fGroupManager = groupManager;
        this.fFilePath = filePath;
        this.fSpaceGroupUtil = spaceGroupUtil;
        this.fAos = aos;
        this.fWillNotify = willNotify;
    }

    @Override
    public String getName() {
        return "Removing memberships from CSV";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processRecord(CSVRecord csvRecord, int taskEntityId) {
        boolean isSuccessfulUser = false;
        CSUMTaskEntity taskEntity = this.fAos.getTaskEntity(taskEntityId);
        if (taskEntity != null) {
            String successfulUsersStr = taskEntity.getSuccessfulUsers();
            String unsuccessfulUsersStr = taskEntity.getUnsuccessfulUsers();
            String userNameVal = csvRecord.get(0).trim();
            String groupNameVal = csvRecord.get(1).trim();
            try {
                AuthenticatedUserThreadLocal.set((ConfluenceUser)this.fInitiator);
                SpaceGroupUtil.OperationResult<ConfluenceUser> userValidationResult = this.fSpaceGroupUtil.validateCSVUsers(this.fSpace, userNameVal, new String[0]);
                if (!userValidationResult.successes.isEmpty()) {
                    Group group = this.fGroupManager.getGroup(groupNameVal);
                    if (group != null && this.fSpaceGroupUtil.isNotABlocklistedGroup(group) && this.fSpaceGroupUtil.isNotGlobalPermissionGroup(group)) {
                        isSuccessfulUser = this.removeValidUserFromGroup(userNameVal, groupNameVal, userValidationResult);
                    }
                } else {
                    LOG.error("Empty userValidationResult.successes. name: " + userNameVal + " not associated with a valid User.");
                }
            }
            catch (Exception e) {
                LOG.error("Exception thrown in addValidUserToGroup, could not remove user: " + userNameVal, (Throwable)e);
            }
            finally {
                AbstractTask.saveTaskEntity(taskEntity, isSuccessfulUser, successfulUsersStr, unsuccessfulUsersStr, userNameVal);
            }
        }
        return isSuccessfulUser;
    }

    private boolean removeValidUserFromGroup(String userNameVal, String groupNameVal, SpaceGroupUtil.OperationResult<ConfluenceUser> userValidationResult) throws AuthorizationException, SpaceGroupPatternMismatchException, EntityException, DuplicateException {
        boolean ret = false;
        Group selectedGroup = this.fGroupManager.getGroup(groupNameVal);
        if (selectedGroup != null) {
            if (this.fSpaceGroupUtil.isNotABlocklistedGroup(selectedGroup)) {
                ConfluenceUser aUser = (ConfluenceUser)userValidationResult.successes.get(0);
                if (aUser != null) {
                    LOG.debug("Attempting to remove valid user: " + aUser.getName() + " from Group: " + selectedGroup.getName());
                    List<String> failedToRemoveList = this.fSpaceGroupUtil.removeGroupMembers(this.fSpace, groupNameVal, userNameVal, "", this.fInitiator);
                    if (!failedToRemoveList.contains(aUser.getName())) {
                        ret = true;
                    }
                }
            } else {
                LOG.error("group: " + groupNameVal + " is a blocklisted group by your system admin. Could not remove user: " + userNameVal);
            }
        } else {
            LOG.error("value: " + groupNameVal + " found no matching groups. Could not remove user: " + userNameVal);
        }
        return ret;
    }

    @Override
    public ConfluenceUser getInitiatingUser() {
        return this.fInitiator;
    }

    @Override
    public String getFilePath() {
        return this.fFilePath;
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.REMOVE_GROUP_MEMBERS;
    }

    @Override
    public Space getSpace() {
        return this.fSpace;
    }

    @Override
    public int getExpectedFieldCount() {
        return 2;
    }

    @Override
    public boolean willNotify() {
        return this.fWillNotify;
    }
}

