/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.integration;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.pluginpeople.confluence.csum.ao.CSUMAuditEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.ITAuditingManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class ITAuditingManagerImpl
implements ITAuditingManager {
    private ICSUMActiveObjectService fAos;
    private TransactionTemplate fTxTemplate;

    @Autowired
    public ITAuditingManagerImpl(ICSUMActiveObjectService aos, @ComponentImport TransactionTemplate txTemplate) {
        this.fAos = aos;
        this.fTxTemplate = txTemplate;
    }

    public int getNumberOfAuditEventsForSpace(Space space) {
        return (Integer)this.fTxTemplate.execute(() -> {
            CSUMAuditEntity[] auditEntities = this.fAos.getAuditEvents(space);
            if (auditEntities == null) {
                auditEntities = new CSUMAuditEntity[]{};
            }
            return auditEntities.length;
        });
    }

    public void createAuditEntityForSpace(Space space) {
        this.fTxTemplate.execute(() -> {
            this.fAos.createAuditEntityForSpace(space);
            return null;
        });
    }

    public void createOldAuditEntityForSpace(Space space) {
        this.fTxTemplate.execute(() -> {
            this.fAos.createOldAuditEntityForSpace(space);
            return null;
        });
    }

    public void deleteAllAuditEntities() {
        this.fTxTemplate.execute(() -> {
            this.fAos.deleteAllAuditEntities(0);
            return null;
        });
    }

    public void attemptDeleteOldSpaceAuditHistory(Space space) {
        this.fTxTemplate.execute(() -> {
            this.fAos.deleteAuditEntities(space, 30);
            return null;
        });
    }

    public String getLatestAuditStatusForSpace(Space space) {
        return (String)this.fTxTemplate.execute(() -> {
            CSUMAuditEntity[] auditEntities = this.fAos.getAuditEvents(space);
            if (auditEntities != null && auditEntities.length != 0) {
                CSUMAuditEntity latestAuditEntity = auditEntities[0];
                return latestAuditEntity.getEventOutcome();
            }
            return "invalid";
        });
    }
}

