/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.rest;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.access.annotations.RequiresLicensedConfluenceAccess;
import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.pluginpeople.confluence.csum.ao.CSUMTaskEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.InvalidSpaceException;
import com.pluginpeople.confluence.csum.rest.AbstractCSUMRestResource;
import com.pluginpeople.confluence.csum.rest.FileUploadProgressListener;
import com.pluginpeople.confluence.csum.rest.beans.DataTableTaskList;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.task.TaskManager;
import com.pluginpeople.confluence.csum.task.TaskType;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ReadOnlyAccessAllowed
@Path(value="bulktasks")
@RequiresLicensedConfluenceAccess
public class FileUploadResource
extends AbstractCSUMRestResource {
    private static final Logger LOG = LoggerFactory.getLogger(FileUploadResource.class);
    private final TaskManager fTaskManager;
    private final ICSUMActiveObjectService fAos;
    private static final String CSUM_PROGRESS = "csumUploadProgress";

    public FileUploadResource(XsrfTokenService tokenService, TaskManager taskManager, SpaceManager spaceManager, CSUMPermissionUtil permissionUtil, PermissionManager permissionManager, ICSUMActiveObjectService ao, ICSUMCacheManager cacheManager) {
        super(spaceManager, permissionUtil, tokenService, permissionManager, cacheManager);
        this.fTaskManager = taskManager;
        this.fAos = ao;
    }

    @GET
    @Path(value="info")
    @Produces(value={"application/json"})
    public Response getTaskInfo(@Context HttpServletRequest hsr, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="id") int taskId, @QueryParam(value="atl_token") String atlToken) {
        if (this.isUnauthorizedOrBadXsrfToken(hsr, spaceKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.doesSpaceKeyMatchSpace(spaceKey)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return Response.ok(this.fTaskManager.getTaskInfo(taskId)).build();
    }

    @GET
    @Path(value="downloadcsv")
    @Produces(value={"text/plain"})
    public Response getLastUploadedCsv(@Context HttpServletRequest hsr, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="id") int taskId, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        if (this.isUnauthorizedOrBadXsrfToken(hsr, spaceKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.doesSpaceKeyMatchSpace(spaceKey)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            Space validSpace = this.getValidSpaceFromKey(spaceKey);
            byte[] latestUploadedFileContent = this.fTaskManager.getLatestUploadedFile(validSpace, taskId);
            if (latestUploadedFileContent != null) {
                String latestFileData = new String(latestUploadedFileContent);
                response = Response.ok((Object)latestFileData).build();
            } else {
                LOG.error("No files found in shared home. Was this file deleted by mistake?");
                response = Response.noContent().build();
            }
        }
        catch (IOException e) {
            LOG.error("Access to tmp csv uploaded files not granted, could not read data from shared home", (Throwable)e);
            response = Response.serverError().entity((Object)e).build();
        }
        catch (InvalidSpaceException e) {
            LOG.error("Invalid Space, could not find Space using spacekey: " + spaceKey, (Throwable)e);
            response = Response.serverError().entity((Object)e).build();
        }
        catch (Exception e) {
            LOG.error("Unable to retrieve latest csv uploaded file from shared home", (Throwable)e);
            response = Response.serverError().entity((Object)e).build();
        }
        return response;
    }

    @GET
    @Path(value="tasks")
    @Produces(value={"application/json"})
    public Response getTasks(@Context HttpServletRequest hsr, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        if (this.isUnauthorizedOrBadXsrfToken(hsr, spaceKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.doesSpaceKeyMatchSpace(spaceKey)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            Space validSpace = this.getValidSpaceFromKey(spaceKey);
            CSUMTaskEntity[] records = this.fTaskManager.getTaskRecords(validSpace);
            DataTableTaskList list = new DataTableTaskList(records);
            response = Response.ok((Object)list).build();
        }
        catch (InvalidSpaceException e) {
            LOG.error("Invalid Space, could not find Space using spacekey: " + spaceKey, (Throwable)e);
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getLocalizedMessage()).build();
        }
        catch (Exception e) {
            LOG.error(e.getLocalizedMessage());
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getLocalizedMessage()).build();
        }
        return response;
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @Path(value="addusers")
    public Response addUsersViaImport(@Context HttpServletRequest hsr, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="type") String opType, @QueryParam(value="delimiter") String delimiterType, @QueryParam(value="willnotify") boolean willNotify, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        if (this.isUnauthorizedOrBadXsrfToken(hsr, spaceKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.doesSpaceKeyMatchSpace(spaceKey)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        CSUMTaskEntity taskEntity = null;
        try {
            Space aSpace = this.getValidSpaceFromKey(spaceKey);
            TaskType type = TaskType.ADD_GROUP_MEMBERS.getName().equals(opType) ? TaskType.ADD_GROUP_MEMBERS : TaskType.REMOVE_GROUP_MEMBERS;
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            taskEntity = this.fAos.createTaskEntity(type, aSpace.getKey(), currentUser.getName());
            Space validSpace = this.getValidSpaceFromKey(spaceKey);
            this.cleanupOldRecordsForSpace(validSpace);
            this.storeFileFromRequest(hsr, taskEntity, validSpace);
            response = this.processCsvImport(delimiterType, willNotify, taskEntity, aSpace, type);
        }
        catch (IOException e) {
            LOG.error("IOException creating file directory for uploaded CSV file - Does confluence shared home have correct read/write permissions?", (Throwable)e);
            if (taskEntity != null) {
                taskEntity.setStatus("failure");
                taskEntity.save();
            }
            response = Response.serverError().entity((Object)e.getLocalizedMessage()).build();
        }
        catch (FileUploadException e) {
            LOG.error("FileUploadException thrown creating Directory", (Throwable)e);
            if (taskEntity != null) {
                taskEntity.setStatus("failure");
                taskEntity.save();
            }
            response = Response.serverError().entity((Object)e.getLocalizedMessage()).build();
        }
        catch (InvalidSpaceException e) {
            LOG.error("InvalidSpaceException from spacekey: " + spaceKey + " Upload failed as Space not found.", (Throwable)e);
            if (taskEntity != null) {
                taskEntity.setStatus("failure");
                taskEntity.save();
            }
            response = Response.serverError().entity((Object)e.getLocalizedMessage()).build();
        }
        catch (Exception e) {
            LOG.error("Unknown Exception thrown attempting csv upload for group members", (Throwable)e);
            if (taskEntity != null) {
                taskEntity.setStatus("failure");
                taskEntity.save();
            }
            response = Response.serverError().entity((Object)e.getLocalizedMessage()).build();
        }
        return response;
    }

    private Response processCsvImport(String delimiterType, boolean willNotify, CSUMTaskEntity taskEntity, Space aSpace, TaskType type) {
        Response response;
        int asciiValue = Integer.parseInt(delimiterType);
        char delimiter = (char)asciiValue;
        Integer successfulTask = this.fTaskManager.processTask(type, aSpace, delimiter, willNotify, taskEntity);
        if (successfulTask > 0) {
            response = Response.status((Response.Status)Response.Status.ACCEPTED).build();
        } else {
            LOG.error("CSV Task did not process successfully, TaskEntity not created");
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return response;
    }

    @DELETE
    @Path(value="remove")
    @Produces(value={"application/json"})
    public Response removeTaskRecord(@Context HttpServletRequest hsr, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="id") int taskId, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        if (this.isUnauthorizedOrBadXsrfToken(hsr, spaceKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.doesSpaceKeyMatchSpace(spaceKey)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            this.fTaskManager.deleteTaskRecord(taskId);
            response = Response.ok().build();
        }
        catch (IOException e) {
            LOG.error(e.getLocalizedMessage());
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getLocalizedMessage()).build();
        }
        return response;
    }

    @DELETE
    @Path(value="cancel")
    @Produces(value={"application/json"})
    public Response cancelTask(@Context HttpServletRequest hsr, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="id") int taskId, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        if (this.isUnauthorizedOrBadXsrfToken(hsr, spaceKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.doesSpaceKeyMatchSpace(spaceKey)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            this.fTaskManager.cancelTask(taskId);
            response = Response.ok().build();
        }
        catch (Exception e) {
            LOG.error(e.getLocalizedMessage());
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getLocalizedMessage()).build();
        }
        return response;
    }

    private boolean doesSpaceKeyMatchSpace(@QueryParam(value="spaceKey") String spaceKey) {
        try {
            this.getValidSpaceFromKey(spaceKey);
        }
        catch (InvalidSpaceException e) {
            LOG.error("Invalid Space, could not find Space using spacekey: " + spaceKey, (Throwable)e);
            return true;
        }
        return false;
    }

    private void cleanupOldRecordsForSpace(Space validSpace) throws IOException {
        LocalDateTime threshold = LocalDateTime.now().minusDays(7L);
        this.fAos.deleteTasksSubmittedBefore(threshold);
        this.fTaskManager.deleteUploadedFilesForSpace(validSpace);
    }

    private void storeFileFromRequest(HttpServletRequest request, CSUMTaskEntity taskEntity, Space validSpace) throws FileUploadException {
        List fileItems;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            ServletFileUpload fileUpload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
            FileUploadProgressListener progressListener = new FileUploadProgressListener();
            fileUpload.setProgressListener((ProgressListener)progressListener);
            HttpSession session = request.getSession();
            if (session == null) {
                throw new FileUploadException("HTTP session was found to be null");
            }
            session.setAttribute(CSUM_PROGRESS, (Object)progressListener);
            fileItems = fileUpload.parseRequest(request);
            if (fileItems.isEmpty() || ((FileItem)fileItems.get(0)).isFormField()) {
                throw new FileUploadException("No file was found as a result of parsing request");
            }
        } else {
            throw new FileUploadException("Request does not contain multipart content");
        }
        this.saveFileToSharedHome(taskEntity, validSpace, fileItems);
    }

    private void saveFileToSharedHome(CSUMTaskEntity taskEntity, Space validSpace, List<FileItem> fileItems) throws FileUploadException {
        try {
            DiskFileItem fileItem = (DiskFileItem)fileItems.get(0);
            taskEntity.setFilename(fileItem.getName());
            File storedFile = this.fTaskManager.storeFileFromRequest(validSpace, taskEntity.getID());
            if (storedFile != null) {
                fileItem.write(storedFile);
                taskEntity.setFilePath(storedFile.getAbsolutePath());
            }
            taskEntity.save();
        }
        catch (IOException ioe) {
            throw new FileUploadException("IO problem building the disk file item", (Throwable)ioe);
        }
        catch (Exception e) {
            throw new FileUploadException("General problem building the disk file item", (Throwable)e);
        }
    }
}

