AJS.$(document).ready(function () {
    //Shared variables
    let spaceKey = getSpaceKey();
    let spaceName = getSpaceName();
    let atlToken = AJS.Meta.get("atl-token");
    let contextPath = AJS.contextPath();

    /*TAB 1 - SpaceGroups/Users*/
    let csumUserDataTable;
    let csumGroupDataTable;
    let selectedGroupName = null;
    let spaceGroupsTabRenderedData;
    let groupPerms = AJS.$("#groupPerms").val() === "true";
    let groupRenamePermitted = AJS.$("#groupRenamePermitted").val() === "true";
    let groupAddRemovePerms = AJS.$("#groupAddRemovePerms").val() === "true";
    let readOnly = AJS.$('#readOnly').val() === "true";
    let userOperationsHidden = AJS.$("#hideUserOperations").val() === "true";
    let groupOperationsHidden = AJS.$("#hideGroupOperations").val() === "true";
    let userServerSideProc = AJS.$("#userServerSideProc").val() === "true";
    let groupServerSideProc = AJS.$("#groupServerSideProc").val() === "true";
    let cachedDataTableRef=AJS.$.fn.DataTable;
    let spaceTasksPolling = false;
    let timeoutTime = 2000;

    let groupRenameScopeRadio = AJS.$("input[type=radio][name=globalRenameRadio]");
    let groupRenameScopeRadioGlobal = AJS.$("input[type=radio][id=transferRenameRadioGlobal]");
    let groupRenameScopePotentialImpactAui = AJS.$("#transferRenameRadioPotentialImpact");

    let cleanSpaceScopeRadio = AJS.$("input[type=radio][name=cleanSpacePermsRadio]");
    let cleanSpaceScopeRadioGlobal = AJS.$("input[type=radio][id=spacePermsCleanRadioGlobal]");
    let cleanSpaceScopePotentialImpactAui = AJS.$("#spacePermsCleanRadioPotentialImpact");

    let cleanPageScopeRadio = AJS.$("input[type=radio][name=cleanPagePermsRadio]");
    let cleanPageScopeRadioLocal = AJS.$("input[type=radio][id=pagePermsCleanRadioLocal]");
    let cleanPageScopeRadioGlobal = AJS.$("input[type=radio][id=pagePermsCleanRadioGlobal]");
    let cleanPageScopePotentialImpactAui= AJS.$("#pagePermsCleanRadioPotentialImpact");

    /*TAB 2 - DelegatedSpaceGroups/Users*/
    let csumDelegGroupDataTable;
    let csumDelegGroupUserDataTable;
    let selectedDelegGroupName = null;
    let dlgUserOperationsHidden = AJS.$("#hideDlgUserOperations").val() === "true";
    let dlgGroupOperationsHidden = AJS.$("#hideDlgGroupOperations").val() === "true";

    let dlgUserServerSideProc = AJS.$("#dlgUserServerSideProc").val() === "true";
    let dlgGroupServerSideProc = AJS.$("#dlgGroupServerSideProc").val() === "true";

    /*TAB 3 - File import/export*/
    let taskTable;
    let refresher;

    /*TAB 4 - Audit Log*/
    let auditingTable;
    let refreshTimer;

    /*TAB 5 - Clone*/
    let isImportBtnChecked = false;
    const userTableColumnIds = {
        fullName: 0,
        lastNames: 1,
        username: 2,
        email: 3,
        isDeactivated: 4,
        filterLozenge: 5
    }
    const taskTableColumnIds = {
        entityId: 0,
        type: 1,
        submitted: 2,
        status: 3,
        actions: 4,
        lastUpdated: 5
    }
    /*SHARED FUNCTIONS - All SpaceAdmin tabs*/
    console.log('CSUM starting...');

    function markMatch(text, term, markup) {
        let match = csumStripDiacritics(text.toUpperCase()).indexOf(csumStripDiacritics(term.toUpperCase())), tl = term.length;

        if (match < 0) {
            markup.push(AJS.escapeHtml(text));
            return;
        }

        markup.push(AJS.escapeHtml(text.substring(0, match)));
        markup.push("<span class='select2-match'>");
        markup.push(AJS.escapeHtml(text.substring(match, match + tl)));
        markup.push("</span>");
        markup.push(AJS.escapeHtml(text.substring(match + tl, text.length)));
    }

    //Retrieve SpaceKey (Shared across SpaceAdmin view)
    function getSpaceKey() {
        let ret;
        let ajsSpaceKey = AJS.$("meta[name='ajs-space-key']").attr('content');

        if (typeof ajsSpaceKey === "undefined") {
            console.log('unable to find ajs-space-key, falling back to confluence-space-key');
            let confluenceSpaceKey = AJS.$("meta[name='confluence-space-key']").attr('content');
            if (typeof confluenceSpaceKey === "undefined") {
                alert('CSUM unable to detect current space, please contact support with a HAR archive: https://confluence.atlassian.com/kb/generating-har-files-and-analyzing-web-requests-720420612.html');
            } else {
                console.log('CSUM found space key from meta:confluence-space-key: ' + confluenceSpaceKey);
                ret = confluenceSpaceKey;
            }
        } else {
            console.log('CSUM found space key from meta:ajs-space-key: ' + ajsSpaceKey);
            ret = ajsSpaceKey;
        }
        return ret;
    }

    function getSpaceName() {
        let ret;
        let ajsSpaceName = AJS.$("meta[name='ajs-space-name']").attr('content');

        if (typeof ajsSpaceName === "undefined") {
            console.log('unable to find ajs-space-name');
            alert('CSUM unable to detect current space, please contact support with a HAR archive: https://confluence.atlassian.com/kb/generating-har-files-and-analyzing-web-requests-720420612.html');
        } else {
            console.log('CSUM found space name from meta:ajs-space-name: ' + ajsSpaceName);
            ret = ajsSpaceName;
        }
        return ret;
    }

    function openExceptionDialog(JSONPayload, dialog, operationName) {
        AJS.dialog2(dialog).hide();

        let exceptionName = JSONPayload.exceptionName;
        let exceptionMessage = JSONPayload.exceptionMessage;
        let stackTrace = JSONPayload.stackTrace;
        let pluginVersion = JSONPayload.pluginVersion;

        AJS.$('#exceptionName').text(exceptionName);
        AJS.$('#exceptionMessage').text(exceptionMessage);
        AJS.$('#stackTrace').text(stackTrace);
        AJS.$('#csumVersion').text("CSUM " + pluginVersion);
        AJS.$('#exceptionHeader').text(AJS.I18n.getText("csum.error.exception.header", operationName));

        AJS.dialog2("#exceptionDialog").show();
    }

    function getResponseTextOrDefault(jqXHR, def) {
        let responseText;

        if (jqXHR) {
            responseText = jqXHR.responseText;
            if (responseText) {
                if (responseText === "bad-space-key"){
                    return '<p>' + AJS.I18n.getText("csum.spacetools.bad.space.key") + '</p>';
                } else {
                    return '<p>' + AJS.escapeHtml(responseText) + '</p>';
                }
            }
        }
        return '<p>' + def + '</p>';
    }

    //Flag for Errors/Warnings Ajax from Requests
    function createFlagBody(flagBody, failedUsers, totalUsers) {
        flagBody += '<ul style="max-height: 200px;overflow: auto">';
        let failedUsersSplit = failedUsers.split(",");
        failedUsersSplit.forEach(function (user) {
            flagBody += '<li>' + AJS.escapeHtml(user) + '</li>';
        });

        flagBody += '</ul>';
        if(totalUsers > 5){
            //Remove listed users from total
            totalUsers = totalUsers -5;
            flagBody += 'and ' + totalUsers + ' more.';
        }
        return flagBody;
    }

    //Unhandled Error Flag
    function unhandledError(i18nTitle){
        AJS.flag({
            type: "error",
            title: i18nTitle + ': error',
            body: AJS.I18n.getText('csum.error.generic.unknown')
        });
    }

    //AUI Error Flag
    function errorFlag(i18nTitle, i18nBody, jqXHR) {
        let jqStatus;

        if (jqXHR) {
            jqStatus = jqXHR.statusText;
        } else {
            jqStatus = 'error';
        }

        AJS.flag({
            type: "error",
            title: i18nTitle + ': ' +  jqStatus,
            body: getResponseTextOrDefault(jqXHR, i18nBody)
        });
    }

    /*TAB 1 - SpaceGroups/Users*/
    function resetDataTableRef() {
        let fromVer = AJS.$.fn.DataTable.version;

        AJS.$.fn.DataTable = cachedDataTableRef;

        let toVer = AJS.$.fn.DataTable.version;

        if (fromVer!==toVer) {
            console.log('reset DataTable from ['+fromVer+'] to ['+toVer+']');
        } else {
            console.log('no change in DataTable version');
        }
    }

    //this function only needs to be present in one of the javascript files per set of tabs
    $.fn.dataTable.ext.errMode = function () {
        AJS.flag({
            type: "error",
            title: AJS.I18n.getText('csum.error.datatable.timeout.title'),
            body: AJS.I18n.getText('csum.error.datatable.timeout') +
                '<ul class="aui-nav-actions-list">' +
                '<li><a class="aui-button aui-button-link" href="' + contextPath + '/csum/configure.action?key=' + spaceKey + '">Reload page</a></li>' +
                '</ul>'
        });
    };

    //Add row to SpaceGroups/Users table
    function addGroupRow(group) {
        csumGroupDataTable.row.add([group, "true"]).draw(false);
    }

    //Clear Users Table Rows
    function clearGroupMembers() {
        AJS.$('#csum-member-table-body').empty();
    }

    //Retrieve Members of specified groupName and populate SpaceGroups/Users user table
    // https://www.datatables.net/examples/api/select_single_row.html
    function loadGroupMembers(groupName) {
        let endpointUrl = contextPath + "/rest/csum/1.0/spacegroup/members?spaceKey=" + encodeURIComponent(spaceKey) + "&spaceGroup=" + encodeURIComponent(groupName) + "&atl_token=" + atlToken;

        AJS.$('#csum-member-table_wrapper').hide();
        AJS.$('.csum-longload-message').hide();
        AJS.$("#csumSelectedGroupNameHeading").text(groupName).show();

        let longLoadTimer = setTimeout(function () {
            AJS.$('.csum-longload-message').fadeIn('fast');
        }, 30000);

        let spinTimer = setTimeout(function () {
            AJS.$('#csum-user-spinner').show();
        }, 250);

        if(userServerSideProc){
            AJS.$('#csum-member-table').DataTable().ajax.reload(function() {
                clearTimeout(spinTimer);
                clearTimeout(longLoadTimer);
                AJS.$('#csum-user-spinner').hide();
                AJS.$('.csum-longload-message').hide();
                AJS.$('#csum-member-table_wrapper').show();
            });
        } else {
            csumUserDataTable.ajax.url(endpointUrl).load(function () {
                clearTimeout(spinTimer);
                clearTimeout(longLoadTimer);
                AJS.$('#csum-user-spinner').hide();
                AJS.$('.csum-longload-message').hide();
                AJS.$('#csum-member-table_wrapper').show();
            }, false);
        }
    }

    //Populate Groups in SpaceGroups/Users tab
    function loadGroups() {
        let endpointUrl = contextPath + "/rest/csum/1.0/spacegroup/groups?spaceKey=" + encodeURIComponent(spaceKey) + "&isGroupProc=" + encodeURIComponent(groupServerSideProc) + "&atl_token=" + atlToken;
        let spinTimer = setTimeout(function () {
            AJS.$('#csum-group-table_wrapper').hide();
            AJS.$('#csum-group-spinner').show();
        }, 250);
        if (groupServerSideProc) {
            AJS.$('#csum-group-table').DataTable().ajax.reload(function() {
                clearTimeout(spinTimer);
                AJS.$('#csum-group-spinner').hide();
                AJS.$('#csum-group-table_wrapper').show();
            });
        } else {
            csumGroupDataTable.ajax.url(endpointUrl).load(function (response) {
                clearTimeout(spinTimer);
                AJS.$('#csum-group-spinner').hide();
                AJS.$('#csum-group-table_wrapper').show();
                if (response.cacheLimitReached) {
                    AJS.flag({
                        type: "warning",
                        title: AJS.I18n.getText('csum.cache.grouplimit.reached'),
                        body: AJS.I18n.getText('csum.cache.grouplimit.reached.desc'),
                        close: "auto"
                    });
                }
            }, false);
        }
    }

    //Functions to Disable/Enable top-right user action buttons in SpaceGroups/Users tab
    function enableAddUserButton() {
        if (groupAddRemovePerms) {
            AJS.$('#addUserCSUMGroupMemberButton').removeAttr('disabled');
        } else {
            disableAddUserButton();
        }
    }
    function disableAddUserButton() {
        AJS.$('#addUserCSUMGroupMemberButton').attr('disabled', 'disabled');
    }
    function enableRemoveUserButton() {
        if (groupAddRemovePerms) {
            AJS.$('#removeUserFromCSUMGroupButton').removeAttr('disabled');
        } else {
            disableRemoveUserButton();
        }
    }
    function disableRemoveUserButton() {
        AJS.$('#removeUserFromCSUMGroupButton').attr('disabled', 'disabled');
    }
    function enableRemoveGroupButton() {
        AJS.$('#removeCSUMGroupButton').removeAttr('disabled');
    }
    function disableRemoveGroupButton() {
        AJS.$('#removeCSUMGroupButton').attr('disabled', 'disabled');
    }
    function enableRenameGroupButton() {
        if (groupRenamePermitted) {
            AJS.$('#renameCSUMGroupButton').removeAttr('disabled');
        } else {
            disableRenameGroupButton();
        }
    }
    function disableRenameGroupButton() {
        AJS.$('#renameCSUMGroupButton').attr('disabled', 'disabled');
    }

    //Enable spinner before calling AddUser ajax call
    function beforeSendAddUserSpinner() {
        AJS.$('#csum-adduser-spinner').show();
        AJS.$('#csum-adduser-popup-dialog :button').attr("disabled", true);
    }

    //Success ajax response, output appropriate flag to user (Successful/Invalid Users found/Users already group members
    function onAddUserSuccess(data, textStatus, jqXHR) {
        if (jqXHR && jqXHR.status !== 202) {
            if (csumGroupDataTable.row({selected: true}).data()) {
                let groupName = csumGroupDataTable.row('.selected').data()[0];
                loadGroupMembers(groupName);
            }
            //data is failed users, if empty, no warnings or errors
            let failedUsersInvalid = null;
            let invalidCount = 0;
            let failedUsersMembership = null;
            let membershipCount = 0;
            if(data) {
                for(let failedUser in data){
                    //Add Invalid/Already has membership info of failedUsers
                    if(data[failedUser] === "membership"){
                        if(membershipCount < 5){
                            if (failedUsersMembership !== null) {
                                failedUsersMembership = failedUsersMembership + ", " + failedUser;
                            } else {
                                failedUsersMembership = failedUser;
                            }
                        }
                        membershipCount++;
                    }
                    else if (data[failedUser] === "invalid"){
                        if(invalidCount < 5){
                            if (failedUsersInvalid !== null) {
                                failedUsersInvalid = failedUsersInvalid + "," + failedUser;
                            } else {
                                failedUsersInvalid = failedUser;
                            }
                        }
                        invalidCount++;
                    }
                }

                if(membershipCount > 0 || invalidCount > 0){
                    //warning flag for invalid users/users already part of group
                    if(membershipCount > 0){
                        let warningBody = AJS.I18n.getText('csum.display.alert.add.users.membership', membershipCount) + ':';
                        warningBody = createFlagBody(warningBody, failedUsersMembership, membershipCount);

                        AJS.flag({
                            type: "warning",
                            title: AJS.I18n.getText('csum.unsuccessful.operation.membership'),
                            body: warningBody,
                            close: 'auto'
                        });
                    }

                    if(invalidCount > 0){
                        let errorBody = AJS.I18n.getText('csum.display.alert.add.users.invalid', invalidCount) + ':';
                        errorBody = createFlagBody(errorBody, failedUsersInvalid, invalidCount);

                        AJS.flag({
                            type: "error",
                            title: AJS.I18n.getText('csum.unsuccessful.operation.invalid'),
                            body: errorBody,
                            close: 'auto'
                        });
                    }
                } else {
                    //Successful operation
                    AJS.flag({
                        type: "success",
                        title: AJS.I18n.getText('csum.successful.operation'),
                        close: 'auto'
                    });
                }
            }
        }
    }

    //UI Cleanup after AddUser request
    function onAddUserComplete() {
        AJS.dialog2("#csum-adduser-popup-dialog").hide();
        AJS.$('#csum-adduser-spinner').hide();
        AJS.$('#csum-adduser-popup-dialog :button').removeAttr("disabled");
        AJS.$("#csum-userpicker").val("");
        AJS.$("#csum-userpicker.csum-user-search").select2('data', []);
    }

    //SpaceGroup delete function
    function submitDeleteSpaceGroup(groupName) {
        let operationName = "Delete space group";
        let endpointUrl = contextPath + "/rest/csum/1.0/spacegroup/delete?spaceKey=" + encodeURIComponent(spaceKey) + "&spaceGroup=" + encodeURIComponent(groupName) + "&atl_token=" + atlToken;
        AJS.$.ajax({
            type: "delete",
            url: endpointUrl,
            contentType: "application/json; charset=utf-8",
            statusCode: {
                303: function(jqXHR) {
                    let json = jqXHR.responseJSON;
                    if (json != null) {
                        openExceptionDialog(json, "#csum-delete-dialog", operationName);
                    } else {
                        unhandledError(AJS.I18n.getText('title.remove.group'));
                    }
                },
                400: function(jqXHR) {
                    AJS.flag({
                        type: "error",
                        title: AJS.I18n.getText('title.remove.group') + ': ' + jqXHR.statusText,
                        body: AJS.I18n.getText('csum.display.alert.invalid.space.key', jqXHR.responseText)
                    });
                },
                401: function(jqXHR) {
                    let json = jqXHR.responseJSON;
                    if (json != null) {
                        openExceptionDialog(json, "#csum-delete-dialog", operationName);
                    } else {
                        AJS.flag({
                            type: "error",
                            title: AJS.I18n.getText('title.remove.group') + ': ' + jqXHR.statusText,
                            body: getResponseTextOrDefault(jqXHR, AJS.I18n.getText('csum.error.not.authorized'))
                        });
                    }
                },
                500: function(jqXHR) {
                    let json = jqXHR.responseJSON;

                    if (json != null) {
                        openExceptionDialog(json, "#csum-delete-dialog", operationName);
                    } else {
                        unhandledError(AJS.I18n.getText('title.remove.group'));
                    }
                },
                503: function (jqXHR) {
                    errorFlag(AJS.I18n.getText('csum.action.group.disabled'), AJS.I18n.getText('csum.action.group.disabled'), jqXHR);
                }
            },
            beforeSend: function () {
                AJS.$('#csum-delete-spinner').show();
                AJS.$('#csum-delete-dialog :button').attr("disabled", true);
            },
            success: function (data, textStatus, errorMessage) {
                if (textStatus === 'success') {
                    clearGroupMembers();
                    disableRemoveGroupButton();
                    disableRenameGroupButton();
                    disableAddUserButton();
                    if(userServerSideProc) {
                        selectedGroupName = null;
                        loadGroupMembers(null);
                    }
                    disableRemoveUserButton();
                    csumUserDataTable.clear().draw();
                    AJS.$("#csumSelectedGroupNameHeading").val('').text('');
                    csumGroupDataTable.row('.selected').remove().draw(false);
                    AJS.$("#csumSelectedGroupNameHeading").text('');
                } else if (textStatus === 'notmodified') {
                    console.error('group delete failed, status: ' + textStatus + ', errorMessage: ' + errorMessage);
                    let body;
                    if (groupName) {
                        body = '<p>' + AJS.I18n.getText('cannot.remove.group', groupName) + '</p>'
                    } else {
                        body = '<p>' + AJS.I18n.getText('csum.error.client.remove.group') + '</p>'
                    }
                    AJS.messages.error('#csum-group-config-messages', {
                        title: AJS.I18n.getText('action.error') + ': ' + AJS.I18n.getText('title.remove.group'),
                        body: body
                    });
                }
            },
            error: function () {
                AJS.flag({
                    type: "error",
                    title: AJS.I18n.getText('csum.auditing.operation.deletegroup.error'),
                    close: 'auto'
                });
            },
            complete: function () {
                AJS.dialog2("#csum-delete-dialog").hide();
                AJS.$('#csum-delete-spinner').hide();
                AJS.$('#csum-delete-dialog :button').removeAttr("disabled");
                AJS.flag({
                    type: "success",
                    title: AJS.I18n.getText('csum.auditing.operation.deletegroup.success'),
                    close: 'auto'
                });
            }
        });
    }

    //AddUser to specified group (adds User(s) or members of specified group(s) to `groups`)
    function submitAddUserToGroup(groups, users, importViaGroups) {
        let operationName = "Add users to group";
        if (users === "") {
            users = undefined;
        }

        let endpointUrl = contextPath + "/rest/csum/1.0/spacegroup/addusers?spaceKey=" + encodeURIComponent(spaceKey) + "&spaceGroups=" + encodeURIComponent(groups) + "&atl_token=" + atlToken;
        AJS.$.ajax({
            type: "put",
            url: endpointUrl,
            data: {spaceUsers: users, importViaGroups: importViaGroups},
            contentType: false,
            beforeSend: beforeSendAddUserSpinner,
            success: onAddUserSuccess,
            statusCode: {
                303: function(jqXHR) {
                    let json = jqXHR.responseJSON;

                    if (json != null) {
                        openExceptionDialog(json, "#csum-adduser-popup-dialog", operationName);
                    } else {
                        unhandledError(AJS.I18n.getText('add.members'));
                    }
                },
                400: function(jqXHR) {
                    AJS.flag({
                        type: "error",
                        title: AJS.I18n.getText('add.members') + ': ' + jqXHR.statusText,
                        body: AJS.I18n.getText('csum.display.alert.invalid.space.key', jqXHR.responseText)
                    });
                },
                401: function(jqXHR) {
                    let json = jqXHR.responseJSON;

                    if (json != null) {
                        openExceptionDialog(json, "#csum-adduser-popup-dialog", operationName);
                    } else {
                        errorFlag(AJS.I18n.getText('add.members'), AJS.I18n.getText('csum.error.not.authorized'), jqXHR);
                    }
                },
                500: function(jqXHR) {
                    let json = jqXHR.responseJSON;

                    if (json != null) {
                        openExceptionDialog(json, "#csum-adduser-popup-dialog", operationName);
                    } else {
                        unhandledError(AJS.I18n.getText('add.members'));
                    }
                }
            },
            complete: onAddUserComplete
        });
    }

    //Remove User from specified group (removes User(s) or members of specified group(s) from `groupNames`)
    function submitRemoveUserFromGroup(groupNames, userNames, viaMembership) {
        let endpointUrl = contextPath + "/rest/csum/1.0/spacegroup/member?spaceKey=" + encodeURIComponent(spaceKey) + "&spacegroups=" + encodeURIComponent(groupNames) + "&usernames=" + encodeURIComponent(userNames) + "&viamembership=" + encodeURIComponent(viaMembership) + "&atl_token=" + atlToken;
        AJS.$.ajax({
            type: "delete",
            url: endpointUrl,
            contentType: "application/json; charset=utf-8",
            beforeSend: function () {
                AJS.$('#csumRemoveUserSpinner').show();
            },
            success: function (data, textStatus) {
                if (textStatus === 'success') {
                    if (data && data.length > 0) {
                        let usersNotFound = null;
                        for(let i = 0; i < data.length; i++){
                            if (usersNotFound !== null) {
                                usersNotFound = usersNotFound + "," + data[i];
                            } else {
                                usersNotFound = data[i];
                            }
                        }
                        let errorBody = AJS.I18n.getText('csum.display.label.removeuser.error.info');
                        errorBody = createFlagBody(errorBody, usersNotFound, data.length);
                        AJS.flag({
                            type: 'error',
                            title: AJS.I18n.getText('action.error') + ': ' + AJS.I18n.getText('csum.display.label.removeuser.error'),
                            body: errorBody,
                        });
                    } else {
                        AJS.flag({
                            type: 'success',
                            title: AJS.I18n.getText('csum.successful.operation'),
                            close: 'auto'
                        });
                    }
                    //this block is to catch unknown circumstances (may not be needed at all)
                } else if (textStatus === 'notmodified' || textStatus === 'nocontent') {
                    alert("you've hit the no content");
                    AJS.flag({
                        type: 'error',
                        title: AJS.I18n.getText('action.error') + ': ' + AJS.I18n.getText('csum.action.user.remove'),
                        body: '<p>' + AJS.I18n.getText('csum.error.add.user.unknown') + '</p>'
                    });
                }

            },
            statusCode: {
                303: function (jqXHR) {
                    let json = jqXHR.responseJSON;
                    if (json != null) {
                        openExceptionDialog(json, "#csumRemoveUserPopupDialog", "Remove users from group");
                    } else {
                        unhandledError(AJS.I18n.getText('csum.action.user.remove'));
                    }
                },
                400: function (jqXHR) {
                    errorFlag(AJS.I18n.getText('csum.action.user.remove'), AJS.I18n.getText('csum.display.alert.invalid.space.key'), jqXHR);
                },
                401: function (jqXHR) {
                    errorFlag(AJS.I18n.getText('csum.action.user.remove'), AJS.I18n.getText('csum.error.not.authorized'), jqXHR);
                },
                412: function (jqXHR) {
                    AJS.flag({
                        type: "error",
                        title: AJS.I18n.getText('csum.action.user.remove') + ': ' + jqXHR.statusText,
                        body: AJS.I18n.getText('csum.display.alert.invalid.space.key', jqXHR.responseText)
                    });
                },
                500: function (jqXHR) {
                    let json = jqXHR.responseJSON;
                    if (json != null) {
                        openExceptionDialog(json, "#csumRemoveUserPopupDialog", "Remove users from group");
                    } else {
                        unhandledError(AJS.I18n.getText('csum.action.user.remove'))
                    }
                }
            },
            complete: function () {
                csumUserDataTable.ajax.reload(null, false);

                AJS.dialog2('#csumRemoveUserPopupDialog').hide();
                AJS.$('#csumRemoveUserSpinner').hide();
            }
        });
    }

    //Combines group prefix/suffix with user input for CreateGroup function
    function getFullSpaceGroupName(name) {
        let ret = AJS.$('#csumGroupNamePrefix').text() + name + AJS.$('#csumGroupNameSuffix').text();
        return ret.toLowerCase();
    }

    //Removes prefix/suffix for RenameGroup function
    function getStrippedSpaceGroupName(fullName) {
        let pre = AJS.$('#csumGroupNamePrefix').text();
        let suf = AJS.$('#csumGroupNameSuffix').text();
        return fullName.slice(pre.length, fullName.length - suf.length);
    }

    //Opens and closes the respective Modal popup for the Top-Right SpaceGroups/Users tab buttons (Create/Rename/Delete Group)
    function openDeleteGroupDialog(groupName) {
        AJS.$("#csum-delete-content").html(AJS.I18n.getText('group.delete.message', AJS.escapeHtml(groupName)));
        AJS.dialog2("#csum-delete-dialog").show();
        AJS.$("#csum-delete-spinner").hide();
    }
    function openRenameGroupDialog(groupName) {
        hideRegExpErrorMsgs();
        AJS.$('#csum-rename-old').val(groupName);
        AJS.$('#csum-rename-prefix').text(AJS.$('#csumGroupNamePrefix').text());
        AJS.$('#csum-rename-suffix').text(AJS.$('#csumGroupNameSuffix').text());
        AJS.$('#csum-rename-new').attr("placeholder", getStrippedSpaceGroupName(groupName));
        AJS.dialog2("#csum-rename-dialog").show();
        AJS.$("#csum-rename-spinner").hide();
        AJS.$('#csum-rename-new').focus();
    }
    function openCreateGroupDialog() {
        hideRegExpErrorMsgs();
        AJS.$("#csum-create-dialog :input").val("");
        AJS.dialog2("#csum-create-dialog").show();
        AJS.$("#csum-create-spinner").hide();
        //Focus on create group input
        AJS.$("#spaceGroup").focus();
    }
    function openAddUserDialog() {
        AJS.$('#csum-adduser-submit-button').attr('disabled', 'disabled');
        AJS.dialog2("#csum-adduser-popup-dialog").show();
        AJS.$('#csum-adduser-spinner').hide();

        let selectedGroup = '' + AJS.$("#csumSelectedGroupNameHeading").text();

        let groupSearchUrl = contextPath + '/rest/csum/1.0/spacegroup/search?spaceKey=' + encodeURIComponent(spaceKey) + "&atl_token=" + atlToken;
        AJS.$("#csum-grouppicker").auiSelect2({
            placeholder: AJS.I18n.getText('find.groups'),
            minimumInputLength: 1,
            multiple: true,
            ajax: {
                url: groupSearchUrl,
                dataType: 'json',
                quietMillis: 350,
                data: function (term) {
                    return {
                        query: term,
                        page_limit: 25,
                    };
                },
                results: function (data) {
                    return {
                        results: data.groups,
                        text: function (item) {
                            return AJS.escapeHtml(item);
                        },
                        id: function (item) {
                            return item;
                        }
                    };
                }
            },
            initSelection: function (element, callback) {
                let data = [];
                if (selectedGroup !== '') {
                    data.push({id: selectedGroup, text: AJS.escapeHtml(selectedGroup)});
                }
                callback(data);
            },
            formatResult: function (item) {
                if (item.id) {
                    return AJS.escapeHtml(item.id);
                } else {
                    return AJS.escapeHtml(item);
                }
            },
            formatSelection: function (item) {
                if (item.id) {
                    return AJS.escapeHtml(item.id);
                } else {
                    return AJS.escapeHtml(item);
                }
            },
            id: function (item) {
                if (item.id) {
                    return item.id;
                } else {
                    return item;
                }
            }
        }).select2('val', []);

        let importGroupSearchUrl = contextPath + '/rest/csum/latest/spacegroup/searchall';

        AJS.$("#importGroupPicker").auiSelect2({
            placeholder: AJS.I18n.getText('find.groups'),
            minimumInputLength: 3,
            multiple: true,
            ajax: {
                url: importGroupSearchUrl,
                dataType: 'json',
                quietMillis: 350,
                data: function (term) {
                    return {
                        prefix: term,
                        spacekey: spaceKey,
                        atl_token: atlToken
                    };
                },
                results: function (data) {
                    return {
                        results: data.groups,
                        text: function (item) {
                            return AJS.escapeHtml(item);
                        },
                        id: function (item) {
                            return item;
                        }
                    };
                }
            },
            formatResult: function (item) {
                if (item.id) {
                    return AJS.escapeHtml(item.id);
                } else {
                    return AJS.escapeHtml(item);
                }
            },
            formatSelection: function (item) {
                if (item.id) {
                    return AJS.escapeHtml(item.id);
                } else {
                    return AJS.escapeHtml(item);
                }
            },
            id: function (item) {
                if (item.id) {
                    return item.id;
                } else {
                    return item;
                }
            }
        });
    }

    function openRemoveUsersDialog(spaceGroups, userRows) {

        AJS.$('#csumRemoveUserSubmitButton').attr('disabled', 'disabled');

        if (userRows.length > 0) {
            AJS.$('#csumRemoveUserSubmitButton').removeAttr('disabled');
        } else {
            AJS.$('#csumRemoveUserUserPicker').select2('open');
        }

        let groupSearchUrl = contextPath + "/rest/csum/1.0/spacegroup/search?spaceKey=" + encodeURIComponent(spaceKey) + "&atl_token=" + atlToken;

        AJS.$("#csumRemoveUserGroupPicker").auiSelect2({
            placeholder: AJS.I18n.getText('find.groups'),
            minimumInputLength: 3,
            multiple: true,
            ajax: {
                url: groupSearchUrl,
                dataType: 'json',
                quietMillis: 350,
                data: function (term) {
                    return {
                        query: term,
                        page_limit: 25
                    };
                },
                results: function (data) {
                    return {
                        results: data.groups,
                        text: function (item) {
                            return AJS.escapeHtml(item);
                        },
                        id: function (item) {
                            return item;
                        }
                    };
                }
            },
            initSelection: function (element, callback) {
                let data = [];
                if (spaceGroups !== undefined) {
                    if (spaceGroups.length > 0) {
                        for (let i = 0; i < spaceGroups.length; i++) {
                            data.push({id: spaceGroups[i][0], text: AJS.escapeHtml(spaceGroups[i][0])});
                        }
                    }
                    callback(data);
                }
            },
            formatResult: function (item) {
                if (item.id) {
                    return AJS.escapeHtml(item.id);
                } else {
                    return AJS.escapeHtml(item);
                }
            },
            formatSelection: function (item) {
                if (item.id) {
                    return AJS.escapeHtml(item.id);
                } else {
                    return AJS.escapeHtml(item);
                }
            },
            id: function (item) {
                if (item.id) {
                    return item.id;
                } else {
                    return item;
                }
            }
        }).select2('val', []);

        let userSearchUrl = contextPath + '/rest/csum/1.0/spaceuser/search?spaceKey=' + encodeURIComponent(spaceKey) + "&atl_token=" + atlToken;

        if (AJS.$('#userSearch').val() === "true") {
            AJS.$("#csumRemoveUserUserPicker.csum-user-search").auiSelect2({
                placeholder: AJS.I18n.getText('find.users'),
                minimumInputLength: 3,
                multiple: true,
                ajax: {
                    url: userSearchUrl,
                    dataType: 'json',
                    quietMillis: 350,
                    data: function (term) {
                        return {
                            query: term,
                            page_limit: 25
                        };
                    },
                    results: function (data) {
                        return {results: data.users};
                    }
                },
                initSelection: function (element, callback) {
                    let data = [];
                    if (userRows !== undefined) {
                        if (userRows.length > 0) {
                            for (let i = 0; i < userRows.length; i++) {
                                //userRows[i] User Data - from DataTableUserList array - CSUM-299 name is required (not lastname)
                                // [0] getFullName() , [1] lastname(s), [2] getName(), [3] getEmail(), [4] isDeactivated(), [5] filterLozenges
                                data.push({username: userRows[i][userTableColumnIds.username], fullname: userRows[i][userTableColumnIds.fullName]});
                            }
                        }
                        callback(data);
                    }
                },
                formatResult: function (result, container, query) {
                    let markup = [];
                    let text = result.fullname + " (" + result.email + ", " + result.username + ")";
                    markMatch(text, query.term, markup, result.source);
                    return markup.join("");
                },
                formatSelection: function (item) {
                    return item.fullname;
                },
                id: function (item) {
                    return item.username;
                }
            }).select2('val', []);
        } else {
            let data = [];
            for (let i = 0; i < userRows.length; i ++) {
                data.push(userRows[i][userTableColumnIds.username])
            }
            AJS.$('#csumRemoveUserUserPicker').attr('value', data);
        }

        let removeViaMembership = contextPath + "/rest/csum/latest/spacegroup/searchall";

        AJS.$("#removeViaMembershipSpaceGroupPicker").auiSelect2({
            placeholder: AJS.I18n.getText('find.groups'),
            minimumInputLength: 3,
            multiple: true,
            ajax: {
                url: removeViaMembership,
                dataType: 'json',
                quietMillis: 350,
                data: function (term) {
                    return {
                        prefix: term,
                        spacekey: spaceKey,
                        atl_token: atlToken
                    };
                },
                results: function (data) {
                    return {
                        results: data.groups,
                        text: function (item) {
                            return AJS.escapeHtml(item);
                        },
                        id: function (item) {
                            return item;
                        }
                    };
                }
            },
            formatResult: function (item) {
                if (item.id) {
                    return AJS.escapeHtml(item.id);
                } else {
                    return AJS.escapeHtml(item);
                }
            },
            formatSelection: function (item) {
                if (item.id) {
                    return AJS.escapeHtml(item.id);
                } else {
                    return AJS.escapeHtml(item);
                }
            },
            id: function (item) {
                if (item.id) {
                    return item.id;
                } else {
                    return item;
                }
            }
        });

        AJS.dialog2('#csumRemoveUserPopupDialog').show();
        AJS.$('#csumRemoveUserSpinner').hide();
    }

    function hookCloseExceptionDialog() {
        AJS.$('#exceptionDialogClose').click(function (e) {
            e.preventDefault();
            AJS.$("#stackTrace").toggle(false);
            AJS.$("#showStack").text(AJS.I18n.getText("logged.event.see.more"));
            AJS.$("#exceptionDialog").attr("class", "aui-layer aui-dialog2 aui-dialog2-medium aui-dialog2-warning");
            AJS.dialog2("#exceptionDialog").hide();

            AJS.$('#exceptionName').text("");
            AJS.$('#exceptionMessage').text("");
            AJS.$('#stackTrace').text("");
            AJS.$('#csumVersion').text("");
            AJS.$('#exceptionHeader').text("");
        });
    }

    function hookShowStackButton() {
        AJS.$("#showStack").click(function (e) {
            e.preventDefault();

            AJS.$("#stackTrace").toggle();

            if (AJS.$("#showStack").text() === AJS.I18n.getText("logged.event.see.more")) {
                AJS.$("#showStack").text(AJS.I18n.getText("logged.event.see.less"))
                AJS.$("#exceptionDialog").attr("class", "aui-layer aui-dialog2 aui-dialog2-xlarge aui-dialog2-warning")
            } else {
                AJS.$("#showStack").text(AJS.I18n.getText("logged.event.see.more"))
                AJS.$("#exceptionDialog").attr("class", "aui-layer aui-dialog2 aui-dialog2-medium aui-dialog2-warning")
            }
        });
    }

    function hideRenameGroupPopup() {
        AJS.dialog2("#csum-rename-dialog").hide();
        AJS.$('#csum-group-rename-to-existing-group-warning').hide();
        AJS.$('#csum-rename-spinner').hide();
        AJS.$('#csum-rename-form :input').removeAttr("readonly");
        AJS.$('#csum-rename-dialog :button').removeAttr("disabled");
        AJS.$('#csum-rename-new').val('');
    }

    //GroupRename function
    function submitRenameGroup(oldName, newName) {
        let operationName = "Rename group";

        let renameScope;
        if (AJS.$('#transferRenameRadioLocal').is(":checked")) {
            renameScope = "local";
        } else {
            renameScope = "global";
        }

        let cleanSpacePermsScope;
        if (AJS.$('#spacePermsCleanRadioOff').is(":checked")) {
            cleanSpacePermsScope = "off";
        } else if (AJS.$('#spacePermsCleanRadioLocal').is(":checked")) {
            cleanSpacePermsScope = "local";
        } else {
            cleanSpacePermsScope = "global";
        }

        let cleanPagePermsScope;
        if (AJS.$('#pagePermsCleanRadioOff').is(":checked")) {
            cleanPagePermsScope = "off";
        } else if (AJS.$('#pagePermsCleanRadioLocal').is(":checked")) {
            cleanPagePermsScope = "local";
        } else {
            cleanPagePermsScope = "global";
        }

        let endpointUrl = contextPath + "/rest/csum/1.0/spacegroup/rename?spaceKey=" + encodeURIComponent(spaceKey) + "&from=" + encodeURIComponent(oldName) + "&to=" + encodeURIComponent(newName) + "&renameScope=" + renameScope
            + "&cleanSpacePermsScope=" + cleanSpacePermsScope + "&cleanPagePermsScope=" + cleanPagePermsScope + "&atl_token=" + atlToken;

        AJS.$.ajax({
            type: "post",
            url: endpointUrl,
            contentType: "application/json; charset=utf-8",
            beforeSend: function () {
                AJS.$('#csum-rename-spinner').show();
                AJS.$('#csum-rename-form :input').attr("readonly", true);
                AJS.$('#csum-rename-dialog :button').attr("disabled", true);
            },
            success: function (data, textStatus) {
                if(textStatus === "success"){
                    disableRemoveGroupButton();
                    disableRenameGroupButton();
                    AJS.$("#csumSelectedGroupNameHeading").val('').text('');
                    if (data) {
                        AJS.flag({
                            type: "success",
                            title: AJS.I18n.getText('csum.auditing.operation.renamegroup.started.successfully', oldName, newName),
                            close: 'auto'
                        });
                    } else {
                        AJS.flag({
                            type: "success",
                            title: AJS.I18n.getText('csum.auditing.operation.renamegroup.error'),
                            close: 'auto'
                        });
                    }
                    AJS.$("#csumSelectedGroupNameHeading").val('').text('');
                    if (!spaceTasksPolling) {
                        spaceTasksPolling = true;
                        checkForSpaceRenameGroupTasksCompletion();
                    }
                }else if (textStatus === 'notmodified') {
                    AJS.flag({
                        type: "error",
                        title: AJS.I18n.getText('csum.auditing.operation.renamegroup.error'),
                        body: "Original group to change or new group name are already in another group rename task to be completed!",
                    });
                } else {
                    AJS.flag({
                        type: "error",
                        title: AJS.I18n.getText('csum.auditing.operation.renamegroup.error'),
                        close: 'auto'
                    });
                }
            },
            statusCode: {
                303: function(jqXHR) {
                    let json = jqXHR.responseJSON;
                    if (json != null) {
                        openExceptionDialog(json, "#csum-rename-dialog", operationName);
                    } else {
                        unhandledError(AJS.I18n.getText('csum.action.group.rename'));
                    }
                },
                400: function(jqXHR) {
                    AJS.flag({
                        type: "error",
                        title: AJS.I18n.getText('csum.action.group.rename') + ': ' + jqXHR.statusText,
                        body: AJS.I18n.getText('csum.display.alert.invalid.space.key', jqXHR.responseText)
                    });
                },
                401: function(jqXHR) {
                    let json = jqXHR.responseJSON;
                    if (json != null) {
                        openExceptionDialog(json, "#csum-rename-dialog", operationName);
                    } else {
                        errorFlag(AJS.I18n.getText('csum.action.group.rename'), AJS.I18n.getText('csum.error.not.authorized'), jqXHR)
                    }
                },
                406: function(jqXHR) {
                    AJS.flag({
                        type: "error",
                        title: AJS.I18n.getText('csum.action.group.rename'),
                        body: AJS.I18n.getText('csum.configure.group.name.regexp', jqXHR.responseText)
                    });
                },
                500: function(jqXHR) {
                    let json = jqXHR.responseJSON;
                    if (json != null) {
                        openExceptionDialog(json, "#csum-rename-dialog", operationName);
                    }
                },
                502: function(jqXHR) {
                    let json = jqXHR.responseJSON;
                    if (json != null) {
                        openExceptionDialog(json, "#csum-rename-dialog", operationName);
                    }
                }
            },
            error: function (jqXHR, textStatus, error) {
                AJS.flag({
                    type: "error",
                    title: "An unknown error occurred. Error type: " + error ? error : "Unknown",
                    close: 'auto'
                });
            },
            complete: function () {
                hideRenameGroupPopup();
            }
        });
    }

    // Checks for any queued group rename tasks
    function checkForSpaceRenameGroupTasksCompletion() {
        let endpointUrl = contextPath + "/rest/csum/1.0/spacegroup/queuedTasks?spaceKey=" + encodeURIComponent(spaceKey) + "&atl_token=" + atlToken;

        AJS.$.ajax({
            type: "get",
            url: endpointUrl,
            contentType: "application/json; charset=utf-8",
            success: function (data) {
                console.log("checkForSpaceRenameGroupTasksCompletion data value: " + data);
                if (data) {
                    if (spaceTasksPolling) {
                        AJS.flag({
                            type: "success",
                            title: AJS.I18n.getText('csum.auditing.operation.renamegroup.completed.successfully'),
                            close: 'auto'
                        });
                        spaceTasksPolling = false;
                        console.log("Finished looking for any rename group tasks for current space within task queue as no more are present");
                    }
                    enableAddUserButton();
                    enableRemoveUserButton();
                    loadGroups();
                    csumUserDataTable.clear().draw();
                    AJS.$("#csumSelectedGroupNameHeading").val('').text('');
                    AJS.$('#csum-rename-task').html(false);
                    timeoutTime = 2000;
                } else {
                    let renamesIncomplete = AJS.messages.info("#custom-context", {
                        title: AJS.I18n.getText('csum.common.info'),
                        body: AJS.I18n.getText('csum.auditing.operation.renamegrouptasks.within.queue.or.running'),
                        closeable: false
                    });
                    spaceTasksPolling = true;
                    AJS.$('#csum-rename-task').html(renamesIncomplete);
                    setTimeout(() => {
                        if (timeoutTime < 14000) {
                            timeoutTime = timeoutTime + 2000;
                        } else if (timeoutTime !== 15000) {
                            timeoutTime = 15000;
                        }
                        console.log("Still rename group tasks for current space within task queue so delay for " + (timeoutTime/1000) + " seconds before checking again");
                        checkForSpaceRenameGroupTasksCompletion();
                    }, timeoutTime)
                }
            },
            error: function (jqXHR, textStatus, error) {
                AJS.flag({
                    type: "error",
                    title: "An unknown error occurred. Error type: " + error ? error : "Unknown",
                    close: 'auto'
                });
            }
        });
    }

    function isGroupBeingRenamed(groupName) {
        let endpointUrl = contextPath + "/rest/csum/1.0/spacegroup/groupTasksUnderway?spaceKey=" + encodeURIComponent(spaceKey) + "&groupName=" + groupName + "&atl_token=" + atlToken;

        AJS.$.ajax({
            type: "get",
            url: endpointUrl,
            contentType: "application/json; charset=utf-8",
            success: function (data) {
                if (data) {
                    AJS.flag({
                        type: "error",
                        title: AJS.I18n.getText("Error"),
                        body: AJS.I18n.getText('csum.auditing.operation.selected.group.involved.in.rename.task', groupName),
                        close: 'auto'
                    });
                    disableAddUserButton();
                    disableRemoveUserButton();
                    disableRemoveGroupButton();
                    disableRenameGroupButton();
                }
            },
            error: function (jqXHR, textStatus, error) {
                console.log("Error when checking if a group is involved in any queud or running rename tasks. Error: " + error)
            }
        });
    }

    //CreateGroup function Ajax request
    function submitCreateGroup() {
        let operationName = "Create group";
        let partialSpaceGroup = AJS.$("#spaceGroup").val();
        let endpointUrl = contextPath + "/rest/csum/1.0/spacegroup/create?spaceKey=" + encodeURIComponent(spaceKey) + "&spaceGroup=" + encodeURIComponent(partialSpaceGroup) + "&atl_token=" + atlToken;

        AJS.$.ajax({
            type: "put",
            url: endpointUrl,
            contentType: "application/json; charset=utf-8",
            beforeSend: function () {
                AJS.$('#csum-create-spinner').show();
                AJS.$('#csum-create-dialog :button').attr("disabled", true);
            },
            success: function (data, textStatus) {
                if (textStatus === 'success') {
                    AJS.flag({
                        type: "success",
                        title: AJS.I18n.getText('csum.auditing.operation.createGroup.success'),
                        close: 'auto'
                    });
                    addGroupRow(AJS.$("#fullSpaceGroupName").val());
                } else {
                    AJS.flag({
                        type: "error",
                        title: AJS.I18n.getText('csum.auditing.operation.createGroup.error'),
                        close: 'auto'
                    });
                }
            },
            statusCode: {
                304: function(jqXHR) {
                    errorFlag(AJS.I18n.getText('csum.action.group.create'), AJS.I18n.getText("group.exists"), jqXHR)
                },
                303: function(jqXHR) {
                    let json = jqXHR.responseJSON;
                    if (json != null) {
                        openExceptionDialog(json, "#csum-create-dialog", operationName);
                    } else {
                        unhandledError(AJS.I18n.getText('csum.action.group.create'));
                    }
                },
                400: function(jqXHR) {
                    AJS.flag({
                        type: "error",
                        title: AJS.I18n.getText('csum.action.group.create') + ': ' + jqXHR.statusText,
                        body: AJS.I18n.getText('csum.display.alert.invalid.space.key', jqXHR.responseText)
                    });
                },
                401: function(jqXHR) {
                    errorFlag(AJS.I18n.getText('csum.action.group.create'), AJS.I18n.getText('csum.error.not.authorized'), jqXHR);
                },
                406: function(jqXHR) {
                    AJS.flag({
                        type: "error",
                        title: AJS.I18n.getText('csum.action.group.rename'),
                        body: AJS.I18n.getText('csum.configure.group.name.regexp', jqXHR.responseText)
                    });
                },
                500: function(jqXHR) {
                    let json = jqXHR.responseJSON;
                    if (json != null) {
                        openExceptionDialog(json, "#csum-create-dialog", operationName);
                    } else {
                        unhandledError(AJS.I18n.getText('csum.action.group.create'));
                    }
                },
                503: function (jqXHR) {
                    errorFlag(AJS.I18n.getText('csum.action.group.create'), AJS.I18n.getText('csum.action.group.disabled'), jqXHR);
                }
            },
            complete: function () {
                AJS.dialog2("#csum-create-dialog").hide();
                AJS.$('#csum-create-spinner').hide();
                AJS.$('#csum-create-dialog :button').removeAttr("disabled");
            }
        });
    }

    // Classes for auis depending on the
    const movedClass = "aui-lozenge aui-lozenge-moved aui-lozenge-subtle";
    const successClass = "aui-lozenge aui-lozenge-success aui-lozenge-subtle";
    const errorClass = "aui-lozenge aui-lozenge-error aui-lozenge-subtle";

    // Click functions for rename radios to change potential performance impacts based on selection
    groupRenameScopeRadio.change(function(e) {
        console.log("Transfer permissions scope: " + groupRenameScopeRadio.val())
        if (groupRenameScopeRadioGlobal.is(":checked"))
        {
            replaceClass(groupRenameScopePotentialImpactAui, errorClass);
            groupRenameScopePotentialImpactAui.text(AJS.I18n.getText('csum.rename.potential.performance.impact.high'));
        } else {
            replaceClass(groupRenameScopePotentialImpactAui, successClass);
            groupRenameScopePotentialImpactAui.text(AJS.I18n.getText('csum.rename.potential.performance.impact.low'));
        }
        console.log("Transfer permissions potential performance impact: " + groupRenameScopePotentialImpactAui.textContent);
    });

    cleanSpaceScopeRadio.change(function(e) {
        console.log("Clean Space scope: : " + cleanSpaceScopeRadio.val())
        if (cleanSpaceScopeRadioGlobal.is(":checked")) {
            replaceClass(cleanSpaceScopePotentialImpactAui, movedClass);
            cleanSpaceScopePotentialImpactAui.text(AJS.I18n.getText('csum.rename.potential.performance.impact.medium'));
        } else {
            replaceClass(cleanSpaceScopePotentialImpactAui, successClass);
            cleanSpaceScopePotentialImpactAui.text(AJS.I18n.getText('csum.rename.potential.performance.impact.low'));
        }
        console.log("Clean Space scope potential performance impact: " + cleanSpaceScopePotentialImpactAui.textContent);
    });

    cleanPageScopeRadio.change(function(e) {
        console.log("Clean Page scope: " + cleanPageScopeRadio.val())
        if (cleanPageScopeRadioGlobal.is(":checked"))
        {
            replaceClass(cleanPageScopePotentialImpactAui, errorClass);
            cleanPageScopePotentialImpactAui.text(AJS.I18n.getText('csum.rename.potential.performance.impact.high'));
        } else if (cleanPageScopeRadioLocal.is(":checked")) {
            replaceClass(cleanPageScopePotentialImpactAui, movedClass);
            cleanPageScopePotentialImpactAui.text(AJS.I18n.getText('csum.rename.potential.performance.impact.medium'));
        } else {
            replaceClass(cleanPageScopePotentialImpactAui, successClass);
            cleanPageScopePotentialImpactAui.text(AJS.I18n.getText('csum.rename.potential.performance.impact.low'));
        }
        console.log("Clean Page scope potential performance impact: " + cleanPageScopePotentialImpactAui.textContent);
    });

    function replaceClass(element, desiredClass) {

        if (element.hasClass(successClass)) {
            element.removeClass(successClass);
            element.addClass(desiredClass);
        } else if (element.hasClass(movedClass)) {
            element.removeClass(movedClass);
            element.addClass(desiredClass);
        } else if (element.hasClass(errorClass)) {
            element.removeClass(errorClass);
            element.addClass(desiredClass);
        }
    }

    //GroupRename validate group does not already exist
    function validateNewGroupName(originalGroupName, newGroupName) {
        let endpointUrl = contextPath + "/rest/csum/1.0/spacegroup/group?spaceKey=" + encodeURIComponent(spaceKey) + "&groupName=" + encodeURIComponent(newGroupName) + "&atl_token=" + atlToken;
        AJS.$.ajax({
            type: "get",
            url: endpointUrl,
            contentType: "application/json; charset=utf-8",
            success: function (data, textStatus) {
                if (textStatus === "success") {
                    submitRenameGroup(originalGroupName, newGroupName);
                    hideRenameGroupPopup();
                }
                else {
                    AJS.$('#csum-group-rename-to-existing-group-warning').show();
                    AJS.$('#csum-rename-btn').hide();
                    AJS.$('#csum-rename-existing-group-btn').show();
                }
            },
            error: function (jqXHR, textStatus, error) {
                console.error('error: unknown error occured when validating group rename, status: ' + textStatus);
                AJS.flag({
                    type: "error",
                    title: "An unknown error occurred. Error type: " + error ? error : "Unknown",
                    close: 'auto'
                });
                AJS.$('#csum-rename-new').val('');
                hideRenameGroupPopup();
            }
        });
    }

    //handle space changes
    AJS.$('#spaceSwitcher').change(function () {
        let space = AJS.$('#spaceSwitcher').val();
        document.location = "configure.action?key=" + space;
    });

    //hookSpaceSwitcher for SpaceGroups tab "Go To Space" select
    function hookSpaceSwitcher() {
        let customSpaceFindUrl = AJS.contextPath() + "/rest/csum/1.0/space/search?atl_token=" + AJS.Meta.get("atl-token");
        AJS.$("#spaceSwitcher").auiSelect2({
            placeholder: AJS.I18n.getText('csum.space.switcher.placeholder', spaceName, spaceKey),
            minimumInputLength: 1,
            allowClear: true,
            width: 500,
            ajax: {
                type: "post",
                url: customSpaceFindUrl,
                dataType: 'json',
                quietMillis: 350,
                data: function (term) {
                    return {
                        spaceKey: spaceKey,
                        term: term,
                        pageLimit: 25
                    };
                },
                results: function (data) {
                    return {
                        results: data,
                        text: function (item) {
                            return AJS.escapeHtml(item.spaceName + " (" + item.key + ")");
                        },
                        id: function (item) {
                            return AJS.escapeHtml(item.spaceName + " (" + item.key + ")");
                        }
                    };
                }
            },
            formatResult: function (item) {
                return AJS.escapeHtml(item.spaceName + " (" + item.key + ")");
            },
            formatSelection: function (item) {
                return AJS.escapeHtml(item.spaceName + " (" + item.key + ")");
            },
            id: function (item) {
                return AJS.escapeHtml(item.key);
            }
        });
    }

    //hookAddUsersToGroup for SpaceGroups/Users AddUser function
    function hookAddUsersToGroup() {
        AJS.$('#addUserCSUMGroupMemberButton').click(function () {

            resetDataTableRef();

            AJS.$("#csum-grouppicker").val("");
            AJS.$("#csum-grouppicker").select2('data', []);
            AJS.$("#importGroupPicker").val("");
            AJS.$("#importGroupPicker").select2('data', []);

            openAddUserDialog();
        });
        AJS.$("#csum-adduser-cancel-button").click(function () {
            AJS.dialog2("#csum-adduser-popup-dialog").hide();
            AJS.$("#csum-userpicker").val("");
            AJS.$("#csum-userpicker.csum-user-search").select2('data', []);
        });
        AJS.$("#csum-adduser-submit-button").click(function () {
            let targetGroups = AJS.$('#csum-grouppicker').val();
            let importViaGroups = "";
            let targetUsers = "";
            if (!userOperationsHidden) {
                targetUsers = AJS.$('#csum-userpicker').val();
            }
            if (!groupOperationsHidden) {
                importViaGroups = AJS.$('#importGroupPicker').val();
            }

            console.log("Adding " + targetUsers.split().length + " users to " + targetGroups.split().length + " groups");
            console.log("Adding " + targetUsers + " to " + targetGroups);
            if (importViaGroups) {
                console.log("Adding users from " + importViaGroups);
            }

            submitAddUserToGroup(targetGroups, targetUsers, importViaGroups);
            return false;
        });
        // disable submit if either group or user picker is empty
        AJS.$('#csum-grouppicker, #csum-userpicker, #importGroupPicker').on('input change', function () {
            let targetGroups = AJS.$('#csum-grouppicker').val();
            let targetUsers = AJS.$('#csum-userpicker').val();
            let importViaGroups = AJS.$('#importGroupPicker').val();
            if ((targetGroups && targetGroups.trim().length > 0) &&
                ((targetUsers && targetUsers.trim().length > 0) || (importViaGroups && importViaGroups.trim().length > 0))) {
                AJS.$('#csum-adduser-submit-button').removeAttr('disabled');
            } else {
                AJS.$('#csum-adduser-submit-button').attr('disabled', 'disabled');
            }
        });

        AJS.$('#csum-csv-import').change(function () {
            AJS.$('#csum-import-btn').attr('disabled', 'disabled');
            AJS.$('#csum-csv-import + div.error').hide();
            if (this.files.length > 0) {
                let fileName = this.files[0].name;
                let fileType = fileName.split('.').pop();

                if ((fileType === "csv" || fileType === "CSV" || fileType === "Csv") && (groupAddRemovePerms))
                {
                    AJS.$('#csum-import-btn').removeAttr('disabled');
                } else {
                    AJS.$('#csum-csv-import + div.error').show();
                }
            }
        });

        // https://select2.org/configuration/options-api
        let userSearchUrl = contextPath + '/rest/csum/1.0/spaceuser/search?spaceKey=' + encodeURIComponent(spaceKey) + "&atl_token=" + atlToken;

        AJS.$("#csum-userpicker.csum-user-search").auiSelect2({
            placeholder: AJS.I18n.getText('find.users'),
            minimumInputLength: 2,
            multiple: true,
            ajax: {
                url: userSearchUrl,
                dataType: 'json',
                quietMillis: 350,
                data: function (term) {
                    return {
                        query: term,
                        page_limit: 25
                    };
                },
                results: function (data) {
                    return {results: data.users};
                }
            },
            formatResult: function (result, container, query) {
                let markup = [];
                let text = result.fullname + " (" + result.email + ", " + result.username + ")";
                markMatch(text, query.term, markup, result.source);
                return markup.join("");
            },
            formatSelection: function (item) {
                return item.fullname;
            },
            id: function (item) {
                return item.username;
            }
        });
        //dissallow return to submit,when empty
        AJS.$("#csum-grouppicker, #csum-userpicker, #importGroupPicker").bind("keypress", function (e) {
            if (e.keyCode === 13) {
                return false;
            }
        });
    }

    //hookRemoveUsersFromGroups for SpaceGroups/Users RemoveUser function
    function hookRemoveUsersFromGroups() {
        AJS.$('#removeUserFromCSUMGroupButton').click(function () {

            resetDataTableRef();

            AJS.$("#removeViaMembershipSpaceGroupPicker").val("");
            AJS.$("#removeViaMembershipSpaceGroupPicker").select2('data', []);
            AJS.$("#csumRemoveUserUserPicker").val("");
            AJS.$("#csumRemoveUserUserPicker").select2('data', []);
            AJS.$("#csumRemoveUserGroupPicker").val("");
            AJS.$("#csumRemoveUserGroupPicker").select2('data', []);

            let i;
            let spaceGroups = [];
            let selectedGroupRowCount = csumGroupDataTable.rows({selected: true}).count();
            let selectedUserRowCount = csumUserDataTable.rows({selected: true}).count();

            console.log('there are ' + selectedGroupRowCount + ' groups selected, and ' + selectedUserRowCount + ' users selected');

            if ( selectedGroupRowCount > 0 ) {
                console.log('adding ' + selectedGroupRowCount + ' groups');
                for ( i = 0; i < selectedGroupRowCount; i++) {
                    let selectedGroupData = csumGroupDataTable.rows({selected: true}).data()[i];
                    console.log("Adding group: " + selectedGroupData);
                    spaceGroups.push(selectedGroupData);
                }
            }
            let selectedUserRows = [];
            if ( selectedUserRowCount > 0 ) {
                console.log('adding ' + selectedUserRowCount + ' users');
                for ( i = 0; i < selectedUserRowCount; i++) {
                    let selectedUserData = csumUserDataTable.rows({selected: true}).data()[i];
                    console.log("adding user: " +selectedUserData[0]);
                    selectedUserRows.push(selectedUserData);
                }
            }

            openRemoveUsersDialog(spaceGroups, selectedUserRows);
            AJS.$('#csumRemoveUserSubmitButton').show();
            AJS.$('#csumRemoveUserCancelButton').show();
        });

        AJS.$('#csumRemoveUserSubmitButton').click(function (event) {
            event.preventDefault();
            let targetGroups = AJS.$('#csumRemoveUserGroupPicker').val();
            let targetUsers = "";
            let targetViaMembership = "";
            if (!userOperationsHidden) {
                targetUsers = AJS.$('#csumRemoveUserUserPicker').val();
            }
            if (!groupOperationsHidden) {
                targetViaMembership = AJS.$('#removeViaMembershipSpaceGroupPicker').val();
            }

            submitRemoveUserFromGroup(targetGroups, targetUsers, targetViaMembership);

            return false;
        });

        AJS.$('#csumRemoveUserCancelButton').click(function (event) {
            event.preventDefault();
            AJS.$("#csumRemoveUserGroupPicker").auiSelect2('data', []);
            AJS.$("#csumRemoveUserUserPicker").auiSelect2('data', []);
            AJS.dialog2('#csumRemoveUserPopupDialog').hide();
            AJS.$('#csumRemoveUserSubmitButton').hide();
            AJS.$('#csumRemoveUserCancelButton').hide();
        });

        AJS.$('#csumRemoveUserGroupPicker, #csumRemoveUserUserPicker, #removeViaMembershipSpaceGroupPicker').on('input change', function () {
            AJS.$('#csumRemoveUserSubmitButton').show();
            AJS.$('#csumRemoveUserCancelButton').show();
            let targetGroups = AJS.$('#csumRemoveUserGroupPicker').val();
            let targetUsers = AJS.$('#csumRemoveUserUserPicker').val();
            let targetViaMembership = AJS.$('#removeViaMembershipSpaceGroupPicker').val();

            if ((targetGroups && targetGroups.trim().length > 0) && ((targetUsers && targetUsers.trim().length > 0) ||
                (targetViaMembership && targetViaMembership.trim().length > 0))) {
                AJS.$('#csumRemoveUserSubmitButton').removeAttr('disabled');
            } else {
                AJS.$('#csumRemoveUserSubmitButton').attr('disabled', 'disabled');
            }
        });

        AJS.$("#csumRemoveUserGroupPicker, #csumRemoveUserUserPicker, #removeViaMembershipSpaceGroupPicker").bind("keypress", function (e) {
            if (e.keyCode === 13) {
                return false;
            }
        });

    }

    //User Action Button enable/disable hook
    function hookGroupActionBtnEnablement() {
        csumGroupDataTable.on("select deselect", function (e, dt, type) {
            if (type === "row") {
                if (csumGroupDataTable.rows({selected: true}).data().length > 0) {
                    if (!readOnly) {
                        if (groupPerms) {
                            enableRemoveGroupButton();
                            enableRenameGroupButton();
                            enableRemoveUserButton();
                            enableAddUserButton();
                        }
                    }
                    let groupName = csumGroupDataTable.row('.selected').data()[0];
                    selectedGroupName = groupName;
                    loadGroupMembers(groupName);
                    isGroupBeingRenamed(groupName);
                } else {
                    if (userServerSideProc) {
                        selectedGroupName = null;
                        loadGroupMembers(null);
                    }
                    disableRemoveGroupButton();
                    disableRenameGroupButton();
                    enableRemoveUserButton();
                    enableAddUserButton();
                    csumUserDataTable
                        .clear()
                        .draw();
                    AJS.$("#csumSelectedGroupNameHeading").val('').text('');
                }
            }
        });
    }

    //CreateGroup hook
    function hookGroupCreate() {
        resetDataTableRef();

        AJS.$('#createCSUMGroupButton').click(function () {
            openCreateGroupDialog();
        });
        AJS.$("#csum-group-create-cancel-button").click(function () {
            AJS.dialog2("#csum-create-dialog").hide();
        });
        AJS.$("#csumCreateGroupForm").submit(function (e) {
            e.preventDefault();
        });
        AJS.$("#csum-group-create-submit-button").click(function (e) {
            e.preventDefault();
            let newName = AJS.$("#spaceGroup").val();
            doesGroupNameMatchRegexp(newName, "create", submitCreateGroup);
        });
        AJS.$('#spaceGroup').on("input", function () {
            hideRegExpErrorMsgs();
            let grpName = AJS.$(this).val().toLowerCase();
            if (grpName.trim().length === 0) {
                AJS.$(this).val('');
                AJS.$('#csum-group-create-submit-button').attr('disabled', 'disabled');
                AJS.$('#fullSpaceGroupName').val('');
            } else {
                AJS.$(this).val(grpName);
                AJS.$('#csum-group-create-submit-button').removeAttr('disabled');
                let fullName = getFullSpaceGroupName(grpName);
                AJS.$('#fullSpaceGroupName').val(fullName);
            }
        });
    }

    //DeleteGroup Hook
    function hookGroupDelete() {
        resetDataTableRef();

        AJS.$('#removeCSUMGroupButton').click(function () {
            let groupName = csumGroupDataTable.row('.selected').data()[0];
            openDeleteGroupDialog(groupName);
        });
        AJS.$("#csum-delete-cancel-btn").click(function () {
            AJS.dialog2("#csum-delete-dialog").hide();
        });
        AJS.$("#csum-delete-confirm-btn").click(function () {
            let groupName = csumGroupDataTable.row('.selected').data()[0];
            submitDeleteSpaceGroup(groupName);
        });
    }

    //RenameGroup Hook
    function hookRenameGroup() {
       resetDataTableRef();

        AJS.$('#renameCSUMGroupButton').click(function () {
            let groupName = csumGroupDataTable.row('.selected').data()[0];
            openRenameGroupDialog(groupName);
            AJS.$('#csum-group-rename-to-existing-group-warning').hide();
            AJS.$('#csum-rename-existing-group-btn').hide();
            AJS.$('#csum-rename-btn').show();
            AJS.$("#csum-rename-btn").attr('disabled', true);
        });
        AJS.$("#csum-rename-btn").click(function () {
            let newName = AJS.$('#csum-rename-new').val();
            doesGroupNameMatchRegexp(newName, "rename", validateNewGroupName);
        });

        AJS.$("#csum-rename-existing-group-btn").click(function () {
            let groupName = csumGroupDataTable.row('.selected').data()[0];
            let newName = AJS.$('#csum-rename-new').val();
            submitRenameGroup(groupName, newName);
        });

        AJS.$("#csum-rename-cancel-btn").click(function () {
            hideRenameGroupPopup();
        });
        AJS.$('#csum-rename-new').on('input', function () {
            let groupName = csumGroupDataTable.row('.selected').data()[0];
            let originalGroupName = getStrippedSpaceGroupName(groupName);

            hideRegExpErrorMsgs();

            AJS.$('#csum-group-rename-to-existing-group-warning').hide();
            AJS.$('#csum-rename-existing-group-btn').hide();
            AJS.$('#csum-rename-btn').show();
            if (this.value.length > 0) {
                let grpName = AJS.$(this).val().toLowerCase();
                AJS.$(this).val(grpName);
                if (this.value === originalGroupName) {
                    AJS.$("#csum-rename-btn").attr('disabled', true);
                } else {
                    AJS.$("#csum-rename-btn").attr('disabled', false);
                }
            } else {
                AJS.$("#csum-rename-btn").attr('disabled', true);
            }
        })

        // If user presses enter key anywhere, go to next stage of group rename if in process and possible
        $(document).keypress(function(event) {
            if (event === 'Enter' || event.keyCode === 13) {
                let newName = AJS.$('#csum-rename-new').val();
                if (AJS.$('#csum-rename-dialog').is(':hidden') === false) {
                    if (AJS.$('#csum-rename-btn').is(':hidden') === false) {
                        if (AJS.$('#csum-rename-btn').prop('disabled') === false) {
                            doesGroupNameMatchRegexp(newName, "rename", validateNewGroupName);
                        }
                    } else {
                        doesGroupNameMatchRegexp(newName, "rename", submitRenameGroup);
                    }
                }
            }
        })
    }

    function hideRegExpErrorMsgs() {
        // Hide regexp error message on change of text input
        AJS.$("#createRegexErrorMsg").attr("hidden", true);
        AJS.$("#renameRegexErrorMsg").attr("hidden", true);
        // Enable buttons again
        AJS.$("#csum-group-create-submit-button").removeAttr("disabled");
        AJS.$("#csum-rename-btn").removeAttr("disabled");
        AJS.$("#csum-rename-existing-group-btn").removeAttr("disabled");
    }

    //Invalidates SpaceGroups/Users cache on Cache refresh
    function invalidateSpaceCache() {
        AJS.$.ajax({
            type: "delete",
            url: AJS.contextPath() + '/rest/csum/latest/spacegroup/cache?spaceKey=' + encodeURIComponent(spaceKey) + '&atl_token=' + atlToken,
            beforeSend: function () {
                AJS.$('#csum-forcerefresh').attr("disabled", true);
            },
            success: function () {
                loadGroups();
            },
            error: function (jqXHR) {
                AJS.flag({
                    type: "error",
                    title: jqXHR.statusText,
                    body: getResponseTextOrDefault(jqXHR, AJS.I18n.getText('action.error') + ': ' + jqXHR.status)
                });
            },
            complete: function () {
                AJS.$('#csum-forcerefresh').removeAttr("disabled");
            }
        });
    }

    //Cache refresh hook (Refresh button on SpaceGroups/Users tab)
    function hookCacheRefresh() {
        AJS.$('#csum-forcerefresh').click(function (e) {
            e.preventDefault();
            invalidateSpaceCache();
        });
    }

    // initialise Group DataTable
    if(groupServerSideProc){
        //DataTables serverSide Processing (https://datatables.net/reference/option/serverSide)
        console.log("rendering Groups using serverSide processing");
        csumGroupDataTable = AJS.$('#csum-group-table').DataTable({
            serverSide: true,
            select: 'single',
            lengthMenu: [[10, 50, 100, 500], [10, 50, 100, 500]],
            ordering: false,
            ajax: function (data, callback){
                let draw = data.draw;
                let start = data.start;
                let length = data.length;
                let searchVal = data.search.value;

                let endpointUrl = contextPath + "/rest/csum/1.0/spacegroup/groups?spaceKey=" + encodeURIComponent(spaceKey) + "&isGroupProc=" + encodeURIComponent(groupServerSideProc)
                    + "&draw=" + encodeURIComponent(draw) + "&start=" + encodeURIComponent(start) + "&length=" + encodeURIComponent(length)
                    + "&searchVal=" + encodeURIComponent(searchVal) + "&atl_token=" + atlToken;
                AJS.$.ajax({
                    type: "get",
                    url: endpointUrl,
                    data: data,
                    contentType: "application/json; charset=utf-8",
                    success: function (data){
                        callback(data);
                    },
                    error: function (){
                        callback({"data": []})
                    }
                });
            },
            columns: [
                {
                    "data": [0],
                    "width": "100%",
                    "render": function (data, type) {
                        return type === 'display' ? AJS.escapeHtml(data) : data;
                    }
                }
            ],
            language: {
                "emptyTable": AJS.I18n.getText('there.are.no.groups'),
                "info": AJS.I18n.getText('search.result.hidden.query', '_START_', '_END_', '_TOTAL_'),
                "infoEmpty": AJS.I18n.getText('search.result.hidden.query', '0', '0', '0'),
                "infoFiltered": AJS.I18n.getText('total.results.display', '_MAX_'),
                "lengthMenu": AJS.I18n.getText('show.word') + " _MENU_",
                "paginate": {"next": AJS.I18n.getText('aui.next.name'), "previous": AJS.I18n.getText('aui.prev.name')},
                "search": AJS.I18n.getText('search.name'),
                "select": {"rows": ""},
                "zeroRecords": AJS.I18n.getText('no.groups.found')
            }
        });
    } else {
        csumGroupDataTable = AJS.$('#csum-group-table').DataTable({
            select: 'single',
            lengthMenu: [[10, 50, 100, 500], [10, 50, 100, 500]],
            columns: [
                {
                    "data": [0],
                    "width": "100%",
                    "render": function (data, type) {
                        return type === 'display' ? AJS.escapeHtml(data) : data;
                    }
                }
            ],
            language: {
                "emptyTable": AJS.I18n.getText('there.are.no.groups'),
                "info": AJS.I18n.getText('search.result.hidden.query', '_START_', '_END_', '_TOTAL_'),
                "infoEmpty": AJS.I18n.getText('search.result.hidden.query', '0', '0', '0'),
                "infoFiltered": AJS.I18n.getText('total.results.display', '_MAX_'),
                "lengthMenu": AJS.I18n.getText('show.word') + " _MENU_",
                "paginate": {"next": AJS.I18n.getText('aui.next.name'), "previous": AJS.I18n.getText('aui.prev.name')},
                "search": AJS.I18n.getText('search.name'),
                "select": {"rows": ""},
                "zeroRecords": AJS.I18n.getText('no.groups.found')
            }
        });
    }

    //Initialise User DataTable
    if(userServerSideProc){
        //DataTables serverSide Processing (https://datatables.net/reference/option/serverSide)
        console.log("rendering Users using serverSide processing");
        let lastNameVisiblePaging = (AJS.$('#fullNameFormat').val() && AJS.$('#fullNameFormat').val() !== 'none');
        csumUserDataTable = AJS.$('#csum-member-table').DataTable({
            serverSide: true,
            select: true,
            lengthMenu: [[10, 50, 100, 500], [10, 50, 100, 500]],
            ordering: false,
            ajax: function (data, callback){
                //Retrieve datatable settings required for serverSide processing, pass through to resource
                let draw = data.draw;
                let start = data.start;
                let length = data.length;
                let searchVal = data.search.value;

                let endpointUrl = contextPath + "/rest/csum/1.0/spacegroup/members?spaceKey=" + encodeURIComponent(spaceKey)
                    + "&spaceGroup=" + encodeURIComponent(selectedGroupName) + "&highlightedGroup=" + encodeURIComponent(selectedGroupName)
                    + "&isUserProc=" + encodeURIComponent(userServerSideProc) + "&draw=" + encodeURIComponent(draw) + "&start=" + encodeURIComponent(start)
                    + "&length=" + encodeURIComponent(length) + "&searchVal=" + encodeURIComponent(searchVal) + "&atl_token=" + atlToken;

                AJS.$.ajax({
                    type: "get",
                    url: endpointUrl,
                    data: data,
                    contentType: "application/json; charset=utf-8",
                    success: function (data){
                        callback(data);
                    },
                    error: function (){
                        callback({"data": []})
                    }
                });
            },
            columns: [
                {
                    "data": [userTableColumnIds.fullName],
                    "render": function (data, type, row) {
                        spaceGroupsTabRenderedData = "";
                        if (type === 'display') {
                            spaceGroupsTabRenderedData = '<a href="' + AJS.contextPath() + '/users/viewuserprofile.action?username=' + row[userTableColumnIds.username] + '">' + data + '</a>';
                        } else spaceGroupsTabRenderedData = data;
                        return spaceGroupsTabRenderedData;
                    }
                },
                {
                    "data": [userTableColumnIds.lastNames],
                    "visible": lastNameVisiblePaging,
                    "render": function (data, type) {
                        spaceGroupsTabRenderedData = "";
                        if (type === 'display' && data !== null) {
                            spaceGroupsTabRenderedData = '<span>' + data + '</span>';
                        } else spaceGroupsTabRenderedData = data;
                        return spaceGroupsTabRenderedData;
                    }
                },
                {
                    "data": [userTableColumnIds.username],
                    "render": function (data, type, row) {
                        spaceGroupsTabRenderedData = "";
                        if (row[userTableColumnIds.isDeactivated] === "true") {
                            spaceGroupsTabRenderedData = '<span style="text-decoration-line: line-through">' + data + '</span>';
                        } else if (row[userTableColumnIds.filterLozenge] !== "false") {
                            spaceGroupsTabRenderedData = '<span style="text-decoration-line: line-through">' + data + '</span>';
                        } else {
                            spaceGroupsTabRenderedData = data;
                        }
                        return spaceGroupsTabRenderedData;
                    }
                },
                {
                    "data": [userTableColumnIds.email],
                    "render": function (data, type, row) {
                        spaceGroupsTabRenderedData = "";
                        if (type === 'display') {
                            spaceGroupsTabRenderedData = '<a href="mailto:' + data + '">' + data + '</a>';
                        }
                        if (row[userTableColumnIds.isDeactivated] === "true") {
                            spaceGroupsTabRenderedData = '<span style="text-decoration-line: line-through">' + spaceGroupsTabRenderedData + '</span>';
                        } else if (row[userTableColumnIds.email] === "null") {
                            spaceGroupsTabRenderedData = '<span class="aui-lozenge aui-lozenge-subtle">No email found</span>';
                        }  else if (row[userTableColumnIds.filterLozenge] !== "false") {
                            spaceGroupsTabRenderedData = '<span style="text-decoration-line: line-through">' + data + '</span>';
                        } else spaceGroupsTabRenderedData = data;
                        return spaceGroupsTabRenderedData;
                    }
                },
                {
                    "data": [userTableColumnIds.filterLozenge],
                    "width": "25%",
                    "render": function (data, type, row) {
                        spaceGroupsTabRenderedData = "";
                        if (row[userTableColumnIds.isDeactivated] === "true") {
                            spaceGroupsTabRenderedData = '<span class="aui-lozenge aui-lozenge-subtle">deactivated</span>';
                        }
                        if (row[userTableColumnIds.filterLozenge] !== "false") {
                            spaceGroupsTabRenderedData = spaceGroupsTabRenderedData + '<span class="aui-lozenge aui-lozenge-moved aui-lozenge-subtle" title="Not a member of ' + row[userTableColumnIds.filterLozenge] + '">FILTERED</span>';
                        }
                        return spaceGroupsTabRenderedData;
                    }
                }
            ],
            language: {
                "emptyTable": AJS.I18n.getText('no.users.found'),
                "info": AJS.I18n.getText('search.result.hidden.query', '_START_', '_END_', '_TOTAL_'),
                "infoEmpty": AJS.I18n.getText('search.result.hidden.query', '0', '0', '0'),
                "infoFiltered": AJS.I18n.getText('total.results.display', '_MAX_'),
                "lengthMenu": AJS.I18n.getText('show.word') + " _MENU_",
                "paginate": {"next": AJS.I18n.getText('aui.next.name'), "previous": AJS.I18n.getText('aui.prev.name')},
                "search": AJS.I18n.getText('search.name'),
                "select": {"rows": {_: AJS.I18n.getText('text.selected') + ": %d", 0: ""}},
                "zeroRecords": AJS.I18n.getText('error.invalid.search.nouser')
            }
        });
    }else{
        let lastNameVisible = (AJS.$('#fullNameFormat').val() && AJS.$('#fullNameFormat').val() !== 'none');
        csumUserDataTable = AJS.$('#csum-member-table').DataTable({
            select: true,
            lengthMenu: [[10, 50, 100, -1], [10, 50, 100, "All"]],
            columns: [
                {
                    "data": [userTableColumnIds.fullName],
                    "render": function (data, type, row) {
                        spaceGroupsTabRenderedData = "";
                        if (type === 'display') {
                            spaceGroupsTabRenderedData = '<a href="' + AJS.contextPath() + '/users/viewuserprofile.action?username=' + row[userTableColumnIds.username] + '">' + data + '</a>';
                        } else spaceGroupsTabRenderedData = data;
                        return spaceGroupsTabRenderedData;
                    }
                },
                {
                    "data": [userTableColumnIds.lastNames],
                    "visible": lastNameVisible,
                    "render": function (data, type) {
                        spaceGroupsTabRenderedData = "";
                        if (type === 'display' && data !== null) {
                            spaceGroupsTabRenderedData = '<span>' + data + '</span>';
                        } else spaceGroupsTabRenderedData = data;
                        return spaceGroupsTabRenderedData;
                    }
                },
                {
                    "data": [userTableColumnIds.username],
                    "render": function (data, type, row) {
                        spaceGroupsTabRenderedData = "";
                        if (row[userTableColumnIds.isDeactivated] === "true") {
                            spaceGroupsTabRenderedData = '<span style="text-decoration-line: line-through">' + data + '</span>';
                        } else if (row[userTableColumnIds.filterLozenge] !== "false") {
                            spaceGroupsTabRenderedData = '<span style="text-decoration-line: line-through">' + data + '</span>';
                        } else {
                            spaceGroupsTabRenderedData = data;
                        }
                        return spaceGroupsTabRenderedData;
                    }
                },
                {
                    "data": [userTableColumnIds.email],
                    "render": function (data, type, row) {
                        spaceGroupsTabRenderedData = "";
                        if (type === 'display') {
                            spaceGroupsTabRenderedData = '<a href="mailto:' + data + '">' + data + '</a>';
                        }
                        if (row[userTableColumnIds.isDeactivated] === "true") {
                            spaceGroupsTabRenderedData = '<span style="text-decoration-line: line-through">' + spaceGroupsTabRenderedData + '</span>';
                        } else if (row[userTableColumnIds.email] === "null") {
                            spaceGroupsTabRenderedData = '<span class="aui-lozenge aui-lozenge-subtle">No email found</span>';
                        }  else if (row[userTableColumnIds.filterLozenge] !== "false") {
                            spaceGroupsTabRenderedData = '<span style="text-decoration-line: line-through">' + data + '</span>';
                        } else spaceGroupsTabRenderedData = data;
                        return spaceGroupsTabRenderedData;
                    }
                },
                {
                    "data": [userTableColumnIds.filterLozenge],
                    "width": "25%",
                    "render": function (data, type, row) {
                        spaceGroupsTabRenderedData = "";
                        if (row[userTableColumnIds.isDeactivated] === "true") {
                            spaceGroupsTabRenderedData = '<span class="aui-lozenge aui-lozenge-subtle">deactivated</span>';
                        }
                        if (row[userTableColumnIds.filterLozenge] !== "false") {
                            spaceGroupsTabRenderedData = spaceGroupsTabRenderedData + '<span class="aui-lozenge aui-lozenge-moved aui-lozenge-subtle" title="Not a member of ' + row[userTableColumnIds.filterLozenge] + '">FILTERED</span>';
                        }
                        return spaceGroupsTabRenderedData;
                    }
                }
            ],
            language: {
                "emptyTable": AJS.I18n.getText('no.users.found'),
                "info": AJS.I18n.getText('search.result.hidden.query', '_START_', '_END_', '_TOTAL_'),
                "infoEmpty": AJS.I18n.getText('search.result.hidden.query', '0', '0', '0'),
                "infoFiltered": AJS.I18n.getText('total.results.display', '_MAX_'),
                "lengthMenu": AJS.I18n.getText('show.word') + " _MENU_",
                "paginate": {"next": AJS.I18n.getText('aui.next.name'), "previous": AJS.I18n.getText('aui.prev.name')},
                "search": AJS.I18n.getText('search.name'),
                "select": {"rows": {_: AJS.I18n.getText('text.selected') + ": %d", 0: ""}},
                "zeroRecords": AJS.I18n.getText('error.invalid.search.nouser')
            }
        });
    }

    /*TAB 2 - DelegatedSpaceGroups/Users*/
    function loadDelegatedGroups() {
        let restEndpoint = contextPath + "/rest/csum/latest/spacedlg/list?spacekey=" + encodeURIComponent(spaceKey) + "&isGroupProc=" + encodeURIComponent(dlgGroupServerSideProc) + "&atl_token=" + atlToken;
        let spinTimer = setTimeout(function () {
            AJS.$('#csumGroupTable_wrapper').hide();
            AJS.$('#csumGroupSpinner').show();
        }, 250);

        if (dlgGroupServerSideProc) {
            AJS.$('#csumSpaceDlgGroupTable').DataTable().ajax.reload(function() {
                clearTimeout(spinTimer);
                AJS.$('#csumGroupSpinner').hide();
                AJS.$('#csumGroupTable_wrapper').show();
            });
        } else {
            csumDelegGroupDataTable.ajax.url(restEndpoint).load(function (response) {
                clearTimeout(spinTimer);
                AJS.$('#csumGroupSpinner').hide();
                AJS.$('#csumGroupTable_wrapper').show();
                if (response.cacheLimitReached) {
                    AJS.flag({
                        type: "warning",
                        title: AJS.I18n.getText('csum.cache.grouplimit.reached'),
                        body: AJS.I18n.getText('csum.cache.grouplimit.reached.desc'),
                        close: "auto"
                    });
                }
            }, false);
        }
    }

    function loadDelegatedGroupMembers(group) {
        if (group != null) {
            let endpointUrl = contextPath + "/rest/csum/latest/spacedlg/members?spacekey=" + encodeURIComponent(spaceKey) + "&isUserProc=" + encodeURIComponent(dlgUserServerSideProc) + "&group=" + encodeURIComponent(group[1]) + "&atl_token=" + atlToken;

            AJS.$('#csumDlgSpaceAuthUsersTable_wrapper').hide();
            AJS.$('.csum-dlg-long-load-message').hide();
            AJS.$("#csumDlgSelectedGroupNameHeading").text(group[1]).show();

            let longLoadTimer = setTimeout(function () {
                AJS.$('.csum-dlg-long-load-message').fadeIn('fast');
            }, 30000);

            let spinTimer = setTimeout(function () {
                AJS.$('#csumSpaceAuthUsersSpinner').show();
            }, 250);

            if (dlgUserServerSideProc) {
                AJS.$('#csumSpaceDlgGroupMemberTable').DataTable().ajax.reload(function() {
                    clearTimeout(spinTimer);
                    clearTimeout(longLoadTimer);
                    AJS.$('#csumSpaceAuthUsersSpinner').hide();
                    AJS.$('.csum-dlg-long-load-message').hide();
                    AJS.$('#csumSpaceAuthUsersTable_wrapper').show();
                }, false);
            } else {
                csumDelegGroupUserDataTable.ajax.url(endpointUrl).load(function () {
                    clearTimeout(spinTimer);
                    clearTimeout(longLoadTimer);
                    AJS.$('#csumSpaceAuthUsersSpinner').hide();
                    AJS.$('.csum-dlg-long-load-message').hide();
                    AJS.$('#csumSpaceAuthUsersTable_wrapper').show();
                }, false);
            }
        }
    }

    function enableRemoveButton() {
        AJS.$('#removeUserFromCSUMDlgGroupButton').removeAttr('disabled');
    }

    function disableRemoveButton() {
        AJS.$('#removeUserFromCSUMDlgGroupButton').attr('disabled', 'disabled');
    }

    function hookGroupActionBtnEnabler() {
        csumDelegGroupDataTable.on("select deselect", function (e, dt, type) {
            if (type === "row") {
                if (csumDelegGroupDataTable.rows({selected: true}).data().length > 0) {

                    let group = csumDelegGroupDataTable.row('.selected').data();
                    selectedDelegGroupName = group;
                    AJS.$("#csumSelectedDlgGroupNameHeading").text(group[1]).show();
                    loadDelegatedGroupMembers(group);

                    if (!readOnly && !AJS.$("dlgGroupPerms").val()) {
                        enableRemoveButton();
                    }
                } else {
                    if (dlgUserServerSideProc) {
                        selectedDelegGroupName = null;
                        loadDelegatedGroupMembers(null);
                    }
                    csumDelegGroupUserDataTable
                        .clear()
                        .draw();
                    disableRemoveButton();
                    AJS.$("#csumDlgSelectedGroupNameHeading").val('').text('');
                }
            }
        });
    }

    function hookDlgAddUsersToGroup() {
        AJS.$('#addUserCSUMDlgGroupMemberButton').click(function () {

            AJS.$("#dlgImportGroupPicker").val("");
            AJS.$("#dlgImportGroupPicker").select2('data', []);
            AJS.$("#csumDlgUserPicker").val("");
            AJS.$("#csumDlgUserPicker").select2('data', []);
            AJS.$("#csumDlgGroupPicker").val("");
            AJS.$("#csumDlgGroupPicker").select2('data', []);

            let dlgGroups = [];
            let selectedGroupRowCount = csumDelegGroupDataTable.rows({selected: true}).count();

            console.log('there are ' + selectedGroupRowCount + ' groups selected');
            if ( selectedGroupRowCount > 0) {
                for (let i = 0; i < selectedGroupRowCount; i++) {
                    let selectedGroupRowData = csumDelegGroupDataTable.rows({selected: true}).data()[i];
                    console.log("selected group: " + selectedGroupRowData);
                    dlgGroups.push(selectedGroupRowData);
                }
            }
            enableUserSearchSelect2("#csumDlgUserPicker.csum-user-search", undefined);

            openDlgAddUserDialog(dlgGroups);
        });
        AJS.$("#csumDlgAddUserCancelButton").click(function () {
            AJS.dialog2("#csumDlgAddUserPopupDialog").hide();
            AJS.$("#csumDlgUserPicker").val("");
            AJS.$("#csumDlgUserPicker.csum-user-search").select2('data', []);
        });
        AJS.$("#csumDlgAddUserSubmitButton").click(function () {
            let targetGroups = AJS.$('#csumDlgGroupPicker').val();
            let importViaGroups = "";
            let targetUsers = "";
            if (!dlgUserOperationsHidden) {
                targetUsers = AJS.$('#csumDlgUserPicker').val();
            }
            if (!dlgGroupOperationsHidden) {
                importViaGroups = AJS.$('#dlgImportGroupPicker').val();
            }
            submitDlgAddUserToGroup(targetGroups, targetUsers, importViaGroups);
            return false;
        });
        // disable submit if either group or user picker is empty
        AJS.$('#csumDlgGroupPicker, #csumDlgUserPicker, #dlgImportGroupPicker').on('input change', function () {
            let targetGroups = AJS.$('#csumDlgGroupPicker').val();
            let targetUsers = AJS.$('#csumDlgUserPicker').val();
            let importViaGroups = AJS.$('#dlgImportGroupPicker').val();
            if ((targetGroups && targetGroups.trim().length > 0) && ((targetUsers && targetUsers.trim().length > 0) ||
                importViaGroups && importViaGroups.trim().length > 0)) {
                AJS.$('#csumDlgAddUserSubmitButton').removeAttr('disabled');
            } else {
                AJS.$('#csumDlgAddUserSubmitButton').attr('disabled', 'disabled');
            }
        });
    }

    function hookRemoveUsersFromGroup() {
        AJS.$('#removeUserFromCSUMDlgGroupButton').click(function () {

            let i;
            let dlgGroups = [];
            let selectedGroupCount = csumDelegGroupDataTable.rows({selected: true}).count();
            let selectedUserRowCount = csumDelegGroupUserDataTable.rows({selected: true}).count();

            console.log('there are ' + selectedGroupCount + ' groups selected, and ' + selectedUserRowCount + ' users selected');

            if ( selectedGroupCount > 0 ) {
                for ( i = 0; i < selectedGroupCount; i++) {
                    let selectedGroupData = csumDelegGroupDataTable.rows({selected: true}).data()[i];
                    console.log("Adding group: " + selectedGroupData);
                    dlgGroups.push(selectedGroupData);
                }
            }

            let userRows = [];
            if ( selectedUserRowCount > 0) {
                for ( i = 0; i < selectedUserRowCount; i++) {
                    let selectedUserData = csumDelegGroupUserDataTable.rows({selected: true}).data()[i]
                    console.log("Adding user: " + selectedUserData[userTableColumnIds.fullName]);
                    userRows.push(selectedUserData);
                }
            }

            openRemoveUserDialog(dlgGroups, userRows);
        });

        AJS.$('#csumDlgRemoveUserSubmitButton').click(function (event) {
            event.preventDefault();
            let targetGroups = AJS.$('#csumDlgRemoveUserGroupPicker').val();
            let targetUsers = "";
            let targetViaMembership = "";
            if (!dlgUserOperationsHidden) {
                targetUsers = AJS.$('#csumDlgRemoveUserUserPicker').val();
            }
            if (!dlgGroupOperationsHidden) {
                targetViaMembership = AJS.$('#removeViaMembershipGroupPicker').val();
            }

            submitDlgRemoveUserFromGroup(targetGroups, targetUsers, targetViaMembership);

            AJS.$("#csumDlgRemoveUserUserPicker").val("");
            AJS.$("#csumDlgRemoveUserUserPicker.csum-user-search").select2('data', []);
            AJS.$("#csumDlgRemoveUserGroupPicker").val("");
            AJS.$("#csumDlgRemoveUserGroupPicker.csum-group-search").select2('data', []);
            AJS.$("#removeViaMembershipGroupPicker").val("");
            AJS.$("#removeViaMembershipGroupPicker").select2('data', []);
            return false;
        });

        AJS.$('#csumDlgRemoveUserCancelButton').click(function (event) {
            event.preventDefault();
            AJS.$("#csumDlgRemoveUserGroupPicker").auiSelect2('data', []);
            AJS.$("#csumDlgRemoveUserUserPicker").auiSelect2('data', []);
            AJS.dialog2('#csumDlgRemoveUserPopupDialog').hide();
        });

        AJS.$('#csumDlgRemoveUserGroupPicker, #csumDlgRemoveUserUserPicker, #removeViaMembershipGroupPicker').on('input change', function () {
            let targetGroups = AJS.$('#csumDlgRemoveUserGroupPicker').val();
            let targetUsers = AJS.$('#csumDlgRemoveUserUserPicker').val();
            let targetViaMembership = AJS.$('#removeViaMembershipGroupPicker').val();

            if ((targetGroups && targetGroups.trim().length > 0) && ((targetUsers && targetUsers.trim().length > 0) ||
                (targetViaMembership && targetViaMembership.trim().length > 0))) {
                AJS.$('#csumDlgRemoveUserSubmitButton').removeAttr('disabled');
            } else {
                AJS.$('#csumDlgRemoveUserSubmitButton').attr('disabled', 'disabled');
            }
        });
    }

    function openDlgAddUserDialog(dlgGroups) {
        AJS.$('#csumDlgAddUserSubmitButton').attr('disabled', 'disabled');
        AJS.dialog2("#csumDlgAddUserPopupDialog").show();
        AJS.$("#csumDlgAddUserSpinner").hide();

        let groupSearchUrl = contextPath + "/rest/csum/latest/spacedlg/group/search?spaceKey=" + encodeURIComponent(spaceKey) + "&atl_token=" + atlToken;
        AJS.$("#csumDlgGroupPicker").auiSelect2({
            placeholder: AJS.I18n.getText('find.groups'),
            minimumInputLength: 3,
            multiple: true,
            ajax: {
                url: groupSearchUrl,
                dataType: 'json',
                quietMillis: 350,
                data: function (term) {
                    return {
                        query: term,
                        page_limit: 25
                    };
                },
                results: function (data) {
                    return {
                        results: data.groups,
                        text: function (item) {
                            return AJS.escapeHtml(item);
                        },
                        id: function (item) {
                            return item;
                        }
                    };
                }
            },
            initSelection: function (element, callback) {
                let data = [];
                if (dlgGroups !== undefined) {
                    if (dlgGroups.length > 0) {
                        for (let i = 0; i < dlgGroups.length; i++) {
                            data.push({id: dlgGroups[i][1], text: AJS.escapeHtml(dlgGroups[i][1])});
                        }
                    }
                    callback(data);
                }
            },
            formatResult: function (item) {
                if (item.id) {
                    return AJS.escapeHtml(item.id);
                } else {
                    return AJS.escapeHtml(item);
                }
            },
            formatSelection: function (item) {
                if (item.id) {
                    return AJS.escapeHtml(item.id);
                } else {
                    return AJS.escapeHtml(item);
                }
            },
            id: function (item) {
                if (item.id) {
                    return item.id;
                } else {
                    return item;
                }
            }
        }).select2('val', []);

        let importGroupSearchUrl = contextPath + '/rest/csum/latest/spacegroup/searchall';

        AJS.$("#dlgImportGroupPicker").auiSelect2({
            placeholder: AJS.I18n.getText('find.groups'),
            minimumInputLength: 3,
            multiple: true,
            ajax: {
                url: importGroupSearchUrl,
                dataType: 'json',
                quietMillis: 350,
                data: function (term) {
                    return {
                        prefix: term,
                        spacekey: spaceKey,
                        atl_token: atlToken
                    };
                },
                results: function (data) {
                    return {
                        results: data.groups,
                        text: function (item) {
                            return AJS.escapeHtml(item);
                        },
                        id: function (item) {
                            return item;
                        }
                    };
                }
            },
            formatResult: function (item) {
                if (item.id) {
                    return AJS.escapeHtml(item.id);
                } else {
                    return AJS.escapeHtml(item);
                }
            },
            formatSelection: function (item) {
                if (item.id) {
                    return AJS.escapeHtml(item.id);
                } else {
                    return AJS.escapeHtml(item);
                }
            },
            id: function (item) {
                if (item.id) {
                    return item.id;
                } else {
                    return item;
                }
            }
        });
    }

    function openRemoveUserDialog(dlgGroups, userRows) {

        AJS.$('#csumDlgRemoveUserSubmitButton').attr('disabled', 'disabled');

        if (userRows.length > 0) {
            AJS.$('#csumDlgRemoveUserSubmitButton').removeAttr('disabled');
        } else {
            AJS.$('#csumDlgRemoveUserUserPicker').select2('open');
        }

        let groupSearchUrl = contextPath + "/rest/csum/latest/spacedlg/group/search?spaceKey=" + encodeURIComponent(spaceKey) + "&atl_token=" + atlToken;
        AJS.$("#csumDlgRemoveUserGroupPicker").auiSelect2({
            placeholder: AJS.I18n.getText('find.groups'),
            minimumInputLength: 3,
            multiple: true,
            ajax: {
                url: groupSearchUrl,
                dataType: 'json',
                quietMillis: 350,
                data: function (term) {
                    return {
                        query: term,
                        page_limit: 25
                    };
                },
                results: function (data) {
                    return {
                        results: data.groups,
                        text: function (item) {
                            return AJS.escapeHtml(item);
                        },
                        id: function (item) {
                            return item;
                        }
                    };
                }
            },
            initSelection: function (element, callback) {
                let data = [];
                if (dlgGroups !== undefined) {
                    if (dlgGroups.length > 0) {
                        for (let i = 0; i < dlgGroups.length; i++) {
                            data.push({id: dlgGroups[i][1], text: AJS.escapeHtml(dlgGroups[i][1])});
                        }
                    }
                    callback(data);
                }
            },
            formatResult: function (item) {
                if (item.id) {
                    return AJS.escapeHtml(item.id);
                } else {
                    return AJS.escapeHtml(item);
                }
            },
            formatSelection: function (item) {
                if (item.id) {
                    return AJS.escapeHtml(item.id);
                } else {
                    return AJS.escapeHtml(item);
                }
            },
            id: function (item) {
                if (item.id) {
                    return item.id;
                } else {
                    return item;
                }
            }
        }).select2('val', []);

        enableUserSearchSelect2("#csumDlgRemoveUserUserPicker.csum-user-search", userRows);

        let removeViaMembership = contextPath + "/rest/csum/latest/spacegroup/searchall";

        AJS.$("#removeViaMembershipGroupPicker").auiSelect2({
            placeholder: AJS.I18n.getText('find.groups'),
            minimumInputLength: 3,
            multiple: true,
            ajax: {
                url: removeViaMembership,
                dataType: 'json',
                quietMillis: 350,
                data: function (term) {
                    return {
                        prefix: term,
                        spacekey: spaceKey,
                        atl_token: atlToken
                    };
                },
                results: function (data) {
                    return {
                        results: data.groups,
                        text: function (item) {
                            return AJS.escapeHtml(item);
                        },
                        id: function (item) {
                            return item;
                        }
                    };
                }
            },
            formatResult: function (item) {
                if (item.id) {
                    return AJS.escapeHtml(item.id);
                } else {
                    return AJS.escapeHtml(item);
                }
            },
            formatSelection: function (item) {
                if (item.id) {
                    return AJS.escapeHtml(item.id);
                } else {
                    return AJS.escapeHtml(item);
                }
            },
            id: function (item) {
                if (item.id) {
                    return item.id;
                } else {
                    return item;
                }
            }
        });

        AJS.dialog2('#csumDlgRemoveUserPopupDialog').show();
        AJS.$('#csumDlgRemoveUserSpinner').hide();
    }

    function enableUserSearchSelect2(select2Field, userRows) {
        // https://select2.org/configuration/options-api
        let userSearchUrl = contextPath + '/rest/csum/1.0/spaceuser/search?spaceKey=' + encodeURIComponent(spaceKey) + "&atl_token=" + atlToken;

        if (AJS.$('#userSearch').val() === "true") {
            AJS.$(select2Field).auiSelect2({
                placeholder: AJS.I18n.getText('find.users'),
                minimumInputLength: 3,
                multiple: true,
                ajax: {
                    url: userSearchUrl,
                    dataType: 'json',
                    quietMillis: 350,
                    data: function (term) {
                        return {
                            query: term,
                            page_limit: 25
                        };
                    },
                    results: function (data) {
                        return {results: data.users};
                    }
                },
                initSelection: function (element, callback) {
                    let data = [];
                    if (userRows !== undefined) {
                        if (userRows.length > 0) {
                            for (let i = 0; i < userRows.length; i++) {
                                //userRows[i] User Data - from DataTableUserList array - CSUM-299 name is required (not lastname)
                                // [0] getFullName() , [1] lastname(s), [2] getName(), [3] getEmail(), [4] isDeactivated(), [5] filterLozenges
                                data.push({username: userRows[i][userTableColumnIds.username], fullname: userRows[i][userTableColumnIds.fullName]});
                            }
                        }
                        callback(data);
                    }
                },
                formatResult: function (result, container, query) {
                    let markup = [];
                    let text = result.fullname + " (" + result.email + ", " + result.username + ")";
                    markMatch(text, query.term, markup, result.source);
                    return markup.join("");
                },
                formatSelection: function (item) {
                    return item.fullname;
                },
                id: function (item) {
                    return item.username;
                }
            }).select2('val', []);
        } else {
            if (userRows !== undefined) {
                let data = [];
                for (let i = 0; i < userRows.length; i++) {
                    data.push(userRows[i][userTableColumnIds.username])
                }
                AJS.$('#csumDlgRemoveUserUserPicker').attr('value', data);
            }
        }

        //dissallow return to submit,when empty
        AJS.$("#csumDlgGroupPicker, #csumDlgUserPicker").bind("keypress", function (e) {
            if (e.keyCode === 13) {
                return false;
            }
        });
    }

    function beforeAddUserSend() {
        AJS.$('#csumDlgAddUserSpinner').show();
        AJS.$('#csumDlgAddUserPopupDialog :button').attr("disabled", true);
    }

    function hookCloseDlgExceptionDialog() {
        AJS.$('#dlgExceptionDialogClose').click(function (e) {

            e.preventDefault();
            AJS.$("#dlgStackTrace").toggle(false);
            AJS.$("#dlgShowStack").text(AJS.I18n.getText("logged.event.see.more"));
            AJS.$("#dlgExceptionDialog").attr("class", "aui-layer aui-dialog2 aui-dialog2-medium aui-dialog2-warning")
            AJS.dialog2("#dlgExceptionDialog").hide();

            AJS.$('#dlgExceptionName').text("");
            AJS.$('#dlgExceptionMessage').text("");
            AJS.$('#dlgStackTrace').text("");
            AJS.$('#dlgCsumVersion').text("");
            AJS.$('#dlgExceptionHeader').text("");
        });
    }

    function hookShowDlgStackButton() {
        AJS.$("#dlgShowStack").click(function (e) {
            e.preventDefault();

            AJS.$("#dlgStackTrace").toggle();

            if (AJS.$("#dlgShowStack").text() === AJS.I18n.getText("logged.event.see.more")) {
                AJS.$("#dlgShowStack").text(AJS.I18n.getText("logged.event.see.less"));
                AJS.$("#dlgExceptionDialog").attr("class", "aui-layer aui-dialog2 aui-dialog2-xlarge aui-dialog2-warning");
            } else {
                AJS.$("#dlgShowStack").text(AJS.I18n.getText("logged.event.see.more"));
                AJS.$("#dlgExceptionDialog").attr("class", "aui-layer aui-dialog2 aui-dialog2-medium aui-dialog2-warning");
            }
        });
    }

    function submitDlgAddUserToGroup(groups, users, importViaGroups) {
        let flagType;
        let i18nTitle;
        let i18nBody;
        let closeType;
        let operationName = "Add user(s) to group"

        let endpointUrl = contextPath + "/rest/csum/latest/spacedlg/addusers?spacekey=" + encodeURIComponent(spaceKey) + "&dlggroups=" + encodeURIComponent(groups) + "&atl_token=" + atlToken;

        AJS.$.ajax({
            type: "put",
            url: endpointUrl,
            data: { spaceusers: users, importViaGroups: importViaGroups },
            contentType: false,
            beforeSend: beforeAddUserSend,
            success: function (data, textStatus) {
                if (textStatus === "success") {
                    let group = csumDelegGroupDataTable.row('.selected').data();

                    if (data) {
                        for (let i = 0; i < data.length; i++) {
                            let membershipUserFailures = null;
                            let membershipFailureCount = 0;
                            let invalidUserFailures = null;
                            let invalidFailureCount = 0;

                            let groupName = data[i].groupName;
                            let userFailures = data[i].failedUserNames;
                            let userFailureReasons = data[i].failedUserReasons;

                            for(let userLoopCount = 0; userLoopCount < userFailures.length && userLoopCount < userFailureReasons.length; userLoopCount++){
                                let failedUser = userFailures[userLoopCount];
                                let reason = userFailureReasons[userLoopCount];
                                if(reason === "membership"){
                                    if(membershipFailureCount < 5){
                                        if (membershipUserFailures !== null) {
                                            membershipUserFailures = membershipUserFailures + "," + failedUser;
                                        } else {
                                            membershipUserFailures = failedUser;
                                        }
                                    }
                                    membershipFailureCount++;
                                }
                                else if (reason === "invalid"){
                                    if(invalidFailureCount < 5){
                                        if (invalidUserFailures !== null) {
                                            invalidUserFailures = invalidUserFailures + "," + failedUser;
                                        } else {
                                            invalidUserFailures = failedUser;
                                        }
                                    }
                                    invalidFailureCount++;
                                }
                            }

                            //Display flags for each group operation
                            if (invalidFailureCount > 0 || membershipFailureCount > 0) {
                                if (membershipFailureCount > 0) {
                                    let warningBody = AJS.I18n.getText('csum.display.alert.add.users.membership', membershipFailureCount) + ':';
                                    warningBody = createFlagBody(warningBody, membershipUserFailures, membershipFailureCount);

                                    AJS.flag({
                                        type: "warning",
                                        title: AJS.I18n.getText('csum.error.dlg.partialfailure', membershipFailureCount, groupName),
                                        body: warningBody,
                                        close: 'auto'
                                    });
                                }
                                if (invalidFailureCount > 0) {
                                    let errorBody = AJS.I18n.getText('csum.display.alert.add.users.invalid', invalidFailureCount) + ':';
                                    errorBody = createFlagBody(errorBody, invalidUserFailures, invalidFailureCount);

                                    AJS.flag({
                                        type: "error",
                                        title: AJS.I18n.getText('csum.error.dlg.invalid', membershipFailureCount, groupName),
                                        close: 'auto'
                                    });
                                }

                            } else {
                                //Success, no errors or warning found
                                AJS.flag({
                                    type: "success",
                                    title: AJS.I18n.getText('csum.successful.operation'),
                                    close: 'auto'
                                });
                                if (group) {
                                    loadDelegatedGroupMembers(group);
                                }
                            }
                        }
                    }
                }
            },
            error: function(jqXHR, textStatus, errorMessage) {
                flagType = 'error';
                console.error('error: user-addition failed, status: ' + textStatus + ', errorMessage: ' + errorMessage);
            },
            statusCode: {
                204: function() {
                    flagType = 'error';
                    i18nTitle = AJS.I18n.getText('csum.error.title.missing.data');
                    i18nBody = AJS.I18n.getText('csum.error.missing.data') + '<a href="mailto:support@thepluginpeople.com?subject=CSUM:%20An%20unknown%20error%20is%20causing%20either%20groups%20or%20users%20to%20not%20be%20sent%20to%20the%20server">support@thepluginpeople.com</a>';
                },
                303: function(jqXHR) {
                    let json = jqXHR.responseJSON;

                    if (json != null) {
                        openExceptionDialog(json, "#csumDlgAddUserPopupDialog", operationName);
                    } else {
                        i18nTitle = AJS.I18n.getText('csum.error.not.authorized');
                        i18nBody = AJS.I18n.getText('csum.error.title.unknown');
                    }
                },
                400: function(jqXHR) {
                    AJS.flag({
                        type: "error",
                        title: AJS.I18n.getText('csum.error.bad.space.key') + ': ' + jqXHR.statusText,
                        body: AJS.I18n.getText('csum.display.alert.invalid.space.key', jqXHR.responseText)
                    });
                },
                401: function() {
                    i18nTitle = AJS.I18n.getText('csum.error.not.authorized');
                    i18nBody = AJS.I18n.getText('csum.error.not.authorized');
                },
                500: function(jqXHR) {
                    let json = jqXHR.responseJSON;

                    if (json != null) {
                        openExceptionDialog(json, "#csumDlgAddUserPopupDialog", operationName);
                    } else {
                        i18nTitle = AJS.I18n.getText('csum.error.title.user.group.not.found');
                        i18nBody = AJS.I18n.getText('csum.error.user.group.not.found');
                    }
                }
            },
            complete: function(jqXHR) {

                if (flagType && i18nTitle && i18nBody) {
                    AJS.flag({
                        type: flagType,
                        title: i18nTitle,
                        body: getResponseTextOrDefault(jqXHR, i18nBody),
                        close: closeType
                    });
                }

                AJS.dialog2("#csumDlgAddUserPopupDialog").hide();
                AJS.$('#csumDlgAddUserSpinner').hide();
                AJS.$('#csumDlgAddUserPopupDialog :button').removeAttr("disabled");
                AJS.$("#csumDlgUserPicker").val("");
                AJS.$("#csumDlgUserPicker.csum-user-search").select2('data', []);
            }
        });
    }

    function submitDlgRemoveUserFromGroup(groupNames, userNames, viaMembership) {
        let endpointUrl = contextPath + "/rest/csum/latest/spacedlg/removeusers?spacekey=" + spaceKey + "&dlggroups=" + encodeURIComponent(groupNames) + "&usernames=" + encodeURIComponent(userNames) + "&viamembership=" + encodeURIComponent(viaMembership) + "&atl_token=" + atlToken;
        AJS.$.ajax({
            type: "delete",
            url: endpointUrl,
            contentType: "application/json; charset=utf-8",
            beforeSend: function () {
                AJS.$('#csumDlgRemoveUserSpinner').show();
                AJS.$('#csumDlgRemoveUserPopupDialog :button').attr("disabled", true);
            },
            success: function (data, textStatus) {

                if (textStatus === 'success') {
                    if (data.length > 0) {
                        let usersNotFound = null;
                        for(let i = 0; i < data.length; i++){
                            if (usersNotFound !== null) {
                                usersNotFound = usersNotFound + "," + data[i];
                            } else {
                                usersNotFound = data[i];
                            }
                        }
                        let errorBody = AJS.I18n.getText('csum.display.label.removeuser.error.info');
                        errorBody = createFlagBody(errorBody, usersNotFound, data.length);
                        AJS.flag({
                            type: 'error',
                            title: AJS.I18n.getText('action.error') + ': ' + AJS.I18n.getText('csum.display.label.removeuser.error'),
                            body: errorBody,
                        });
                    } else {
                        AJS.flag({
                            type: 'success',
                            title: AJS.I18n.getText('csum.successful.operation'),
                            close: 'auto'
                        });
                    }
                } else if (textStatus === 'notmodified') {
                    console.error('Group Membership [' + groupNames + '] failed for user [' + userNames + '], status: ' + textStatus + ', errorMessage: ' + textStatus);
                    AJS.flag({
                        type: 'error',
                        title: AJS.I18n.getText('action.error') + ': ' + AJS.I18n.getText('csum.action.user.remove'),
                        body: '<p>' + AJS.I18n.getText('cannot.remove.group.membership.failed', userNames, groupNames) + '</p>'
                    });
                }
            },
            statusCode: {
                204: function() {
                    unhandledError(AJS.I18n.getText('csum.action.user.remove'));
                },
                303: function(jqXHR) {
                    let json = jqXHR.responseJSON;
                    if (json != null) {
                        openExceptionDialog(json, "#csumDlgRemoveUserPopupDialog", "Remove user(s) from group(s)");
                    } else {
                        unhandledError(AJS.I18n.getText('csum.action.group.create'));
                    }
                },
                400: function(jqXHR) {
                    if (jqXHR.responseText === "checkLogs") {
                        errorFlag(AJS.I18n.getText('csum.action.user.remove'), AJS.I18n.getText('cannot.remove.group.membership.failed', userNames, groupNames), jqXHR);
                    } else if (jqXHR.responseText) {
                        errorFlag(AJS.I18n.getText('csum.action.user.remove'), AJS.I18n.getText('csum.error.membership.generic'), jqXHR)
                    } else {
                        errorFlag(AJS.I18n.getText('csum.action.user.remove'), AJS.I18n.getText('csum.error.remove.all.users'), jqXHR)
                    }
                },
                401: function(jqXHR) {
                    errorFlag(AJS.I18n.getText('csum.action.user.remove'), AJS.I18n.getText('csum.error.not.authorized'), jqXHR)
                },
                403: function(jqXHR) {
                    errorFlag(AJS.I18n.getText('csum.action.user.remove'), AJS.I18n.getText('csum.error.remove.last.user'), jqXHR);
                },
                412: function(jqXHR) {
                    AJS.flag({
                        type: "error",
                        title: AJS.I18n.getText('csum.action.user.remove') + ': ' + jqXHR.statusText,
                        body: AJS.I18n.getText('csum.display.alert.invalid.space.key', jqXHR.responseText)
                    });
                },
            },
            complete: function () {
                let group = csumDelegGroupDataTable.row('.selected').data();

                loadDelegatedGroupMembers(group);

                AJS.dialog2('#csumDlgRemoveUserPopupDialog').hide();
                AJS.$('#csumDlgRemoveUserSpinner').hide();
                AJS.$('#csumDlgRemoveUserPopupDialog :button').removeAttr("disabled");
            }
        });
    }

    // init group datatable
    if (dlgGroupServerSideProc) {
        csumDelegGroupDataTable = AJS.$('#csumSpaceDlgGroupTable').DataTable({
            select: true,
            lengthMenu: [[10, 50, 100, 500], [10, 50, 100, 500]],
            ordering: false,
            serverSide: true,
            ajax: function (data, callback){
                let draw = data.draw;
                let start = data.start;
                let length = data.length;
                let searchVal = data.search.value;
                let endpointUrl = contextPath + "/rest/csum/latest/spacedlg/list?spacekey=" + encodeURIComponent(spaceKey) + "&isGroupProc=" + encodeURIComponent(dlgGroupServerSideProc)
                    + "&draw=" + encodeURIComponent(draw) + "&start=" + encodeURIComponent(start) + "&length=" + encodeURIComponent(length)
                    + "&searchVal=" + encodeURIComponent(searchVal) + "&atl_token=" + atlToken;

                AJS.$.ajax({
                    type: "get",
                    url: endpointUrl,
                    data: data,
                    contentType: "application/json; charset=utf-8",
                    success: function (data){
                        callback(data);
                    },
                    error: function (){
                        callback({"data": []})
                    }
                });
            },
            columns: [
                {
                    "data": [1],
                    "render": function (data, type) {
                        return type === 'display' ? AJS.escapeHtml(data) : data;
                    }
                }
            ],
            language: {
                "emptyTable": AJS.I18n.getText('there.are.no.groups'),
                "info": AJS.I18n.getText('search.result.hidden.query', '_START_', '_END_', '_TOTAL_'),
                "infoEmpty": AJS.I18n.getText('search.result.hidden.query', '0', '0', '0'),
                "infoFiltered": AJS.I18n.getText('total.results.display', '_MAX_'),
                "lengthMenu": AJS.I18n.getText('show.word') + " _MENU_",
                "paginate": {"next": AJS.I18n.getText('aui.next.name'), "previous": AJS.I18n.getText('aui.prev.name')},
                "search": AJS.I18n.getText('search.name'),
                "select": {"rows": ""},
                "zeroRecords": AJS.I18n.getText('no.groups.found')
            }
        });
    } else {
        csumDelegGroupDataTable = AJS.$('#csumSpaceDlgGroupTable').DataTable({
            select: true,
            lengthMenu: [[10, 50, 100, 500], [10, 50, 100, 500]],
            columns: [
                {
                    "data": [1],
                    "render": function (data, type) {
                        return type === 'display' ? AJS.escapeHtml(data) : data;
                    }
                }
            ],
            language: {
                "emptyTable": AJS.I18n.getText('there.are.no.groups'),
                "info": AJS.I18n.getText('search.result.hidden.query', '_START_', '_END_', '_TOTAL_'),
                "infoEmpty": AJS.I18n.getText('search.result.hidden.query', '0', '0', '0'),
                "infoFiltered": AJS.I18n.getText('total.results.display', '_MAX_'),
                "lengthMenu": AJS.I18n.getText('show.word') + " _MENU_",
                "paginate": {"next": AJS.I18n.getText('aui.next.name'), "previous": AJS.I18n.getText('aui.prev.name')},
                "search": AJS.I18n.getText('search.name'),
                "select": {"rows": ""},
                "zeroRecords": AJS.I18n.getText('no.groups.found')
            }
        });
    }

    //init user datatable
    let dlgSpaceGroupsTabRenderedData;
    let lastNameVisible = (AJS.$('#fullNameFormat').val() && AJS.$('#fullNameFormat').val() !== 'none');
    if (dlgUserServerSideProc) {
        csumDelegGroupUserDataTable = AJS.$('#csumSpaceDlgGroupMemberTable').DataTable({
            select: true,
            lengthMenu: [[10, 50, 100, 500], [10, 50, 100, 500]],
            ordering: false,
            serverSide: true,
            ajax: function (data, callback){
                //Retrieve datatable settings required for serverSide processing, pass through to resource
                let draw = data.draw;
                let start = data.start;
                let length = data.length;
                let searchVal = data.search.value;

                let endpointUrl = contextPath + "/rest/csum/latest/spacedlg/members?spacekey=" + encodeURIComponent(spaceKey)
                    + "&spaceGroup=" + encodeURIComponent(selectedDelegGroupName) + "&highlightedGroup=" + encodeURIComponent(selectedDelegGroupName)
                    + "&isUserProc=" + encodeURIComponent(dlgUserServerSideProc) + "&draw=" + encodeURIComponent(draw) + "&start=" + encodeURIComponent(start)
                    + "&length=" + encodeURIComponent(length) + "&searchVal=" + encodeURIComponent(searchVal) + "&atl_token=" + atlToken;

                AJS.$.ajax({
                    type: "get",
                    url: endpointUrl,
                    data: data,
                    contentType: "application/json; charset=utf-8",
                    success: function (data){
                        callback(data);
                    },
                    error: function (){
                        callback({"data": []})
                    }
                });
            },
            columns: [
                {
                    "data": [userTableColumnIds.fullName],
                    "render": function (data, type, row) {
                        dlgSpaceGroupsTabRenderedData = "";
                        if (type === 'display') {
                            dlgSpaceGroupsTabRenderedData = '<a href="' + AJS.contextPath() + '/users/viewuserprofile.action?username=' + row[userTableColumnIds.username] + '">' + data + '</a>';
                        } else dlgSpaceGroupsTabRenderedData = data;
                        return dlgSpaceGroupsTabRenderedData;
                    }
                },
                {
                    "data": [userTableColumnIds.lastNames],
                    "visible": lastNameVisible,
                    "render": function (data, type) {
                        dlgSpaceGroupsTabRenderedData = "";
                        if (type === 'display' && data !== null) {
                            dlgSpaceGroupsTabRenderedData = '<span>' + data + '</span>';
                        } else dlgSpaceGroupsTabRenderedData = data;
                        return dlgSpaceGroupsTabRenderedData;
                    }
                },
                {
                    "data": [userTableColumnIds.username],
                    "render": function (data, type, row) {
                        dlgSpaceGroupsTabRenderedData = "";
                        if (row[userTableColumnIds.isDeactivated] === "true") {
                            dlgSpaceGroupsTabRenderedData = '<span style="text-decoration-line: line-through">' + data + '</span>';
                        } else if (row[userTableColumnIds.filterLozenge] !== "false") {
                            dlgSpaceGroupsTabRenderedData = '<span style="text-decoration-line: line-through">' + data + '</span>';
                        } else {
                            dlgSpaceGroupsTabRenderedData = data;
                        }
                        return dlgSpaceGroupsTabRenderedData;
                    }
                },
                {
                    "data": [userTableColumnIds.email],
                    "render": function (data, type, row) {
                        dlgSpaceGroupsTabRenderedData = "";
                        if (type === 'display') {
                            dlgSpaceGroupsTabRenderedData = '<a href="mailto:' + data + '">' + data + '</a>';
                        }
                        if (row[userTableColumnIds.isDeactivated] === "true") {
                            dlgSpaceGroupsTabRenderedData = '<span style="text-decoration-line: line-through">' + dlgSpaceGroupsTabRenderedData + '</span>';
                        } else if (row[userTableColumnIds.email] === "null") {
                            dlgSpaceGroupsTabRenderedData = '<span class="aui-lozenge aui-lozenge-subtle">No email found</span>';
                        } else if (row[userTableColumnIds.filterLozenge] !== "false") {
                            dlgSpaceGroupsTabRenderedData = '<span style="text-decoration-line: line-through">' + data + '</span>';
                        } else dlgSpaceGroupsTabRenderedData = data;
                        return dlgSpaceGroupsTabRenderedData;
                    }
                },
                {
                    "data": [userTableColumnIds.filterLozenge],
                    "width": "25%",
                    "render": function (data, type, row) {
                        dlgSpaceGroupsTabRenderedData = "";
                        if (row[userTableColumnIds.isDeactivated] === "true") {
                            dlgSpaceGroupsTabRenderedData = '<span class="aui-lozenge aui-lozenge-subtle">deactivated</span>';
                        }
                        if (row[userTableColumnIds.filterLozenge] !== "false") {
                            dlgSpaceGroupsTabRenderedData = dlgSpaceGroupsTabRenderedData + '<span class="aui-lozenge aui-lozenge-moved aui-lozenge-subtle" title="Not a member of ' + row[userTableColumnIds.filterLozenge] + '">FILTERED</span>';
                        }
                        return dlgSpaceGroupsTabRenderedData;
                    }
                }
            ],
            language: {
                "emptyTable": AJS.I18n.getText('no.users.found'),
                "info": AJS.I18n.getText('search.result.hidden.query', '_START_', '_END_', '_TOTAL_'),
                "infoEmpty": AJS.I18n.getText('search.result.hidden.query', '0', '0', '0'),
                "infoFiltered": AJS.I18n.getText('total.results.display', '_MAX_'),
                "lengthMenu": AJS.I18n.getText('show.word') + " _MENU_",
                "paginate": {"next": AJS.I18n.getText('aui.next.name'), "previous": AJS.I18n.getText('aui.prev.name')},
                "search": AJS.I18n.getText('search.name'),
                "select": {"rows": {_: AJS.I18n.getText('text.selected') + ": %d", 0: ""}},
                "zeroRecords": AJS.I18n.getText('error.invalid.search.nouser')
            }
        });
    } else {
        csumDelegGroupUserDataTable = AJS.$('#csumSpaceDlgGroupMemberTable').DataTable({
            select: true,
            lengthMenu: [[10, 50, 100, 500], [10, 50, 100, 500]],
            columns: [
                {
                    "data": [userTableColumnIds.fullName],
                    "render": function (data, type, row) {
                        dlgSpaceGroupsTabRenderedData = "";
                        if (type === 'display') {
                            dlgSpaceGroupsTabRenderedData = '<a href="' + AJS.contextPath() + '/users/viewuserprofile.action?username=' + row[userTableColumnIds.username] + '">' + data + '</a>';
                        } else dlgSpaceGroupsTabRenderedData = data;
                        return dlgSpaceGroupsTabRenderedData;
                    }
                },
                {
                    "data": [userTableColumnIds.lastNames],
                    "visible": lastNameVisible,
                    "render": function (data, type) {
                        dlgSpaceGroupsTabRenderedData = "";
                        if (type === 'display' && data !== null) {
                            dlgSpaceGroupsTabRenderedData = '<span>' + data + '</span>';
                        } else dlgSpaceGroupsTabRenderedData = data;
                        return dlgSpaceGroupsTabRenderedData;
                    }
                },
                {
                    "data": [userTableColumnIds.username],
                    "render": function (data, type, row) {
                        dlgSpaceGroupsTabRenderedData = "";
                        if (row[userTableColumnIds.isDeactivated] === "true") {
                            dlgSpaceGroupsTabRenderedData = '<span style="text-decoration-line: line-through">' + data + '</span>';
                        } else if (row[userTableColumnIds.filterLozenge] !== "false") {
                            dlgSpaceGroupsTabRenderedData = '<span style="text-decoration-line: line-through">' + data + '</span>';
                        } else {
                            dlgSpaceGroupsTabRenderedData = data;
                        }
                        return dlgSpaceGroupsTabRenderedData;
                    }
                },
                {
                    "data": [userTableColumnIds.email],
                    "render": function (data, type, row) {
                        dlgSpaceGroupsTabRenderedData = "";
                        if (type === 'display') {
                            dlgSpaceGroupsTabRenderedData = '<a href="mailto:' + data + '">' + data + '</a>';
                        }
                        if (row[userTableColumnIds.isDeactivated] === "true") {
                            dlgSpaceGroupsTabRenderedData = '<span style="text-decoration-line: line-through">' + dlgSpaceGroupsTabRenderedData + '</span>';
                        } else if (row[userTableColumnIds.email] === "null") {
                            dlgSpaceGroupsTabRenderedData = '<span class="aui-lozenge aui-lozenge-subtle">No email found</span>';
                        } else if (row[userTableColumnIds.filterLozenge] !== "false") {
                            dlgSpaceGroupsTabRenderedData = '<span style="text-decoration-line: line-through">' + data + '</span>';
                        } else dlgSpaceGroupsTabRenderedData = data;
                        return dlgSpaceGroupsTabRenderedData;
                    }
                },
                {
                    "data": [userTableColumnIds.filterLozenge],
                    "width": "25%",
                    "render": function (data, type, row) {
                        dlgSpaceGroupsTabRenderedData = "";
                        if (row[userTableColumnIds.isDeactivated] === "true") {
                            dlgSpaceGroupsTabRenderedData = '<span class="aui-lozenge aui-lozenge-subtle">deactivated</span>';
                        }
                        if (row[userTableColumnIds.filterLozenge] !== "false") {
                            dlgSpaceGroupsTabRenderedData = dlgSpaceGroupsTabRenderedData + '<span class="aui-lozenge aui-lozenge-moved aui-lozenge-subtle" title="Not a member of ' + row[userTableColumnIds.filterLozenge] + '">FILTERED</span>';
                        }
                        return dlgSpaceGroupsTabRenderedData;
                    }
                }
            ],
            language: {
                "emptyTable": AJS.I18n.getText('no.users.found'),
                "info": AJS.I18n.getText('search.result.hidden.query', '_START_', '_END_', '_TOTAL_'),
                "infoEmpty": AJS.I18n.getText('search.result.hidden.query', '0', '0', '0'),
                "infoFiltered": AJS.I18n.getText('total.results.display', '_MAX_'),
                "lengthMenu": AJS.I18n.getText('show.word') + " _MENU_",
                "paginate": {"next": AJS.I18n.getText('aui.next.name'), "previous": AJS.I18n.getText('aui.prev.name')},
                "search": AJS.I18n.getText('search.name'),
                "select": {"rows": {_: AJS.I18n.getText('text.selected') + ": %d", 0: ""}},
                "zeroRecords": AJS.I18n.getText('error.invalid.search.nouser')
            }
        });
    }


    /*TAB 3 - File import/export*/
    //Task AutoRefresh
    function startAutoRefresh() {
        refresher = setInterval(function () {
            if (AJS.$('#csum-space-tabs #csum-space-tabs-tasks').hasClass('active-pane')) {
                getAllTasks();
            }
        }, 10000);
    }

    //Load All CsvUpload tasks
    function getAllTasks() {
        let url = contextPath + "/rest/csum/1.0/bulktasks/tasks?spaceKey=" + encodeURIComponent(spaceKey) + '&atl_token=' + atlToken;
        taskTable.ajax.url(url).load(null, false);
    }

    //CsvUpload Table hook
    function hookTableActions() {
        AJS.$('#csum-tasks-table').on('click', '.delete-task', function () {
            let el = this;
            let taskId = AJS.$(el).val();
            let url = contextPath + "/rest/csum/1.0/bulktasks/remove?spaceKey=" + encodeURIComponent(spaceKey) + '&id=' + taskId + '&atl_token=' + atlToken;
            AJS.$.ajax({
                type: 'delete',
                url: url,
                success: function () {
                    taskTable.row(AJS.$(el).parents('tr')).remove().draw();
                },
                error: function (jqXHR, text) {
                    AJS.flag({
                        type: "error",
                        title: AJS.I18n.getText('action.error'),
                        body: jqXHR.responseText ? jqXHR.responseText : text,
                        close: 'auto'
                    });
                }
            })
        });
        AJS.$('#csum-tasks-table').on('click', '.cancel-task', function () {
            let el = this;
            let taskId = AJS.$(el).val();
            let url = contextPath + "/rest/csum/1.0/bulktasks/cancel?spaceKey=" + encodeURIComponent(spaceKey) + '&id=' + taskId + '&atl_token=' + atlToken;
            AJS.$.ajax({
                type: 'delete',
                url: url,
                success: function () {
                    getAllTasks();
                },
                error: function (jqXHR, text) {
                    AJS.flag({
                        type: "error",
                        title: AJS.I18n.getText('action.error'),
                        body: jqXHR.responseText ? jqXHR.responseText : text,
                        close: 'auto'
                    });
                }
            })
        });
        //'Information' modal popup
        AJS.$('#csum-tasks-table').on('click', '.task-details', function (e) {
            e.preventDefault();
            AJS.$('#csum-taskinfo-table').hide();
            AJS.dialog2("#taskinfo-dialog").show();
            let el = this;
            let taskId = AJS.$(el).val();
            let url = contextPath + "/rest/csum/1.0/bulktasks/info?spaceKey=" + encodeURIComponent(spaceKey) + '&id=' + taskId + '&atl_token=' + atlToken;
            AJS.$.ajax({
                url: url,
                beforeSend: function () {
                    AJS.$('#csum-taskinfo-spinner').show();
                }
            })
                .done(function (data) {
                    let isCsvType = data.type === "addMembers" || data.type === "removeMembers";
                    let successTotal = 0;
                    let unsuccessfultotal = 0;
                    if (data.successful > 0) {
                        successTotal = data.successful + " - <a id='csum-taskinfo-passuserlist'>Download list</a>";
                    }
                    if (data.unsuccessful > 0) {
                        unsuccessfultotal = data.unsuccessful + " - <a id='csum-taskinfo-failuserlist'>Download list</a>";
                    }
                    AJS.$('#csum-taskinfo-table').show();
                    AJS.$("#csum-taskinfo-id").text(data.id);
                    AJS.$("#csum-taskinfo-type").text(data.type);
                    AJS.$("#csum-taskinfo-status").text(data.status);
                    AJS.$("#csum-taskinfo-message").text(data.message);
                    AJS.$("#csum-taskinfo-submitted").text(data.submitted);
                    AJS.$("#csum-taskinfo-finished").text(data.finished);
                    AJS.$("#csum-taskinfo-creator").text(data.user);
                    AJS.$("#csum-taskinfo-lastactivity").text(data.last_activity);
                    AJS.$("#csum-taskinfo-originalgroupname").text(data.original_group_name);
                    AJS.$("#csum-taskinfo-newgroupname").text(data.new_group_name);
                    AJS.$("#csum-taskinfo-renamescope").text(data.rename_scope);
                    AJS.$("#csum-taskinfo-cleanspacepermsscope").text(data.clean_space_perms_scope);
                    AJS.$("#csum-taskinfo-cleanpagepermsscope").text(data.clean_page_perms_scope);
                    if (isCsvType) {
                        AJS.$("#csum-taskinfo-filename").text(data.filename);
                        AJS.$("#csum-taskinfo-filename-row").show();
                        AJS.$("#csum-taskinfo-successfultotal").html(successTotal);
                        AJS.$("#csum-taskinfo-successfultotal-row").show();
                        AJS.$("#csum-taskinfo-unsuccessfultotal").html(unsuccessfultotal);
                        AJS.$("#csum-taskinfo-unsuccessfultotal-row").show();
                    } else {
                        AJS.$("#csum-taskinfo-filename-row").hide();
                        AJS.$("#csum-taskinfo-successfultotal-row").hide();
                        AJS.$("#csum-taskinfo-unsuccessfultotal-row").hide();
                    }
                    hookUserListListener(data);

                })
                .fail(function (jqXHR, text) {
                    AJS.flag({
                        type: "error",
                        title: AJS.I18n.getText('action.error'),
                        body: jqXHR.responseText ? jqXHR.responseText : text,
                        close: 'auto'
                    });
                })
                .always(function () {
                    AJS.$('#csum-taskinfo-spinner').hide();
                });
        });
        //'Download' most recent csv-file
        AJS.$('#csum-tasks-table').on('click', '.download-csv-file', function (e) {
            e.preventDefault();
            let el = this;
            let taskId = AJS.$(el).val();
            let url = contextPath + "/rest/csum/1.0/bulktasks/downloadcsv?spaceKey=" + encodeURIComponent(spaceKey) + "&id=" + taskId + '&atl_token=' + atlToken;
            AJS.$.ajax({
                url: url,
                beforeSend: function () {
                    AJS.$('#csum-taskinfo-spinner').show();
                }
            }).done(function (data) {
                downloadFile(data, spaceKey+"-"+taskId+".csv", "csv");
            }).error(function (jqXHR, options, error) {
                handleDownloadCsvError(jqXHR, options, error);
            });
        });
        AJS.$('#csum-taskinfo-spinner').hide();
    }

    //CsvUpload UserList hook
    function hookUserListListener(data) {
        AJS.$('#csum-taskinfo-passuserlist').click(function () {
            downloadFile(data.successful_list, "successful_users", "csv");
        });

        AJS.$('#csum-taskinfo-failuserlist').click(function () {
            downloadFile(data.unsuccessful_list, "unsuccessful_users", "csv");
        });
    }

    //CsvBulk tab downloadFile from Task table
    function downloadFile(data, filename, type) {
        let file = new Blob([data], {type: type});
        if (window.navigator.msSaveOrOpenBlob)
            window.navigator.msSaveOrOpenBlob(file, filename);
        else {
            let a = document.createElement("a"),
                url = URL.createObjectURL(file);
            a.href = url;
            a.download = filename;
            document.body.appendChild(a);
            a.click();
            setTimeout(function () {
                document.body.removeChild(a);
                window.URL.revokeObjectURL(url);
            }, 0);
        }
    }

    //CsvUpload file upload hook
    function hookCSVUpload() {
        AJS.$('#csum-csv-import').change(function () {
            if ((AJS.$(this).prop('files').length > 0) && (groupAddRemovePerms)) {
                AJS.$('#csum-import-btn').removeAttr("disabled");
                AJS.$('#csum-cancel-upload').removeAttr("disabled");
            } else {
                AJS.$('#csum-import-btn').attr("disabled", true);
            }
        });

        AJS.$('#csum-csv-import-form').submit(function (e) {
            let formData = new FormData();
            if (AJS.$('#csum-csv-import').prop('files').length > 0) {
                let delimiterType = AJS.$('#csum-delimiter').val();
                let file = AJS.$('#csum-csv-import').prop('files')[0];
                let willNotify = AJS.$('#notificationCheckBox').prop("checked");

                formData.append('csvFile', file, file.name);

                sendCSVFile(formData, AJS.$('input[name=csum-bulktype]:checked').val(), delimiterType, willNotify);
            }
            e.preventDefault();
        });

        AJS.$('#csum-cancel-upload').click(function () {
            AJS.$('#csum-cancel-upload').attr("disabled", true);
            AJS.$('#csum-import-btn').attr("disabled", true);
            clearFileBrowser();
        });
    }

    //Clear CsvUpload file Browse element
    function clearFileBrowser() {
        let $el = AJS.$('#csum-csv-import');
        $el.wrap('<form>').closest('form').get(0).reset();
        $el.unwrap();
    }

    //CsvUpload UI spinner on file upload
    function beforeUpload() {
        AJS.$('#csum-upload-spinner').show();
        AJS.$('#csum-import-btn').attr("disabled", true);
    }

    //CsvUpload cleanup UI and uploadResult logging after file upload
    function postUploadCleanup() {
        AJS.$('#csum-upload-spinner').hide();
        if (groupAddRemovePerms) {
            AJS.$('#csum-import-btn').removeAttr("disabled");
        }
        clearFileBrowser();
        getAllTasks();
    }

    //Handle upload/download calls
    function handleUploadSuccess() {
        AJS.flag({
            type: "success",
            title: AJS.I18n.getText('csum.bulk.operation.csv.success'),
            close: 'auto'
        });
    }
    function handleUploadError(jqXHR, textStatus, msg) {
        AJS.flag({
            type: "error",
            title: AJS.I18n.getText('add.members') + ': ' + jqXHR.statusText,
            body: msg,
            close: 'auto'
        });
    }
    function handleDownloadCsvError(jqXHR, textStatus, msg) {
        console.error('error: csv file download failed, status: ' + textStatus + ', errorMessage: ' + msg);
        AJS.flag({
            type: "error",
            title: AJS.I18n.getText('Download csv') + ': ' + jqXHR.statusText,
            body: msg,
            close: 'auto'
        });
    }

    //CsvUpload file upload
    function sendCSVFile(formData, type, delimiterType, willNotify) {
        console.log("sending task file...");
        let url = contextPath + '/rest/csum/1.0/bulktasks/addusers?type=' + type + '&delimiter=' + delimiterType + '&willnotify=' + willNotify + '&spaceKey=' + encodeURIComponent(spaceKey) + '&atl_token=' + atlToken;

        AJS.$.ajax({
            type: 'post',
            url: url,
            data: formData,
            contentType: false,
            processData: false,
            beforeSend: beforeUpload,
            success: handleUploadSuccess,
            error: handleUploadError,
            complete: postUploadCleanup
        });
    }

    //CsvUpload table render action content
    function getActionHtml(data, type, row) {
        if (type === 'display') {
            let isCsvType = row[1] === "addMembers" || row[1] === "removeMembers";
            let noCancel = row[3] !== 'running' && row[3] !== 'queued';
            if(row[4] === 'true')
            {
                return '<ul class="menu">' +
                    '<li><button class="aui-button aui-button-link download-csv-file"' + (!noCancel ? "disabled" : "") + ' value="' + row[0]  +'"' + (isCsvType ? "" : "style=\"display:none\"") + '>' +
                    AJS.I18n.getText('download.name') + '</button></li>' +
                    '<li><button class="aui-button aui-button-link task-details" value="' + row[0] + '">' +
                    AJS.I18n.getText('Info') + '</button></li>' +
                    '<li><button class="aui-button aui-button-link cancel-task"' + (noCancel ? "disabled" : "") + ' value="' + row[0] + '">' +
                    AJS.I18n.getText('cancel.name') + '</button></li>' +
                    '<li><button class="aui-button aui-button-link delete-task"' + (!noCancel ? "disabled" : "") + ' value="' + row[0] + '">' +
                    AJS.I18n.getText('remove.name') + '</button></li>' +
                    '</ul>';
            } else {
                return '<ul class="menu">' +
                    '<li><button class="aui-button aui-button-link task-details" value="' + row[0] + '">' +
                    AJS.I18n.getText('Info') + '</button></li>' +
                    '<li><button class="aui-button aui-button-link cancel-task"' + (noCancel ? "disabled" : "") + ' value="' + row[0] + '">' +
                    AJS.I18n.getText('cancel.name') + '</button></li>' +
                    '<li><button class="aui-button aui-button-link delete-task"' + (!noCancel ? "disabled" : "") + ' value="' + row[0] + '">' +
                    AJS.I18n.getText('remove.name') + '</button></li>' +
                    '</ul>';
            }
        }
        return data;
    }

    //CsvUpload table render task content
    function getStatusHtml(data, type, row) {
        if (type === 'display') {
            let status = row[3];
            let statusClass = '';
            if (status === 'success') {
                statusClass = ' aui-lozenge-success';
            } else if (status === 'failure' || status === 'rejected' || status === 'requires_attention') {
                statusClass = ' aui-lozenge-error';
            } else if (status === 'uploading') {
                statusClass = ' aui-lozenge-new';
            } else if (status === 'running') {
                statusClass = ' aui-lozenge-current';
            } else if (status === 'cancelled') {
                statusClass = ' aui-lozenge-moved';
            }
            return '<span class="aui-lozenge aui-lozenge-subtle' + statusClass + '" title="' +
                (status === 'rejected' ? AJS.I18n.getText('csum.bulk.import.rejected') : "") + '">' + data + '</span>';
        }
        return data;
    }

    //CsvUpload Datatable Initialise
    taskTable = AJS.$('#csum-tasks-table').DataTable({
        processing: true,
        autoWidth: false,
        order: [[1, "desc"]],
        columns: [
            {
                data: [taskTableColumnIds.entityId], //entity ID
                visible: false
            },
            {
                data: [taskTableColumnIds.submitted],  //Submitted
                width: "15%"
            },
            {
                data: [taskTableColumnIds.lastUpdated], //Last updated
                width: "15%"
            },
            {
                data: [taskTableColumnIds.type],  //Type
                width: "10%"
            },
            {
                data: [taskTableColumnIds.status],  //Status
                render: getStatusHtml,
                width: "10%"
            },
            {
                data: [taskTableColumnIds.actions], //Actions
                render: getActionHtml,
                width: "20%"
            }
        ],
        language: {
            "emptyTable": AJS.I18n.getText('admintask.no.tasks'),
            "info": AJS.I18n.getText('search.result.hidden.query', '_START_', '_END_', '_TOTAL_'),
            "infoEmpty": AJS.I18n.getText('search.result.hidden.query', '0', '0', '0'),
            "infoFiltered": AJS.I18n.getText('total.results.display', '_MAX_'),
            "lengthMenu": AJS.I18n.getText('show.word') + " _MENU_",
            "paginate": {"next": AJS.I18n.getText('aui.next.name'), "previous": AJS.I18n.getText('aui.prev.name')},
            "processing": AJS.I18n.getText('loading.name'),
            "search": AJS.I18n.getText('search.name'),
            "zeroRecords": AJS.I18n.getText('result.grid.no.result.message')
        }
    });


    /*TAB 4 - Audit Log*/
    // enabling this allows you to handle errors yourself.
    //$.fn.dataTable.ext.errMode = 'throw';
    function startAuditingAutoRefresh() {
        refreshTimer = setInterval(function () {
            if (AJS.$('#csum-space-tabs #csum-space-tabs-auditing, #csum-config-tabs #csum-configtabs-audit').hasClass('active-pane')) {
                auditingTable.ajax.reload(null, false);
            }
        }, 10000);
    }

    // Called to check whether the new desired group name matches the RegExp set in the System config.
    // Provide the method that will be called if the new name matches against the RegExp, can be either
    // submitCreateGroup(), validateNewGroupName(groupName, newName) or submitRenameGroup(groupName, newName)
    function doesGroupNameMatchRegexp(groupNameVal, validationEvent, callback) {

        let endpointUrl = contextPath + "/rest/csum/1.0/spacegroup/matchesRegexp?spaceKey=" + encodeURIComponent(spaceKey) + "&groupName=" + encodeURIComponent(groupNameVal) + "&atl_token=" + atlToken;

        AJS.$.ajax({
            type: "get",
            url: endpointUrl,
            contentType: "application/json; charset=utf-8",
            success: function (data){
                if (data) {
                    if (validationEvent === "create")
                    {
                        callback();
                    }
                    else {
                        let groupName = csumGroupDataTable.row('.selected').data()[0];
                        let newName = AJS.$('#csum-rename-new').val();
                        callback(groupName, newName);
                    }
                } else {
                    if (validationEvent === "create") {
                        AJS.$("#createRegexErrorMsg").attr("hidden", false);
                        AJS.$("#csum-group-create-submit-button").attr("disabled", "disabled");
                    }
                    else {
                        AJS.$("#renameRegexErrorMsg").attr("hidden", false);
                        AJS.$("#csum-rename-btn").attr("disabled", "disabled");
                        AJS.$("#csum-rename-existing-group-btn").attr("disabled", "disabled");
                    }
                }
            },
            error: function (jqXHR, textStatus, error) {
                AJS.flag({
                    type: "error",
                    title: "An unknown error occurred. Error type: " + error ? error : "Unknown",
                    close: 'auto'
                });
            }
        });


    }

    function initAuditTableFilters()
    {
        function initUserSelect(userSelectUrl) {
            let userSearchUrl = AJS.contextPath() + '/rest/csum/latest/spaceuser/search?atl_token=' + AJS.Meta.get("atl-token");
            AJS.$(userSelectUrl).auiSelect2({
                placeholder: AJS.I18n.getText('find.users'),
                minimumInputLength: 2,
                allowClear: true,
                width: 500,
                ajax: {
                    url: userSearchUrl,
                    dataType: 'json',
                    quietMillis: 350,
                    data: function (term) {
                        return {
                            spaceKey: spaceKey ? spaceKey : undefined,
                            query: term,
                            page_limit: 25
                        };
                    },
                    results: function (data) {
                        return {results: data.users};
                    }
                },
                formatResult: function (result, container, query) {
                    let markup = [];
                    let text = result.fullname + " (" + result.email + ", " + result.username + ")";
                    markMatch(text, query.term, markup);
                    return markup.join("");
                },
                formatSelection: function (item) {
                    return item.fullname;
                },
                id: function (item) {
                    return item.username;
                }
            });
        }
        initUserSelect("#csum-ctxuser-selector, #csum-changedBy-selector");


        function initGroupSelect() {
            let groupSearchUrl = AJS.contextPath() + '/rest/csum/1.0/spacegroup/search?atl_token=' + AJS.Meta.get("atl-token");
            AJS.$("#csum-group-selector").auiSelect2({
                placeholder: AJS.I18n.getText('find.groups'),
                minimumInputLength: 1,
                allowClear: true,
                width: 500,
                ajax: {
                    url: groupSearchUrl,
                    dataType: 'json',
                    quietMillis: 350,
                    width: 500,
                    data: function (term) {
                        return {
                            spaceKey: spaceKey ? spaceKey : undefined,
                            query: term,
                            page_limit: 25,
                        };
                    },
                    results: function (data) {
                        return {
                            results: data.groups,
                            text: function (item) {
                                return AJS.escapeHtml(item);
                            },
                            id: function (item) {
                                return item;
                            }
                        };
                    }
                },
                formatResult: function (item) {
                    if (item.id) {
                        return AJS.escapeHtml(item.id);
                    } else {
                        return AJS.escapeHtml(item);
                    }
                },
                formatSelection: function (item) {
                    if (item.id) {
                        return AJS.escapeHtml(item.id);
                    } else {
                        return AJS.escapeHtml(item);
                    }
                },
                id: function (item) {
                    if (item.id) {
                        return item.id;
                    } else {
                        return item;
                    }
                }
            });
        }
        initGroupSelect();

        if (AJS.$("#csum-space-selector").length > 0) {
            var customSpaceFindUrl = AJS.contextPath() + "/rest/csum/1.0/space/search?atl_token=" + AJS.Meta.get("atl-token");
            AJS.$("#csum-space-selector").auiSelect2({
                placeholder: AJS.I18n.getText('all'),
                minimumInputLength: 1,
                allowClear: true,
                width: 500,
                ajax: {
                    type: "post",
                    url: customSpaceFindUrl,
                    dataType: 'json',
                    quietMillis: 350,
                    data: function (term) {
                        return {
                            spaceKey: spaceKey,
                            term: term,
                            pageLimit: 25
                        };
                    },
                    results: function (data) {
                        return {
                            results: data,
                            text: function (item) {
                                return AJS.escapeHtml(item.spaceName + " (" + item.key + ")");
                            },
                            id: function (item) {
                                return AJS.escapeHtml(item.spaceName + " (" + item.key + ")");
                            }
                        };
                    }
                },
                formatResult: function (item) {
                    return AJS.escapeHtml(item.spaceName + " (" + item.key + ")");
                },
                formatSelection: function (item) {
                    return AJS.escapeHtml(item.spaceName + " (" + item.key + ")");
                },
                id: function (item) {
                    return AJS.escapeHtml(item.key);
                }
            });

            AJS.$('#csum-space-selector').on('change', function () {
                //Set selected space to hidden input and un-disable delete link
                AJS.$('#selectedSpaceKey').val(this.value);
                AJS.$('#csum-delete-space-history').removeAttr("disabled");
                AJS.$('#csumDeleteSpaceAuditBtn').removeAttr("disabled");
                AJS.$('#csumDeleteSpaceAuditLogo').removeAttr("disabled");
                AJS.$('#csumDeleteSpaceAuditLogo').attr("style", "color: #0052CC");
                auditingTable.column(1).search(this.value).draw();
            });
        }

        AJS.$('#csum-changedBy-selector').on('change', function() {
            auditingTable.column(2).search( this.value ).draw();
            AJS.$('#csum-changedBy-selector-clear').attr("style", "display: inline-block");
        });
        AJS.$('#csum-changedBy-selector-clear').click(function () {
            auditingTable.column(2).search('').draw();
            AJS.$('#csum-changedBy-selector').val(null).trigger('change');
            initUserSelect("#csum-changedBy-selector");
            AJS.$('#csum-changedBy-selector-clear').attr("style", "display: none");
        });

        function initOperationSelect() {
            AJS.$("#csum-operation-selector").auiSelect2({
                placeholder: AJS.I18n.getText('all'),
                allowClear: true,
                width: 500,
                escapeMarkup: function (text) {
                    return text;
                }
            });
        }
        initOperationSelect();

        AJS.$('#csum-operation-selector').on('change', function() {
            auditingTable.column(3).search( this.value ).draw();
            AJS.$('#csum-operation-selector-clear').attr("style", "display: inline-block");
        });
        AJS.$('#csum-operation-selector-clear').click(function () {
            auditingTable.column(3).search('').draw();
            AJS.$('#csum-operation-selector').val(null).trigger('change');
            initOperationSelect();
            AJS.$('#csum-operation-selector-clear').attr("style", "display: none");
        });

        AJS.$('#csum-group-selector').on('change', function() {
            auditingTable.column(4).search( this.value ).draw();
            AJS.$('#csum-group-selector-clear').attr("style", "display: inline-block");
        });
        AJS.$('#csum-group-selector-clear').click(function () {
            auditingTable.column(4).search('').draw();
            AJS.$('#csum-group-selector').val(null).trigger('change');
            initGroupSelect();
            AJS.$('#csum-group-selector-clear').attr("style", "display: none");
        });

        AJS.$('#csum-ctxuser-selector').on('change', function() {
            auditingTable.column(5).search( this.value ).draw();
            AJS.$('#csum-ctxuser-selector-clear').attr("style", "display: inline-block");
        });
        AJS.$('#csum-ctxuser-selector-clear').click(function () {
            auditingTable.column(5).search('').draw();
            AJS.$('#csum-ctxuser-selector').val(null).trigger('change');
            initUserSelect('#csum-ctxuser-selector');
            AJS.$('#csum-ctxuser-selector-clear').attr("style", "display: none");
        });

        function initOutcomeSelector() {
            AJS.$("#csum-outcome-selector").auiSelect2({
                placeholder: AJS.I18n.getText('all'),
                allowClear: true,
                width: 500
            });
        }
        initOutcomeSelector();
        AJS.$('#csum-outcome-selector').on('change', function() {
            auditingTable.column(6).search( this.value ).draw();
            AJS.$('#csum-outcome-selector-clear').attr("style", "display: inline-block");
        });
        AJS.$('#csum-outcome-selector-clear').click(function () {
            auditingTable.column(6).search('').draw();
            AJS.$('#csum-outcome-selector').val(null).trigger('change');
            initOutcomeSelector();
            AJS.$('#csum-outcome-selector-clear').attr("style", "display: none");
        });
    }

    //initialise auditing
    initAuditTableFilters();

    let operationsi18n = {
        systemConfigUpdated: AJS.I18n.getText('csum.auditing.operation.systemConfigUpdated'),
        createUser: AJS.I18n.getText('csum.auditing.operation.createUser'),
        createGroup: AJS.I18n.getText('csum.auditing.operation.createGroup'),
        createRemoteGroup: AJS.I18n.getText('csum.auditing.operation.createRemoteGroup'),
        removeGroup: AJS.I18n.getText('csum.auditing.operation.removeGroup'),
        removeRemoteGroup: AJS.I18n.getText('csum.auditing.operation.removeRemoteGroup'),
        addUserToGroup: AJS.I18n.getText('csum.auditing.operation.addUserToGroup'),
        addUserToRemoteGroup: AJS.I18n.getText('csum.auditing.operation.addUserToRemoteGroup'),
        removeUserFromGroup: AJS.I18n.getText('csum.auditing.operation.removeUserFromGroup'),
        removeUserFromRemoteGroup: AJS.I18n.getText('csum.auditing.operation.removeUserFromRemoteGroup'),
        addDelegatedGroup: AJS.I18n.getText('csum.auditing.operation.addDelegatedGroup'),
        removeDelegatedGroup: AJS.I18n.getText('csum.auditing.operation.removeDelegatedGroup'),
        authorizeUser: AJS.I18n.getText('csum.auditing.operation.authorizeUser'),
        deauthorizeUser: AJS.I18n.getText('csum.auditing.operation.deauthorizeUser'),
        authorizeGroup: AJS.I18n.getText('csum.auditing.operation.authorizeGroup'),
        deauthorizeGroup: AJS.I18n.getText('csum.auditing.operation.deauthorizeGroup'),
        deauthGroupBySystem: AJS.I18n.getText('csum.auditing.operation.deauthGroupBySystem'),
        deauthUserBySystem: AJS.I18n.getText('csum.auditing.operation.deauthUserBySystem'),
        removeDlgGroupBySys: AJS.I18n.getText('csum.auditing.operation.removeDlgGroupBySys'),
        removedFromFilter: AJS.I18n.getText('csum.auditing.operation.removedFromFilter'),
        groupDeletedExternally: AJS.I18n.getText('csum.auditing.operation.groupDeletedExternally'),
        getUsersOrGroups: AJS.I18n.getText('csum.auditing.operation.groupDeletedExternally'),
        cloneGroup: AJS.I18n.getText('csum.auditing.operation.cloneGroup'),
        exportGroups: AJS.I18n.getText('csum.auditing.operation.exportGroups')
    };

    auditingTable = AJS.$('#csum-auditing').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: AJS.contextPath() + "/rest/csum/latest/auditing/records?atl_token=" + AJS.Meta.get("atl-token"),
            type: "POST",
            data: function (d) {
                d.orderCol = d.order[0].column;
                d.orderDir = d.order[0].dir;
                d.spaceVal = spaceKey ? spaceKey : d.columns[1].search.value;
                d.creatorVal = d.columns[2].search.value;
                d.opTypeVal = d.columns[3].search.value;
                d.groupVal = d.columns[4].search.value;
                d.userVal = d.columns[5].search.value;
                d.outcomeVal = d.columns[6].search.value;
            }
        },
        columns: [
            null,
            {
                visible: !spaceKey
            },
            {
                "render": function (data, type) {
                    let renderedData;
                    if (type === 'display' && data !== "system") {
                        renderedData = '<a target="_blank" rel="noopener" href="' + AJS.contextPath() + '/display/~' + data + '">' + data + '</a>';
                    } else {
                        renderedData = data;
                    }
                    return renderedData;
                }
            },
            {
                "render": function (data, type, row) {
                    let renderedData;
                    if(type === 'display') {
                        if (data === "authorizeGroup" || data === "deauthorizeGroup" || data === "deauthGroupBySystem" ) {
                            if (row[7] !== undefined) {
                                renderedData = AJS.escapeHtml(row[7]) + " " + operationsi18n[data];
                            } else {
                                renderedData = "A group " + operationsi18n[data];
                            }
                        } else {
                            renderedData = operationsi18n[data];
                        }
                    } else {
                        renderedData = data;
                    }
                    return renderedData
                }
            },
            {
                "render": function (data, type) {
                    if (type === 'display') {
                        if (data !== null) {
                            data = AJS.escapeHtml(data);
                        }
                    }
                    return data;
                }
            },
            {
                "render": function (data, type) {
                    return type === 'display' && data ?
                        '<a target="_blank" rel="noopener" href="' + AJS.contextPath() + '/display/~' + data + '">' + data + '</a>' : data;
                }
            },
            {
                "render": function (data, type) {
                    if (data === 'success') {
                        data = '<span class="aui-icon aui-icon-small aui-iconfont-check">' + data + '</span>'
                    } else if (data === 'queued') {
                        data = '<span class="aui-icon aui-icon-small aui-iconfont-recent">' + data + '</span>'
                    } else {
                        data = '<span class="aui-icon aui-icon-small aui-iconfont-cross">' + data + '</span>'
                    }
                    return type === 'display' && data;
                }
            }
        ],
        order: [[ 0, "desc"]],
        language: {
            "emptyTable": AJS.I18n.getText('result.grid.no.result.message'),
            "info": AJS.I18n.getText('search.result.hidden.query','_START_','_END_','_TOTAL_'),
            "infoEmpty": AJS.I18n.getText('search.result.hidden.query','0','0','0'),
            "infoFiltered": AJS.I18n.getText('total.results.display','_MAX_'),
            "lengthMenu": AJS.I18n.getText('show.word')+" _MENU_",
            "paginate": {"next": AJS.I18n.getText('aui.next.name'),"previous": AJS.I18n.getText('aui.prev.name')},
            "processing": AJS.I18n.getText('loading.name'),
            "search": AJS.I18n.getText('search.name'),
            "zeroRecords": AJS.I18n.getText('result.grid.no.result.message')
        }
    });

    function getCurrentSpaceGroupsRest() {
        let url = contextPath + "/rest/csum/1.0/spacegroup/groups/clone?currentSpaceKey=" + spaceKey + "&selectedSpace=" + spaceKey + "&atl_token=" + atlToken;
        console.log("url: " + url);
        AJS.$.ajax({
            type: "get",
            url: url,
            dataType: "json",
            success: function (data, textStatus) {

                data = data.data;

                if (textStatus === "success") {
                    if (data) {
                        if (data.length > 0) {
                            for (let i = 0; i < data.length; i++) {
                                AJS.$('#spaceGroupsExportTableBody').append('<tr><td headers="groups" id="spaceGroupExport'+ i + '">' + AJS.escapeHtml(data[i][0]) + '</td>' +
                                    '<td headers="users" id="spaceUserExport'+ i + '">' + data[i][1] + '</td><td headers="checkBox">' +
                                    '<input style="margin-left: 10px" class="checkbox exportCheckBox" type="checkbox" id="exportGroupsCheckBox' + i + '"></td></tr>');
                            }
                        } else {
                            AJS.messages.info('', {
                                body: '<p>' + AJS.I18n.getText('') + '</p>',
                                fadeout: true
                            });
                        }
                    }
                } else if (textStatus === "nocontent") {
                    console.error('' + textStatus);
                    AJS.flag({
                        type: "error",
                        title: AJS.I18n.getText('') + ': ' + jqXHR.statusText,
                        body: AJS.I18n.getText('')
                    });
                }
            },
            error: function () {
                AJS.flag({
                    type: 'error',
                    title: AJS.I18n.getText(''),
                    body: '<p>' + AJS.I18n.getText('') + '</p>',
                });
            }
        });
    }

    function setupChangeExportActionParams() {
        AJS.$("#csumDelimiter").on("change", function()
        {
            changeExportActionParams();
        });

        AJS.$("#spaceGroupsExportTable").on("change", function()
        {
            changeExportActionParams();
        });

        AJS.$("#checkAllGroups").on("click", function()
        {
            changeExportActionParams();
        });
    }

    function changeExportActionParams() {
        let currentSpaceKey = AJS.$("#currentSpaceKey").val();
        let atl_token = AJS.$("#atl_token").val();
        let selectedDelimiterOption = AJS.$('#csumDelimiter :selected').val();
        let selectedDelimiterOptionCharacter = String.fromCharCode(selectedDelimiterOption);
        let selectedGroups = "";

        selectedGroups = concatSelectedGroups(selectedDelimiterOptionCharacter);

        let href = "exportGroups.action?key=" + currentSpaceKey + "&chosenChar=" + encodeURIComponent(selectedDelimiterOptionCharacter) + "&currentSpace=" + currentSpaceKey
            + "&groupsToExport=" + encodeURIComponent(selectedGroups) + "&" + atl_token;
        AJS.$("#csumCsvExportButton").attr("href", href);
    }

    function concatSelectedGroups(delimiter) {
        let groups = "";
        let currCheckBox = AJS.$("#exportGroupsCheckBox0").prop("class");
        let i = 0;

        while (currCheckBox !== undefined) {
            if (AJS.$("#exportGroupsCheckBox" + i).prop("checked") === true) {
                groups = groups.concat(AJS.$("#spaceGroupExport" + i).prop("innerText"));
                groups = groups.concat(delimiter);
            }
            currCheckBox = AJS.$("#exportGroupsCheckBox" + i).prop("class");
            i ++;
        }

        return groups;
    }

    function hookCheckAllGroups() {
        AJS.$('#checkAllGroups').click(function (event) {
            event.preventDefault();

            let i;
            let numOfBoxes = AJS.$('#spaceGroupsExportTableBody').children().length;
            let numOfCheckedBoxes = 0;

            for (i = 0; i < numOfBoxes; i++) {
                if (AJS.$('#exportGroupsCheckBox' + i).prop("checked") === true) {
                    numOfCheckedBoxes ++;
                }
            }

            if (numOfCheckedBoxes === numOfBoxes) {
                for (i = 0; i < numOfBoxes; i++) {
                    AJS.$('#exportGroupsCheckBox' + i).prop("checked", false);
                }
                disableImportButton();
                isImportBtnChecked = false;
            } else {
                for (i = 0; i < numOfBoxes; i++) {
                    AJS.$('#exportGroupsCheckBox' + i).prop("checked", true);
                }
                enableImportButton();
                isImportBtnChecked = true;
            }
        });
    }

    /*TAB 5 - Clone*/
    function getGroups(selectedSpace) {
        let url = contextPath + "/rest/csum/1.0/spacegroup/groups/clone?currentSpaceKey=" + spaceKey + "&selectedSpace=" + selectedSpace + "&atl_token=" + atlToken;
        AJS.$.ajax({
            type: "get",
            url: url,
            dataType: "json",
            success: function (data, textStatus) {

                data = data.data;

                if (textStatus === "success") {
                    if (data) {
                        if (data.length > 0) {
                            for (let i = 0; i < data.length; i++) {
                                AJS.$('#spaceGroupTableBody').append('<tr><td headers="groups" id="spaceGroup'+ i + '">' + AJS.escapeHtml(data[i][0]) + '</td>' +
                                    '<td headers="users" id="spaceUser'+ i + '">' + data[i][1] + '</td><td headers="checkBox">' +
                                    '<input style="margin-left: 10px" class="checkbox cloneCheckBox" type="checkbox" id="cloneGroupCheckBox' + i + '"></td></tr>');
                            }
                            hookButtonEnablement();
                        } else {
                            AJS.messages.info('', {
                                body: '<p>' + AJS.I18n.getText('') + '</p>',
                                fadeout: true
                            });
                        }
                    }
                } else if (textStatus === "nocontent") {
                    console.error('' + textStatus);
                    AJS.flag({
                        type: "error",
                        title: AJS.I18n.getText('') + ': ' + jqXHR.statusText,
                        body: AJS.I18n.getText('')
                    });
                }
            },
            error: function () {
                AJS.flag({
                    type: 'error',
                    title: AJS.I18n.getText(''),
                    body: '<p>' + AJS.I18n.getText('') + '</p>',
                });
            }
        });
    }

    function hookGetGroups() {
        AJS.$('#spacePicker').on('input change', function() {
            AJS.$('#spaceGroupTableBody').empty();

            let selectedSpace = AJS.$('#spacePicker').val();

            if (selectedSpace) {
                getGroups(selectedSpace);
            }

            isImportBtnChecked = false;
        });
    }

    //hookSpacePicker for import tab Space Select
    function hookSpacePicker() {
        var customSpaceFindUrl = AJS.contextPath() + "/rest/csum/1.0/space/search?atl_token=" + AJS.Meta.get("atl-token");
        AJS.$("#spacePicker").auiSelect2({
            placeholder: AJS.I18n.getText('csum.clone.picker'),
            minimumInputLength: 1,
            allowClear: true,
            width: 500,
            ajax: {
                type: "post",
                url: customSpaceFindUrl,
                dataType: 'json',
                quietMillis: 350,
                data: function (term) {
                    return {
                        spaceKey: spaceKey,
                        term: term,
                        pageLimit: 25
                    };
                },
                results: function (data) {
                    return {
                        results: data,
                        text: function (item) {
                            return AJS.escapeHtml(item.spaceName + " (" + item.key + ")");
                        },
                        id: function (item) {
                            return AJS.escapeHtml(item.spaceName + " (" + item.key + ")");
                        }
                    };
                }
            },
            formatResult: function (item) {
                return AJS.escapeHtml(item.spaceName + " (" + item.key + ")");
            },
            formatSelection: function (item) {
                return AJS.escapeHtml(item.spaceName + " (" + item.key + ")");
            },
            id: function (item) {
                return AJS.escapeHtml(item.key);
            }
        });
    }

    function hookCheckAll() {
        AJS.$('#checkAll').click(function (event) {
            event.preventDefault();

            let i;
            let numOfBoxes = AJS.$('#spaceGroupTableBody').children().length;

            if (isImportBtnChecked) {
                for (i = 0; i < numOfBoxes; i++) {
                    AJS.$('#cloneGroupCheckBox' + i).prop("checked", false);
                }
                disableImportButton();
                isImportBtnChecked = false;
            } else {
                let numOfCheckedBoxes = 0;

                for (i = 0; i < numOfBoxes; i++) {
                    if (AJS.$('#cloneGroupCheckBox' + i).prop("checked") === true) {
                        numOfCheckedBoxes ++;
                    }
                }

                if (numOfCheckedBoxes === numOfBoxes) {
                    for (i = 0; i < numOfBoxes; i++) {
                        AJS.$('#cloneGroupCheckBox' + i).prop("checked", false);
                    }
                    disableImportButton();
                    isImportBtnChecked = false;
                } else {
                    for (i = 0; i < numOfBoxes; i++) {
                        AJS.$('#cloneGroupCheckBox' + i).prop("checked", true);
                    }
                    enableImportButton();
                    isImportBtnChecked = true;
                }
            }
        });
    }

    function getSelectedGroupsAndUsers() {
        let entities = [];
        let groups = [];
        let userCount = 0;
        let currCheckBox = AJS.$("#cloneGroupCheckBox0").prop("class");
        let i = 0;

        while (currCheckBox !== undefined) {
            if (AJS.$("#cloneGroupCheckBox" + i).prop("checked") === true) {

                groups.push(AJS.$("#spaceGroup" + i).prop("innerText"));
                userCount = userCount + AJS.$("#spaceUser" + i).prop("innerText");
            }
            currCheckBox = AJS.$("#cloneGroupCheckBox" + i).prop("class");
            i ++;
        }

        entities.push(groups, userCount);
        return entities;
    }

    function openImportProcessingDialog() {
        AJS.dialog2('#clone-processing-dialog').show();
        AJS.$('#clone-processing-spinner').show();
    }

    function closeImportProcessingDialog() {
        AJS.$('#clone-processing-spinner').hide();
        AJS.dialog2('#clone-processing-dialog').hide();
    }

    function openImportCompleteDialog(data, currentSpaceKey, targetSpaceKey) {

        let exceptionBean = data.exceptionBean;

        let successfulGroups = data.successfulGroups;
        let successfulUsers = data.successfulUsers;
        let failedGroups = data.failedGroups;
        let failedUsers = data.failedUsers;
        let failedGroupCount = Object.keys(failedGroups).length;
        let failedUserCount = Object.keys(failedUsers).length;

        if (failedGroupCount === 0 && failedUserCount === 0 && (successfulGroups > 0 || successfulUsers > 0)) {
            AJS.$("#cloneCompleteHeader").text(AJS.I18n.getText("csum.common.successful"));
        } else if ((failedGroupCount > 0 || failedUserCount > 0) && (successfulGroups > 0 || successfulUsers > 0)) {
            AJS.$("#cloneCompleteHeader").text(AJS.I18n.getText("csum.common.requires.attention"));
        } else {
            AJS.$("#cloneCompleteHeader").text(AJS.I18n.getText("csum.common.failed"));
        }

        if (successfulGroups > 0) {
            AJS.$("#csumSuccessfulCloneGroups").html(successfulGroups);
        }
        if (successfulUsers > 0) {
            AJS.$('#csumSuccessfulCloneUsers').html(successfulUsers)
        }

        if (failedGroupCount > 0) {
            let total = '';
            for (let i = 0; i < failedGroupCount; i++) {
                let failedGroup = Object.keys(failedGroups)[i];
                let reason = Object.values(failedGroups)[i];
                total = total + failedGroup + ' (' + reason + ')';
                if (i !== (failedGroupCount - 1)) {
                    total = total + ', ';
                }
            }
            AJS.$("#csumFailedCloneGroups").html(AJS.escapeHtml(total));
        }
        if (failedUserCount > 0) {
            let total = '';
            for (let i = 0; i < failedUserCount; i++) {
                let failedUser = Object.keys(failedUsers)[i];
                let reason = Object.values(failedUsers)[i];
                total = total + failedUser + ' (' + reason + ')';
                if (i !== (failedUserCount - 1)) {
                    total = total + ', ';
                }
            }
            AJS.$("#csumFailedCloneUsers").html(total);
        }

        AJS.$("#clone-complete-sub-heading").text(AJS.I18n.getText("csum.clone.complete.subheader", targetSpaceKey, currentSpaceKey));

        if (exceptionBean) {
            let exceptionName = exceptionBean.exceptionName;
            let exceptionMessage = exceptionBean.exceptionMessage;
            let stackTrace = exceptionBean.stackTrace;
            let pluginVersion = exceptionBean.pluginVersion;

            AJS.$('#cloneCsumVersion').text("CSUM " + pluginVersion);
            AJS.$('#cloneExceptionName').text(exceptionName);
            AJS.$('#cloneExceptionMessage').text(exceptionMessage);
            AJS.$('#cloneStackTrace').text(stackTrace);

            AJS.$("#cloneExceptionMessageBox").show();
        }

        AJS.dialog2('#clone-complete-dialog').show();
    }

    function hookSubmitClone() {
        AJS.$('#cloneSpaceSubmit').click(function (e) {
            e.preventDefault();

            let groupAndUserArr = getSelectedGroupsAndUsers();
            let groupsToCloneCsv = encodeURIComponent(groupAndUserArr[0].toString());
            let targetSpaceKey = encodeURIComponent(AJS.$("#spacePicker").val());
            let cloneUsers = AJS.$("#cloneUsersCheckBox").prop("checked");

            let url = contextPath + "/rest/csum/latest/space/clone?atl_token=" + atlToken + "&currentSpaceKey=" + spaceKey +
                "&groupsToClone=" + groupsToCloneCsv + "&targetSpaceKey=" + targetSpaceKey + "&cloneUsers=" + cloneUsers;

            AJS.$.ajax({
                type: "post",
                url: url,
                contentType: "application/json; charset=utf-8",
                beforeSend: function() {
                    openImportProcessingDialog()
                },
                success: function (data, textStatus) {
                    if (textStatus === "success") {
                        closeImportProcessingDialog();
                        openImportCompleteDialog(data, spaceKey, targetSpaceKey);
                    }
                },
            });
        });
        AJS.$("#spacePicker").val('');
    }

    function enableImportButton() {
        AJS.$('#cloneSpaceSubmit').removeAttr('disabled');
    }
    function disableImportButton() {
        AJS.$('#cloneSpaceSubmit').attr('disabled', 'disabled');
    }

    function hookButtonEnablement() {
        AJS.$('.cloneCheckBox').change(function(e) {
            e.preventDefault();

            let numOfBoxes = AJS.$('#spaceGroupTableBody').children().length;
            let checkedBoxes = 0;

            for (let i = 0; i < numOfBoxes; i++) {
                if (AJS.$('#cloneGroupCheckBox' + i).prop("checked") === true) {
                    checkedBoxes ++;
                }
            }

            if (checkedBoxes > 0) {
                enableImportButton();
            } else {
                disableImportButton();
            }
        });
    }

    function hookCloseCloneDialog() {
        AJS.$("#csumCloneCloseButton").click(function () {
            // dialog
            AJS.$("#csumSuccessfulCloneGroups").html(0);
            AJS.$('#csumSuccessfulCloneUsers').html(0);
            AJS.$("#csumFailedCloneGroups").html(0);
            AJS.$("#csumFailedCloneUsers").html(0);
            AJS.$("#cloneCompleteHeader").text("");

            // exception
            AJS.$("#cloneStackTrace").toggle(false);
            AJS.$("#cloneExceptionMessageBox").hide();
            AJS.$('#cloneExceptionName').text("");
            AJS.$('#cloneExceptionMessage').text("");
            AJS.$('#cloneStackTrace').text("");
            AJS.$('#cloneCsumVersion').text("");
            AJS.$('#cloneExceptionHeader').text("");
            AJS.$("#cloneShowStack").text(AJS.I18n.getText("logged.event.see.more"));
            AJS.$("#clone-complete-dialog").attr("class", "aui-layer aui-dialog2 aui-dialog2-medium");
            AJS.dialog2("#clone-complete-dialog").hide();
        });
    }

    function hookCloneShowStackButton() {
        AJS.$("#cloneShowStack").click(function (e) {
            e.preventDefault();
            AJS.$("#cloneStackTrace").toggle();
            if (AJS.$("#cloneShowStack").text() === AJS.I18n.getText("logged.event.see.more")) {
                AJS.$("#cloneShowStack").text(AJS.I18n.getText("logged.event.see.less"));
                AJS.$("#clone-complete-dialog").attr("class", "aui-layer aui-dialog2 aui-dialog2-xlarge");
            } else {
                AJS.$("#cloneShowStack").text(AJS.I18n.getText("logged.event.see.more"));
                AJS.$("#clone-complete-dialog").attr("class", "aui-layer aui-dialog2 aui-dialog2-medium");
            }
        });
    }

    // init shared
    // TAB 1 - SpaceGroups/Users Tab
    disableAddUserButton();
    disableRemoveUserButton();
    disableRemoveGroupButton();
    disableRenameGroupButton();
    loadGroups();
    hookGroupCreate();
    hookGroupDelete();
    hookGroupActionBtnEnablement();
    hookRenameGroup();
    hookAddUsersToGroup();
    hookRemoveUsersFromGroups();
    hookCacheRefresh();
    hookCloseExceptionDialog();
    hookShowStackButton();
    hookSpaceSwitcher();
    checkForSpaceRenameGroupTasksCompletion();
    /*TAB 2 - DelegatedSpaceGroups/Users*/
    loadDelegatedGroups();
    hookGroupActionBtnEnabler();
    hookDlgAddUsersToGroup();
    hookRemoveUsersFromGroup();
    disableRemoveButton();
    hookCloseDlgExceptionDialog();
    hookShowDlgStackButton();
    /*TAB 3 - Csv Import*/
    AJS.$('#csum-upload-spinner').hide();
    hookCSVUpload();
    getAllTasks();
    hookTableActions();
    startAutoRefresh();
    /*TAB 3 - Csv Export*/
    getCurrentSpaceGroupsRest();
    hookCheckAllGroups();
    setupChangeExportActionParams();
    changeExportActionParams();
    /*TAB 4 - Audit Log*/
    AJS.$('#csum-auditing').width("100%");
    startAuditingAutoRefresh();
    /*TAB 5 - Clone*/
    hookSpacePicker();
    hookCheckAll();
    hookGetGroups();
    hookSubmitClone();
    hookCloseCloneDialog();
    hookCloneShowStackButton();
});