/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.rest;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.access.annotations.RequiresLicensedConfluenceAccess;
import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.whitelist.OutboundWhitelist;
import com.pluginpeople.confluence.csum.ao.CSUMLdapConfigEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.LdapDetailsDTO;
import com.pluginpeople.confluence.csum.api.beans.LDAPQueryResultList;
import com.pluginpeople.confluence.csum.ldap.LDAPException;
import com.pluginpeople.confluence.csum.ldap.LDAPLookupUtil;
import com.pluginpeople.confluence.csum.ldap.LdapValidator;
import com.pluginpeople.confluence.csum.rest.AbstractCSUMRestResource;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import javax.naming.CommunicationException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"application/json"})
@ReadOnlyAccessAllowed
@Path(value="/ldap")
@RequiresLicensedConfluenceAccess
public class LDAPResource
extends AbstractCSUMRestResource {
    protected static final Logger LOG = LoggerFactory.getLogger(LDAPResource.class);
    private ICSUMActiveObjectService fAo;
    private OutboundWhitelist fOutboundAllowlist;

    public LDAPResource(ICSUMActiveObjectService activeObjectService, XsrfTokenService tokenService, @ComponentImport OutboundWhitelist outboundAllowlist, @ComponentImport SpaceManager spaceManager, CSUMPermissionUtil permissionUtil, PermissionManager permissionManager, ICSUMCacheManager cacheManager) {
        super(spaceManager, permissionUtil, tokenService, permissionManager, cacheManager);
        this.fAo = activeObjectService;
        this.fOutboundAllowlist = outboundAllowlist;
    }

    @POST
    @Path(value="/query")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response queryLdap(@Context HttpServletRequest hsr, @QueryParam(value="atl_token") String atl_token, @FormParam(value="ldapFilterConfig") String ldapFilterConfig, @FormParam(value="ldapFilter") String ldapFilter, @FormParam(value="requiredAttributes") String requiredAttributes, @FormParam(value="maxResults") String maxResults, @FormParam(value="expandAttributes") String expandAttributes) {
        Object trimmed;
        if (!this.isCurrentUserAdminOrSystemAdmin() || this.isTokenInvalid(hsr)) {
            return Response.noContent().status(Response.Status.UNAUTHORIZED).build();
        }
        String[] expandAttributesArr = null;
        if (expandAttributes != null && expandAttributes.trim().length() > 0) {
            expandAttributesArr = expandAttributes.split(",");
            for (int i = 0; i < expandAttributesArr.length; ++i) {
                expandAttributesArr[i] = expandAttributesArr[i].trim();
            }
        }
        String[] requiredAttributesArr = null;
        if (requiredAttributes != null && requiredAttributes.trim().length() > 0 && ((String)(trimmed = requiredAttributes.trim())).length() > 0) {
            String lc = ((String)trimmed).toLowerCase();
            if (!lc.contains("cn")) {
                trimmed = (String)trimmed + ",cn";
            }
            if (!lc.contains("distinguishedname")) {
                trimmed = (String)trimmed + ",distinguishedName";
            }
            if (!lc.contains("objectclass")) {
                trimmed = (String)trimmed + ",objectClass";
            }
            if (!lc.contains("mail")) {
                trimmed = (String)trimmed + ",mail";
            }
            if (expandAttributesArr != null) {
                StringBuilder sb = new StringBuilder((String)trimmed);
                for (String s : expandAttributesArr) {
                    if (lc.contains(s.toLowerCase())) continue;
                    sb.append(",").append(s);
                }
                trimmed = sb.toString();
            }
            requiredAttributesArr = ((String)trimmed).split(",");
            for (int i = 0; i < requiredAttributesArr.length; ++i) {
                requiredAttributesArr[i] = requiredAttributesArr[i].trim();
            }
        }
        long startTime = System.currentTimeMillis();
        CSUMLdapConfigEntity configEntity = this.fAo.getLdapConfigById(Integer.parseInt(ldapFilterConfig));
        if (configEntity != null) {
            LdapDetailsDTO dto = this.fAo.getLdapDto(configEntity);
            LdapValidator validator = new LdapValidator(dto, this.fOutboundAllowlist);
            try {
                validator.validateLdapServer();
                LDAPLookupUtil lookupUtil = new LDAPLookupUtil(dto);
                LDAPQueryResultList resultList = lookupUtil.runGroupExpandionQuery(ldapFilter.trim(), requiredAttributesArr, expandAttributesArr, Long.parseLong(maxResults));
                long queryTime = System.currentTimeMillis() - startTime;
                resultList.setQueryTime(queryTime);
                return Response.ok((Object)resultList, (String)"application/json").build();
            }
            catch (CommunicationException e) {
                LOG.error("Failed : " + e.getLocalizedMessage(), (Throwable)e);
                return Response.serverError().build();
            }
            catch (LDAPException e) {
                LOG.error("Failed : " + e.getLocalizedMessage(), (Throwable)e);
                return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)e.getLocalizedMessage()).build();
            }
        }
        return Response.serverError().build();
    }
}

