/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.integration;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.pluginpeople.confluence.csum.api.ITConfluenceUtil;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.auth.BasicScheme;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class ITConfluenceImpl
implements ITConfluenceUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ITConfluenceImpl.class);
    @ComponentImport
    private ApplicationProperties fAppProps;

    @Autowired
    public ITConfluenceImpl() {
    }

    public String getCurrentAtlassianTokenForClient(HttpClient client, String baseUrl) {
        String ret;
        HttpGet httpGet = new HttpGet(baseUrl);
        try {
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials("admin", "admin");
            httpGet.addHeader(new BasicScheme().authenticate((Credentials)creds, (HttpRequest)httpGet, null));
            try {
                HttpResponse response = client.execute((HttpUriRequest)httpGet);
                Document doc = Jsoup.parse((String)IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8));
                ret = doc.getElementById("atlassian-token").attributes().get("content");
            }
            catch (Exception e) {
                LOG.error("Unable to retrieve atlassian token:", (Throwable)e);
                ret = null;
            }
        }
        catch (AuthenticationException aue) {
            LOG.error("Unable to authenticate admin user.", (Throwable)aue);
            ret = null;
        }
        return ret;
    }
}

