/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.service.cache;

import com.atlassian.user.Group;
import com.pluginpeople.confluence.csum.service.cache.ICachedSpaceGroups;
import java.util.Iterator;
import java.util.List;

public class CSUMSpaceGroupsEntry
implements ICachedSpaceGroups {
    private String spaceKey;
    private String[] spaceGroups;

    public CSUMSpaceGroupsEntry(String spaceKey, List<Group> groups) {
        this.spaceKey = spaceKey.toLowerCase();
        if (groups != null) {
            this.spaceGroups = new String[groups.size()];
            int i = 0;
            Iterator<Group> iterator = groups.iterator();
            while (iterator.hasNext()) {
                this.spaceGroups[i++] = iterator.next().getName();
            }
        }
    }

    public CSUMSpaceGroupsEntry(String spaceKey, String[] updatedGroups) {
        this.spaceKey = spaceKey;
        this.spaceGroups = updatedGroups;
    }

    @Override
    public String getSpaceKey() {
        return this.spaceKey;
    }

    @Override
    public String[] getSpaceGroups() {
        return this.spaceGroups;
    }

    @Override
    public String[] getPagedSpaceGroups(int maxGroupRetrieval, int offset) {
        String[] foundGroups = new String[maxGroupRetrieval];
        int count = 0;
        for (int i = 0; i < maxGroupRetrieval; ++i) {
            if (offset + i >= this.spaceGroups.length) continue;
            foundGroups[i] = this.spaceGroups[offset + i];
            ++count;
        }
        String[] ret = new String[count];
        System.arraycopy(foundGroups, 0, ret, 0, count);
        return ret;
    }

    @Override
    public void setSpaceGroups(String[] spaceGroups) {
        this.spaceGroups = spaceGroups;
    }
}

