/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.action;

import com.atlassian.confluence.compat.api.service.accessmode.AccessModeCompatService;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.i18n.Message;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.fugue.Maybe;
import com.atlassian.plugins.whitelist.OutboundWhitelist;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.pluginpeople.confluence.csum.action.AbstractCSUMConfigAction;
import com.pluginpeople.confluence.csum.action.ICSUMDataDefs;
import com.pluginpeople.confluence.csum.ao.CSUMAuditEntity;
import com.pluginpeople.confluence.csum.ao.CSUMConfigEntity;
import com.pluginpeople.confluence.csum.ao.CSUMLdapConfigEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.LdapDetailsDTO;
import com.pluginpeople.confluence.csum.api.beans.ConfigBean;
import com.pluginpeople.confluence.csum.ldap.DTObuilder;
import com.pluginpeople.confluence.csum.ldap.LDAPException;
import com.pluginpeople.confluence.csum.ldap.LDAPHydrationManager;
import com.pluginpeople.confluence.csum.ldap.LdapConfigComparator;
import com.pluginpeople.confluence.csum.ldap.LdapItemBean;
import com.pluginpeople.confluence.csum.ldap.LdapValidator;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.naming.CommunicationException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.bind.JAXBException;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSUMConfigAction
extends AbstractCSUMConfigAction {
    private static final Logger LOG = LoggerFactory.getLogger(CSUMConfigAction.class);
    private static final String DELETING_OLD_AUDIT = "Deleting old CSUM audit history";
    private static final String USER_NOT_GLOBAL_ADMIN = "User is not a global admin";
    private static final String LDAP_EXAMPLE_DIR = "csum/ldap-templates";
    private static final String ON = "on";
    private static final String CRLF = "\r\n";
    private static final String C = ",";
    private static final String Q = "\"";
    private static final String COMMA = ",";
    private static final String SPACE = " ";
    private static final String SPACEKEY = "spacekey";
    private static final String EXPORT_ERROR = "exportError";
    private ICSUMCacheManager fCacheManager;
    private boolean fGroupActionsPermitted;
    private boolean fGroupAddRemovePermitted;
    private boolean fGroupRenamePermitted;
    private boolean fRenameGlobalPermitted;
    private String fCleanSpacePermsSelected;
    private String fCleanPagePermsSelected;
    private boolean fRemoveUserFromPermGrpPerm;
    private boolean fDlgGrpActPerm;
    private String fGroupPrefixPattern;
    private boolean fPluginDown;
    private String fGroupSuffixPattern;
    private boolean fUserSearchEnabled;
    private boolean fPersonalSpaceAllowed;
    private Integer fMaxUserIDsLimit;
    private Integer fMaxGroupIDsLimit;
    private String fJiraRestUrl;
    private String fJiraRestUsername;
    private String fJiraRestPassword;
    private String fPluginDownMsg;
    private String fKey;
    private String fAutoJoinGroups;
    private XsrfTokenService fTokenService;
    private File fConfluenceLocalHome;
    private CrowdDirectoryService fCrowdDirectoryService;
    private String fUserDirectories;
    private List<Directory> fAvailableUserDirectories;
    private String fFullNameFormat;
    private boolean fSelectDirectories;
    private boolean fIgnorePermissionCheck;
    private String fBlocklistGroups;
    private String fGroupFilter;
    private String fGroupFilterBehavior;
    private boolean fHideUserOperations;
    private boolean fHideGroupOperations;
    private boolean fAllowAdminDeleteAudits;
    private boolean fGroupPageProcessing;
    private boolean fUserPageProcessing;
    private boolean fLdapValidateOnSave;
    private transient CSUMLdapConfigEntity[] fLdapConfigs;
    private final transient Map<LdapDetailsDTO, Map<String, String>> fLdapValidationErrors = new HashMap<LdapDetailsDTO, Map<String, String>>();
    private ICSUMDataDefs.DISABLED_USER_HANDLING fDisabledUserHandling = ICSUMDataDefs.DISABLED_USER_HANDLING.show;
    private boolean fIsEdit = false;
    private boolean fIsCreate;
    private boolean fIsImport;
    private boolean fIsExport;
    private String fLdapConfigName;
    private String fLdapHostname;
    private int fLdapPort;
    private boolean fLdapUseSSL;
    private String fLdapUsername;
    private String fLdapPassword;
    private String fLdapBaseDN;
    private String fLdapAdditionalUserDN;
    private String fLdapAdditionalGroupDN;
    private String fLdapObjectClass;
    private String fLdapObjectFilter;
    private String fLdapUserAttr;
    private String fLdapUserRDNAttr;
    private String fLdapUserFirstNameAttr;
    private String fLdapUserLastNameAttr;
    private String fLdapUserDisplayNameAttr;
    private String fLdapUserEmailAttr;
    private String fLdapUserPasswordAttr;
    private boolean fLdapUsePagedResults;
    private int fLdapResultsPerPage;
    private int fLdapSearchTimeout;
    private int fLdapConnectionTimeout;
    private String fLdapTestLookupUsername;
    private int fConfigId = 0;
    private boolean fImportOK;
    private String fLdapEquivalentDomains;
    private int fSortOrder;
    private String fExtLdapDirectories;
    private boolean fCreateUsersEnabled;
    private AccessModeCompatService fAccessModeCompatService;
    private OutboundWhitelist fOutboundAllowlist;
    private String fSelectedSpaceKey;

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        super.setBootstrapManager(bootstrapManager);
        this.fConfluenceLocalHome = bootstrapManager.getLocalHome();
    }

    public void setOutboundWhitelist(OutboundWhitelist outboundWhitelist) {
        this.fOutboundAllowlist = outboundWhitelist;
    }

    public void setXsrfTokenService(XsrfTokenService xsrfTokenService) {
        this.fTokenService = xsrfTokenService;
    }

    public void setICSUMCacheManager(ICSUMCacheManager cacheManager) {
        this.fCacheManager = cacheManager;
    }

    public void setAccessModeCompatService(AccessModeCompatService compatService) {
        this.fAccessModeCompatService = compatService;
    }

    public void setCrowdDirectoryService(CrowdDirectoryService crowdDirectoryService) {
        this.fCrowdDirectoryService = crowdDirectoryService;
    }

    public void setSelectedSpaceKey(String key) {
        this.fSelectedSpaceKey = key;
    }

    public String getSelectedSpaceKey() {
        return this.fSelectedSpaceKey;
    }

    @Override
    public String doDefault() {
        String ret = "input";
        LOG.debug("CustomPermissionConfigAction - VIEW");
        CSUMConfigEntity config = this.getConfig();
        if (this.isPermitted()) {
            config.setJiraRestPassword(null);
            this.fLdapConfigs = this.getLDAPConfigurations();
            for (int i = 0; i < this.fLdapConfigs.length; ++i) {
                CSUMLdapConfigEntity ldapConfig = this.fLdapConfigs[i];
                LdapDetailsDTO dto = new LdapDetailsDTO();
                try {
                    DTObuilder.updateDto(ldapConfig, dto);
                    LdapValidator validator = new LdapValidator(dto, this.fOutboundAllowlist);
                    validator.validateLdapServer();
                    continue;
                }
                catch (LDAPException | CommunicationException e) {
                    HashMap<String, CallSite> msgs = new HashMap<String, CallSite>();
                    msgs.put("allowlist", (CallSite)((Object)("LDAP Configuration not valid or allowed: " + e.getLocalizedMessage())));
                    this.fLdapValidationErrors.put(dto, msgs);
                    this.addActionError("LDAPException: " + e.getLocalizedMessage());
                }
            }
            ret = "success";
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doGenerateCsvAuditReport() {
        String ret = "success";
        LOG.debug("doGenerateCsvAuditReport - UPDATE");
        File f = null;
        try {
            f = File.createTempFile("csum", "csv", new File(this.fConfluenceLocalHome, "temp"));
            if (!f.exists()) {
                String path = f.getAbsolutePath();
                LOG.error("Unable to create temp file (check local home permissions) : " + path);
            } else {
                this.writeDataToFile(f);
                if (f.length() > 0L) {
                    ret = this.writeOutResponse(f);
                }
            }
        }
        catch (IOException e) {
            LOG.error("Error writing csv audit data", (Throwable)e);
        }
        finally {
            if (f != null) {
                try {
                    Files.delete(f.toPath());
                }
                catch (IOException e) {
                    LOG.error("Unable to delete temp csv audit file: " + f.getAbsolutePath(), (Throwable)e);
                }
            }
        }
        return ret;
    }

    private void writeDataToFile(File f) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(f);){
            boolean personalSpaceAllowed = this.getConfig().isPersonalSpaceAllowed();
            this.addSpaceEventHeaders(fos);
            List allSpaces = this.getSpaceManager().getAllSpaces();
            ICSUMActiveObjectService ao = this.getAo();
            for (Space aSpace : allSpaces) {
                if (aSpace.isPersonal() && !personalSpaceAllowed) continue;
                CSUMAuditEntity[] spaceEvents = ao.getAuditEvents(aSpace);
                if (spaceEvents != null && spaceEvents.length > 0) {
                    LOG.debug("Processing " + spaceEvents.length + " events from Space: " + (aSpace.getKey() != null ? aSpace.getKey() : "null"));
                    this.writeSpaceEventData(fos, spaceEvents);
                    continue;
                }
                LOG.debug("No audit events found for Space: " + (aSpace.getKey() != null ? aSpace.getKey() : "null"));
            }
        }
    }

    private String writeOutResponse(File f) {
        String ret;
        HttpServletResponse response = ServletActionContext.getResponse();
        try (FileInputStream fis = new FileInputStream(f);
             ServletOutputStream os = response.getOutputStream();){
            byte[] data = IOUtils.toByteArray((InputStream)fis);
            String filename = "csum-auditing-" + new Timestamp(System.currentTimeMillis()).toLocalDateTime().toString().replace(":", "_") + ".csv";
            response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + Q);
            response.setContentType("text/csv");
            response.setContentLength(data.length);
            response.setStatus(200);
            os.write(data);
            os.flush();
            ret = null;
        }
        catch (IOException e) {
            LOG.error("A problem occurred during Auditing CSV export", (Throwable)e);
            ret = "success";
        }
        return ret;
    }

    private void addSpaceEventHeaders(FileOutputStream fos) throws IOException {
        String csvline = "\"EV_ID\",\"EV_DATE\",\"EV_TIME\",\"EV_USER\",\"EV_TYPE\",\"EV_OUTCOME\",\"SPACE_KEY\",\"SPACE_NAME\",\"GROUP_NAME\",\"USER_NAME\",\"USER_FULLNAME\"\r\n";
        fos.write(csvline.getBytes());
    }

    private void writeSpaceEventData(OutputStream os, CSUMAuditEntity[] spaceEvents) throws IOException {
        for (CSUMAuditEntity e : spaceEvents) {
            StringBuilder csvline = new StringBuilder();
            csvline.append(e.getID());
            String eTs = e.getCreatedDate() != null ? e.getCreatedDate().toLocalDateTime().toString() : "";
            csvline.append(",").append(eTs, 0, eTs.indexOf(84));
            if (eTs.indexOf(46) != -1) {
                csvline.append(",").append(eTs, eTs.indexOf(84) + 1, eTs.lastIndexOf(46));
            } else {
                csvline.append(",").append(eTs.substring(eTs.indexOf(84) + 1));
            }
            ConfluenceUser createdBy = this.getUserAccessor().getUserByKey(new UserKey(e.getCreatedByUserKey()));
            csvline.append(",").append(createdBy != null ? createdBy.getName() : "");
            String rawOperationType = e.getOperationType() != null ? e.getOperationType() : "";
            csvline.append(",").append(rawOperationType.replace(",", SPACE));
            String rawEventOutcome = e.getEventOutcome() != null ? e.getEventOutcome() : "";
            csvline.append(",").append(rawEventOutcome.replace(",", SPACE));
            String rawSpaceKey = e.getSpaceKey() != null ? e.getSpaceKey() : "";
            csvline.append(",").append(rawSpaceKey);
            csvline.append(",").append(rawSpaceKey.replace(",", SPACE));
            String rawGroupName = e.getGroupName() != null ? e.getGroupName() : "";
            csvline.append(",").append(rawGroupName.replace(",", SPACE));
            ConfluenceUser contextUser = null;
            if (e.getContextUserKey() != null) {
                contextUser = this.getUserAccessor().getUserByKey(new UserKey(e.getContextUserKey()));
            }
            if (contextUser != null) {
                csvline.append(",").append(contextUser.getName());
                String fullname = contextUser.getFullName();
                if (fullname != null) {
                    csvline.append(",").append(fullname.replace(",", SPACE));
                } else {
                    csvline.append(",");
                }
            } else {
                csvline.append(",,");
            }
            csvline.append(CRLF);
            os.write(csvline.toString().getBytes(StandardCharsets.UTF_8));
        }
    }

    public String doUpdate() {
        String ret = "success";
        LOG.debug("CustomPermissionConfigAction - UPDATE");
        HttpServletRequest request = ServletActionContext.getRequest();
        Maybe m = this.fTokenService.validate(request);
        Message got = (Message)m.getOrNull();
        if (got != null) {
            return "error";
        }
        if (this.isValidConfig()) {
            this.applyFormValues();
            ArrayList<String> successMessages = new ArrayList<String>();
            successMessages.add(this.getText("updated.word"));
            this.setActionMessages(successMessages);
            this.getAo().createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.systemConfigUpdated, ICSUMActiveObjectService.CSUMAuditEventOutcome.success, null, null, null, this.getAuthenticatedUser().getName(), "configuration updated", null, null);
        } else {
            ret = "error";
        }
        return ret;
    }

    private boolean isValidConfig() {
        boolean groupSuffixHasSpacekey;
        boolean valid = true;
        ArrayList<String> errorsForSummary = new ArrayList<String>();
        if (this.fMaxUserIDsLimit != null && this.fMaxUserIDsLimit < 0) {
            valid = false;
            this.addFieldError("maxUserIDsLimit", this.getText("csum.configure.error.notValidInteger"));
        }
        if (this.fMaxGroupIDsLimit != null && this.fMaxGroupIDsLimit < 0) {
            valid = false;
            this.addFieldError("maxGroupIDsLimit", this.getText("csum.configure.error.notValidInteger"));
        }
        if (!valid) {
            errorsForSummary.add(this.getText("csum.configure.error.changesNeeded", new String[]{String.valueOf(this.getFieldErrors().size())}));
            this.setActionErrors(errorsForSummary);
        }
        if (this.fSelectDirectories && this.fUserDirectories == null) {
            errorsForSummary.add(this.getText("csum.configure.error.userDirectoriesRequired"));
            this.setActionErrors(errorsForSummary);
        }
        boolean groupPrefixHasSpacekey = this.fGroupPrefixPattern != null && this.fGroupPrefixPattern.toLowerCase().contains(SPACEKEY);
        boolean bl = groupSuffixHasSpacekey = this.fGroupSuffixPattern != null && this.fGroupSuffixPattern.toLowerCase().contains(SPACEKEY);
        if (!groupPrefixHasSpacekey && !groupSuffixHasSpacekey) {
            errorsForSummary.add(this.getText("csum.configure.error.nospacekey"));
            this.setActionErrors(errorsForSummary);
        }
        if (this.fHideUserOperations && this.fHideGroupOperations) {
            valid = false;
            this.addFieldError("hideGroupOperations", this.getText("csum.configure.error.hide.operations"));
            this.addFieldError("hideUserOperations", this.getText("csum.configure.error.hide.operations"));
            errorsForSummary.add(this.getText("csum.configure.error.changesNeeded", new String[]{String.valueOf(this.getFieldErrors().size())}));
            this.setActionErrors(errorsForSummary);
        }
        return valid;
    }

    public String doClearCache() {
        this.fCacheManager.flushAll();
        return "success";
    }

    public void applyFormValues() {
        CSUMConfigEntity config = this.getConfig();
        String oldPrefix = config.getGroupPrefixPattern();
        String oldSuffix = config.getGroupSuffixPattern();
        config.setJiraRestUrl(this.fJiraRestUrl);
        config.setJiraRestPassword(this.fJiraRestPassword);
        config.setJiraRestUsername(this.fJiraRestUsername);
        config.setGroupActionsPermitted(this.fGroupActionsPermitted);
        config.setGroupAddRemovePermitted(this.fGroupAddRemovePermitted);
        config.setGroupRenamePermitted(this.fGroupRenamePermitted);
        config.setRenameGlobalPermitted(this.fRenameGlobalPermitted);
        config.setCleanSpacePermsSelected(this.fCleanSpacePermsSelected);
        config.setCleanPagePermsSelected(this.fCleanPagePermsSelected);
        config.setRemoveUserFromPermGrpPerm(this.fRemoveUserFromPermGrpPerm);
        config.setDlgGrpActPerm(this.fDlgGrpActPerm);
        config.setGroupPrefixPattern(this.fGroupPrefixPattern);
        config.setGroupSuffixPattern(this.fGroupSuffixPattern);
        config.setMaxGroupIDsLimit(this.fMaxGroupIDsLimit != null ? this.fMaxGroupIDsLimit : 0);
        config.setMaxUserIDsLimit(this.fMaxUserIDsLimit != null ? this.fMaxUserIDsLimit : 0);
        config.setUserSearchEnabled(this.fUserSearchEnabled);
        config.setCreateUsersEnabled(this.fCreateUsersEnabled);
        config.setFullNameFormat(this.fFullNameFormat);
        config.setPersonalSpaceAllowed(this.fPersonalSpaceAllowed);
        config.setPluginDown(this.fPluginDown);
        config.setPluginDownMsg(this.fPluginDownMsg);
        config.setDisabledUserHandling(this.fDisabledUserHandling.name());
        config.setBlocklistGroups(!this.fBlocklistGroups.equalsIgnoreCase("") ? this.fBlocklistGroups : "none");
        config.setGroupFilter(!this.fGroupFilter.equalsIgnoreCase("") ? this.fGroupFilter : "none");
        config.setGroupFilterBehavior(this.fGroupFilterBehavior != null);
        config.setAutoJoinGroups(this.fAutoJoinGroups);
        config.setGroupPageProcessing(this.fGroupPageProcessing);
        config.setUserPageProcessing(this.fUserPageProcessing);
        config.setSelectDirectories(this.fSelectDirectories);
        config.setIgnorePermissionCheck(this.fIgnorePermissionCheck);
        config.setUserDirectories(this.fUserDirectories);
        config.setExtLdapDirectories(this.fExtLdapDirectories);
        config.setHideUserOperations(this.fHideUserOperations);
        config.setHideGroupOperations(this.fHideGroupOperations);
        config.setAllowAdminDeleteAudits(this.fAllowAdminDeleteAudits);
        config.save();
        this.fCacheManager.updateCachedConfig(config);
        if (!Objects.equals(oldPrefix, this.fGroupPrefixPattern) || !Objects.equals(oldSuffix, this.fGroupSuffixPattern)) {
            this.fCacheManager.flushAll();
        }
    }

    public String getActionName(String fullClassName) {
        return "Configure Custom Space User Management Plugin";
    }

    public List<Space> getSpaces() {
        return this.getSpaceManager().getAllSpaces();
    }

    public ICSUMActiveObjectService.CSUMOperationType[] getOperations() {
        return ICSUMActiveObjectService.CSUMOperationType.values();
    }

    public String doDeleteOldHistory() {
        String ret = null;
        ConfluenceUser currentUser = this.getAuthenticatedUser();
        if (this.permissionManager.isConfluenceAdministrator((User)currentUser)) {
            LOG.info(DELETING_OLD_AUDIT);
            this.getAo().deleteAllAuditEntities(30);
            ret = "success";
        } else {
            this.addActionError(USER_NOT_GLOBAL_ADMIN);
            ret = "error";
        }
        return ret;
    }

    public String doDeleteAllHistory() {
        String ret;
        ConfluenceUser currentUser = this.getAuthenticatedUser();
        if (this.permissionManager.isConfluenceAdministrator((User)currentUser)) {
            LOG.info(DELETING_OLD_AUDIT);
            this.getAo().deleteAllAuditEntities(0);
            ret = "success";
        } else {
            this.addActionError(USER_NOT_GLOBAL_ADMIN);
            ret = "error";
        }
        return ret;
    }

    public String doDeleteAllHistoryForSpace() {
        String ret;
        String selectedSpaceKey = this.getSelectedSpaceKey();
        if (selectedSpaceKey != null) {
            Space space = this.getSpaceManager().getSpace(selectedSpaceKey);
            if (space != null) {
                ConfluenceUser currentUser = this.getAuthenticatedUser();
                if (this.fPermissionManager.isConfluenceAdministrator((User)currentUser) || this.fPermissionManager.hasPermission((User)currentUser, Permission.ADMINISTER, (Object)space)) {
                    LOG.info(DELETING_OLD_AUDIT);
                    int i = this.fAos.deleteAllAuditEntitiesForSpace(space);
                    LOG.info("Completed deletion of " + i + " records for space: " + space.getLowerKey());
                    ret = "success";
                } else {
                    this.addActionError(USER_NOT_GLOBAL_ADMIN);
                    ret = "error";
                }
            } else {
                this.addActionError("No Space found");
                ret = "error";
            }
        } else {
            this.addActionError("No Space Key found");
            ret = "error";
        }
        return ret;
    }

    public int sizeof(String[] arr) {
        return arr.length;
    }

    public String encodeGroupName(String groupName) {
        groupName = groupName != null ? URLEncoder.encode(groupName) : "null";
        return groupName;
    }

    public String doDeleteCachedSpaceGroup() {
        String ret = null;
        ConfluenceUser currentUser = this.getAuthenticatedUser();
        if (this.permissionManager.isConfluenceAdministrator((User)currentUser)) {
            Space aSpace = this.getSpaceManager().getSpace(this.fKey);
            if (aSpace != null) {
                this.fCacheManager.deleteSpaceGroups(aSpace);
            }
            ret = "success";
        } else {
            this.addActionError(USER_NOT_GLOBAL_ADMIN);
            ret = "error";
        }
        return ret;
    }

    public String doRefreshAllSpaceGroups() {
        String ret = null;
        ConfluenceUser currentUser = this.getAuthenticatedUser();
        if (this.permissionManager.isConfluenceAdministrator((User)currentUser)) {
            this.fCacheManager.deleteAllSpaceGroups();
            List allSpaces = this.getSpaceManager().getAllSpaces();
            for (Space aSpace : allSpaces) {
                if (aSpace == null) continue;
                this.fCacheManager.getSpaceGroups(aSpace);
            }
            ret = "success";
        } else {
            this.addActionError(USER_NOT_GLOBAL_ADMIN);
            ret = "error";
        }
        return ret;
    }

    public String doRefreshCachedSpaceGroup() {
        String ret = null;
        ConfluenceUser currentUser = this.getAuthenticatedUser();
        if (this.permissionManager.isConfluenceAdministrator((User)currentUser)) {
            Space aSpace = this.getSpaceManager().getSpace(this.fKey);
            if (aSpace != null) {
                this.fCacheManager.deleteSpaceGroups(aSpace);
                this.fCacheManager.getSpaceGroups(aSpace);
            }
            ret = "success";
        } else {
            this.addActionError(USER_NOT_GLOBAL_ADMIN);
            ret = "error";
        }
        return ret;
    }

    public void setKey(String key) {
        this.fKey = this.getNulled(key);
    }

    public void setGroupName(String groupName) {
    }

    public void setPluginDown(boolean isDown) {
        this.fPluginDown = isDown;
    }

    public void setPluginDownMsg(String pluginDownMsg) {
        this.fPluginDownMsg = this.getNulled(pluginDownMsg);
    }

    public void setGroupActionsPermitted(boolean isGroupActionsPermitted) {
        this.fGroupActionsPermitted = isGroupActionsPermitted;
    }

    public void setGroupAddRemovePermitted(boolean isGroupAddRemovePermitted) {
        this.fGroupAddRemovePermitted = isGroupAddRemovePermitted;
    }

    public void setGroupRenamePermitted(boolean isGroupRenamePermitted) {
        this.fGroupRenamePermitted = isGroupRenamePermitted;
    }

    public void setRenameGlobalPermitted(boolean isRenameGlobalPermitted) {
        this.fRenameGlobalPermitted = isRenameGlobalPermitted;
    }

    public void setCleanSpacePermsSelected(String cleanSpacePermsSelected) {
        this.fCleanSpacePermsSelected = this.getNulled(cleanSpacePermsSelected);
    }

    public void setCleanPagePermsSelected(String cleanPagePermsSelected) {
        this.fCleanPagePermsSelected = this.getNulled(cleanPagePermsSelected);
    }

    public void setRemoveUserFromPermGrpPerm(boolean isRemoveUserFromPermGrpPerm) {
        this.fRemoveUserFromPermGrpPerm = isRemoveUserFromPermGrpPerm;
    }

    public void setDlgGrpActPerm(boolean isDlgGrpActPerm) {
        this.fDlgGrpActPerm = isDlgGrpActPerm;
    }

    public void setGroupPrefixPattern(String newGroupNameCreationPrefixPattern) {
        this.fGroupPrefixPattern = this.getNulled(newGroupNameCreationPrefixPattern);
        if (this.fGroupPrefixPattern != null) {
            this.fGroupPrefixPattern = this.fGroupPrefixPattern.toLowerCase().replace(SPACEKEY, "SPACEKEY");
        }
    }

    public void setGroupSuffixPattern(String newGroupNameCreationSuffixPattern) {
        this.fGroupSuffixPattern = this.getNulled(newGroupNameCreationSuffixPattern);
        if (this.fGroupSuffixPattern != null) {
            this.fGroupSuffixPattern = this.fGroupSuffixPattern.toLowerCase().replace(SPACEKEY, "SPACEKEY");
        }
    }

    public void setUserSearchEnabled(boolean userSearchEnabled) {
        this.fUserSearchEnabled = userSearchEnabled;
    }

    public void setCreateUsersEnabled(boolean createUsers) {
        this.fCreateUsersEnabled = createUsers;
    }

    public void setPersonalSpaceAllowed(boolean allowed) {
        this.fPersonalSpaceAllowed = allowed;
    }

    public void setMaxUserIDsLimit(String maxUserIDsLimit) {
        try {
            this.fMaxUserIDsLimit = Integer.valueOf(maxUserIDsLimit);
        }
        catch (NumberFormatException e) {
            LOG.error("incorrect number format", (Throwable)e);
            this.fMaxUserIDsLimit = -1;
        }
    }

    public void setMaxGroupIDsLimit(String maxGroupIDsLimit) {
        try {
            this.fMaxGroupIDsLimit = Integer.valueOf(maxGroupIDsLimit);
        }
        catch (NumberFormatException e) {
            LOG.error("incorrect number format", (Throwable)e);
            this.fMaxGroupIDsLimit = -1;
        }
    }

    public void setHideUserOperations(boolean hideUserOperations) {
        this.fHideUserOperations = hideUserOperations;
    }

    public void setHideGroupOperations(boolean hideGroupOperations) {
        this.fHideGroupOperations = hideGroupOperations;
    }

    public boolean isAllowAdminDeleteAudits() {
        return this.fAllowAdminDeleteAudits;
    }

    public void setAllowAdminDeleteAudits(boolean allowPermission) {
        this.fAllowAdminDeleteAudits = allowPermission;
    }

    public void setGroupPageProcessing(boolean isGroupPageProcessing) {
        this.fGroupPageProcessing = isGroupPageProcessing;
    }

    public void setUserPageProcessing(boolean isUserPageProcessing) {
        this.fUserPageProcessing = isUserPageProcessing;
    }

    public void setJiraRestUrl(String jiraRestUrl) {
        this.fJiraRestUrl = this.getNulled(jiraRestUrl);
    }

    public void setJiraRestUsername(String jiraRestUsername) {
        this.fJiraRestUsername = this.getNulled(jiraRestUsername);
    }

    public void setJiraRestPassword(String jiraRestPassword) {
        this.fJiraRestPassword = this.getNulled(jiraRestPassword);
    }

    public int getLengthOf(String[] arr) {
        return arr != null ? arr.length : 0;
    }

    public void setAutoJoinGroups(String groups) {
        String groupStr = this.getNulled(groups);
        if (groupStr != null) {
            this.fAutoJoinGroups = groupStr;
        }
    }

    public List<Directory> getAvailableUserDirectories() {
        if (this.fAvailableUserDirectories == null) {
            this.fAvailableUserDirectories = this.fCrowdDirectoryService.findAllDirectories();
            for (Directory directory : this.fAvailableUserDirectories) {
                Set ops = directory.getAllowedOperations();
                for (OperationType op : ops) {
                    LOG.debug("Directory " + (directory.getName() != null ? directory.getName() : "null") + " supports operation: " + (op.getName() != null ? op.getName() : "null"));
                }
            }
        }
        return this.fAvailableUserDirectories;
    }

    public ConfigBean.FULL_NAME_FORMAT[] getAvailableFullNameFormats() {
        return ConfigBean.FULL_NAME_FORMAT.values();
    }

    public void setFullNameFormat(String fullNameFormat) {
        this.fFullNameFormat = fullNameFormat;
    }

    public RepositoryIdentifier getUserDirectoryForCreation() {
        return this.getUserManager().getIdentifier();
    }

    public boolean isUserDirectorySelected(Long aRepoId) {
        CSUMConfigEntity config = this.getConfig();
        String csvIds = config.getUserDirectories();
        if (!config.isSelectDirectories() || csvIds == null || csvIds.isEmpty()) {
            return false;
        }
        boolean isSelected = false;
        String[] idSplit = csvIds.split(",");
        List<Directory> directories = this.getAvailableUserDirectories();
        for (Directory aDirectory : directories) {
            Long dirId = aDirectory.getId();
            if (dirId.equals(aRepoId)) {
                for (String id : idSplit) {
                    if (dirId != Long.parseLong(id)) continue;
                    isSelected = true;
                    break;
                }
            }
            if (!isSelected) continue;
            break;
        }
        return isSelected;
    }

    public void setSelectDirectories(String value) {
        this.fSelectDirectories = Boolean.parseBoolean(value);
    }

    public void setIgnorePermissionCheck(String value) {
        this.fIgnorePermissionCheck = Boolean.parseBoolean(value);
    }

    public void setUserDirectories(String[] values) {
        if (values.length == 0) {
            this.fUserDirectories = null;
        } else {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < values.length; ++j) {
                sb.append(values[j]);
                if (j + 1 >= values.length) continue;
                sb.append(',');
            }
            this.fUserDirectories = sb.toString();
        }
    }

    public void setExternalLdapDirectories(String[] values) {
        if (values.length == 0) {
            this.fExtLdapDirectories = null;
        } else {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < values.length; ++j) {
                sb.append(values[j]);
                if (j + 1 >= values.length) continue;
                sb.append(',');
            }
            this.fExtLdapDirectories = sb.toString();
        }
    }

    public boolean isEditLdapAction() {
        return this.fIsEdit;
    }

    public boolean isCreateAction() {
        return this.fIsCreate;
    }

    public boolean isImportAction() {
        return this.fIsImport;
    }

    public boolean isExportAction() {
        return this.fIsExport;
    }

    public String doEditLdap() {
        String ret = "error";
        this.fIsEdit = true;
        if (this.isLicenseValid()) {
            this.fLdapConfigs = this.getLDAPConfigurations();
            ret = "success";
        }
        return ret;
    }

    public String doUpdateLdap() {
        String ret = "error";
        if (this.isLicenseValid() && this.fConfigId > 0 && this.updateLdapConfig()) {
            this.fLdapConfigs = this.getLDAPConfigurations();
            ret = "success";
        }
        return ret;
    }

    private LdapItemBean buildDto() {
        LdapItemBean dto = new LdapItemBean();
        dto.setSortOrder(this.fSortOrder);
        dto.setLdapConfigName(this.fLdapConfigName);
        dto.setHostname(this.fLdapHostname);
        dto.setPort(this.fLdapPort);
        dto.setUseSSL(this.fLdapUseSSL);
        dto.setUsername(this.fLdapUsername);
        dto.setPassword(this.fLdapPassword);
        dto.setBaseDN(this.fLdapBaseDN);
        dto.setAdditionalUserDN(this.fLdapAdditionalUserDN);
        dto.setAdditionalGroupDN(this.fLdapAdditionalGroupDN);
        dto.setObjectClass(this.fLdapObjectClass);
        dto.setObjectFilter(this.fLdapObjectFilter);
        dto.setUsernameAttr(this.fLdapUserAttr);
        dto.setUserRDNAttr(this.fLdapUserRDNAttr);
        dto.setUserFirstNameAttr(this.fLdapUserFirstNameAttr);
        dto.setUserLastNameAttr(this.fLdapUserLastNameAttr);
        dto.setUserDisplayNameAttr(this.fLdapUserDisplayNameAttr);
        dto.setUserEmailAttr(this.fLdapUserEmailAttr);
        dto.setUserPasswordAttr(this.fLdapUserPasswordAttr);
        dto.setEquivalentMailDomains(this.fLdapEquivalentDomains);
        dto.setUsePagedResults(this.fLdapUsePagedResults);
        dto.setResultsPerPage(this.fLdapResultsPerPage);
        dto.setSearchTimeout(this.fLdapSearchTimeout);
        dto.setConnectionTimeout(this.fLdapConnectionTimeout);
        dto.setTestLookupUsername(this.fLdapTestLookupUsername);
        dto.setValidateOnSave(this.fLdapValidateOnSave);
        return dto;
    }

    public String doCreateNewAdLdap() throws JAXBException, IOException {
        String ret = null;
        if (this.isLicenseValid()) {
            String resourceName = "example-ldap-activedirectory.xml";
            String asXml = null;
            try (InputStream resourceAsStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("csum/ldap-templates/" + resourceName);){
                if (resourceAsStream != null) {
                    LOG.info("Creating by Active Directory example");
                    asXml = IOUtils.toString((InputStream)resourceAsStream, (Charset)StandardCharsets.UTF_8);
                }
            }
            if (asXml == null || asXml.isEmpty()) {
                this.addActionError("notfound", new Object[]{"The example file could not be found, please raise a bug report"});
            } else {
                LDAPHydrationManager pm = new LDAPHydrationManager(this.getAo());
                CSUMLdapConfigEntity configEntity = pm.restoreLDAPFromXml(asXml);
                this.fConfigId = configEntity.getID();
                this.fIsEdit = false;
            }
            ret = "success";
        }
        return ret;
    }

    public String doCreateNewApacheLdap() throws JAXBException, IOException {
        String ret = null;
        if (this.isLicenseValid()) {
            String resourceName = "example-ldap-apachedirectory.xml";
            String asXml = null;
            try (InputStream resourceAsStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("csum/ldap-templates/" + resourceName);){
                if (resourceAsStream != null) {
                    asXml = IOUtils.toString((InputStream)resourceAsStream, (Charset)StandardCharsets.UTF_8);
                }
            }
            if (asXml == null || asXml.isEmpty()) {
                this.addActionError("notfound", new Object[]{"The example file could not be found, please raise a bug report"});
            } else {
                LOG.info("Creating by Apache Directory example");
                LDAPHydrationManager pm = new LDAPHydrationManager(this.getAo());
                CSUMLdapConfigEntity configEntity = pm.restoreLDAPFromXml(asXml);
                this.fConfigId = configEntity.getID();
                this.fIsEdit = true;
            }
            ret = "input";
        }
        return ret;
    }

    public boolean isImportOK() {
        return this.fImportOK;
    }

    public String doImport() {
        String ret = null;
        if (this.isLicenseValid()) {
            this.fIsImport = true;
            ret = "input";
        }
        return ret;
    }

    public String doUploadLdapXML() {
        String ret;
        block16: {
            if (!this.isLicenseValid()) {
                return null;
            }
            ret = null;
            try {
                if (ServletFileUpload.isMultipartContent((HttpServletRequest)this.getCurrentRequest())) {
                    ServletFileUpload fileUpload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
                    HttpSession session = this.getCurrentSession();
                    if (session == null) {
                        throw new FileUploadException("HTTP session was found to be null");
                    }
                    List fileItems = fileUpload.parseRequest(this.getCurrentRequest());
                    if (!fileItems.isEmpty() && !((FileItem)fileItems.get(0)).isFormField()) {
                        String asXml;
                        DiskFileItem fileItem = (DiskFileItem)fileItems.get(0);
                        try (InputStream inputStream = fileItem.getInputStream();){
                            asXml = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                        }
                        if (asXml == null || asXml.length() == 0) {
                            this.addActionError("upload", new Object[]{"The upload was empty, unable to import."});
                        } else {
                            LDAPHydrationManager pm = new LDAPHydrationManager(this.getAo());
                            pm.restoreLDAPFromXml(asXml);
                            ServletActionContext.getResponse().sendRedirect("viewconfig.action?importOK=true");
                        }
                        break block16;
                    }
                    throw new FileUploadException("No file was found as a result of parsing request");
                }
                throw new FileUploadException("Request does not contain multipart content");
            }
            catch (Exception e) {
                this.addActionError("uploadLdapFail", new Object[]{"Failed to upload the LDAP Config, something went wrong: " + e.getLocalizedMessage()});
                if (e.getCause() != null) {
                    this.addActionError("uploadFailCause", new Object[]{"Caused by: " + e.getCause().getLocalizedMessage()});
                }
                ret = "success";
            }
        }
        return ret;
    }

    public String doExportLdap() {
        String ret;
        block12: {
            ret = null;
            if (this.isLicenseValid()) {
                CSUMLdapConfigEntity ldapConfig = this.getLdapConfig();
                LDAPHydrationManager pm = new LDAPHydrationManager(this.getAo());
                try {
                    String xmlData = pm.exportLDAPAsXml(ldapConfig);
                    if (xmlData != null) {
                        byte[] data = xmlData.getBytes();
                        HttpServletResponse response = ServletActionContext.getResponse();
                        String filename = "csum-ldap-" + ldapConfig.getID() + ".xml";
                        response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + Q);
                        response.setContentType("application/octet-stream");
                        response.setContentLength(data.length);
                        response.setStatus(200);
                        try (ServletOutputStream os = response.getOutputStream();){
                            os.write(data);
                            os.flush();
                            response.sendRedirect("viewconfig.action");
                            break block12;
                        }
                        catch (IOException e) {
                            LOG.error("doExport failed due to an IOException: " + e.getLocalizedMessage(), (Throwable)e);
                            this.addActionError(EXPORT_ERROR, new Object[]{"A problem occurred during LDAP XML export (" + e.getLocalizedMessage() + ") , please check the logs and raise an issue"});
                            ret = "success";
                        }
                        break block12;
                    }
                    this.addActionError(EXPORT_ERROR, new Object[]{"Unable to generate LDAP export XML, please check the logs and raise an issue"});
                    ret = "success";
                }
                catch (JAXBException e) {
                    LOG.error("doExport failed due to a JAXBException: " + e.getLocalizedMessage(), (Throwable)e);
                    this.addActionError(EXPORT_ERROR, new Object[]{e.getLocalizedMessage()});
                    ret = "success";
                }
            }
        }
        return ret;
    }

    public String doDeleteLdap() {
        String ret = null;
        if (this.isLicenseValid()) {
            if (this.fConfigId > 0 && !this.isLdapConfigActive(this.fConfigId)) {
                CSUMLdapConfigEntity toDelete = this.getAo().getLdapConfigById(this.fConfigId);
                if (toDelete != null) {
                    this.getAo().delete(toDelete);
                } else {
                    String msg = "doDelete failed for entity#" + this.fConfigId + ", not found.";
                    LOG.error(msg);
                    this.addActionError("deleteError", new Object[]{msg});
                }
            }
            ret = "success";
        }
        return ret;
    }

    public String doCopyLdap() {
        String ret = null;
        if (this.isLicenseValid()) {
            if (this.fConfigId > 0) {
                this.getAo().copyLdapConfig(this.fConfigId);
            }
            ret = "success";
        }
        return ret;
    }

    public boolean hasLdapConfigs() {
        return this.fLdapConfigs != null && this.fLdapConfigs.length != 0;
    }

    public boolean isLdapConfigurationValid(CSUMLdapConfigEntity config) {
        boolean ret = false;
        LOG.info("isLdapConfigurationValid: " + (config != null ? config : "null"));
        if (config != null) {
            LdapDetailsDTO dto = new LdapDetailsDTO();
            try {
                DTObuilder.updateDto(config, dto);
                LdapValidator validator = new LdapValidator(dto, this.fOutboundAllowlist);
                validator.validateLdapServer();
                ret = this.isLdapConfigurationValid(dto, config.getAdditionalParams());
            }
            catch (LDAPException | CommunicationException e) {
                HashMap<String, CallSite> msgs = new HashMap<String, CallSite>();
                msgs.put("allowlist", (CallSite)((Object)("LDAP Configuration not valid or allowed: " + e.getLocalizedMessage())));
                this.fLdapValidationErrors.put(dto, msgs);
            }
        }
        return ret;
    }

    public boolean isLdapConfigurationValid(LdapDetailsDTO dto, String additionalParams) {
        LOG.info("isLdapConfigurationValid: " + (dto != null ? dto : "null") + " for [" + (dto != null ? (dto.getLdapConfigName() != null ? dto.getLdapConfigName() : "null") : "null") + "] : " + (dto != null ? (dto.getLdapHostname() != null ? dto.getLdapHostname() : "null") : "null") + ":" + (Serializable)(dto != null ? (dto.getLdapPort() != 0 ? Integer.valueOf(dto.getLdapPort()) : "0") : "null"));
        HashMap<String, Object> errors = new HashMap<String, Object>();
        boolean isValid = false;
        Properties p = new Properties();
        if (dto != null) {
            block19: {
                if (additionalParams != null) {
                    try {
                        p.load(new StringReader(additionalParams));
                        LOG.info("Loaded " + p.size() + " values from additional params");
                    }
                    catch (IOException e1) {
                        LOG.error("Unable to load ldap additional parameters as a property file: " + e1.getLocalizedMessage(), (Throwable)e1);
                        errors.put("ldap", "Unable to load additional params: " + e1.getLocalizedMessage());
                    }
                    HashMap<Object, String> additionalPropertiesMap = new HashMap<Object, String>();
                    for (Object o : p.keySet()) {
                        String string;
                        String aKey = (String)o;
                        if (aKey == null || (string = p.getProperty(aKey)) == null) continue;
                        additionalPropertiesMap.put(aKey, string);
                    }
                    dto.setLdapAdditionalParams(additionalPropertiesMap);
                }
                try {
                    if (dto.getLdapHostname() == null) {
                        errors.put("ldapHostname", "The hostname was empty");
                    }
                    if (dto.getLdapPort() == 0) {
                        errors.put("ldapPort", "The port was empty");
                    }
                    if (dto.getLdapPassword() != null && dto.getLdapPassword() == null) {
                        errors.put("ldapPassword", "Password is empty");
                    }
                    try {
                        int timeout = dto.getLdapConnectionTimeout();
                        if (timeout <= 0 || timeout > 300000) {
                            errors.put("ldapConnectionTimeout", "Connect timeout is not in the range: 0 > val < 300000 (5mins)");
                        }
                    }
                    catch (NumberFormatException nfe) {
                        errors.put("ldapConnectionTimeout", nfe.getLocalizedMessage());
                    }
                    try {
                        int timeout = dto.getLdapSearchTimeout();
                        if (timeout <= 0 || timeout > 300000) {
                            errors.put("ldapSearchTimeout", "search timeout is not in the range: 0 > val < 300000 (5mins)");
                        }
                    }
                    catch (NumberFormatException nfe) {
                        errors.put("ldapSearchTimeout", nfe.getLocalizedMessage());
                    }
                    Map<LdapDetailsDTO, Map<String, String>> validationErrors = this.getValidationErrors();
                    boolean thisConfigValidationError = false;
                    for (Map.Entry entry : validationErrors.entrySet()) {
                        LdapDetailsDTO key = (LdapDetailsDTO)entry.getKey();
                        if (dto.getID() != key.getID()) continue;
                        thisConfigValidationError = true;
                        break;
                    }
                    if (!thisConfigValidationError) {
                        LdapValidator lv = new LdapValidator(dto, this.fOutboundAllowlist);
                        isValid = lv.validateLdapServer();
                        LOG.info("Validation success: " + isValid);
                    }
                }
                catch (Exception ldape) {
                    errors.put("Exception", ldape.getLocalizedMessage());
                    if (ldape.getCause() == null) break block19;
                    errors.put("exceptionCause", ldape.getCause().getLocalizedMessage());
                }
            }
            if (errors.size() > 0) {
                this.fLdapValidationErrors.put(dto, errors);
            }
            LOG.info("LDAP Configuration validation result: " + isValid);
        }
        return isValid;
    }

    public Map<LdapDetailsDTO, Map<String, String>> getValidationErrors() {
        return this.fLdapValidationErrors;
    }

    public boolean isLdapValidationErrors() {
        CSUMLdapConfigEntity[] allConfigs = this.getLDAPConfigurations();
        if (allConfigs != null) {
            for (CSUMLdapConfigEntity config : allConfigs) {
                this.isLdapConfigurationValid(config);
            }
        }
        return this.fLdapValidationErrors.size() > 0;
    }

    public CSUMLdapConfigEntity[] getLDAPConfigurations() {
        if (this.fLdapConfigs == null || this.fLdapConfigs.length == 0) {
            this.fLdapConfigs = this.fAos.getLdapConfigs();
            if (this.fLdapConfigs.length > 0) {
                if (this.fLdapConfigs.length > 1) {
                    ArrayList<CSUMLdapConfigEntity> list = new ArrayList<CSUMLdapConfigEntity>(Arrays.asList(this.fLdapConfigs));
                    list.sort(new LdapConfigComparator());
                    list.toArray(this.fLdapConfigs);
                }
                return this.fLdapConfigs;
            }
            return new CSUMLdapConfigEntity[0];
        }
        return this.fLdapConfigs;
    }

    private boolean updateLdapConfig() {
        boolean wasUpdated = false;
        if (this.fConfigId > 0) {
            LdapItemBean bean = this.buildDto();
            try {
                if (this.fLdapValidateOnSave) {
                    LdapValidator validator = new LdapValidator(bean, this.fOutboundAllowlist);
                    validator.validateLdapServer();
                }
                this.getAo().updateLdapConfig(this.fConfigId, bean);
                wasUpdated = true;
            }
            catch (CommunicationException e) {
                this.addActionError("CommunicationException: " + e.getLocalizedMessage());
            }
            catch (LDAPException e) {
                this.addActionError("LDAPException: " + e.getLocalizedMessage());
            }
        }
        return wasUpdated;
    }

    public void setLdapValidateOnSave(String value) {
        this.fLdapValidateOnSave = value.equalsIgnoreCase(ON);
    }

    public void setLdapConfigName(String name) {
        this.fLdapConfigName = this.getNulled(name);
    }

    public void setHostname(String hostname) {
        this.fLdapHostname = this.getNulled(hostname);
    }

    public void setPort(int port) {
        this.fLdapPort = port;
    }

    public void setUseSSL(String value) {
        this.fLdapUseSSL = value.equalsIgnoreCase(ON);
    }

    public void setUsername(String username) {
        this.fLdapUsername = this.getNulled(username);
    }

    public void setPassword(String password) {
        this.fLdapPassword = this.getNulled(password);
    }

    public void setTestLookupUsername(String username) {
        this.fLdapTestLookupUsername = this.getNulled(username);
    }

    public void setBaseDN(String baseDN) {
        this.fLdapBaseDN = this.getNulled(baseDN);
    }

    public void setAdditionalUserDN(String userDN) {
        this.fLdapAdditionalUserDN = this.getNulled(userDN);
    }

    public void setAdditionalGroupDN(String groupDN) {
        this.fLdapAdditionalGroupDN = this.getNulled(groupDN);
    }

    public void setObjectClass(String objClass) {
        this.fLdapObjectClass = this.getNulled(objClass);
    }

    public void setObjectFilter(String objFilter) {
        this.fLdapObjectFilter = this.getNulled(objFilter);
    }

    public void setUsernameAttr(String userAttr) {
        this.fLdapUserAttr = this.getNulled(userAttr);
    }

    public void setGroupAttr(String groupAttr) {
        String fLdapUserGroupMembershipAttr = this.getNulled(groupAttr);
    }

    public void setUserRdnAttr(String userRdn) {
        this.fLdapUserRDNAttr = this.getNulled(userRdn);
    }

    public void setUserFirstNameAttr(String firstNameAttr) {
        this.fLdapUserFirstNameAttr = this.getNulled(firstNameAttr);
    }

    public void setUserLastNameAttr(String lastNameAttr) {
        this.fLdapUserLastNameAttr = this.getNulled(lastNameAttr);
    }

    public void setUserDisplayNameAttr(String displayNameAttr) {
        this.fLdapUserDisplayNameAttr = this.getNulled(displayNameAttr);
    }

    public void setUserEmailAttr(String emailAttr) {
        this.fLdapUserEmailAttr = this.getNulled(emailAttr);
    }

    public void setUserPasswordAttr(String passwordAttr) {
        this.fLdapUserPasswordAttr = this.getNulled(passwordAttr);
    }

    public void setProxyAddressesAttr(String proxyAddressesAttr) {
        String fLdapProxyAddressesAttr = this.getNulled(proxyAddressesAttr);
    }

    public void setEquivalentMailDomains(String equivDomains) {
        this.fLdapEquivalentDomains = this.getNulled(equivDomains);
    }

    public void setUsePagedResults(String value) {
        this.fLdapUsePagedResults = value.equalsIgnoreCase(ON);
    }

    public void setResultsPerPage(int resultSize) {
        this.fLdapResultsPerPage = resultSize;
    }

    public void setSearchTimeout(int timeout) {
        this.fLdapSearchTimeout = timeout;
    }

    public void setConnectionTimeout(int timeout) {
        this.fLdapConnectionTimeout = timeout;
    }

    public void setAdditionalParams(String paramMap) {
        String fLdapAdditionalParams = this.getNulled(paramMap);
    }

    public String getMaskedPassword(String raw) {
        StringBuilder out = new StringBuilder();
        if (raw != null) {
            int len = raw.length();
            for (int i = 0; i < len; ++i) {
                out.append("*");
            }
        }
        return out.toString();
    }

    public void setId(String id) {
        if (id.trim().length() > 0) {
            this.fConfigId = Integer.parseInt(id);
        }
    }

    public CSUMLdapConfigEntity getLdapConfig() {
        CSUMLdapConfigEntity e = null;
        if (this.fConfigId > 0) {
            e = this.getAo().getLdapConfigById(this.fConfigId);
        }
        return e;
    }

    public void setFlavour(String flavour) {
        LDAPFlavours fLdapFlavour = LDAPFlavours.valueOf(flavour);
    }

    public void setDlFilter(String filter) {
        String fDistListFilter = this.getNulled(filter);
    }

    public void setDlExpandAttr(String attr) {
        String fDlExpandAttr = this.getNulled(attr);
    }

    public void setSortOrder(String order) {
        this.fSortOrder = Integer.parseInt(order);
    }

    public boolean isLdapConfigActive(int ldapConfigId) {
        CSUMConfigEntity config = this.getConfig();
        String ldapIds = config.getExtLdapDirectories();
        if (ldapIds != null) {
            for (String id : ldapIds.split(",")) {
                if (ldapConfigId != Integer.parseInt(id)) continue;
                return true;
            }
        }
        return false;
    }

    public ICSUMDataDefs.DISABLED_USER_HANDLING[] getAvailableUserHandlingOptions() {
        return ICSUMDataDefs.DISABLED_USER_HANDLING.values();
    }

    public void setDisabledUserHandling(String status) {
        this.fDisabledUserHandling = ICSUMDataDefs.DISABLED_USER_HANDLING.valueOf(status);
    }

    public String getBlocklistGroups() {
        return this.fBlocklistGroups;
    }

    public void setBlocklistGroups(String groupNames) {
        if (groupNames == null) {
            this.fBlocklistGroups = "none";
        } else {
            String[] groups = groupNames.split(",");
            StringBuilder newGroupNamesString = new StringBuilder();
            for (String groupName : groups) {
                newGroupNamesString.append(groupName).append('|');
            }
            this.fBlocklistGroups = newGroupNamesString.toString();
        }
    }

    public String getGroupFilter() {
        return this.fGroupFilter;
    }

    public void setGroupFilter(String groupName) {
        this.fGroupFilter = groupName == null ? "none" : groupName;
    }

    public String getGroupFilterBehavior() {
        return this.fGroupFilterBehavior;
    }

    public void setGroupFilterBehavior(String groupFilterBehavior) {
        this.fGroupFilterBehavior = groupFilterBehavior;
    }

    public boolean isDcReadOnly() {
        return this.fAccessModeCompatService.isReadOnlyAccessModeEnabled();
    }

    private static enum LDAPFlavours {
        APACHEDIRECTORY,
        ACTIVEDIRECTORY;

    }
}

