AJS.$(document).ready(function() {

	console.log('CSUM js loading');

	let atlToken = AJS.Meta.get("atl-token")
	let pollingTimer;
	let currPrefix = AJS.$("#groupPrefixPattern").val();
	let currSuffix = AJS.$("#groupSuffixPattern").val();
	let changeConfirmed = false;

	let allowGlobalRenameDiv = AJS.$("#allowGlobalRename");
	let cleanupInputsDiv = AJS.$("#cleanupInputs");

	function hookVisibleGroupRenameInput(){
		if (AJS.$('input[type=radio][name=groupRenamePermitted]:checked').attr('value') === "true") {
			allowGlobalRenameDiv.show();
			cleanupInputsDiv.show();
		} else {
			allowGlobalRenameDiv.hide();
			cleanupInputsDiv.hide();
		}
	}

	AJS.$("input[type=radio][name=groupRenamePermitted]").change(function(){
		hookVisibleGroupRenameInput();
	});

	AJS.$("input[type=radio][name=renameGlobalPermitted]").change(function(){
		hookVisibleGroupRenameInput();
	});

	function markMatch(text, term, markup) {
		let match = csumStripDiacritics(text.toUpperCase()).indexOf(csumStripDiacritics(term.toUpperCase())), tl = term.length;

		if (match < 0) {
			markup.push(AJS.escapeHtml(text));
			return;
		}

		markup.push(AJS.escapeHtml(text.substring(0, match)));
		markup.push("<span class='select2-match'>");
		markup.push(AJS.escapeHtml(text.substring(match, match + tl)));
		markup.push("</span>");
		markup.push(AJS.escapeHtml(text.substring(match + tl, text.length)));
	}

    function hookUserGroupFilter() {
		AJS.$("#groupFilter").auiSelect2({
			placeholder: "Select Group(s)",
			minimumInputLength: 3,
			multiple: true,
			ajax: {
				url: AJS.contextPath() + "/rest/csum/latest/dlggroup/search",
				placeholder: "Search for a group",
				dataType: 'json',
				quietMillis: 300,
				data: function (term) {
					return {
						prefix: term,
						atl_token: atlToken
					};
				},
				results: function(data) {
					return {
						results: data.groups
					};
				}
			},
			initSelection: function (element, callback) {
				let currentFilters = AJS.$('#groupFilterHidField').val().split(",");
				let data = [];
				if (currentFilters[0] !== "none" && currentFilters.length > 0) {
					for (let i = 0; i < currentFilters.length; i++) {
						let filterStr = currentFilters[i];
						if (filterStr !== "") {
							data.push({id: filterStr, text: AJS.escapeHtml(filterStr)});
						}
					}
				}
				callback(data);
			},
			formatResult: function(item)
			{
				if (item.id) {
					return AJS.escapeHtml(item.id);
				} else {
					return AJS.escapeHtml(item);
				}
			},
			formatSelection: function(item){
				if (item.id) {
					return AJS.escapeHtml(item.id);
				} else {
					return AJS.escapeHtml(item);
				}
			},
			id : function(item) {
				if (item.id) {
					return item.id;
				} else {
					return item;
				}
			}
		}).select2('val', []);
	}

	function hookBlocklistGroupFilter() {
		AJS.$("#blocklistGroups").auiSelect2({
			placeholder: "Select Group(s)",
			minimumInputLength: 1,
			multiple: true,
			ajax: {
				url: AJS.contextPath() + "/rest/csum/latest/config/searchgroups",
				placeholder: "Search for a group",
				dataType: 'json',
				quietMillis: 300,
				data: function (term) {
					return {
						query: term,
						atl_token: atlToken
					};
				},
				results: function(data) {
					return {
						results: data.groups
					};
				}
			},
			initSelection: function (element, callback) {
				let currentFilters = AJS.$('#blocklistGroupsHidField').val().split("|");
				let data = [];
				if (currentFilters[0] !== "none" && currentFilters.length > 0) {
					for (let i = 0; i < currentFilters.length; i++) {
						let filterStr = currentFilters[i];
						if (filterStr !== "") {
							data.push({id: filterStr, text: AJS.escapeHtml(filterStr)});
						}
					}
				}
				callback(data);
			},
			formatResult: function(item)
			{
				if (item.id) {
					return AJS.escapeHtml(item.id);
				} else {
					return AJS.escapeHtml(item);
				}
			},
			formatSelection: function(item){
				if (item.id) {
					return AJS.escapeHtml(item.id);
				} else {
					return AJS.escapeHtml(item);
				}
			},
			id : function(item) {
				if (item.id) {
					return item.id;
				} else {
					return item;
				}
			}
		}).select2('val', []);
	}
	
	AJS.$("#csum-mainconfig-form").submit(function(){
		AJS.log("config submitted");
		let changed = (AJS.$("#groupPrefixPattern").val() !== currPrefix || AJS.$("#groupSuffixPattern").val() !== currSuffix);
		if (changed && !changeConfirmed){
			AJS.log("preventing submit as confirmation needed");
			AJS.dialog2("#csum-patternchange-dialog").show();
			return false;
		}
	});
	
	AJS.$("#csum-patternconfirm-btn").click(function(){
		changeConfirmed = true;
		AJS.dialog2("#csum-patternchange-dialog").hide();
		AJS.$("#csum-mainconfig-form").submit();
	});
	
	AJS.$("#csum-patterncancel-btn").click(function(){
		AJS.dialog2("#csum-patternchange-dialog").hide();
	});
	
	AJS.$("#autoJoinGroups").auiSelect2({
		multiple: true,
		minimumInputLength: 1,
		placeholder: AJS.I18n.getText('find.groups'),
		ajax : {
			url : AJS.contextPath() + "/rest/csum/latest/config/searchgroups",
			dataType : 'json',
			quietMillis : 350,
	        data: function (term) {
	            return {
	                query: term, //search term
					atl_token: atlToken
	            };
	        },
		    results: function(data) {
		    	return {
		    		results: data.groups
		        };
		    }
		},
	    initSelection: function(element, callback) {
	        // resolves groups in input elements value attribute to results objects
			let selections = [];
	        $(element.val().split(",")).each(function () {
	        	selections.push({id: this, text: this});
	        });
	        callback(selections);
	    },
		formatResult: function(result, container, query) {
			let markup=[];
			let text = result.name !== undefined ? result.name : result;
            markMatch(text, query.term, markup);
            return markup.join("");
        },
		formatSelection: function(item) {
			if (item.text !== undefined) {
				return item.text;
			} else {
				return item;
			}
        },
        id : function(item) {
        	if (item.text !== undefined) {
				return item.text;
			} else {
				return item;
			}
        },
		escapeMarkup : function(m) {
			return m;
		}
	});
	
	AJS.$("#csum-tools-namefix-openbtn").click(function(e) {
		e.preventDefault();
		openGroupFixDialog();
	});
	
	AJS.$("#csum-grpfixer-findbtn").click(function(e) {
		e.preventDefault();
		startFinder();
	});
	
	AJS.$("#csum-grpfixer-fixbtn").click(function(e) {
		e.preventDefault();
		startFixer();
	});
	
	AJS.$("#csum-grpfixer-cancelbtn").click(function(e) {
		e.preventDefault();
		stopFinder();
	    stopFixer();
	    AJS.$('#csum-groupfixer-status, #csum-groupfixer-count').empty();
	});
	
	AJS.$("#csum-grpfixer-closebtn").click(function(e) {
		e.preventDefault();
		closeGroupFixDialog();
	});

	//fn
	function applyVisibilityForUserSearchGroup(value) {
		//console.log('applyVisibilityForUserDirectoryGroup() : '+value);
		if (value==='true') {
			AJS.$(".csum-user-search-group").show(300);
		} else {
			AJS.$(".csum-user-search-group").hide(100);
		}
	}
		
	function applyVisibilityForUserDirectoryGroup(value) {
		//console.log('applyVisibilityForUserDirectoryGroup() : '+value);
		if (value==='true') {
			AJS.$(".csum-user-directory-group").show(300);
		} else {
			AJS.$(".csum-user-directory-group").hide(100);
		}
	}

	function applyVisibilityForLdapDirectoryGroup(value) {
		//console.log('applyVisibilityForLdapDirectoryGroup() : '+value);
		if (value==='true') {
			AJS.$(".csum-ldap-directory-group").show(300);
		} else {
			AJS.$(".csum-ldap-directory-group").hide(100);
		}
	}
	
	//hook
	AJS.$("input[type=radio][name=userSearchEnabled]").change(function() {
		//console.log('hook test : '+this.value);
		applyVisibilityForUserSearchGroup(this.value);
	});	
	AJS.$("input[type=radio][name=selectDirectories]").change(function() {
		//console.log('hook test : '+this.value);
		applyVisibilityForUserDirectoryGroup(this.value);
	});	

	AJS.$("input[type=radio][name=createUsersEnabled]").change(function() {
		//console.log('hook test : '+this.value);
		applyVisibilityForLdapDirectoryGroup(this.value);
	});	
	
	//init
	applyVisibilityForUserSearchGroup(AJS.$('input[type=radio][name=userSearchEnabled]:checked').attr('value'));
	applyVisibilityForUserDirectoryGroup(AJS.$('input[type=radio][name=selectDirectories]:checked').attr('value'));
	applyVisibilityForLdapDirectoryGroup(AJS.$('input[type=radio][name=createUsersEnabled]:checked').attr('value'));
		
	function createFlag(type, message){
		AJS.flag({
		    type: type,
		    body: message
		});
	}
	
	function showErrorMessage(divId, title, message){
		AJS.messages.error("#"+divId, {
		   title: title,
		   body: message
		});
	}
	
	function showWarnMessage(divId, title, message){
		AJS.messages.warning("#"+divId, {
		   title: title,
		   body: message,
		   closeable: false
		});
	}
	
	function toggleEnabled(elementId, enabled){
		let val = (enabled ? null : "true");
		AJS.$("#"+elementId).attr({
			"aria-disabled": val,
			"disabled": val
		});
	}
	
	function openGroupFixDialog() {
		AJS.dialog2("#csum-tools-groupname-dialog").show();
		checkForExistingData();
	}
	
	function closeGroupFixDialog() {
	    AJS.dialog2("#csum-tools-groupname-dialog").hide();
	    AJS.$("#csum-grpfix-messages").empty();
	}
	
	function checkGroupToolAccess() {
		AJS.$.ajax({
	  		url: AJS.contextPath()+"/rest/csum/latest/tools/groupnamefixer/status?atl_token="+atlToken,
	  		dataType: "json"
		})
		.done(function(data){
			if (data.status !== "RUNNING" || data.localFinderRunning || data.localFixerRunning) {
				toggleEnabled("csum-tools-namefix-openbtn",true);
			} else {
				AJS.$("#csum-tools-namefix-openbtn").text(AJS.I18n.getText('task.in.progress',AJS.I18n.getText('disabled')));
				AJS.$("#csum-groupfix-accesshelp").append("<span>"+AJS.I18n.getText('user.date.updated')+": "+
						new Date(data.updated).toLocaleString()+" , "+AJS.I18n.getText('heading.modifier')+": "+data.user+"</span>");
			}
		})
		.fail(function(jqXHR, textStatus){
			createFlag("error",AJS.I18n.getText('csum.tools.groupfixer.error.statuscheck')+": "+textStatus);
		});
	}
	
	function checkForExistingData() {
		AJS.$.ajax({
	  		url: AJS.contextPath()+"/rest/csum/latest/tools/groupnamefixer/status?atl_token="+atlToken,
	  		dataType: "json"
		})
		.done(function(data){
			if (data.status !== "RUNNING") {
				AJS.$.ajax({
			  		url: AJS.contextPath()+"/rest/csum/latest/tools/groupnamefixer/knowngroups?atl_token="+atlToken,
			  		dataType: "json"
				})
				.done(function(data) {
					if (data && data>0){
						AJS.$('#csum-groupfixer-count').text(AJS.I18n.getText('csum.tools.groupfixer.knowngroups')+": "+data);
						toggleEnabled("csum-grpfixer-fixbtn",true);
						let i18nDecode = AJS.$('<textarea />').html(AJS.I18n.getText('csum.tools.groupfixer.warning.changes')).text();
						showWarnMessage("csum-grpfix-messages", i18nDecode);
					}
				});
			}
			else if (data.localFinderRunning) {
				toggleEnabled("csum-grpfixer-fixbtn",false);
				toggleEnabled("csum-grpfixer-findbtn",true);
			} else if (data.localFixerRunning) {
				toggleEnabled("csum-grpfixer-findbtn",false);
				toggleEnabled("csum-grpfixer-fixbtn",true);
			} else {
				toggleEnabled("csum-grpfixer-findbtn",false);
				toggleEnabled("csum-grpfixer-fixbtn",false);
			}
		});
	}
	
	function startFinder(){
		AJS.$("#csum-grpfix-messages").empty();
		toggleEnabled("csum-grpfixer-findbtn",false);
		toggleEnabled("csum-grpfixer-fixbtn",false);
		AJS.$.ajax({
	  		url: AJS.contextPath()+"/rest/csum/latest/tools/groupnamefixer/find?atl_token="+atlToken,
	  		dataType: "json"
		})
		.done(function() {
			toggleEnabled("csum-grpfixer-cancelbtn",true);
			startFinderStatus();
			AJS.$('#csum-finder-spinner').show();
			AJS.$('#csum-groupfixer-status').text(AJS.I18n.getText('search.searching'));
			AJS.$('#csum-groupfixer-count').empty();
		})
		.fail(function(jqXHR, status, error){
			AJS.$("#csum-grpfix-messages").empty();
			showErrorMessage("csum-grpfix-messages", AJS.I18n.getText('action.error'), error+": "+jqXHR.responseText);
			toggleEnabled("csum-grpfixer-findbtn",true);
		});
	}
	
	function startFinderStatus() {
		pollingTimer = setInterval(pollFinderStatus, 1000);
	}
	
	function stopStatusLoop() {
		clearInterval(pollingTimer);
	}
	
	function pollFinderStatus(){
		AJS.$.ajax({
	  		url: AJS.contextPath()+"/rest/csum/latest/tools/groupnamefixer/find/progress?atl_token="+atlToken,
	  		dataType: "json"
		})
		.done(function(data){
			if (data.status === "RUNNING"){
				AJS.$('#csum-groupfixer-status').text(AJS.I18n.getText('search.searching'));
				AJS.$('#csum-groupfixer-count').text(AJS.I18n.getText('found')+": "+data.found+"/"+data.processed);
			} else if (data.status === "IDLE"){
				handleFinderCompletion(data);
			} else if (data.status === "ERROR"){
				handleError(data);
			}
			return data;
		})
		.fail(function(jqXHR, status, error){
			AJS.$("#csum-grpfix-messages").empty();
			showErrorMessage("csum-grpfix-messages", AJS.I18n.getText('action.error'), error);
		});
	}
	
	function handleError(data){
		stopStatusLoop();
		stopFinder();
		stopFixer();
		AJS.$('#csum-groupfixer-status').text(AJS.I18n.getText('error.word.caps')+": "+data.error);
	}
	
	function handleFinderCompletion(data){
		toggleEnabled("csum-grpfixer-cancelbtn",false);
		stopStatusLoop();
		AJS.$('#csum-finder-spinner').hide();
		toggleEnabled("csum-grpfixer-findbtn",true);
		AJS.$('#csum-groupfixer-status').text(AJS.I18n.getText('done.name'));
		if (data.found>0){
			AJS.$('#csum-groupfixer-count').text(AJS.I18n.getText('found')+": "+data.found);
			toggleEnabled("csum-grpfixer-fixbtn",true);
			let i18nDecode = AJS.$('<textarea />').html(AJS.I18n.getText('csum.tools.groupfixer.warning.changes')).text();
			showWarnMessage("csum-grpfix-messages", i18nDecode);
		} else {
			AJS.$('#csum-groupfixer-count').text(AJS.I18n.getText('there.are.no.groups'));
		}
	}
	
	function stopFinder(){
		AJS.$.ajax({
			type: "DELETE",
	  		url: AJS.contextPath()+"/rest/csum/latest/tools/groupnamefixer/find?atl_token="+atlToken,
	  		dataType: "json"
		})
		.done(function(){
			AJS.$('#csum-finder-spinner').hide();
			toggleEnabled("csum-grpfixer-findbtn",true);
			toggleEnabled("csum-grpfixer-cancelbtn",false);
		})
		.fail(function(jqXHR, status){
			AJS.flag({
			    type: 'error',
			    title: AJS.I18n.getText('action.error')+": "+status,
			    body: jqXHR.status===404?jqXHR.statusText:jqXHR.responseText
			});
		});
		if (pollingTimer != null){
			stopStatusLoop();
		}
	}
	
	function startFixer(){
		AJS.$("#csum-grpfix-messages").empty();
		toggleEnabled("csum-grpfixer-fixbtn",false);
		toggleEnabled("csum-grpfixer-findbtn",false);
		AJS.$.ajax({
	  		url: AJS.contextPath()+"/rest/csum/latest/tools/groupnamefixer/fix?atl_token="+atlToken,
	  		dataType: "json"
		})
		.done(function(){
			toggleEnabled("csum-grpfixer-cancelbtn",true);
			startFixerStatus();
			AJS.$("#csum-groupfixer-prog").show();
		})
		.fail(function(jqXHR, status, error){
			AJS.$("#csum-grpfix-messages").empty();
			showErrorMessage("csum-grpfix-messages", AJS.I18n.getText('action.error'), error+": "+jqXHR.responseText);
			toggleEnabled("csum-grpfixer-fixbtn",true);
		});
	}
	
	function stopFixer(){
		AJS.$.ajax({
			type: "DELETE",
	  		url: AJS.contextPath()+"/rest/csum/latest/tools/groupnamefixer/fix?atl_token="+atlToken,
	  		dataType: "json"
		})
		.done(function(){
			AJS.$('#csum-groupfixer-status, #csum-groupfixer-count').empty();
			AJS.progressBars.update("#csum-groupfixer-prog", 0);
			AJS.$("#csum-groupfixer-prog").hide();
			toggleEnabled("csum-grpfixer-findbtn",true);
			toggleEnabled("csum-grpfixer-cancelbtn",false);
		})
		.fail(function(jqXHR, status){
			AJS.flag({
			    type: 'error',
			    title: AJS.I18n.getText('action.error')+": "+status,
			    body: jqXHR.status===404?jqXHR.statusText:jqXHR.responseText
			});
		});
		if (pollingTimer != null){
			stopStatusLoop();
		}
	}
	
	function startFixerStatus() {
		pollingTimer = setInterval(pollFixerStatus, 1000);
	}
	
	function pollFixerStatus(){
		AJS.$.ajax({
	  		url: AJS.contextPath()+"/rest/csum/latest/tools/groupnamefixer/fix/progress?atl_token="+atlToken,
	  		dataType: "json"
		})
		.done(function(data){
			if (data.status === "RUNNING"){
				let prog = data.fixed / data.total;
				let percent = Math.round(prog*100);
				AJS.$('#csum-groupfixer-status').text(AJS.I18n.getText('task.in.progress', AJS.I18n.getText('status.name')));
				AJS.$('#csum-groupfixer-count').text(AJS.I18n.getText('updated.name')+": "+data.fixed+" ("+percent+"%)");
				
				AJS.progressBars.update("#csum-groupfixer-prog", prog);
			} else if (data.status === "IDLE") {
				handleFixerCompletion(data);
			} else if (data.status === "ERROR"){
				handleError(data);
			}
		})
		.fail(function(jqXHR, status, error){
			AJS.$("#csum-grpfix-messages").empty();
			showErrorMessage("csum-grpfix-messages", AJS.I18n.getText('action.error'), error);
		});
	}
	
	function handleFixerCompletion(data){
		toggleEnabled("csum-grpfixer-cancelbtn",false);
		stopStatusLoop();
		AJS.progressBars.update("#csum-groupfixer-prog", 0);
		AJS.$("#csum-groupfixer-prog").hide();
		toggleEnabled("csum-grpfixer-findbtn",true);
		AJS.$('#csum-groupfixer-status').text(AJS.I18n.getText('done.name'));
		AJS.$('#csum-groupfixer-count').text(AJS.I18n.getText('updated.name')+": "+data.fixed);
	}

	AJS.$("#groupPrefixPattern").on("input", function () {
		validatePrefixAndSuffix();
	});

	AJS.$("#groupSuffixPattern").on("input", function () {
		validatePrefixAndSuffix();
	});

	function validatePrefixAndSuffix() {
		console.log("Validating prefix and suffix");

		let prefixVal = AJS.$("#groupPrefixPattern").val();
		let suffixVal = AJS.$("#groupSuffixPattern").val();

		// Check neither are null
		if (prefixVal === null || prefixVal === undefined || prefixVal === "") {
			if (suffixVal === null || suffixVal === undefined || suffixVal === "") {
				AJS.$("#emptyPrefixAndSuffixError").attr("hidden", false);
				AJS.$("#saveButton").prop('disabled', true);
				AJS.$("#spacekeyNotPresentWarning").attr("hidden", true);
			} else {
				AJS.$("#emptyPrefixAndSuffixError").attr("hidden", true);
				AJS.$("#saveButton").prop('disabled', false);
				checkPrefixOrSuffixContainsSpaceKey(prefixVal, suffixVal);
			}
		} else {
			AJS.$("#emptyPrefixAndSuffixError").attr("hidden", true);
			AJS.$("#saveButton").prop('disabled', false);
			checkPrefixOrSuffixContainsSpaceKey(prefixVal, suffixVal);
		}
	}

	function checkPrefixOrSuffixContainsSpaceKey(prefixVal, suffixVal) {
		if (!prefixVal.includes("spacekey") && !prefixVal.includes("SPACEKEY") &&
			!suffixVal.includes("spacekey") && !suffixVal.includes("SPACEKEY")) {
			AJS.$("#spacekeyNotPresentWarning").attr("hidden", false);
		} else {
			AJS.$("#spacekeyNotPresentWarning").attr("hidden", true);
		}
	}

	checkGroupToolAccess();
	hookUserGroupFilter();
	hookBlocklistGroupFilter();
	hookVisibleGroupRenameInput();
	validatePrefixAndSuffix();
});