/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.util;

import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.AuthorizationException;
import com.pluginpeople.confluence.csum.api.DuplicateException;
import com.pluginpeople.confluence.csum.api.GroupActionNotPermittedException;
import com.pluginpeople.confluence.csum.api.SpaceGroupPatternMismatchException;
import com.pluginpeople.confluence.csum.rest.beans.ExceptionBean;
import com.pluginpeople.confluence.csum.rest.beans.JSONImportGroupsResult;
import com.pluginpeople.confluence.csum.util.SpaceGroupUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ImportSpaceGroupUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ImportSpaceGroupUtil.class);
    private static final String COMMA = ",";
    private static final String INVALID_REASON = "invalid";
    private final PermissionManager fPermissionManager;
    private final SpaceGroupUtil fSpaceGroupUtil;
    private final PluginAccessor fPluginAccessor;
    ICSUMActiveObjectService fAos;
    private final SpaceManager fSpaceManager;
    private final GroupManager fGroupManager;
    private final UserAccessor fUserAccessor;

    @Autowired
    public ImportSpaceGroupUtil(SpaceGroupUtil spaceGroupUtil, @ComponentImport SpaceManager spaceManager, @ComponentImport GroupManager groupMgr, ICSUMActiveObjectService aos, @ComponentImport UserAccessor userAccessor, @ComponentImport PermissionManager permissionManager, @ComponentImport PluginAccessor pluginAccessor) {
        this.fSpaceGroupUtil = spaceGroupUtil;
        this.fSpaceManager = spaceManager;
        this.fGroupManager = groupMgr;
        this.fAos = aos;
        this.fUserAccessor = userAccessor;
        this.fPermissionManager = permissionManager;
        this.fPluginAccessor = pluginAccessor;
    }

    public JSONImportGroupsResult importGroupsAndUsers(String currentSpaceKey, String importFromSpaceKey, String groupsToImportCsv, boolean importUsers) {
        int successfulGroupImports = 0;
        int successfulUserImports = 0;
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        Space importFromSpace = this.fSpaceManager.getSpace(importFromSpaceKey);
        Space importToSpace = this.fSpaceManager.getSpace(currentSpaceKey);
        HashMap<String, String> failedUserImports = new HashMap<String, String>();
        ExceptionBean exceptionBean = null;
        if (!this.fPermissionManager.hasPermission((User)currentUser, Permission.ADMINISTER, (Object)importFromSpace) || !this.fPermissionManager.hasPermission((User)currentUser, Permission.ADMINISTER, (Object)importToSpace)) {
            GroupActionNotPermittedException e = new GroupActionNotPermittedException("Current user: " + currentUser.getName() + " does not have permission to Administer space(s):" + currentSpaceKey + ", " + importFromSpaceKey);
            exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
            return new JSONImportGroupsResult(successfulGroupImports, null, successfulUserImports, failedUserImports, exceptionBean);
        }
        Map<String, String> failedGroupImports = null;
        try {
            SpaceGroupUtil.OperationResult<Group> validateGroupsResult = this.fSpaceGroupUtil.validateSpaceGroups(importFromSpace, groupsToImportCsv.split(COMMA));
            List validGroups = validateGroupsResult.successes;
            failedGroupImports = validateGroupsResult.failures;
            if (validGroups.isEmpty()) {
                NotPermittedException e = new NotPermittedException("User: " + currentUser.getName() + " is not authorized to manage space(s): " + currentSpaceKey + ", " + importFromSpaceKey);
                exceptionBean = new ExceptionBean((Throwable)e, this.fPluginAccessor);
                return new JSONImportGroupsResult(successfulGroupImports, failedGroupImports, successfulUserImports, failedUserImports, exceptionBean);
            }
            for (Group validGroup : validGroups) {
                try {
                    Group imported = this.fSpaceGroupUtil.importGroupToNewSpace(importFromSpace, importToSpace, validGroup.getName());
                    if (imported == null) continue;
                    ++successfulGroupImports;
                    if (!importUsers) continue;
                    List userNames = this.fUserAccessor.getMemberNamesAsList(validGroup);
                    SpaceGroupUtil.OperationResult<ConfluenceUser> userValidationResult = this.fSpaceGroupUtil.validateCSVUsers(importFromSpace, String.join((CharSequence)COMMA, userNames), new String[0]);
                    List validUsers = userValidationResult.successes;
                    Map<String, String> failures = userValidationResult.failures;
                    failedUserImports.putAll(failures);
                    for (User validUser : validUsers) {
                        try {
                            this.fGroupManager.addMembership(imported, validUser);
                            ++successfulUserImports;
                        }
                        catch (EntityException e) {
                            LOG.error("EntityException Importing user: " + validUser.getName(), (Throwable)e);
                            failedUserImports.put(validUser.getName(), INVALID_REASON);
                        }
                    }
                }
                catch (DuplicateException e) {
                    failedGroupImports.put(validGroup.getName(), INVALID_REASON);
                    if (!importUsers) continue;
                    Pager nonAttemptedUsers = this.fGroupManager.getMemberNames(validGroup);
                    for (String nonAttemptedUser : nonAttemptedUsers) {
                        failedUserImports.put(nonAttemptedUser, INVALID_REASON);
                    }
                }
                catch (GroupActionNotPermittedException | SpaceGroupPatternMismatchException e) {
                    exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                }
            }
        }
        catch (EntityException e) {
            exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
        }
        catch (AuthorizationException e) {
            LOG.error("Current user: " + currentUser.getName() + " does not have permission to Administer space(s):" + currentSpaceKey + ", " + importFromSpaceKey);
            exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
        }
        return new JSONImportGroupsResult(successfulGroupImports, failedGroupImports, successfulUserImports, failedUserImports, exceptionBean);
    }
}

