/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.rest;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.access.annotations.RequiresLicensedConfluenceAccess;
import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.pluginpeople.confluence.csum.api.InvalidSpaceException;
import com.pluginpeople.confluence.csum.rest.AbstractCSUMRestResource;
import com.pluginpeople.confluence.csum.rest.beans.JSONImportGroupsResult;
import com.pluginpeople.confluence.csum.rest.beans.SpaceSearchResult;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import com.pluginpeople.confluence.csum.util.ImportSpaceGroupUtil;
import com.pluginpeople.confluence.csum.util.SpaceGroupUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@ReadOnlyAccessAllowed
@RequiresLicensedConfluenceAccess
@Path(value="/space")
public class SpaceResource
extends AbstractCSUMRestResource {
    private final SpaceGroupUtil fSpaceGroupUtil;
    private final ImportSpaceGroupUtil fImportSpaceGroupUtil;

    public SpaceResource(@ComponentImport SpaceManager spaceManager, @ComponentImport XsrfTokenService tokenService, CSUMPermissionUtil permissionUtil, @ComponentImport PermissionManager permissionManager, ImportSpaceGroupUtil importSpaceGroupUtil, SpaceGroupUtil grpUtil) {
        super(spaceManager, permissionUtil, tokenService, permissionManager);
        this.fSpaceGroupUtil = grpUtil;
        this.fImportSpaceGroupUtil = importSpaceGroupUtil;
    }

    @POST
    @Path(value="/import")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response importGroupsAndUsers(@Context HttpServletRequest hsr, @QueryParam(value="atl_token") String atlToken, @QueryParam(value="currentSpaceKey") String currentSpaceKey, @QueryParam(value="groupsToImport") String groupsToImportCsv, @QueryParam(value="targetSpaceKey") String importFromSpaceKey, @QueryParam(value="importUsers") boolean importUsers) {
        Response response;
        try {
            this.getValidSpaceFromKey(currentSpaceKey);
        }
        catch (InvalidSpaceException e) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)currentSpaceKey).build();
        }
        try {
            this.getValidSpaceFromKey(importFromSpaceKey);
        }
        catch (InvalidSpaceException e) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)importFromSpaceKey).build();
        }
        if (this.isUnauthorizedOrBadXsrfToken(hsr, currentSpaceKey)) {
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        } else if (this.isUnauthorizedOrBadXsrfToken(hsr, importFromSpaceKey)) {
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        } else {
            JSONImportGroupsResult ret = this.fImportSpaceGroupUtil.importGroupsAndUsers(currentSpaceKey, importFromSpaceKey, groupsToImportCsv, importUsers);
            response = Response.ok((Object)ret).build();
        }
        return response;
    }

    @POST
    @Path(value="/search")
    @Produces(value={"application/json"})
    public Response searchSpaces(@Context HttpServletRequest hsr, @FormParam(value="spaceKey") String spaceKey, @QueryParam(value="atl_token") String atlToken, @FormParam(value="term") String term, @FormParam(value="pageLimit") int pageLimit) {
        Response response;
        if (spaceKey != null) {
            try {
                this.getValidSpaceFromKey(spaceKey);
            }
            catch (InvalidSpaceException e) {
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)spaceKey).build();
            }
            if (this.isUnauthorizedOrBadXsrfToken(hsr, spaceKey)) {
                response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            } else {
                List<SpaceSearchResult> results = this.fSpaceGroupUtil.searchForSpaces(term, pageLimit);
                response = Response.ok(results).build();
            }
        } else {
            List<SpaceSearchResult> results = this.fSpaceGroupUtil.searchForSpaces(term, pageLimit);
            response = Response.ok(results).build();
        }
        return response;
    }
}

