/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.util;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.pluginpeople.confluence.csum.rest.beans.UserSearchResult;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserUtil {
    private static final Logger LOG = LoggerFactory.getLogger(UserUtil.class);
    private final UserAccessor fUserAccessor;

    @Autowired
    public UserUtil(@ComponentImport UserAccessor userAccessor) {
        this.fUserAccessor = userAccessor;
    }

    public boolean isValidEmail(String email) {
        return email != null && email.trim().length() > 2 && email.contains("@");
    }

    public void removeDisabledUsers(boolean disabledUsersHidden, List<UserSearchResult> jsonObjList) {
        if (disabledUsersHidden) {
            for (int i = 0; i < jsonObjList.size(); ++i) {
                UserSearchResult userSearchResult = jsonObjList.get(i);
                String username = userSearchResult.getUsername();
                ConfluenceUser user = this.fUserAccessor.getUserByName(username);
                if (user != null && this.fUserAccessor.isDeactivated(username)) {
                    jsonObjList.remove(i);
                }
                LOG.debug("didnt show: " + username + " in search result because they are disabled");
            }
        }
    }
}

