/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.util;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.search.SearchResult;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.query.GroupNameTermQuery;
import com.pluginpeople.confluence.csum.ao.CSUMDelegatedGroupEntity;
import com.pluginpeople.confluence.csum.ao.CSUMDlgGrpAuthGrpEntity;
import com.pluginpeople.confluence.csum.ao.CSUMDlgGrpAuthUsrEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.AuthorizationException;
import com.pluginpeople.confluence.csum.api.DuplicateException;
import com.pluginpeople.confluence.csum.api.GroupActionNotPermittedException;
import com.pluginpeople.confluence.csum.api.RemoveAllUsersException;
import com.pluginpeople.confluence.csum.api.beans.AddDlgConfirmBean;
import com.pluginpeople.confluence.csum.api.beans.AuthGroupBean;
import com.pluginpeople.confluence.csum.api.beans.AuthUserBean;
import com.pluginpeople.confluence.csum.api.beans.DlgGroupBean;
import com.pluginpeople.confluence.csum.api.beans.JSONAddUserResultBean;
import com.pluginpeople.confluence.csum.rest.beans.AuthCreateResult;
import com.pluginpeople.confluence.csum.rest.beans.DataTableGroupList;
import com.pluginpeople.confluence.csum.rest.beans.DataTableUserList;
import com.pluginpeople.confluence.csum.rest.beans.JSONAddGroupResult;
import com.pluginpeople.confluence.csum.rest.beans.JSONAddGroupResultParent;
import com.pluginpeople.confluence.csum.rest.beans.UserSearchResult;
import com.pluginpeople.confluence.csum.service.cache.CSUMDlgGroupCacheEntry;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.service.cache.ICachedConfig;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import com.pluginpeople.confluence.csum.util.DlgEntryXmlStrConv;
import com.pluginpeople.confluence.csum.util.GroupUtil;
import com.pluginpeople.confluence.csum.util.SpaceGroupUtil;
import com.pluginpeople.confluence.csum.util.UserUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DlgGroupManager {
    private static final Logger LOG = LoggerFactory.getLogger(DlgGroupManager.class);
    private static final String GROUP_ACTIONS_DISABLED = "csum.action.dlg.group.disabled";
    private static final String COMMA_STRING = ",";
    private static final String MEMBERSHIP_REASON = "membership";
    private final ICSUMActiveObjectService fICActiveObjectService;
    private final ICSUMCacheManager fCacheManager;
    private final I18nResolver fI18n;
    private final UserAccessor fUserAccessor;
    private final GroupManager fGroupManager;
    private final CrowdService fCrowdService;
    private final CSUMPermissionUtil fPermissionUtil;
    private final SpaceGroupUtil fSpaceGroupUtil;
    private final GroupUtil fGroupUtil;
    private final UserUtil fUserUtil;

    @Autowired
    public DlgGroupManager(ICSUMActiveObjectService iCActiveObjectService, ICSUMCacheManager cacheManager, @ComponentImport I18nResolver i18N, @ComponentImport UserAccessor userAccessor, @ComponentImport GroupManager groupManager, CSUMPermissionUtil permissionUtil, @ComponentImport CrowdService crowdService, SpaceGroupUtil spaceGroupUtil, GroupUtil groupUtil, UserUtil userUtil) {
        this.fICActiveObjectService = iCActiveObjectService;
        this.fCacheManager = cacheManager;
        this.fI18n = i18N;
        this.fUserAccessor = userAccessor;
        this.fGroupManager = groupManager;
        this.fCrowdService = crowdService;
        this.fPermissionUtil = permissionUtil;
        this.fSpaceGroupUtil = spaceGroupUtil;
        this.fGroupUtil = groupUtil;
        this.fUserUtil = userUtil;
    }

    public DlgGroupBean[] getDlgGroups() {
        CSUMDelegatedGroupEntity[] dlgGroupEntities;
        ArrayList<DlgGroupBean> dlgGroupBeans = new ArrayList<DlgGroupBean>();
        for (CSUMDelegatedGroupEntity dlgGroupEntity : dlgGroupEntities = this.fICActiveObjectService.getDelegatedGroups()) {
            DlgGroupBean dlgGroupBean = new DlgGroupBean();
            dlgGroupBean.setGroupName(dlgGroupEntity.getGroupName());
            dlgGroupBean.setDlgGroupEntityId(dlgGroupEntity.getID());
            dlgGroupBeans.add(dlgGroupBean);
        }
        return dlgGroupBeans.toArray(new DlgGroupBean[0]);
    }

    public DlgGroupBean getDlgGroup(int dlgGroupId) throws EntityException {
        return this.getDlgBean(this.fICActiveObjectService.getDelegatedGroup(dlgGroupId));
    }

    @Nonnull
    public DlgGroupBean createDlgGroup(@Nonnull String dlgGroupName) throws GroupActionNotPermittedException, AuthorizationException {
        if (!this.fPermissionUtil.isGlobalAdmin()) {
            throw new AuthorizationException();
        }
        if (!this.fCacheManager.getCachedConfig().isDlgGrpActPerm()) {
            throw new GroupActionNotPermittedException(this.fI18n.getText(GROUP_ACTIONS_DISABLED));
        }
        CSUMDelegatedGroupEntity createdDlgGroup = this.fICActiveObjectService.createDelegatedGroup(dlgGroupName);
        LOG.debug("Group created: " + createdDlgGroup.getGroupName());
        DlgGroupBean dlgGroupBean = new DlgGroupBean();
        dlgGroupBean.setGroupName(createdDlgGroup.getGroupName());
        dlgGroupBean.setDlgGroupEntityId(createdDlgGroup.getID());
        return dlgGroupBean;
    }

    public boolean deleteDlgGroup(DlgGroupBean dlgGroupBean, String origin) {
        int id = dlgGroupBean.getDlgGroupEntityId();
        CSUMDelegatedGroupEntity groupEntity = this.fICActiveObjectService.getDelegatedGroup(id);
        ConfluenceUser authenticatedUser = AuthenticatedUserThreadLocal.get();
        return this.fICActiveObjectService.deleteDelegatedGroup(groupEntity, authenticatedUser, origin);
    }

    public AddDlgConfirmBean validateDlgGroupCreate(String[] groupNameArr) throws GroupActionNotPermittedException, AuthorizationException {
        AddDlgConfirmBean confirmBean = new AddDlgConfirmBean();
        ArrayList<String> successfulGroups = new ArrayList<String>();
        ArrayList<String> duplicateGroups = new ArrayList<String>();
        DlgGroupBean[] existingDlgGroups = this.getDlgGroups();
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        for (String dlgGrpToBeCreated : groupNameArr) {
            this.createDlgGroupsFromArray(successfulGroups, duplicateGroups, existingDlgGroups, currentUser, dlgGrpToBeCreated);
        }
        confirmBean.setSuccessfulGroups(successfulGroups.toArray(new String[0]));
        confirmBean.setDuplicateGroups(duplicateGroups.toArray(new String[0]));
        return confirmBean;
    }

    private void createDlgGroupsFromArray(List<String> successfulGroups, List<String> duplicateGroups, DlgGroupBean[] existingDlgGroups, ConfluenceUser currentUser, String dlgGrpToBeCreated) throws GroupActionNotPermittedException, AuthorizationException {
        if (existingDlgGroups.length == 0) {
            DlgGroupBean created = this.createDlgGroup(dlgGrpToBeCreated);
            if (created.getDlgGroupEntityId() != 0) {
                successfulGroups.add(dlgGrpToBeCreated);
            }
        } else {
            String msg;
            int count = 0;
            for (DlgGroupBean existingDlgGroupBeans : existingDlgGroups) {
                if (!existingDlgGroupBeans.getGroupName().equalsIgnoreCase(dlgGrpToBeCreated)) {
                    ++count;
                    continue;
                }
                duplicateGroups.add(dlgGrpToBeCreated);
                msg = dlgGrpToBeCreated + "group has already been added to delegated groups";
                this.fICActiveObjectService.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.addDelegatedGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, null, dlgGrpToBeCreated, null, currentUser.getName(), msg, null, null);
                LOG.error(msg);
                break;
            }
            if (count == existingDlgGroups.length) {
                try {
                    this.createDlgGroup(dlgGrpToBeCreated);
                    successfulGroups.add(dlgGrpToBeCreated);
                    msg = "Delegated group added: " + dlgGrpToBeCreated;
                    this.fICActiveObjectService.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.addDelegatedGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.success, null, dlgGrpToBeCreated, null, currentUser.getName(), msg, null, null);
                    LOG.debug(msg);
                }
                catch (Exception e) {
                    msg = dlgGrpToBeCreated + "group has already been added to delegated groups";
                    this.fICActiveObjectService.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.addDelegatedGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, null, dlgGrpToBeCreated, null, currentUser.getName(), msg, null, null);
                    LOG.error(msg);
                }
            }
        }
    }

    public List<AuthGroupBean> getDlgAuthGroups(int dlgGroupId) throws EntityException {
        ArrayList<AuthGroupBean> authGroupBeans = new ArrayList<AuthGroupBean>();
        CSUMDelegatedGroupEntity dlgGroupEntity = this.fICActiveObjectService.getDelegatedGroup(dlgGroupId);
        if (this.fGroupManager.getGroup(dlgGroupEntity.getGroupName()) != null) {
            CSUMDlgGrpAuthGrpEntity[] authGroupEntities;
            for (CSUMDlgGrpAuthGrpEntity authGroup : authGroupEntities = dlgGroupEntity.getAuthGroups()) {
                AuthGroupBean authGroupBean = new AuthGroupBean();
                authGroupBean.setAuthGroupEntityId(authGroup.getID());
                authGroupBean.setGroupName(authGroup.getGroupName());
                authGroupBeans.add(authGroupBean);
            }
        }
        return authGroupBeans;
    }

    public List<AuthUserBean> getDlgAuthUsers(int dlgGroupId) {
        ArrayList<AuthUserBean> authUserBeans = new ArrayList<AuthUserBean>();
        CSUMDelegatedGroupEntity dlgGroupEntity = this.fICActiveObjectService.getDelegatedGroup(dlgGroupId);
        if (dlgGroupEntity != null) {
            CSUMDlgGrpAuthUsrEntity[] authUserEntities;
            for (CSUMDlgGrpAuthUsrEntity authUserEntity : authUserEntities = dlgGroupEntity.getAuthUsers()) {
                ConfluenceUser confUser = this.fUserAccessor.getExistingUserByKey(new UserKey(authUserEntity.getUserKey()));
                if (confUser == null) {
                    this.fICActiveObjectService.delete(authUserEntity);
                    continue;
                }
                AuthUserBean authUserBean = new AuthUserBean();
                authUserBean.setEmail(confUser.getEmail());
                authUserBean.setFullName(confUser.getFullName());
                authUserBean.setKey(confUser.getKey().getStringValue());
                authUserBean.setUserName(confUser.getName());
                authUserBeans.add(authUserBean);
            }
        }
        return authUserBeans;
    }

    public AuthCreateResult authorizeUsersAndGroups(int dlgGroupId, String groups, String users, String importViaGroups) throws EntityException {
        DlgGroupBean dlgGroupBean = this.getDlgGroup(dlgGroupId);
        if (dlgGroupBean == null || dlgGroupBean.getDlgGroupEntityId() == 0) {
            return null;
        }
        List<Object> groupList = new ArrayList();
        if (groups != null) {
            groupList = Arrays.asList(groups.split(COMMA_STRING));
        }
        HashSet<String> userList = new HashSet<String>();
        if (users != null) {
            userList.addAll(Arrays.asList(users.split(COMMA_STRING)));
        }
        if (importViaGroups != null) {
            String[] usersFromImport = this.fSpaceGroupUtil.getGroupMemberNamesViaImport(importViaGroups.split(COMMA_STRING));
            List<String> usersFromImportList = Arrays.asList(usersFromImport);
            userList.addAll(usersFromImportList);
        }
        String dlgGroupName = dlgGroupBean.getGroupName();
        List authGroups = dlgGroupBean.getAuthGroups();
        ArrayList<String> authGroupNames = new ArrayList<String>();
        if (authGroups != null && !authGroups.isEmpty()) {
            for (AuthGroupBean authGroup : authGroups) {
                authGroupNames.add(authGroup.getGroupName());
            }
        }
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        ArrayList<String> authGroupFailures = new ArrayList<String>();
        int authGroupSuccesses = 0;
        for (String string : groupList) {
            authGroupSuccesses = this.authoriseGroupFromGroupList(dlgGroupId, dlgGroupName, authGroupNames, currentUser, authGroupFailures, authGroupSuccesses, string);
        }
        List authUserBeans = dlgGroupBean.getAuthUsers();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (authUserBeans != null && !authUserBeans.isEmpty()) {
            for (AuthUserBean authUserBean : authUserBeans) {
                arrayList.add(authUserBean.getUserName());
            }
        }
        ArrayList<String> authUserFailures = new ArrayList<String>();
        int authUserSuccesses = 0;
        for (String userName : userList) {
            authUserSuccesses = this.authoriseUserFromUserList(dlgGroupBean, dlgGroupName, currentUser, arrayList, authUserFailures, authUserSuccesses, userName);
        }
        return new AuthCreateResult(authGroupSuccesses, authUserSuccesses, authGroupFailures, authUserFailures);
    }

    private int authoriseUserFromUserList(DlgGroupBean dlgGroupBean, String dlgGroupName, ConfluenceUser currentUser, List<String> authUserNames, List<String> authUserFailures, int authUserSuccesses, String userName) {
        ConfluenceUser userByName = this.fUserAccessor.getUserByName(userName);
        if (userByName != null) {
            if (!authUserNames.contains(userName)) {
                String userKeyStr = userByName.getKey().getStringValue();
                this.fICActiveObjectService.createDlgGrpAuthUser(dlgGroupBean, userKeyStr);
                ++authUserSuccesses;
                String msg = "User authorized to manage " + dlgGroupName;
                this.fICActiveObjectService.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.authorizeUser, ICSUMActiveObjectService.CSUMAuditEventOutcome.success, null, dlgGroupName, userKeyStr, currentUser.getName(), msg, null, null);
                LOG.debug(msg);
            }
        } else {
            String msg = "User " + userName + " has not been found within confluence";
            this.fICActiveObjectService.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.authorizeUser, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, null, dlgGroupName, null, currentUser.getName(), msg, null, null);
            LOG.error(msg);
            authUserFailures.add(userName);
        }
        return authUserSuccesses;
    }

    private int authoriseGroupFromGroupList(int dlgGroupId, String dlgGroupName, List<String> authGroupNames, ConfluenceUser currentUser, List<String> authGroupFailures, int authGroupSuccesses, String groupName) throws EntityException {
        if (this.fGroupManager.getGroup(groupName) != null) {
            if (!authGroupNames.contains(groupName)) {
                this.fICActiveObjectService.createDlgGrpAuthGrp(groupName, dlgGroupId);
                ++authGroupSuccesses;
                String msg = "Group " + groupName + " was authorized to manage " + dlgGroupName;
                this.fICActiveObjectService.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.authorizeGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.success, null, dlgGroupName, null, currentUser.getName(), msg, null, groupName);
                LOG.debug(msg);
            }
        } else {
            String msg = groupName + "The group(s) have already been authorized";
            this.fICActiveObjectService.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.authorizeGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, null, dlgGroupName, null, currentUser.getName(), msg, null, groupName);
            LOG.error(msg);
            authGroupFailures.add(groupName);
        }
        return authGroupSuccesses;
    }

    public JSONAddGroupResultParent addDlgGroupConfirmation(AddDlgConfirmBean confirmBean) {
        String[] succGroups = confirmBean.getSuccessfulGroups();
        String[] dupGroups = confirmBean.getDuplicateGroups();
        ArrayList<JSONAddGroupResult> succList = new ArrayList<JSONAddGroupResult>();
        ArrayList<JSONAddGroupResult> dupList = new ArrayList<JSONAddGroupResult>();
        if (succGroups.length > 0) {
            for (String succGroup : succGroups) {
                JSONAddGroupResult successful = new JSONAddGroupResult(this.fICActiveObjectService.getDlgGroupId(succGroup), succGroup);
                succList.add(successful);
            }
        }
        if (dupGroups.length > 0) {
            for (String dupGroup : dupGroups) {
                JSONAddGroupResult duplicate = new JSONAddGroupResult(0, dupGroup);
                dupList.add(duplicate);
            }
        }
        return new JSONAddGroupResultParent(succList.toArray(new JSONAddGroupResult[0]), dupList.toArray(new JSONAddGroupResult[0]));
    }

    public String[][] deauthUsersAndGroups(int dlgGroupId, String userNames, String groupNames, String viaMembership) throws EntityException {
        String[] groupNameArray;
        String msg;
        int removedGroupsCount = 0;
        int removedUsersCount = 0;
        ArrayList<String> userNameList = new ArrayList<String>();
        ArrayList<String> usersFailedToRemove = new ArrayList<String>();
        ArrayList<String> groupsFailedToRemove = new ArrayList<String>();
        String dlgGroupName = this.fICActiveObjectService.getDelegatedGroup(dlgGroupId).getGroupName();
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (userNames != null && !userNames.isEmpty() || viaMembership != null && !viaMembership.isEmpty()) {
            if (userNames != null && !userNames.isEmpty()) {
                userNameList.addAll(Arrays.asList(userNames.split(COMMA_STRING)));
            }
            if (!viaMembership.isEmpty()) {
                userNameList.addAll(Arrays.asList(this.fSpaceGroupUtil.getGroupMemberNamesViaImport(viaMembership.split(COMMA_STRING))));
            }
            for (String string : userNameList) {
                ConfluenceUser user = this.fUserAccessor.getUserByName(string);
                if (user == null) {
                    usersFailedToRemove.add(string);
                    continue;
                }
                UserKey userKey = user.getKey();
                try {
                    CSUMDlgGrpAuthUsrEntity userEntity = this.fICActiveObjectService.getDlgGrpAuthUserByKeyAndGroupId(userKey, dlgGroupId);
                    if (userEntity != null) {
                        this.fICActiveObjectService.deleteDlgGrpAuthUser(userEntity);
                        msg = "User de-authorized from delegated group: " + dlgGroupName;
                        this.fICActiveObjectService.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.deauthorizeUser, ICSUMActiveObjectService.CSUMAuditEventOutcome.success, null, dlgGroupName, userKey.getStringValue(), currentUser.getName(), msg, null, null);
                        LOG.debug(msg);
                        ++removedUsersCount;
                        continue;
                    }
                    usersFailedToRemove.add(string);
                    msg = "User failed to be de-authorized from delegated group: " + dlgGroupName;
                    this.fICActiveObjectService.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.deauthorizeUser, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, null, dlgGroupName, userKey.getStringValue(), currentUser.getName(), msg, null, null);
                    LOG.debug(msg);
                }
                catch (DuplicateException e) {
                    CSUMDlgGrpAuthUsrEntity[] userEntities;
                    LOG.error("exists in the database more than once - attempting to remove duplicate(s)", (Throwable)e);
                    for (CSUMDlgGrpAuthUsrEntity usrEntity : userEntities = this.fICActiveObjectService.getDupAuthUsersByKey(userKey.getStringValue())) {
                        this.fICActiveObjectService.deleteDlgGrpAuthUser(usrEntity);
                        ++removedUsersCount;
                    }
                }
            }
        }
        if (groupNames != null && !groupNames.isEmpty() && (groupNameArray = groupNames.split(COMMA_STRING)).length > 0) {
            for (String groupName : groupNameArray) {
                CSUMDlgGrpAuthGrpEntity[] authGroupEntity = new CSUMDlgGrpAuthGrpEntity[]{};
                try {
                    authGroupEntity = this.fICActiveObjectService.getDlgGrpAuthGrp(groupName);
                }
                catch (DuplicateException e) {
                    LOG.info(e.getLocalizedMessage());
                }
                if (authGroupEntity.length < 1) {
                    groupsFailedToRemove.add(groupName);
                    msg = "Group failed to be de-authorized: " + groupName + " from dlg group: " + dlgGroupName;
                    this.fICActiveObjectService.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.deauthorizeGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, null, dlgGroupName, null, currentUser.getName(), msg, null, groupName);
                    LOG.debug(msg);
                    continue;
                }
                if (authGroupEntity[0] == null) continue;
                this.fICActiveObjectService.deleteDlgGrpAuthGrp(authGroupEntity[0]);
                ++removedGroupsCount;
                msg = "Group de-authorized: " + groupName + " from dlg group: " + dlgGroupName;
                this.fICActiveObjectService.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.deauthorizeGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.success, null, dlgGroupName, null, currentUser.getName(), msg, null, groupName);
                LOG.debug(msg);
            }
        }
        String[] usersFailedArr = new String[usersFailedToRemove.size()];
        String[] stringArray = new String[groupsFailedToRemove.size()];
        usersFailedToRemove.toArray(usersFailedArr);
        groupsFailedToRemove.toArray(stringArray);
        String[][] data = new String[3][2];
        data[0] = usersFailedArr;
        data[1] = stringArray;
        data[2][0] = String.valueOf(removedGroupsCount);
        data[2][1] = String.valueOf(removedUsersCount);
        return data;
    }

    public List<String> performGroupSearch(String searchTerm, int max, int dlgGroupId) throws EntityException {
        boolean exitLoop;
        com.atlassian.user.search.query.Query<Group> query = this.buildGroupQuery(searchTerm);
        SearchResult searchResult = this.fUserAccessor.findGroups(query);
        Pager visibleGroups = searchResult.pager();
        ArrayList<String> matches = new ArrayList<String>();
        do {
            List currentPage = visibleGroups.getCurrentPage();
            for (Group group : currentPage) {
                if (dlgGroupId == 0) {
                    matches.add(group.getName());
                    continue;
                }
                if (matches.size() > max) break;
                matches.add(group.getName());
            }
            boolean bl = exitLoop = visibleGroups.onLastPage() || matches.size() == max;
            if (exitLoop) continue;
            visibleGroups.nextPage();
        } while (!exitLoop);
        return matches;
    }

    public List<String> performAuthGroupSearch(String searchTerm, int max, int dlgGroupId) throws EntityException {
        boolean exitLoop;
        com.atlassian.user.search.query.Query<Group> query = this.buildGroupQuery(searchTerm);
        SearchResult searchResult = this.fUserAccessor.findGroups(query);
        Pager visibleGroups = searchResult.pager();
        ArrayList<String> matches = new ArrayList<String>();
        while (!(exitLoop = this.authGroupSearch(max, dlgGroupId, (Pager<Group>)visibleGroups, matches))) {
        }
        return matches;
    }

    private boolean authGroupSearch(int max, int dlgGroupId, Pager<Group> visibleGroups, List<String> matches) {
        boolean exitLoop;
        CSUMDlgGrpAuthGrpEntity[] authGroupEntities;
        List currentPage = visibleGroups.getCurrentPage();
        for (CSUMDlgGrpAuthGrpEntity groupEntity : authGroupEntities = this.fICActiveObjectService.getDelegatedGroup(dlgGroupId).getAuthGroups()) {
            for (Group group : currentPage) {
                if (!groupEntity.getGroupName().equalsIgnoreCase(group.getName())) continue;
                matches.add(group.getName());
            }
            if (matches.size() > max) break;
        }
        boolean bl = exitLoop = visibleGroups.onLastPage() || matches.size() == max;
        if (!exitLoop) {
            visibleGroups.nextPage();
        }
        return exitLoop;
    }

    private com.atlassian.user.search.query.Query<Group> buildGroupQuery(String searchTerm) {
        if (searchTerm == null) {
            throw new IllegalArgumentException("Search term should not be null");
        }
        GroupNameTermQuery retQuery = new GroupNameTermQuery(searchTerm, "contains");
        return retQuery;
    }

    public String[] fillFormatData(List<AuthGroupBean> groups) {
        String[] data = new String[groups.size()];
        for (int i = 0; i < groups.size(); ++i) {
            data[i] = groups.get(i).getGroupName();
        }
        return data;
    }

    public Map<String, UserSearchResult[]> searchAuthUsers(String query) {
        boolean disabledUsersHidden = false;
        ICachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
        if (cachedConfig.getDisabledUserHandling().equalsIgnoreCase("hide")) {
            disabledUsersHidden = true;
        }
        ArrayList<UserSearchResult> jsonObjList = new ArrayList<UserSearchResult>();
        EntityQuery userQuery = QueryBuilder.queryFor(com.atlassian.crowd.embedded.api.User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)query), Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)query), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)query)})).startingAt(0).returningAtMost(10);
        Iterable results = this.fCrowdService.search((Query)userQuery);
        for (com.atlassian.crowd.embedded.api.User aUser : results) {
            UserSearchResult o = new UserSearchResult(aUser.getName(), aUser.getDisplayName(), aUser.getEmailAddress());
            jsonObjList.add(o);
        }
        this.fUserUtil.removeDisabledUsers(disabledUsersHidden, jsonObjList);
        return this.transferJsonObjListSortedMap(jsonObjList);
    }

    public Map<String, UserSearchResult[]> transferJsonObjListSortedMap(List<UserSearchResult> jsonObjList) {
        jsonObjList.sort(Comparator.comparing(o -> o.getUsername().toLowerCase()));
        UserSearchResult[] jsonObjArr = new UserSearchResult[jsonObjList.size()];
        jsonObjList.toArray(jsonObjArr);
        HashMap<String, UserSearchResult[]> result = new HashMap<String, UserSearchResult[]>();
        result.put("users", jsonObjArr);
        return result;
    }

    public DataTableUserList listAuthUsers(int dlgGroupId) throws EntityException {
        DlgGroupBean dlGroup = this.getDlgGroup(dlgGroupId);
        if (dlGroup != null) {
            List authUsers = dlGroup.getAuthUsers();
            ArrayList<ConfluenceUser> users = new ArrayList<ConfluenceUser>();
            for (AuthUserBean authUserBean : authUsers) {
                String keyString = authUserBean.getKey();
                UserKey userkey = new UserKey(keyString);
                ConfluenceUser user = this.fUserAccessor.getUserByKey(userkey);
                users.add(user);
            }
            User[] userArr = new User[authUsers.size()];
            users.toArray(userArr);
            return new DataTableUserList(userArr, this.fUserAccessor, this.fGroupManager, this.fCacheManager, this.fGroupUtil);
        }
        return new DataTableUserList(new User[0], this.fUserAccessor, this.fGroupManager, this.fCacheManager, this.fGroupUtil);
    }

    public Map<String, UserSearchResult[]> searchAuthUsersFromGroup(String query, int dlgGroupId) throws AuthorizationException {
        CSUMDlgGrpAuthUsrEntity[] authUsers;
        boolean disabledUsersHidden = false;
        ICachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
        if (cachedConfig.getDisabledUserHandling().equalsIgnoreCase("hide")) {
            disabledUsersHidden = true;
        }
        ArrayList<UserSearchResult> jsonObjList = new ArrayList<UserSearchResult>();
        for (CSUMDlgGrpAuthUsrEntity userEntity : authUsers = this.fICActiveObjectService.getDelegatedGroup(dlgGroupId).getAuthUsers()) {
            UserSearchResult o;
            String authUserKeyStr = userEntity.getUserKey();
            UserKey userkey = new UserKey(authUserKeyStr);
            ConfluenceUser authUser = this.fUserAccessor.getUserByKey(userkey);
            if (authUser == null) {
                LOG.error("User not authorized");
                throw new AuthorizationException("User with key [" + userkey + "] not authorized");
            }
            String fullName = authUser.getFullName();
            String userName = authUser.getName();
            String email = authUser.getEmail();
            if (!query.equalsIgnoreCase("*")) {
                if (!fullName.contains(query) && !userName.contains(query) && !email.contains(query)) continue;
                o = new UserSearchResult(userName, fullName, email);
                jsonObjList.add(o);
                continue;
            }
            o = new UserSearchResult(userName, fullName, email);
            jsonObjList.add(o);
        }
        this.fUserUtil.removeDisabledUsers(disabledUsersHidden, jsonObjList);
        return this.transferJsonObjListSortedMap(jsonObjList);
    }

    public List<String> removeUsersSpaceDlgGroups(String dlgGroups, String userNames, String membershipGroups, Space space) throws RemoveAllUsersException, EntityException, AuthorizationException {
        String usersToStr;
        List<String> groups = Arrays.asList(dlgGroups.split(COMMA_STRING));
        ICSUMActiveObjectService.CSUMOperationType operationType = ICSUMActiveObjectService.CSUMOperationType.removeUserFromGroup;
        this.checkUserAuthorization(space, groups, operationType);
        HashSet<ConfluenceUser> userList = new HashSet<ConfluenceUser>();
        if (userNames != null && !userNames.isEmpty()) {
            String[] users;
            for (String userName : users = userNames.split(COMMA_STRING)) {
                userList.add(this.fUserAccessor.getUserByName(userName));
            }
        }
        if (membershipGroups != null && !membershipGroups.isEmpty()) {
            this.removeUsersWithGroupMembership(membershipGroups, space, groups, userList);
        }
        if (!(usersToStr = userList.stream().map(Entity::getName).collect(Collectors.joining(COMMA_STRING))).isEmpty() && this.isRemovingLastUser(dlgGroups, usersToStr, space)) {
            throw new RemoveAllUsersException(this.fI18n.getText("csum.error.remove.last.user"));
        }
        ArrayList<Group> groupList = new ArrayList<Group>();
        for (String groupName : groups) {
            groupList.add(this.fGroupManager.getGroup(groupName));
        }
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        ArrayList<String> failedToRemove = new ArrayList<String>();
        for (Group groupObj : groupList) {
            this.removeMembershipFromGroupList(space, userList, currentUser, failedToRemove, groupObj);
        }
        return failedToRemove;
    }

    private void removeMembershipFromGroupList(Space space, Set<ConfluenceUser> userList, ConfluenceUser currentUser, List<String> failedToRemove, Group groupObj) throws EntityException {
        String groupName = groupObj.getName();
        for (ConfluenceUser userObj : userList) {
            if (this.fGroupManager.hasMembership(groupObj, (User)userObj)) {
                this.fGroupManager.removeMembership(groupObj, (User)userObj);
                String msg = "User removed from group: " + groupName;
                this.fICActiveObjectService.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeUserFromGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.success, space, groupName, userObj.getKey().getStringValue(), currentUser.getName(), msg, null, null);
                LOG.debug(msg);
                continue;
            }
            failedToRemove.add(userObj.getName());
        }
    }

    private void removeUsersWithGroupMembership(String membershipGroups, Space space, List<String> groups, Set<ConfluenceUser> userList) throws EntityException, RemoveAllUsersException {
        String[] membershipGroupArr = membershipGroups.split(COMMA_STRING);
        for (String groupName : membershipGroupArr = this.removeBlocklistedGroups(membershipGroupArr).toArray(new String[0])) {
            if (groups.contains(groupName) && this.isSystemGroup(groupName)) {
                String msg = "Trying to remove members of " + groupName + " by removing members with membership of " + groupName;
                this.fICActiveObjectService.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeUserFromGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, groupName, null, AuthenticatedUserThreadLocal.getUsername(), msg, null, null);
                LOG.error(msg);
                throw new RemoveAllUsersException(this.fI18n.getText("csum.error.remove.last.user"));
            }
            Group group = this.fGroupManager.getGroup(groupName);
            if (group == null) continue;
            for (ConfluenceUser userObject : this.fUserAccessor.getMembers(group)) {
                userList.add(userObject);
            }
        }
    }

    public List<String> performSpaceDlgGroupSearch(String prefix, int max, ConfluenceUser user) throws EntityException, JAXBException {
        boolean exitLoop;
        com.atlassian.user.search.query.Query<Group> query = this.buildGroupQuery(prefix);
        SearchResult searchResult = this.fUserAccessor.findGroups(query);
        Pager visibleGroups = searchResult.pager();
        ArrayList<String> matches = new ArrayList<String>();
        do {
            Group group;
            List currentPage = visibleGroups.getCurrentPage();
            Iterator iterator = currentPage.iterator();
            while (iterator.hasNext() && !this.dlgGroupSearchPage(max, user, matches, group = (Group)iterator.next())) {
            }
            boolean bl = exitLoop = visibleGroups.onLastPage() || matches.size() == max;
            if (exitLoop) continue;
            visibleGroups.nextPage();
        } while (!exitLoop);
        return matches;
    }

    private boolean dlgGroupSearchPage(int max, ConfluenceUser user, List<String> matches, Group group) throws JAXBException {
        String[] groupEntryBeans = this.fCacheManager.getDlgGroupsForUser(user);
        CSUMDlgGroupCacheEntry[] visibleGroupList = new CSUMDlgGroupCacheEntry[groupEntryBeans.length];
        for (int i = 0; i < groupEntryBeans.length; ++i) {
            visibleGroupList[i] = DlgEntryXmlStrConv.stringToBean(groupEntryBeans[i]);
        }
        for (CSUMDlgGroupCacheEntry cachedDlgGroup : visibleGroupList) {
            if (!cachedDlgGroup.getGroupName().equalsIgnoreCase(group.getName())) continue;
            matches.add(group.getName());
        }
        return matches.size() > max;
    }

    public DataTableGroupList formatSpaceDelegatedGroupData(CSUMDlgGroupCacheEntry[] groups, int draw, int filteredRecords, int totalRecords) throws EntityException {
        int i = 0;
        String[][] data = new String[groups.length][];
        for (CSUMDlgGroupCacheEntry group : groups) {
            String groupName = group.getGroupName();
            boolean isValid = this.fGroupManager.getGroup(groupName) != null;
            data[i++] = new String[]{String.valueOf(group.getDlgGroupEntityId()), groupName, String.valueOf(isValid)};
        }
        return new DataTableGroupList(data, false, draw, filteredRecords, totalRecords);
    }

    public DlgGroupBean getDlgGroupBean(String dlgGroup) throws DuplicateException, EntityException {
        return this.getDlgBean(this.fICActiveObjectService.getDelegatedGroup(dlgGroup));
    }

    private DlgGroupBean getDlgBean(CSUMDelegatedGroupEntity delegatedGroup) throws EntityException {
        DlgGroupBean dlgGroupBean = null;
        if (delegatedGroup != null) {
            dlgGroupBean = new DlgGroupBean();
            int id = delegatedGroup.getID();
            dlgGroupBean.setGroupName(delegatedGroup.getGroupName());
            dlgGroupBean.setDlgGroupEntityId(id);
            dlgGroupBean.setAuthGroups(this.getDlgAuthGroups(id));
            dlgGroupBean.setAuthUsers(this.getDlgAuthUsers(id));
        }
        return dlgGroupBean;
    }

    public boolean isDlgGroup(String groupName) throws DuplicateException, EntityException {
        boolean result = false;
        DlgGroupBean dlgGroup = this.getDlgGroupBean(groupName);
        if (dlgGroup != null) {
            result = dlgGroup.getDlgGroupEntityId() != 0;
        }
        return result;
    }

    public void delAllDbAuthUsersAndGroups() {
        CSUMDlgGrpAuthUsrEntity[] allUsers = this.fICActiveObjectService.getAllAuthUsers();
        CSUMDlgGrpAuthGrpEntity[] allGroups = this.fICActiveObjectService.getAllAuthGroups();
        for (CSUMDlgGrpAuthUsrEntity user : allUsers) {
            this.fICActiveObjectService.deleteDlgGrpAuthUser(user);
        }
        for (CSUMDlgGrpAuthGrpEntity group : allGroups) {
            this.fICActiveObjectService.deleteDlgGrpAuthGrp(group);
        }
    }

    public void rebuildAuthUserCache() {
        this.fCacheManager.deleteAuthUsers();
    }

    @Nonnull
    public List<String> getDlgGroupsForUser(ConfluenceUser remoteUser) {
        return Arrays.asList(this.fCacheManager.getDlgGroupsForUser(remoteUser));
    }

    public DataTableUserList getAuthUsersInDatatableFormat(DlgGroupBean dlgGroup) throws EntityException {
        return this.listAuthUsers(dlgGroup.getDlgGroupEntityId());
    }

    public void unauthorizeGroup(String groupName) {
        this.fICActiveObjectService.deleteAuthorizedGroup(groupName);
    }

    private boolean isNotDelegatedForAllGroups(@Nonnull List<String> groupNames) {
        ArrayList<String> delegatedGroups = new ArrayList<String>();
        try {
            for (String s : this.getDlgGroupsForUser(AuthenticatedUserThreadLocal.get())) {
                CSUMDlgGroupCacheEntry csumDlgGroupCacheEntry = DlgEntryXmlStrConv.stringToBean(s);
                String groupName = csumDlgGroupCacheEntry.getGroupName();
                delegatedGroups.add(groupName);
            }
        }
        catch (JAXBException e) {
            LOG.error("Exception during delegated group cache value conversion", (Throwable)e);
        }
        return !delegatedGroups.containsAll(groupNames);
    }

    private void checkUserAuthorization(Space space, List<String> groups, ICSUMActiveObjectService.CSUMOperationType operationType) throws AuthorizationException {
        if (!this.fPermissionUtil.isAuthorized(space) || this.isNotDelegatedForAllGroups(groups)) {
            String msg = "UNAUTHORIZED access attempt by user: " + AuthenticatedUserThreadLocal.getUsername();
            this.fICActiveObjectService.createAuditEntity(operationType, ICSUMActiveObjectService.CSUMAuditEventOutcome.unauthorized, space, null, null, AuthenticatedUserThreadLocal.getUsername(), msg, null, null);
            LOG.error(msg);
            throw new AuthorizationException(this.fI18n.getText("notpermitted"));
        }
    }

    public JSONAddUserResultBean[] addUsersToGroups(Space space, String groupNames, String userNames, String importViaGroups) throws AuthorizationException, EntityException {
        String[] groupNameArr = groupNames.split(COMMA_STRING);
        ICSUMActiveObjectService.CSUMOperationType operationType = ICSUMActiveObjectService.CSUMOperationType.addUserToGroup;
        this.checkUserAuthorization(space, Arrays.asList(groupNameArr), operationType);
        ArrayList<JSONAddUserResultBean> groupResults = new ArrayList<JSONAddUserResultBean>();
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        try {
            this.addProvidedUsersToProvidedGroups(space, userNames, importViaGroups, groupNameArr, groupResults, currentUser);
        }
        catch (EntityException e) {
            this.fSpaceGroupUtil.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.addUserToGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, null, null, currentUser.getName(), e.getLocalizedMessage(), null, null);
            LOG.error("Exception during addition of space group members", (Throwable)e);
            throw e;
        }
        return groupResults.toArray(new JSONAddUserResultBean[0]);
    }

    private void addProvidedUsersToProvidedGroups(Space space, String userNames, String importViaGroups, String[] groupNameArr, List<JSONAddUserResultBean> groupResults, ConfluenceUser currentUser) throws EntityException {
        ArrayList<String> unSuccessfulUsers = new ArrayList<String>();
        ArrayList<String> unSuccessfulUserNames = new ArrayList<String>();
        ArrayList<String> unSuccessfulUserReasons = new ArrayList<String>();
        ArrayList<Group> groups = new ArrayList<Group>();
        for (String groupName : groupNameArr) {
            groups.add(this.fGroupManager.getGroup(groupName));
        }
        SpaceGroupUtil.OperationResult<ConfluenceUser> userValidationResult = this.fSpaceGroupUtil.validateCSVUsers(space, userNames, importViaGroups.split(COMMA_STRING));
        int totalUsers = userValidationResult.successes.size() + userValidationResult.failures.size();
        String autoJoinGroupsStr = this.fCacheManager.getCachedConfig().getAutoJoinGroups();
        if (autoJoinGroupsStr != null && !autoJoinGroupsStr.isEmpty()) {
            this.getAutoJoinGroups(groups, autoJoinGroupsStr);
        }
        for (Group aGroup : groups) {
            if (aGroup == null) continue;
            int successfulUsersCounter = 0;
            unSuccessfulUsers.clear();
            unSuccessfulUserNames.clear();
            unSuccessfulUserReasons.clear();
            for (ConfluenceUser aUser : userValidationResult.successes) {
                Objects.requireNonNull(aUser);
                Objects.requireNonNull(aGroup);
                String userKey = aUser.getKey().getStringValue();
                String userName = aUser.getName();
                if (!this.fGroupManager.hasMembership(aGroup, (User)aUser)) {
                    this.fGroupManager.addMembership(aGroup, (User)aUser);
                    this.fICActiveObjectService.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.addUserToGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.success, space, aGroup.getName(), userKey, currentUser.getName(), null, null, null);
                    ++successfulUsersCounter;
                    continue;
                }
                unSuccessfulUsers.add(userKey);
                unSuccessfulUserNames.add(userName);
                unSuccessfulUserReasons.add(MEMBERSHIP_REASON);
            }
            JSONAddUserResultBean groupData = new JSONAddUserResultBean(aGroup.getName(), successfulUsersCounter, unSuccessfulUsers.toArray(new String[0]), unSuccessfulUserNames.toArray(new String[0]), unSuccessfulUserReasons.toArray(new String[0]), totalUsers);
            groupResults.add(groupData);
        }
    }

    private void getAutoJoinGroups(List<Group> groups, String autoJoinGroupsStr) throws EntityException {
        String[] autoJoinGroupArr;
        for (String groupName : autoJoinGroupArr = autoJoinGroupsStr.split(COMMA_STRING)) {
            Group autoGroup = this.fGroupManager.getGroup(groupName);
            if (autoGroup == null || groups.contains(autoGroup)) continue;
            groups.add(autoGroup);
        }
    }

    public boolean isRemovingLastUser(String dlgGroups, String userNames, Space space) throws EntityException {
        boolean removingAllUsers = false;
        ArrayList<ConfluenceUser> activeUsers = new ArrayList<ConfluenceUser>();
        ArrayList<ConfluenceUser> disabledUsers = new ArrayList<ConfluenceUser>();
        HashSet<Group> allGroupsSet = new HashSet<Group>();
        String[] dlgGroupArr = dlgGroups.split(COMMA_STRING);
        if (userNames != null) {
            removingAllUsers = this.isRemoveUsers(userNames, space, removingAllUsers, activeUsers, disabledUsers, allGroupsSet, dlgGroupArr);
        }
        return removingAllUsers;
    }

    private boolean isRemoveUsers(String userNames, Space space, boolean removingAllUsers, List<ConfluenceUser> activeUsers, List<ConfluenceUser> disabledUsers, Set<Group> allGroupsSet, String[] dlgGroupArr) throws EntityException {
        List<String> userNamesList = Arrays.asList(userNames.split(COMMA_STRING));
        for (String groupName : dlgGroupArr) {
            allGroupsSet.add(this.fGroupManager.getGroup(groupName));
        }
        for (Group currentGroup : allGroupsSet) {
            disabledUsers.clear();
            activeUsers.clear();
            if (this.fPermissionUtil.hasPermission(currentGroup, "USECONFLUENCE") || this.fPermissionUtil.hasPermission(currentGroup, "ADMINISTRATECONFLUENCE")) {
                for (String userName : userNamesList) {
                    ConfluenceUser user = this.fUserAccessor.getUserByName(userName);
                    if (this.fUserAccessor.isDeactivated((User)user)) {
                        disabledUsers.add(user);
                        continue;
                    }
                    activeUsers.add(user);
                }
                removingAllUsers = this.isRemovingAllUsers(userNamesList, activeUsers, disabledUsers, currentGroup);
            }
            if (!removingAllUsers) continue;
            String msg = "Trying to remove all members from a system group: " + currentGroup;
            this.fICActiveObjectService.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeUserFromGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, currentGroup.getName(), null, AuthenticatedUserThreadLocal.getUsername(), msg, null, null);
            LOG.error(msg);
            break;
        }
        return removingAllUsers;
    }

    public boolean isRemovingAllUsers(List<String> userNamesList, List<ConfluenceUser> users, List<ConfluenceUser> disabledUsers, Group group) {
        List members = this.fUserAccessor.getMemberNamesAsList(group);
        int numOfUsersInGroup = members.size();
        return numOfUsersInGroup == users.size() + disabledUsers.size() || this.isRemovingAllActiveUsers(userNamesList, members);
    }

    private boolean isRemovingAllActiveUsers(List<String> userNamesList, List<String> allUserNames) {
        ArrayList<String> activeUsers = new ArrayList<String>();
        for (String userName : allUserNames) {
            if (this.fUserAccessor.isDeactivated(userName)) continue;
            activeUsers.add(userName);
        }
        return userNamesList.containsAll(activeUsers);
    }

    public boolean dlgGroupActionsPermitted() {
        return this.fCacheManager.getCachedConfig().isDlgGrpActPerm();
    }

    private boolean isSystemGroup(String groupName) throws EntityException {
        boolean matched = false;
        Group aGroup = this.fGroupManager.getGroup(groupName);
        if (this.fPermissionUtil.hasPermission(aGroup, "USECONFLUENCE") || this.fPermissionUtil.hasPermission(aGroup, "ADMINISTRATECONFLUENCE")) {
            matched = true;
        }
        return matched;
    }

    private Set<String> removeBlocklistedGroups(String[] currentFilteredGroups) {
        ICachedConfig cachedConfig;
        String blocklistedGroupsString;
        HashSet<String> originalGroups = new HashSet<String>(Arrays.asList(currentFilteredGroups));
        if (!(originalGroups.isEmpty() || (blocklistedGroupsString = (cachedConfig = this.fCacheManager.getCachedConfig()).getBlocklistGroups()) == null || blocklistedGroupsString.equalsIgnoreCase("none") || blocklistedGroupsString.equalsIgnoreCase(""))) {
            String[] blocklistedGroups;
            for (String blocklistedGroupName : blocklistedGroups = blocklistedGroupsString.split(Pattern.quote("|"))) {
                originalGroups.remove(blocklistedGroupName);
                if (originalGroups.isEmpty()) break;
            }
        }
        return originalGroups;
    }
}

