/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.util;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.pluginpeople.confluence.csum.ao.CSUMBadGroupToolStatus;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.util.IBadGroupNameFinder;
import com.pluginpeople.confluence.csum.util.IBadGroupNameFixer;
import com.pluginpeople.confluence.csum.util.OpStatus;
import com.pluginpeople.confluence.csum.util.ToolRequest;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CSUMToolManager
implements DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(CSUMToolManager.class);
    private static Timestamp lastUpdateCommitted;
    private final IBadGroupNameFixer fBadGroupFixer;
    private final ICSUMActiveObjectService fAo;
    private final IBadGroupNameFinder fBadGroupFinder;
    private ScheduledExecutorService fFinderUpdater = null;
    private ScheduledExecutorService fFixerUpdater = null;
    private final TransactionTemplate fTxTemplate;

    @Autowired
    public CSUMToolManager(ICSUMActiveObjectService ao, IBadGroupNameFinder badGroupFinder, IBadGroupNameFixer badGroupFixer, @ComponentImport TransactionTemplate txTemplate) {
        this.fAo = ao;
        this.fBadGroupFinder = badGroupFinder;
        this.fBadGroupFixer = badGroupFixer;
        this.fTxTemplate = txTemplate;
    }

    public boolean isRunningOnLocalNode(ToolKey tool) {
        boolean running = false;
        if (tool != null) {
            if (tool.equals((Object)ToolKey.BAD_GROUP_FINDER)) {
                running = this.fBadGroupFinder.getStatus().equals((Object)OpStatus.RUNNING);
            } else if (tool.equals((Object)ToolKey.BADGROUP_FIXER)) {
                running = this.fBadGroupFixer.getStatus().equals((Object)OpStatus.RUNNING);
            }
        }
        return running;
    }

    public void resetIfTaskStuck() {
        CSUMBadGroupToolStatus globalStatus = this.fAo.getBadGroupToolStatus();
        if (globalStatus != null) {
            Timestamp oneMinuteAgo = new Timestamp(System.currentTimeMillis() - 60000L);
            if (globalStatus.getStatus().equals(OpStatus.RUNNING.name()) && globalStatus.getLastUpdated().before(oneMinuteAgo)) {
                LOG.debug("Global group fixer tool status not updated in last 60s, resetting for new launch");
                this.resetBadGroupTool(globalStatus);
            }
        }
    }

    public ToolRequest requestBadGroupFinderLaunch() {
        ToolRequest req;
        CSUMBadGroupToolStatus globalStatus = this.fAo.getBadGroupToolStatus();
        if (globalStatus != null) {
            if (!globalStatus.getStatus().equals(OpStatus.RUNNING.name())) {
                req = this.fBadGroupFinder.launch(AuthenticatedUserThreadLocal.get());
                if (req.isSuccess()) {
                    this.startFinderUpdates();
                }
            } else {
                Timestamp oneMinuteAgo = new Timestamp(System.currentTimeMillis() - 60000L);
                if (globalStatus.getLastUpdated().before(oneMinuteAgo)) {
                    LOG.debug("Global group fixer tool status not updated in last 60s, resetting for new launch");
                    this.resetBadGroupTool(globalStatus);
                    req = this.fBadGroupFinder.launch(AuthenticatedUserThreadLocal.get());
                    if (req.isSuccess()) {
                        this.startFinderUpdates();
                    }
                } else {
                    req = this.isRunningOnLocalNode(ToolKey.BAD_GROUP_FINDER) ? new ToolRequest(true, null) : new ToolRequest(false, "Bad group tool already running");
                }
            }
        } else {
            req = new ToolRequest(false, "Global group fixer tool status could not be found/created");
        }
        return req;
    }

    public void requestBadGroupFinderStop() {
        if (this.fBadGroupFinder.getStatus().equals((Object)OpStatus.RUNNING)) {
            this.fBadGroupFinder.stop();
        }
    }

    public ToolRequest requestBadGroupFixerLaunch() {
        ToolRequest req;
        CSUMBadGroupToolStatus globalStatus = this.fAo.getBadGroupToolStatus();
        if (globalStatus != null) {
            if (!globalStatus.getStatus().equals(OpStatus.RUNNING.name())) {
                req = this.fBadGroupFixer.launch(AuthenticatedUserThreadLocal.get());
                if (req.isSuccess()) {
                    this.startFixerUpdates();
                }
            } else {
                Timestamp oneMinuteAgo = new Timestamp(System.currentTimeMillis() - 60000L);
                if (globalStatus.getLastUpdated().before(oneMinuteAgo)) {
                    LOG.debug("Global group fixer status not updated in last 60s, resetting for new launch");
                    this.resetBadGroupTool(globalStatus);
                    req = this.fBadGroupFixer.launch(AuthenticatedUserThreadLocal.get());
                    if (req.isSuccess()) {
                        this.startFixerUpdates();
                    }
                } else {
                    req = this.isRunningOnLocalNode(ToolKey.BADGROUP_FIXER) ? new ToolRequest(true, null) : new ToolRequest(false, "Bad group tool already running");
                }
            }
        } else {
            req = new ToolRequest(false, "Global group fixer status could not be found/created");
        }
        return req;
    }

    public void requestBadGroupFixerStop() {
        if (this.fBadGroupFixer.getStatus().equals((Object)OpStatus.RUNNING)) {
            this.fBadGroupFixer.stop();
        }
    }

    public Map<String, Object> getBadGroupFinderProgress() {
        HashMap<String, Object> statusData = new HashMap<String, Object>();
        statusData.put("status", this.fBadGroupFinder.getStatus().name());
        statusData.put("found", this.fBadGroupFinder.getFoundCount());
        statusData.put("processed", this.fBadGroupFinder.getProcessed());
        statusData.put("error", this.fBadGroupFinder.getError());
        return statusData;
    }

    public Map<String, Object> getBadGroupFixerProgress() {
        HashMap<String, Object> statusData = new HashMap<String, Object>();
        statusData.put("status", this.fBadGroupFixer.getStatus().name());
        statusData.put("fixed", this.fBadGroupFixer.getFixedCount());
        statusData.put("total", this.fBadGroupFixer.getInitialCount());
        statusData.put("error", this.fBadGroupFixer.getError());
        return statusData;
    }

    private void resetBadGroupTool(CSUMBadGroupToolStatus globalStatus) {
        if (this.fBadGroupFinder.getStatus().equals((Object)OpStatus.RUNNING)) {
            this.fBadGroupFinder.stop();
        }
        if (this.fBadGroupFixer.getStatus().equals((Object)OpStatus.RUNNING)) {
            this.fBadGroupFixer.stop();
        }
        globalStatus.setStatus(OpStatus.IDLE.name());
        globalStatus.setLastUpdated(new Timestamp(System.currentTimeMillis()));
        globalStatus.save();
    }

    private Timestamp getLastCommited() {
        return (Timestamp)this.fTxTemplate.execute((TransactionCallback)new TransactionCallback<Timestamp>(){

            public Timestamp doInTransaction() {
                CSUMBadGroupToolStatus statusEnt = CSUMToolManager.this.fAo.getBadGroupToolStatus();
                if (statusEnt != null) {
                    return statusEnt.getLastUpdated();
                }
                return null;
            }
        });
    }

    private synchronized void startFinderUpdates() {
        this.fFinderUpdater = Executors.newScheduledThreadPool(1, new UpdaterThreadFactory());
        this.fFinderUpdater.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (lastUpdateCommitted == null || lastUpdateCommitted.before(new Timestamp(System.currentTimeMillis() - 10000L)) || !CSUMToolManager.this.fBadGroupFinder.getStatus().equals((Object)OpStatus.RUNNING)) {
                    CSUMToolManager.this.fTxTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                        public Object doInTransaction() {
                            CSUMBadGroupToolStatus statusEnt = CSUMToolManager.this.fAo.getBadGroupToolStatus();
                            if (statusEnt != null) {
                                Timestamp now = new Timestamp(System.currentTimeMillis());
                                statusEnt.setStatus(CSUMToolManager.this.fBadGroupFinder.getStatus().name());
                                statusEnt.setInitUser(CSUMToolManager.this.fBadGroupFinder.getInitiatingUser().getName());
                                statusEnt.setLastUpdated(now);
                                statusEnt.save();
                                lastUpdateCommitted = now;
                            }
                            return null;
                        }
                    });
                    if (!CSUMToolManager.this.fBadGroupFinder.getStatus().equals((Object)OpStatus.RUNNING)) {
                        CSUMToolManager.this.stopFinderUpdates();
                    }
                }
            }
        }, 0L, 1L, TimeUnit.SECONDS);
    }

    private void stopFinderUpdates() {
        LOG.debug("Stopping finder updates");
        if (this.fFinderUpdater != null) {
            this.fFinderUpdater.shutdownNow();
            try {
                if (!this.fFinderUpdater.awaitTermination(30L, TimeUnit.SECONDS)) {
                    LOG.error("Updates for finder failed to terminate after 30s");
                }
            }
            catch (InterruptedException e) {
                this.fFinderUpdater.shutdownNow();
                Thread.currentThread().interrupt();
            }
            finally {
                this.fFinderUpdater = null;
                lastUpdateCommitted = null;
            }
        }
    }

    private synchronized void startFixerUpdates() {
        this.fFixerUpdater = Executors.newScheduledThreadPool(1, new UpdaterThreadFactory());
        this.fFixerUpdater.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (lastUpdateCommitted == null || lastUpdateCommitted.before(new Timestamp(System.currentTimeMillis() - 10000L)) || !CSUMToolManager.this.fBadGroupFixer.getStatus().equals((Object)OpStatus.RUNNING)) {
                    CSUMToolManager.this.fTxTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                        public Object doInTransaction() {
                            CSUMBadGroupToolStatus statusEnt = CSUMToolManager.this.fAo.getBadGroupToolStatus();
                            if (statusEnt != null) {
                                Timestamp now = new Timestamp(System.currentTimeMillis());
                                statusEnt.setStatus(CSUMToolManager.this.fBadGroupFixer.getStatus().name());
                                statusEnt.setInitUser(CSUMToolManager.this.fBadGroupFixer.getInitiatingUser().getName());
                                statusEnt.setLastUpdated(now);
                                statusEnt.save();
                                lastUpdateCommitted = now;
                            }
                            return null;
                        }
                    });
                    if (!CSUMToolManager.this.fBadGroupFixer.getStatus().equals((Object)OpStatus.RUNNING)) {
                        CSUMToolManager.this.stopFixerUpdates();
                    }
                }
            }
        }, 0L, 1L, TimeUnit.SECONDS);
    }

    private void stopFixerUpdates() {
        LOG.debug("Stopping fixer updates");
        if (this.fFixerUpdater != null) {
            this.fFixerUpdater.shutdownNow();
            try {
                if (!this.fFixerUpdater.awaitTermination(30L, TimeUnit.SECONDS)) {
                    LOG.error("Updates for fixer failed to terminate after 30s");
                }
            }
            catch (InterruptedException e) {
                this.fFixerUpdater.shutdownNow();
                Thread.currentThread().interrupt();
            }
            finally {
                this.fFixerUpdater = null;
                lastUpdateCommitted = null;
            }
        }
    }

    public void destroy() {
        LOG.debug("Destroying bad group fixer updater");
        this.stopFinderUpdates();
        this.stopFixerUpdates();
    }

    private class UpdaterThreadFactory
    implements ThreadFactory {
        private UpdaterThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "CSUMFixerStatusUpdater");
        }
    }

    public static enum ToolKey {
        BAD_GROUP_FINDER,
        BADGROUP_FIXER;

    }
}

