/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.util;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.SpaceComparator;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CSUMPermissionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CSUMPermissionUtil.class);
    private final PluginLicenseManager fPluginLicenseManager;
    private final PermissionManager fConfluencePermissionMgr;
    private final SpacePermissionManager fSpacePermissionMgr;
    private final PermissionManager fPermissionManager;
    private final SpaceManager fSpaceManager;
    private final ICSUMCacheManager fCacheManager;

    @Autowired
    public CSUMPermissionUtil(@ComponentImport PermissionManager confPermissionMgr, @ComponentImport SpacePermissionManager spacePermissionMgr, @ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport PermissionManager permissionManager, @ComponentImport SpaceManager spaceManager, ICSUMCacheManager cacheManager) {
        this.fConfluencePermissionMgr = confPermissionMgr;
        this.fSpacePermissionMgr = spacePermissionMgr;
        this.fPluginLicenseManager = pluginLicenseManager;
        this.fPermissionManager = permissionManager;
        this.fSpaceManager = spaceManager;
        this.fCacheManager = cacheManager;
    }

    public PluginLicenseManager getPluginLicenseManager() {
        return this.fPluginLicenseManager;
    }

    public boolean isAuthorized(Space aSpace) {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        return this.fConfluencePermissionMgr.isConfluenceAdministrator((User)currentUser) || this.fConfluencePermissionMgr.hasPermission((User)currentUser, Permission.ADMINISTER, (Object)aSpace);
    }

    public boolean isGlobalAdmin() {
        ConfluenceUser current = AuthenticatedUserThreadLocal.get();
        return this.fConfluencePermissionMgr.isSystemAdministrator((User)current) || this.fConfluencePermissionMgr.isConfluenceAdministrator((User)current);
    }

    public boolean isGlobalAdmin(ConfluenceUser currentUser) {
        return this.fConfluencePermissionMgr.isSystemAdministrator((User)currentUser) || this.fConfluencePermissionMgr.isConfluenceAdministrator((User)currentUser);
    }

    public List<SpacePermission> getPermissions(String groupName) {
        return this.fSpacePermissionMgr.getAllPermissionsForGroup(groupName);
    }

    public void savePermission(SpacePermission permission) {
        try {
            this.fSpacePermissionMgr.savePermission(permission);
        }
        catch (EntityNotFoundException enfe) {
            LOG.error("Error during saving of SpacePermission " + permission.getType() + " for space " + permission.getSpace().getKey() + ", manual triage of permission update may be required", (Throwable)enfe);
        }
    }

    public void removePermission(SpacePermission permission) {
        try {
            this.fSpacePermissionMgr.removePermission(permission);
        }
        catch (EntityNotFoundException enfe) {
            LOG.error("Error during removal of SpacePermission " + permission.getType() + " for space " + permission.getSpace().getKey() + ", manual triage of permission update may be required", (Throwable)enfe);
        }
    }

    public boolean hasPermission(Group group, String permissionType) {
        List globalPermissions = this.fSpacePermissionMgr.getGlobalPermissions();
        ArrayList<SpacePermission> permissions = new ArrayList<SpacePermission>();
        for (SpacePermission spacePermission : globalPermissions) {
            String spacePermissionGroup = spacePermission.getGroup();
            if (spacePermissionGroup == null || !spacePermission.isGroupPermission() || !spacePermission.getType().equalsIgnoreCase(permissionType) || !spacePermissionGroup.equalsIgnoreCase(group.getName())) continue;
            permissions.add(spacePermission);
        }
        return !permissions.isEmpty();
    }

    public final boolean isLicenseValid() {
        boolean valid = false;
        try {
            PluginLicense license;
            if (this.fPluginLicenseManager.getLicense().isDefined() && !(license = (PluginLicense)this.fPluginLicenseManager.getLicense().get()).getError().isDefined()) {
                valid = true;
            }
        }
        catch (Exception e) {
            LOG.error("Exception thrown trying to fetch licence", (Throwable)e);
        }
        return valid;
    }

    public List<Space> getSpacesAsSpaceAdminForUser() {
        return this.getSpacesAssociatedToUserForGivenPermission((User)AuthenticatedUserThreadLocal.get(), "SETSPACEPERMISSIONS");
    }

    public List<Space> getSpacesAssociatedToUserForGivenPermission(User user, String permission) {
        List spaceList;
        if (this.fPermissionManager.isSystemAdministrator(user)) {
            spaceList = this.fSpaceManager.getAllSpaces();
        } else {
            SpacesQuery spaceQuery = SpacesQuery.newQuery().forUser(user).withPermission(permission).build();
            spaceList = this.fSpaceManager.getAllSpaces(spaceQuery);
        }
        if (!this.fCacheManager.getCachedConfig().isPersonalSpaceAllowed()) {
            ArrayList<Space> toRemove = new ArrayList<Space>();
            for (Space thisSpace : spaceList) {
                String key = thisSpace.getKey();
                if (key == null || !key.startsWith("~")) continue;
                toRemove.add(thisSpace);
            }
            spaceList.removeAll(toRemove);
        }
        spaceList.sort(new SpaceComparator());
        return spaceList;
    }
}

