/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.task;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.pluginpeople.confluence.csum.ao.CSUMTaskEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.AuthorizationException;
import com.pluginpeople.confluence.csum.task.AbstractTask;
import com.pluginpeople.confluence.csum.task.TaskType;
import com.pluginpeople.confluence.csum.util.SpaceGroupUtil;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddUsersTask
extends AbstractTask {
    private static final Logger LOG = LoggerFactory.getLogger(AddUsersTask.class);
    private final GroupManager fGroupManager;
    private final SpaceGroupUtil fSpaceGroupUtil;
    private final String fFilePath;
    private final ConfluenceUser fInitiator;
    private final Space fSpace;
    private final ICSUMActiveObjectService fAos;
    private final boolean fWillNotify;

    public AddUsersTask(String filePath, ConfluenceUser initiator, Space space, GroupManager groupManager, SpaceGroupUtil spaceGroupUtil, ICSUMActiveObjectService aos, boolean willNotify) {
        this.fInitiator = initiator;
        this.fSpace = space;
        this.fGroupManager = groupManager;
        this.fFilePath = filePath;
        this.fSpaceGroupUtil = spaceGroupUtil;
        this.fAos = aos;
        this.fWillNotify = willNotify;
    }

    @Override
    public String getName() {
        return "Importing memberships from CSV";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processRecord(CSVRecord csvRecord, int taskEntityId) {
        boolean isSuccessfulUser = false;
        CSUMTaskEntity taskEntity = this.fAos.getTaskEntity(taskEntityId);
        if (taskEntity != null) {
            String successfulUsersStr = taskEntity.getSuccessfulUsers();
            String unsuccessfulUsersStr = taskEntity.getUnsuccessfulUsers();
            String userNameVal = csvRecord.get(0).trim();
            String groupNameVal = csvRecord.get(1).trim();
            try {
                SpaceGroupUtil.OperationResult<ConfluenceUser> userValidationResult = this.fSpaceGroupUtil.validateCSVUsers(this.fSpace, userNameVal, new String[0]);
                if (!userValidationResult.successes.isEmpty()) {
                    Group group = this.fGroupManager.getGroup(groupNameVal);
                    if (group != null) {
                        isSuccessfulUser = this.addValidUserToGroup(userNameVal, groupNameVal, userValidationResult);
                    }
                } else {
                    LOG.error("Empty userValidationResult.successes. name: " + userNameVal + " not associated with a valid User.");
                }
            }
            catch (Exception e) {
                LOG.error("Exception thrown in addValidUserToGroup, could not add user: " + userNameVal, (Throwable)e);
            }
            finally {
                AbstractTask.saveTaskEntity(taskEntity, isSuccessfulUser, successfulUsersStr, unsuccessfulUsersStr, userNameVal);
            }
        }
        return isSuccessfulUser;
    }

    private boolean addValidUserToGroup(String userNameVal, String groupNameVal, SpaceGroupUtil.OperationResult<ConfluenceUser> userValidationResult) throws EntityException, AuthorizationException {
        boolean ret = false;
        Group selectedGroup = this.fGroupManager.getGroup(groupNameVal);
        if (selectedGroup != null) {
            ConfluenceUser aUser = (ConfluenceUser)userValidationResult.successes.get(0);
            if (aUser != null) {
                LOG.debug("Attempting to add valid user: " + aUser.getName() + " into Group: " + selectedGroup.getName());
                ret = this.fSpaceGroupUtil.addSingleUserToGroup(aUser, selectedGroup, this.fSpace, this.fInitiator, false);
            } else {
                LOG.error("User by name: " + userNameVal + " was valid, but could not be found for adding to group: " + groupNameVal);
            }
        } else {
            LOG.error("value: " + groupNameVal + " found no matching groups. Could not add user: " + userNameVal);
        }
        return ret;
    }

    @Override
    public ConfluenceUser getInitiatingUser() {
        return this.fInitiator;
    }

    @Override
    public String getFilePath() {
        return this.fFilePath;
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.ADD_GROUP_MEMBERS;
    }

    @Override
    public Space getSpace() {
        return this.fSpace;
    }

    @Override
    public int getExpectedFieldCount() {
        return 2;
    }

    @Override
    public boolean willNotify() {
        return this.fWillNotify;
    }
}

