/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.rest;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.access.annotations.RequiresLicensedConfluenceAccess;
import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.pluginpeople.confluence.csum.ao.CSUMAuditEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.InvalidSpaceException;
import com.pluginpeople.confluence.csum.rest.AbstractCSUMRestResource;
import com.pluginpeople.confluence.csum.rest.beans.AuditTableData;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ReadOnlyAccessAllowed
@Path(value="auditing")
@RequiresLicensedConfluenceAccess
public class AuditingResource
extends AbstractCSUMRestResource {
    private static final Logger LOG = LoggerFactory.getLogger(AuditingResource.class);
    private final ICSUMActiveObjectService fAos;
    private final UserAccessor fUserAccessor;
    private static final String ASC = "ASC";
    private static final String DESC = "DESC";
    private static final String SPACE = " ";
    private static final String CREATED_DATE = "CREATED_DATE";
    private static final String SPACE_KEY = "SPACE_KEY";
    private static final String CREATED_BY_USER_NAME = "CREATED_BY_USER_NAME";
    private static final String OPERATION_TYPE = "OPERATION_TYPE";
    private static final String GROUP_NAME = "GROUP_NAME";
    private static final String USER_NAME = "USER_NAME";
    private static final String EVENT_OUTCOME = "EVENT_OUTCOME";
    private static final String AUTH_GROUP = "AUTH_GROUP";

    public AuditingResource(XsrfTokenService tokenService, CSUMPermissionUtil permissionUtil, ICSUMActiveObjectService aos, SpaceManager spaceManager, PermissionManager permissionManager, UserAccessor userAccessor) {
        super(spaceManager, permissionUtil, tokenService, permissionManager);
        this.fAos = aos;
        this.fUserAccessor = userAccessor;
    }

    @POST
    @Path(value="records")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response getAuditRecords(@Context HttpServletRequest hsr, @FormParam(value="draw") int draw, @FormParam(value="start") int start, @FormParam(value="length") int length, @FormParam(value="orderCol") int orderCol, @FormParam(value="orderDir") String orderDir, @FormParam(value="outcomeVal") String outcomeVal, @FormParam(value="opTypeVal") String opTypeVal, @FormParam(value="creatorVal") String creatorVal, @FormParam(value="groupVal") String groupVal, @FormParam(value="userVal") String userVal, @FormParam(value="spaceVal") String spaceKey) {
        Response response;
        if (this.isUnauthorizedOrBadXsrfToken(hsr, spaceKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Space space = null;
        try {
            if (!spaceKey.equals("")) {
                space = this.getValidSpaceFromKey(spaceKey);
            }
        }
        catch (InvalidSpaceException e) {
            LOG.error("Invalid Space, could not find Space using spacekey: " + spaceKey, (Throwable)e);
        }
        try {
            String creatorUserKey = this.getUserKey(creatorVal);
            String contextUserKey = this.getUserKey(userVal);
            Query filtered = this.fAos.getAuditEventQuery(space, creatorUserKey, opTypeVal, groupVal, contextUserKey, outcomeVal);
            Query unfiltered = this.fAos.getAuditEventQuery(space, null, null, null, null, null);
            int recordsTotal = this.fAos.getCountForQuery(CSUMAuditEntity.class, unfiltered);
            int recordsFiltered = this.fAos.getCountForQuery(CSUMAuditEntity.class, filtered);
            CSUMAuditEntity[] pagedEnts = this.fAos.getAuditEvents(filtered.order(this.getOrderClause(orderCol, orderDir)).offset(start).limit(length));
            AuditTableData data = new AuditTableData(pagedEnts, draw, recordsFiltered, recordsTotal, null, this.fUserAccessor);
            response = Response.ok((Object)data).build();
        }
        catch (Exception e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getLocalizedMessage()).build();
        }
        return response;
    }

    private String getUserKey(String userName) {
        String ret = userName;
        ConfluenceUser user = this.fUserAccessor.getUserByName(userName);
        if (user != null) {
            ret = String.valueOf(user.getKey());
        }
        return ret;
    }

    private String getOrderClause(int colNumber, String dir) {
        String direction = DESC.equalsIgnoreCase(dir) ? DESC : ASC;
        String column = this.getColumnName(colNumber);
        return column + SPACE + direction;
    }

    private String getColumnName(int colNumber) {
        String column = colNumber == 0 ? CREATED_DATE : (colNumber == 1 ? SPACE_KEY : (colNumber == 2 ? CREATED_BY_USER_NAME : (colNumber == 3 ? OPERATION_TYPE : (colNumber == 4 ? GROUP_NAME : (colNumber == 5 ? USER_NAME : (colNumber == 6 ? EVENT_OUTCOME : AUTH_GROUP))))));
        return column;
    }
}

