/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.action;

import com.atlassian.confluence.compat.api.service.accessmode.AccessModeCompatService;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.pluginpeople.confluence.csum.action.AbstractCSUMSpaceAction;
import com.pluginpeople.confluence.csum.ao.CSUMAuditEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.service.cache.ICachedConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSUMSpaceConfigAction
extends AbstractCSUMSpaceAction {
    private static final long serialVersionUID = -2986683032211589835L;
    private static final Logger LOG = LoggerFactory.getLogger(CSUMSpaceConfigAction.class);
    private static final String CRLF = "\r\n";
    private static final String COMMA = ",";
    private static final String QUOTE = "\"";
    public static final String SPACE = " ";
    public static final char CHAR_T = 'T';
    public static final char CHAR_FULL_STOP = '.';
    private File fConfluenceLocalHome;
    private AccessModeCompatService fAccessModeCompatService;
    private static final String CSV_LINE = "\"EV_ID\",\"EV_DATE\",\"EV_TIME\",\"EV_USER\",\"EV_TYPE\",\"EV_OUTCOME\",\"SPACE_KEY\",\"SPACE_NAME\",\"GROUP_NAME\",\"USER_NAME\",\"USER_FULLNAME\"\r\n";

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        super.setBootstrapManager(bootstrapManager);
        this.fConfluenceLocalHome = bootstrapManager.getLocalHome();
    }

    public void setAccessModeCompatService(AccessModeCompatService compatService) {
        this.fAccessModeCompatService = compatService;
    }

    public String doDefault() {
        LOG.debug("CSUMSpaceConfigAction.doDefault() called");
        LOG.debug("request uri: " + ServletActionContext.getRequest().getRequestURI());
        String result = null;
        result = this.isLicenseValid() ? this.setupForView() : "error";
        return result;
    }

    private String setupForView() {
        String ret = "success";
        if (this.getSpace() == null) {
            LOG.warn("Space was null");
            ArrayList<String> resultList = new ArrayList<String>();
            resultList.add(this.getText("csum.display.alert.invalid.space.key"));
            this.setActionErrors(resultList);
        } else if (this.getAuthenticatedUser() == null) {
            LOG.warn("RemoteUser was null");
            ArrayList<String> resultList = new ArrayList<String>();
            resultList.add(this.getText("csum.display.alert.invaliduser"));
            this.setActionErrors(resultList);
        }
        return ret;
    }

    public ICachedConfig getConfig() {
        return this.fCacheManager.getCachedConfig();
    }

    public String urlEncode(String param) throws UnsupportedEncodingException {
        return URLEncoder.encode(param, "UTF-8");
    }

    public List<Space> getAllSpaces() {
        return this.fSpaceManager.getAllSpaces();
    }

    @Override
    public String formatDate(Timestamp t) {
        return t.toGMTString();
    }

    public String getUserAvatarUrlByKey(String userKey) {
        ConfluenceUser u;
        UserAccessor ua = this.getUserAccessor();
        ProfilePictureInfo userProfilePicture = ua.getUserProfilePicture((User)(u = ua.getUserByKey(new UserKey(userKey))));
        String ret = userProfilePicture.isExternal() ? "/images/icons/profilepics/default.png" : userProfilePicture.getUriReference();
        return ret;
    }

    public String getUserAvatarUrlByName(String username) {
        ConfluenceUser u;
        UserAccessor ua = this.getUserAccessor();
        ProfilePictureInfo userProfilePicture = ua.getUserProfilePicture((User)(u = ua.getUserByName(username)));
        String ret = userProfilePicture.isExternal() ? "/images/icons/profilepics/default.png" : userProfilePicture.getUriReference();
        return ret;
    }

    public String getSpaceAvatarUrl(String spaceKey) {
        String baseUrl = this.getGlobalSettings().getBaseUrl();
        return baseUrl + this.fSpaceManager.getLogoForSpace(spaceKey).getDownloadPath();
    }

    public String getBaseUrl() {
        return this.getGlobalSettings().getBaseUrl();
    }

    public String urlEscapeText(String param) {
        return URLEncoder.encode(param);
    }

    public boolean isGroupExists(String groupName) {
        Group aGroup = this.getUserAccessor().getGroup(groupName);
        return aGroup != null;
    }

    public String doDeleteOldHistory() {
        String ret = null;
        LOG.info("Deleting old CSUM audit history");
        Space aSpace = this.getSpace();
        if (this.space != null) {
            ConfluenceUser currentUser = this.getAuthenticatedUser();
            if (this.fPermissionManager.isConfluenceAdministrator((User)currentUser) || this.fPermissionManager.hasPermission((User)currentUser, Permission.ADMINISTER, (Object)aSpace)) {
                int deleted = this.fAos.deleteAuditEntities(aSpace, 30);
                LOG.debug("Deleted " + deleted + " records");
                ret = "success";
            } else {
                this.addActionError("User is not a global admin or a space admin: " + aSpace.getKey());
            }
        } else {
            ret = "error";
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doGenerateCsvAuditReport() {
        boolean isPersonalAndNotPermitted;
        String ret = "success";
        Space aSpace = this.getSpace();
        if (aSpace == null) {
            return ret;
        }
        ConfluenceUser currentUser = this.getAuthenticatedUser();
        boolean isNotAuthed = !this.fPermissionManager.isConfluenceAdministrator((User)currentUser) && !this.fPermissionManager.hasPermission((User)currentUser, Permission.ADMINISTER, (Object)aSpace);
        boolean bl = isPersonalAndNotPermitted = aSpace.isPersonal() && !this.getConfig().isPersonalSpaceAllowed();
        if (isNotAuthed || isPersonalAndNotPermitted) {
            if (isNotAuthed) {
                this.addActionError("User is not a global admin or a space admin: " + aSpace.getKey());
            }
            return ret;
        }
        LOG.debug("doGenerateCsvAuditReport - UPDATE");
        File f = null;
        try {
            f = File.createTempFile("csum", "csv", new File(this.fConfluenceLocalHome, "temp"));
            if (!f.exists()) {
                LOG.error("Unable to create temp file (check local home permissions) : " + f.getAbsolutePath());
            } else {
                this.writeDataToFile(aSpace, f);
                if (f.length() > 0L) {
                    ret = this.writeOutResponse(aSpace, f);
                }
            }
        }
        catch (IOException e) {
            LOG.error("Error writing csv audit data", (Throwable)e);
        }
        finally {
            if (f != null) {
                try {
                    Files.delete(f.toPath());
                }
                catch (IOException e) {
                    f.getAbsolutePath();
                    LOG.error("Unable to delete temp csv audit file: " + f.getAbsolutePath(), (Throwable)e);
                }
            }
        }
        return ret;
    }

    private void writeDataToFile(Space aSpace, File f) throws IOException {
        block6: {
            try (FileOutputStream fos = new FileOutputStream(f);){
                this.addSpaceEventHeaders(fos);
                CSUMAuditEntity[] spaceEvents = this.fAos.getAuditEvents(aSpace);
                if (spaceEvents != null && spaceEvents.length > 0) {
                    LOG.debug("Processing " + spaceEvents.length + " events from Space: " + (aSpace != null ? (aSpace.getKey() != null ? aSpace.getKey() : "null") : "null"));
                    this.writeSpaceEventData(fos, spaceEvents);
                    break block6;
                }
                LOG.debug("No audit events found for Space: " + (aSpace != null ? (aSpace.getKey() != null ? aSpace.getKey() : "null") : "null"));
            }
        }
    }

    private String writeOutResponse(Space aSpace, File f) {
        String ret;
        HttpServletResponse response = ServletActionContext.getResponse();
        try (FileInputStream fis = new FileInputStream(f);
             ServletOutputStream os = response.getOutputStream();){
            byte[] data = IOUtils.toByteArray((InputStream)fis);
            String filename = "csum-auditing-" + aSpace.getKey().toUpperCase() + "-" + new Timestamp(System.currentTimeMillis()).toLocalDateTime().toString().replace(":", "_") + ".csv";
            response.setHeader("Content-Disposition", "attachment; filename=\"" + filename + QUOTE);
            response.setContentType("text/csv");
            response.setContentLength(data.length);
            response.setStatus(200);
            os.write(data);
            os.flush();
            ret = null;
        }
        catch (IOException e) {
            LOG.error("A problem occurred during Auditing CSV export", (Throwable)e);
            ret = "success";
        }
        return ret;
    }

    private void addSpaceEventHeaders(FileOutputStream fos) throws IOException {
        fos.write(CSV_LINE.getBytes());
    }

    private void writeSpaceEventData(OutputStream os, CSUMAuditEntity[] spaceEvents) throws IOException {
        for (CSUMAuditEntity e : spaceEvents) {
            StringBuilder csvLine = new StringBuilder();
            csvLine.append(e.getID());
            String eTs = e.getCreatedDate() != null ? e.getCreatedDate().toLocalDateTime().toString() : "";
            csvLine.append(COMMA).append(eTs, 0, eTs.indexOf(84));
            if (eTs.indexOf(46) != -1) {
                csvLine.append(COMMA).append(eTs, eTs.indexOf(84) + 1, eTs.lastIndexOf(46));
            } else {
                csvLine.append(COMMA).append(eTs.substring(eTs.indexOf(84) + 1));
            }
            String userKey = e.getContextUserKey() != null ? e.getContextUserKey() : "";
            csvLine.append(COMMA).append(this.getUsernameFromKey(userKey));
            String rawOperationType = e.getOperationType() != null ? e.getOperationType() : "";
            csvLine.append(COMMA).append(rawOperationType.replace(COMMA, SPACE));
            String rawEventOutcome = e.getEventOutcome() != null ? e.getEventOutcome() : "";
            csvLine.append(COMMA).append(rawEventOutcome.replace(COMMA, SPACE));
            String rawSpaceKey = e.getSpaceKey() != null ? e.getSpaceKey() : "";
            csvLine.append(COMMA).append(rawSpaceKey);
            csvLine.append(COMMA).append(rawSpaceKey.replace(COMMA, SPACE));
            String rawGroupName = e.getGroupName() != null ? e.getGroupName() : "";
            csvLine.append(COMMA).append(rawGroupName.replace(COMMA, SPACE));
            ConfluenceUser contextUser = null;
            if (e.getContextUserKey() != null) {
                contextUser = this.getUserAccessor().getUserByKey(new UserKey(e.getContextUserKey()));
            }
            if (contextUser != null) {
                csvLine.append(COMMA).append(contextUser.getName().replace(COMMA, SPACE));
                String fullName = contextUser.getFullName();
                if (fullName != null) {
                    csvLine.append(COMMA).append(fullName.replace(COMMA, SPACE));
                } else {
                    csvLine.append(COMMA);
                }
            } else {
                csvLine.append(",,");
            }
            csvLine.append(CRLF);
            os.write(csvLine.toString().getBytes(StandardCharsets.UTF_8));
        }
    }

    public ICSUMActiveObjectService.CSUMOperationType[] getOperations() {
        return ICSUMActiveObjectService.CSUMOperationType.values();
    }

    public String getContextPath() {
        return this.settingsManager.getGlobalSettings().getBaseUrl();
    }

    public boolean isDcReadOnly() {
        return this.fAccessModeCompatService.isReadOnlyAccessModeEnabled();
    }
}

