/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.util;

import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.util.SecureRandomStringUtils;
import com.atlassian.fugue.Pair;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.impl.EntityMissingException;
import com.atlassian.user.search.SearchResult;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.query.GroupNameTermQuery;
import com.atlassian.user.search.query.Query;
import com.atlassian.user.security.password.Credential;
import com.pluginpeople.confluence.csum.action.ICSUMDataDefs;
import com.pluginpeople.confluence.csum.ao.CSUMAuditEntity;
import com.pluginpeople.confluence.csum.ao.CSUMDelegatedGroupEntity;
import com.pluginpeople.confluence.csum.ao.CSUMLdapConfigEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.AuthorizationException;
import com.pluginpeople.confluence.csum.api.DuplicateException;
import com.pluginpeople.confluence.csum.api.GroupActionNotPermittedException;
import com.pluginpeople.confluence.csum.api.LdapDetailsDTO;
import com.pluginpeople.confluence.csum.api.SpaceGroupPatternMismatchException;
import com.pluginpeople.confluence.csum.ldap.LDAPException;
import com.pluginpeople.confluence.csum.ldap.LDAPLookupUtil;
import com.pluginpeople.confluence.csum.ldap.LDAPUser;
import com.pluginpeople.confluence.csum.rest.beans.SpaceSearchResult;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.service.cache.ICachedConfig;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.Session;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpaceGroupUtil {
    private final ContentPermissionManager fContentPermManager;
    private final ICSUMCacheManager fCacheManager;
    private final SpaceManager fSpaceManager;
    private final GroupManager fGroupManager;
    private final SpacePermissionManager fSpacePermissionManager;
    private final UserManager fUserManager;
    private final UserAccessor fUserAccessor;
    private final I18nResolver fI18n;
    private final CSUMPermissionUtil fPermissionUtil;
    ICSUMActiveObjectService fAos;
    private static final int MINUS_ONE = -1;
    private static final int RANDOM_PASSWORD_LENGTH = 22;
    public static final String NAME_EQUAL = ", name=";
    public static final String COMMA = ",";
    private static final Logger LOG = LogManager.getLogger(SpaceGroupUtil.class);
    private static final String NOT_PERMITTED = "not.permitted.description";
    private static final String GROUP_ACTIONS_DISABLED = "csum.action.group.disabled";
    private static final String NO_PATTERN_MATCH = "csum.display.alert.no.pattern.match";
    private static final String NOT_AUTHORISED = "csum.error.not.authorized";
    private static final String RENAMING_SPACE_GROUP_WITH_ORIGINAL_NAME = " for renaming Space Group with original name: ";
    private static final String UNAUTHORISED_USER_ATTEMPT = "UNAUTHORIZED access attempt by user: ";
    private static final String GROUP_PERMISSION_FAILURE = "Group Action Permission failure by user: ";
    private static final String AUDIT_EVENT_CREATED_WITH_ID = ". Audit event created with ID: ";
    private static final String USER_SPACE_GROUP_PATTERN_MISMATCH = "SpaceGroupPatternMismatchException by user: ";
    private static final String FOR_ADDING = " for adding users to groups";
    private static final String INVALID_REASON = "invalid";
    private static final String MEMBERSHIP_REASON = "membership";
    private static final String SPACE_GROUP_NAME = ", spaceGroupName=";
    private static final String USER_NAME_CSV = ", userNameCsv=";

    @Autowired
    public SpaceGroupUtil(ICSUMCacheManager cacheManager, @ComponentImport SpaceManager spaceManager, @ComponentImport GroupManager groupMgr, @ComponentImport UserManager userMgr, ICSUMActiveObjectService aos, @ComponentImport I18nResolver i18n, CSUMPermissionUtil permissionUtil, @ComponentImport UserAccessor userAccessor, @ComponentImport ContentPermissionManager contentPermManager, @ComponentImport SpacePermissionManager spacePermissionMgr) {
        this.fCacheManager = cacheManager;
        this.fSpaceManager = spaceManager;
        this.fGroupManager = groupMgr;
        this.fUserManager = userMgr;
        this.fAos = aos;
        this.fI18n = i18n;
        this.fPermissionUtil = permissionUtil;
        this.fUserAccessor = userAccessor;
        this.fContentPermManager = contentPermManager;
        this.fSpacePermissionManager = spacePermissionMgr;
    }

    public Group createSpaceGroup(Space space, String groupName) throws AuthorizationException, GroupActionNotPermittedException, DuplicateException, EntityException {
        Group createdGroup = null;
        if (!this.fPermissionUtil.isAuthorized(space)) {
            CSUMAuditEntity auditEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.createGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.unauthorized, space, null, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText(NOT_AUTHORISED), null, null);
            LOG.error(UNAUTHORISED_USER_ATTEMPT + AuthenticatedUserThreadLocal.getUsername() + " for Space Group creation. Audit event created with ID: " + auditEntity.getID());
            throw new AuthorizationException(this.fI18n.getText(NOT_PERMITTED));
        }
        if (!this.fCacheManager.getCachedConfig().isGroupActionsPermitted()) {
            CSUMAuditEntity auditEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.createGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.unauthorized, space, null, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText(GROUP_ACTIONS_DISABLED), null, null);
            LOG.error(GROUP_PERMISSION_FAILURE + AuthenticatedUserThreadLocal.getUsername() + " for Space Group creation. Audit event created with ID: " + auditEntity.getID());
            throw new GroupActionNotPermittedException(this.fI18n.getText(GROUP_ACTIONS_DISABLED));
        }
        String fullGroupName = this.computeSpaceGroupName(space, groupName);
        if (fullGroupName != null) {
            if (this.fGroupManager.getGroup(fullGroupName) != null) {
                CSUMAuditEntity auditEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.createGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, null, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText("csum.error.duplicate.group", new Serializable[]{fullGroupName}), null, null);
                LOG.error("DuplicateException by user: " + AuthenticatedUserThreadLocal.getUsername() + " for Space Group creation of duplicate Group: " + this.fGroupManager.getGroup(fullGroupName) + AUDIT_EVENT_CREATED_WITH_ID + auditEntity.getID());
                throw new DuplicateException(this.fI18n.getText("csum.error.duplicate.group", new Serializable[]{fullGroupName}));
            }
            createdGroup = this.fGroupManager.createGroup(fullGroupName);
            LOG.debug("Group created: " + createdGroup.getName());
            this.addViewSpacePermission(space, createdGroup);
            this.addSpaceGroupToCache(space, fullGroupName);
            this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.createGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.success, space, fullGroupName, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText("csum.auditing.operation.createGroup"), null, null);
        } else {
            LOG.error("Group name was empty");
        }
        return createdGroup;
    }

    public boolean deleteSpaceGroup(Space space, String groupName) throws AuthorizationException, SpaceGroupPatternMismatchException, GroupActionNotPermittedException, EntityException {
        boolean success;
        if (!this.fPermissionUtil.isAuthorized(space)) {
            CSUMAuditEntity auditEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.unauthorized, space, groupName, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText(NOT_AUTHORISED), null, null);
            LOG.error(UNAUTHORISED_USER_ATTEMPT + AuthenticatedUserThreadLocal.getUsername() + " for Space Group deletion. Audit event created with ID: " + auditEntity.getID());
            throw new AuthorizationException(this.fI18n.getText(NOT_PERMITTED));
        }
        if (!this.isSpaceGroup(space, groupName)) {
            CSUMAuditEntity auditEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, groupName, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText(NO_PATTERN_MATCH), null, null);
            LOG.error(USER_SPACE_GROUP_PATTERN_MISMATCH + AuthenticatedUserThreadLocal.getUsername() + " for Space Group deletion via pattern. Audit event created with ID: " + auditEntity.getID());
            throw new SpaceGroupPatternMismatchException(this.fI18n.getText(NO_PATTERN_MATCH) + ": " + groupName);
        }
        if (!this.fCacheManager.getCachedConfig().isGroupActionsPermitted()) {
            CSUMAuditEntity auditEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.unauthorized, space, groupName, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText(GROUP_ACTIONS_DISABLED), null, null);
            LOG.error(GROUP_PERMISSION_FAILURE + AuthenticatedUserThreadLocal.getUsername() + " for Space Group deletion. Audit event created with ID: " + auditEntity.getID());
            throw new GroupActionNotPermittedException(this.fI18n.getText(GROUP_ACTIONS_DISABLED));
        }
        this.validateSpaceGroups(space, groupName);
        try {
            Group group = this.fGroupManager.getGroup(groupName);
            if (group == null) {
                String msg = "Unable to find user group for deletion with name: " + groupName;
                this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, groupName, null, AuthenticatedUserThreadLocal.getUsername(), msg, null, null);
                LOG.error(msg);
                throw new EntityMissingException("Group was not found with groupName: " + groupName);
            }
            this.fContentPermManager.removeAllGroupPermissions(group.getName());
            this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.success, space, groupName, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText("csum.auditing.operation.removeGroup"), null, null);
            this.removeAllPermissions(group);
            this.fGroupManager.removeGroup(group);
            this.cleanupGroupCache(space);
            success = true;
        }
        catch (EntityException eme) {
            this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, groupName, null, AuthenticatedUserThreadLocal.getUsername(), eme.getLocalizedMessage(), null, null);
            LOG.error("Error getting group for delete: " + groupName, (Throwable)eme);
            throw eme;
        }
        return success;
    }

    public Space getSpaceForGroup(String groupName) {
        Space matchingSpace = null;
        List globalSpaces = this.fSpaceManager.getAllSpaces(SpacesQuery.newQuery().withSpaceType(SpaceType.GLOBAL).build());
        for (Space aSpace : globalSpaces) {
            if (!this.isSpaceGroup(aSpace, groupName)) continue;
            matchingSpace = aSpace;
            break;
        }
        return matchingSpace;
    }

    public boolean isSpaceGroup(Space aSpace, String groupName) {
        ICachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
        String prefix = cachedConfig.getGroupPrefixPattern();
        String suffix = cachedConfig.getGroupSuffixPattern();
        String lcGroupName = groupName.toLowerCase();
        String prefixStr = prefix != null ? prefix.replace("SPACEKEY", aSpace.getLowerKey()) : "";
        String suffixStr = suffix != null ? suffix.replace("SPACEKEY", aSpace.getLowerKey()) : "";
        boolean isPrefixMatch = prefix == null || lcGroupName.startsWith(prefixStr);
        boolean isSuffixMatch = isPrefixMatch && (suffix == null || lcGroupName.endsWith(suffixStr));
        return isPrefixMatch && isSuffixMatch;
    }

    public boolean validateRenameGroupIsAllowed(Space space, String oldName) throws SpaceGroupPatternMismatchException, GroupActionNotPermittedException, AuthorizationException, EntityException {
        ICachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
        if (!this.fPermissionUtil.isAuthorized(space)) {
            CSUMAuditEntity failedDeleteEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.unauthorized, space, oldName, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText(NOT_AUTHORISED), null, null);
            LOG.error(UNAUTHORISED_USER_ATTEMPT + AuthenticatedUserThreadLocal.getUsername() + RENAMING_SPACE_GROUP_WITH_ORIGINAL_NAME + oldName + AUDIT_EVENT_CREATED_WITH_ID + failedDeleteEntity.getID());
            throw new AuthorizationException(this.fI18n.getText(NOT_PERMITTED));
        }
        if (!this.isSpaceGroup(space, oldName)) {
            CSUMAuditEntity auditEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, oldName, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText(NO_PATTERN_MATCH), null, null);
            LOG.error(USER_SPACE_GROUP_PATTERN_MISMATCH + AuthenticatedUserThreadLocal.getUsername() + RENAMING_SPACE_GROUP_WITH_ORIGINAL_NAME + oldName + AUDIT_EVENT_CREATED_WITH_ID + auditEntity.getID());
            throw new SpaceGroupPatternMismatchException(this.fI18n.getText(NO_PATTERN_MATCH) + ": " + oldName);
        }
        if (!cachedConfig.isGroupActionsPermitted()) {
            CSUMAuditEntity auditEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.unauthorized, space, oldName, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText(GROUP_ACTIONS_DISABLED), null, null);
            LOG.error(GROUP_PERMISSION_FAILURE + AuthenticatedUserThreadLocal.getUsername() + " for renaming Space Group via pattern with original name: " + oldName + AUDIT_EVENT_CREATED_WITH_ID + auditEntity.getID());
            throw new GroupActionNotPermittedException(this.fI18n.getText(GROUP_ACTIONS_DISABLED));
        }
        OperationResult<Group> result = this.validateSpaceGroups(space, oldName);
        return !result.successes.isEmpty();
    }

    public Group importGroupToNewSpace(Space importFromSpace, Space importToSpace, String groupName) throws SpaceGroupPatternMismatchException, GroupActionNotPermittedException, AuthorizationException, DuplicateException, EntityException {
        Group newGroup;
        ICachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
        if (!this.fPermissionUtil.isAuthorized(importFromSpace)) {
            CSUMAuditEntity failedDeleteEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.unauthorized, importFromSpace, groupName, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText("csum.auditing.operation.renamegroup.unauthorized"), null, null);
            LOG.error(UNAUTHORISED_USER_ATTEMPT + AuthenticatedUserThreadLocal.getUsername() + RENAMING_SPACE_GROUP_WITH_ORIGINAL_NAME + groupName + AUDIT_EVENT_CREATED_WITH_ID + failedDeleteEntity.getID());
            throw new AuthorizationException(this.fI18n.getText(NOT_PERMITTED));
        }
        if (!this.isSpaceGroup(importFromSpace, groupName)) {
            CSUMAuditEntity auditEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, importFromSpace, groupName, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText("csum.auditing.operation.renamegroup.grouppattern"), null, null);
            LOG.error(USER_SPACE_GROUP_PATTERN_MISMATCH + AuthenticatedUserThreadLocal.getUsername() + RENAMING_SPACE_GROUP_WITH_ORIGINAL_NAME + groupName + AUDIT_EVENT_CREATED_WITH_ID + auditEntity.getID());
            throw new SpaceGroupPatternMismatchException(this.fI18n.getText(NO_PATTERN_MATCH) + ": " + groupName);
        }
        if (!cachedConfig.isGroupActionsPermitted()) {
            CSUMAuditEntity auditEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.unauthorized, importFromSpace, groupName, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText("csum.auditing.operation.actionnotpermitted"), null, null);
            LOG.error(GROUP_PERMISSION_FAILURE + AuthenticatedUserThreadLocal.getUsername() + " for renaming Space Group via pattern with original name: " + groupName + AUDIT_EVENT_CREATED_WITH_ID + auditEntity.getID());
            throw new GroupActionNotPermittedException(this.fI18n.getText(GROUP_ACTIONS_DISABLED));
        }
        try {
            this.validateSpaceGroups(importFromSpace, groupName);
            String baseGroupName = this.removePrefixAndSuffix(importFromSpace, groupName);
            newGroup = this.createSpaceGroup(importToSpace, baseGroupName);
            if (newGroup != null) {
                this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.importGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.success, importFromSpace, newGroup.getName(), null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText("csum.auditing.operation.importGroup"), null, null);
            }
        }
        catch (DuplicateException e) {
            LOG.error("Group already exists: " + groupName + " in space: " + importToSpace.getName(), (Throwable)e);
            throw e;
        }
        catch (EntityException e) {
            LOG.error("Cannot validate groups/cannot create new groups: " + groupName + ". Initial space: " + importFromSpace + ". Destination space: " + importToSpace, (Throwable)e);
            throw e;
        }
        return newGroup;
    }

    public Group convertToLowercase(@Nonnull Space space, @Nonnull String group) {
        Group converted = null;
        try {
            String targetName = group.toLowerCase();
            converted = this.changeGroupName(space, group, targetName);
        }
        catch (EntityException e) {
            LOG.error("Exception during group conversion to lowercase", (Throwable)e);
        }
        return converted;
    }

    private Group changeGroupName(Space space, String oldName, String newName) throws EntityException {
        Group newGroup = null;
        Group original = this.fGroupManager.getGroup(oldName);
        if (original != null) {
            Pager memberPager = this.fGroupManager.getMemberNames(original);
            newGroup = this.fGroupManager.createGroup(newName);
            for (String userStr : memberPager) {
                User user = this.fUserManager.getUser(userStr);
                if (user == null) continue;
                this.fGroupManager.addMembership(newGroup, user);
            }
            this.fGroupManager.removeGroup(original);
            this.cleanupGroupCache(space);
            this.addSpaceGroupToCache(space, newName);
        }
        return newGroup;
    }

    private void removeAllPermissions(Group g) {
        List<SpacePermission> allocatedPerms = this.fPermissionUtil.getPermissions(g.getName());
        for (SpacePermission aPermission : allocatedPerms) {
            this.fPermissionUtil.removePermission(aPermission);
        }
    }

    public String computeSpaceGroupName(Space aSpace, String groupName) {
        String fullGroupName = null;
        ICachedConfig config = this.fCacheManager.getCachedConfig();
        String prefix = config.getGroupPrefixPattern();
        String suffix = config.getGroupSuffixPattern();
        if (aSpace != null) {
            fullGroupName = ((prefix != null ? prefix.trim().replace("SPACEKEY", aSpace.getLowerKey()) : "") + groupName.trim() + (suffix != null ? suffix.trim().replace("SPACEKEY", aSpace.getLowerKey()) : "")).toLowerCase();
        } else {
            LOG.debug("computeSpaceGroupName() Space was not set");
        }
        return fullGroupName;
    }

    public String removePrefixAndSuffix(Space importFromSpace, String oldGroupName) {
        ICachedConfig config = this.fCacheManager.getCachedConfig();
        String prefixPattern = config.getGroupPrefixPattern();
        String suffixPattern = config.getGroupSuffixPattern();
        String prefix = null;
        int prefixIndex = -1;
        int suffixIndex = -1;
        if (prefixPattern != null && prefixPattern.equalsIgnoreCase("SPACEKEY-")) {
            prefix = importFromSpace.getLowerKey().toLowerCase().concat("-");
            prefixIndex = oldGroupName.indexOf(prefix);
        }
        if (suffixPattern != null && suffixPattern.equalsIgnoreCase("-SPACEKEY")) {
            String suffix = "-".concat(importFromSpace.getLowerKey().toLowerCase());
            suffixIndex = oldGroupName.indexOf(suffix);
        }
        String baseGroupName = prefixIndex > -1 && suffixIndex > -1 && prefix != null ? oldGroupName.substring(prefixIndex + prefix.length(), suffixIndex) : (prefixIndex > -1 && prefix != null ? oldGroupName.substring(prefixIndex + prefix.length()) : (suffixIndex > -1 ? oldGroupName.substring(0, suffixIndex) : oldGroupName));
        return baseGroupName;
    }

    public void cleanupGroupCache(Space aSpace) throws EntityException {
        String[] cachedGroups = this.fCacheManager.getSpaceGroups(aSpace);
        ArrayList<String> nonmatch = new ArrayList<String>();
        for (String cachedGroup : cachedGroups) {
            if (this.fGroupManager.getGroup(cachedGroup) == null) continue;
            nonmatch.add(cachedGroup);
        }
        String[] updatedGroups = new String[nonmatch.size()];
        nonmatch.toArray(updatedGroups);
        this.fCacheManager.setSpaceGroups(aSpace, updatedGroups);
    }

    public String[] refreshSpaceGroupsCache(Space space) throws AuthorizationException {
        if (!this.fPermissionUtil.isAuthorized(space)) {
            CSUMAuditEntity failedDeleteEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.getUsersOrGroups, ICSUMActiveObjectService.CSUMAuditEventOutcome.unauthorized, space, null, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText(NOT_AUTHORISED), null, null);
            LOG.error(UNAUTHORISED_USER_ATTEMPT + AuthenticatedUserThreadLocal.getUsername() + " for refreshing and retrieving Space Groups. Audit event created with ID: " + failedDeleteEntity.getID());
            throw new AuthorizationException(this.fI18n.getText(NOT_PERMITTED));
        }
        this.fCacheManager.deleteSpaceGroups(space);
        return this.fCacheManager.getSpaceGroups(space);
    }

    public String[] getSpaceGroupsFromCache(Space space) throws AuthorizationException {
        this.spaceGroupAuthorizationCheck(space);
        return this.fCacheManager.getSpaceGroups(space);
    }

    public String[] getPagedSpaceGroupsFromCache(Space space, int maxGroupRetrieval, int offset, String searchVal) throws AuthorizationException {
        this.spaceGroupAuthorizationCheck(space);
        return this.fCacheManager.getPagedSpaceGroups(space, maxGroupRetrieval, offset, searchVal);
    }

    private void spaceGroupAuthorizationCheck(Space space) throws AuthorizationException {
        if (!this.fPermissionUtil.isAuthorized(space)) {
            CSUMAuditEntity failedDeleteEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.getUsersOrGroups, ICSUMActiveObjectService.CSUMAuditEventOutcome.unauthorized, space, null, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText(NOT_AUTHORISED), null, null);
            LOG.error(UNAUTHORISED_USER_ATTEMPT + AuthenticatedUserThreadLocal.getUsername() + " for retrieving Space Groups. Audit event created with ID: " + failedDeleteEntity.getID());
            throw new AuthorizationException(this.fI18n.getText(NOT_PERMITTED));
        }
    }

    public void addSpaceGroupToCache(Space aSpace, String fullGroupName) {
        String[] cachedGroups;
        for (String group : cachedGroups = this.fCacheManager.getSpaceGroups(aSpace)) {
            if (!fullGroupName.equals(group)) continue;
            return;
        }
        int arrsize = cachedGroups.length + 1;
        String[] updatedGroups = new String[arrsize];
        System.arraycopy(cachedGroups, 0, updatedGroups, 0, cachedGroups.length);
        updatedGroups[updatedGroups.length - 1] = fullGroupName;
        this.fCacheManager.setSpaceGroups(aSpace, updatedGroups);
    }

    public void removeSpaceGroupFromCache(Space aSpace, String originalGroupName) {
        String[] cachedGroups = this.fCacheManager.getSpaceGroups(aSpace);
        List<String> cachedGroupsList = Arrays.asList(cachedGroups);
        for (String group : cachedGroupsList) {
            if (!originalGroupName.equals(group)) continue;
            cachedGroupsList.remove(group);
            String[] newCachedGroups = new String[cachedGroupsList.size()];
            int position = 0;
            Iterator<String> iterator = cachedGroupsList.iterator();
            while (iterator.hasNext()) {
                String remainingGroup;
                newCachedGroups[position] = remainingGroup = iterator.next();
                ++position;
            }
            this.fCacheManager.setSpaceGroups(aSpace, newCachedGroups);
            break;
        }
    }

    public List<String> searchGroupCache(Space space, @Nullable String query) throws AuthorizationException {
        String[] cachedGroups;
        if (!this.fPermissionUtil.isAuthorized(space)) {
            CSUMAuditEntity failedDeleteEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.getUsersOrGroups, ICSUMActiveObjectService.CSUMAuditEventOutcome.unauthorized, space, null, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText(NOT_AUTHORISED), null, null);
            LOG.error(UNAUTHORISED_USER_ATTEMPT + AuthenticatedUserThreadLocal.getUsername() + " for searching Group cache. Audit event created with ID: " + failedDeleteEntity.getID());
            throw new AuthorizationException(this.fI18n.getText(NOT_PERMITTED));
        }
        ArrayList<String> matches = new ArrayList<String>();
        for (String cachedGroup : cachedGroups = this.fCacheManager.getSpaceGroups(space)) {
            if (query != null && !cachedGroup.toLowerCase().contains(query.toLowerCase())) continue;
            matches.add(cachedGroup);
        }
        return matches;
    }

    public List<String> searchGroupsAvoidCache(String queryStr) throws EntityException, AuthorizationException {
        if (!this.fPermissionUtil.isGlobalAdmin()) {
            CSUMAuditEntity failedDeleteEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.getUsersOrGroups, ICSUMActiveObjectService.CSUMAuditEventOutcome.unauthorized, null, null, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText(NOT_AUTHORISED), null, null);
            LOG.error(UNAUTHORISED_USER_ATTEMPT + AuthenticatedUserThreadLocal.getUsername() + " for searching Group. Audit event created with ID: " + failedDeleteEntity.getID());
            throw new AuthorizationException(this.fI18n.getText(NOT_PERMITTED));
        }
        ArrayList<String> ret = new ArrayList<String>();
        GroupNameTermQuery query = new GroupNameTermQuery(queryStr, "contains");
        SearchResult result = this.fUserAccessor.findGroups((Query)query);
        do {
            List page = result.pager().getCurrentPage();
            for (Group group : page) {
                ret.add(group.getName());
            }
            result.pager().nextPage();
        } while (!result.pager().onLastPage());
        return ret;
    }

    public void addViewSpacePermission(Space aSpace, Group g) {
        SpacePermission perm = new SpacePermission("VIEWSPACE", aSpace, g.getName());
        perm.setCreator(AuthenticatedUserThreadLocal.get());
        perm.setCreationDate(new Date());
        perm.setLastModifier(AuthenticatedUserThreadLocal.get());
        perm.setLastModificationDate(new Date());
        aSpace.addPermission(perm);
        this.fPermissionUtil.savePermission(perm);
        LOG.debug("added viewspace perm to " + g.getName());
    }

    public Pair<Map<String, String>, Map<String, String>> addUsersToGroups(Space space, String spaceGroups, String spaceUsers, String importViaGroups) throws AuthorizationException, EntityException, SpaceGroupPatternMismatchException {
        ArrayList<ConfluenceUser> userWithMembership = new ArrayList<ConfluenceUser>();
        if (!this.fPermissionUtil.isAuthorized(space)) {
            CSUMAuditEntity failedDeleteEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.addUserToGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.unauthorized, space, null, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText(NOT_AUTHORISED), null, null);
            LOG.error(UNAUTHORISED_USER_ATTEMPT + AuthenticatedUserThreadLocal.getUsername() + " for adding users to groups. Audit event created with ID: " + failedDeleteEntity.getID());
            throw new AuthorizationException(this.fI18n.getText(NOT_PERMITTED));
        }
        for (String string : spaceGroups.split(COMMA)) {
            if (this.isSpaceGroup(space, string)) continue;
            CSUMAuditEntity auditEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.addUserToGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, string, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText(NO_PATTERN_MATCH), null, null);
            LOG.error(USER_SPACE_GROUP_PATTERN_MISMATCH + AuthenticatedUserThreadLocal.getUsername() + " for adding users to groups with original name: " + string + AUDIT_EVENT_CREATED_WITH_ID + auditEntity.getID());
            throw new SpaceGroupPatternMismatchException(this.fI18n.getText(NO_PATTERN_MATCH) + ": " + string);
        }
        String[] groupArr = spaceGroups.split(COMMA);
        ArrayList<Group> groups = new ArrayList<Group>();
        HashMap<String, String> invalidGroups = new HashMap<String, String>();
        for (String string : groupArr) {
            Group group = this.fGroupManager.getGroup(string);
            if (group != null) {
                groups.add(group);
                continue;
            }
            invalidGroups.put(string, INVALID_REASON);
        }
        ArrayList<Group> arrayList = new ArrayList<Group>();
        String autoJoinGroupsStr = this.fCacheManager.getCachedConfig().getAutoJoinGroups();
        if (autoJoinGroupsStr != null && !autoJoinGroupsStr.isEmpty()) {
            String[] autoJoinGroupArr;
            for (String string : autoJoinGroupArr = autoJoinGroupsStr.split(COMMA)) {
                Group autoGroup = this.fGroupManager.getGroup(string);
                if (autoGroup != null) {
                    arrayList.add(autoGroup);
                    continue;
                }
                invalidGroups.put(string, INVALID_REASON);
            }
        }
        OperationResult<ConfluenceUser> operationResult = this.validateCSVUsers(space, spaceUsers, importViaGroups.split(COMMA));
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        try {
            for (Group group : groups) {
                for (ConfluenceUser aUser : operationResult.successes) {
                    if (!this.fGroupManager.hasMembership(group, (User)aUser)) {
                        this.addSingleUserToGroup(aUser, group, space, currentUser, false);
                        continue;
                    }
                    userWithMembership.add(aUser);
                }
            }
            for (Group group : arrayList) {
                for (ConfluenceUser aUser : operationResult.successes) {
                    if (!this.fGroupManager.hasMembership(group, (User)aUser)) {
                        this.addSingleUserToGroup(aUser, group, space, currentUser, true);
                        continue;
                    }
                    userWithMembership.add(aUser);
                }
            }
        }
        catch (EntityException e) {
            this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.addUserToGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, null, null, currentUser.getName(), e.getLocalizedMessage(), null, null);
            LOG.error("Exception during addition of space group members. Related Space: " + space.getName(), (Throwable)e);
            throw e;
        }
        if (!userWithMembership.isEmpty()) {
            for (User user : userWithMembership) {
                ConfluenceUser matchUserToRemove = null;
                for (ConfluenceUser successUser : operationResult.successes) {
                    if (!successUser.getName().equals(user.getName())) continue;
                    matchUserToRemove = successUser;
                }
                if (matchUserToRemove == null) continue;
                operationResult.successes.remove(matchUserToRemove);
                operationResult.failures.put(matchUserToRemove.getName(), MEMBERSHIP_REASON);
            }
        }
        return new Pair(operationResult.failures, invalidGroups);
    }

    public String[] getGroupMemberNamesViaImport(@Nonnull String[] importViaGroups) throws EntityException {
        ArrayList userNames = new ArrayList();
        if (!importViaGroups[0].equalsIgnoreCase("")) {
            for (String groupName : importViaGroups) {
                try {
                    Group groupObj = this.fGroupManager.getGroup(groupName);
                    List memberNames = this.fUserAccessor.getMemberNamesAsList(groupObj);
                    userNames.addAll(memberNames);
                }
                catch (EntityException e) {
                    LOG.error("Failed to get group from confluence: " + groupName);
                    throw e;
                }
            }
        }
        return userNames.toArray(new String[0]);
    }

    public boolean addSingleUserToGroup(@Nonnull ConfluenceUser user, @Nonnull Group group, Space space, ConfluenceUser currentUser, boolean isAutoJoin) throws EntityException, AuthorizationException {
        if (!this.fPermissionUtil.isAuthorized(space)) {
            CSUMAuditEntity failedDeleteEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.addUserToGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.unauthorized, space, null, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText(NOT_AUTHORISED), null, null);
            LOG.error(UNAUTHORISED_USER_ATTEMPT + AuthenticatedUserThreadLocal.getUsername() + " for adding Group members. Audit event created with ID: " + failedDeleteEntity.getID());
            throw new AuthorizationException(this.fI18n.getText(NOT_PERMITTED));
        }
        boolean successfulOperation = true;
        try {
            Objects.requireNonNull(user);
            Objects.requireNonNull(group);
            Objects.requireNonNull(space);
            this.cleanupGroupCache(space);
            if (this.isCSVAddOrRemoveValid(group, currentUser, space) || isAutoJoin) {
                this.fGroupManager.addMembership(group, (User)user);
                this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.addUserToGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.success, space, group.getName(), user.getKey().getStringValue(), currentUser.getName(), null, null, null);
            } else {
                if (!this.isSpaceGroup(space, group.getName())) {
                    LOG.info("User: " + user.getName() + " not added to group: " + group.getName() + ". Group is not a Space Group or listed as an auto-join group.");
                } else if (this.fGroupManager.hasMembership(group, (User)user)) {
                    LOG.info("User: " + user.getName() + " already has group membership for Group: " + group);
                } else {
                    LOG.error("User should have been added, but did not for some unknown reason");
                    this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.addUserToGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, group.getName(), user.getKey().getStringValue(), currentUser.getName(), null, null, null);
                }
                successfulOperation = false;
            }
        }
        catch (EntityException e) {
            LOG.error("EntityException when adding user: " + user.getName() + " to group: " + group.getName(), (Throwable)e);
            this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.addUserToGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, group.getName(), user.getKey().getStringValue(), currentUser.getName(), null, null, null);
            throw e;
        }
        catch (Exception e) {
            successfulOperation = false;
            LOG.error("Exception adding user: " + user.getName() + " to group: " + group.getName(), (Throwable)e);
            this.createFailedUserAdditionCreationMessage(currentUser, space, group, user);
        }
        if (!successfulOperation) {
            this.createFailedUserAdditionCreationMessage(currentUser, space, group, user);
        }
        return successfulOperation;
    }

    private void createFailedUserAdditionCreationMessage(ConfluenceUser currentUser, Space space, Group group, ConfluenceUser user) {
        LOG.error("Failed adding user: " + user.getName() + " to group: " + group.getName());
        if (currentUser != null) {
            this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.addUserToGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, group.getName(), user.getKey().getStringValue(), currentUser.getName(), null, null, null);
        } else {
            this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.addUserToGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, group.getName(), user.getKey().getStringValue(), null, null, null, null);
        }
    }

    public OperationResult<ConfluenceUser> validateCSVUsers(Space forSpace, String usersCSV, @Nonnull String[] importViaGroups) throws EntityException {
        String[] allUsers;
        ArrayList<ConfluenceUser> validUsers = new ArrayList<ConfluenceUser>();
        HashMap<String, String> invalidUsers = new HashMap<String, String>();
        String[] spaceUsersArr = usersCSV != null ? usersCSV.split(COMMA) : new String[]{};
        if (importViaGroups.length > 0) {
            String[] usersFromImport = this.getGroupMemberNamesViaImport(importViaGroups);
            int spaceUsersArrLen = spaceUsersArr.length;
            int usersFromImportLen = usersFromImport.length;
            allUsers = new String[spaceUsersArrLen + usersFromImportLen];
            System.arraycopy(spaceUsersArr, 0, allUsers, 0, spaceUsersArrLen);
            System.arraycopy(usersFromImport, 0, allUsers, spaceUsersArrLen, usersFromImportLen);
        } else {
            allUsers = spaceUsersArr;
        }
        try {
            ICachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
            for (String aSpaceUsersArr : allUsers) {
                String userStr = aSpaceUsersArr.trim();
                if (userStr.isEmpty()) continue;
                ConfluenceUser aUser = this.fUserAccessor.getUserByName(userStr);
                if (aUser != null) {
                    LOG.debug("Found valid User with name: " + userStr);
                    validUsers.add(aUser);
                    continue;
                }
                if (cachedConfig.isCreateUsersEnabled()) {
                    LOG.debug("User with name: " + userStr + " not found, but createUsers enabled - attempting to create user via LDAP config");
                    this.attemptNewLDAPUserCreation(forSpace, validUsers, invalidUsers, userStr);
                    continue;
                }
                LOG.debug("UserAccessor could not find user with name: " + userStr);
                invalidUsers.put(userStr, INVALID_REASON);
            }
        }
        catch (Exception e) {
            LOG.error("Exception occurred during validation of users for operation", (Throwable)e);
        }
        return new OperationResult<ConfluenceUser>(validUsers, invalidUsers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attemptNewLDAPUserCreation(Space forSpace, List<ConfluenceUser> validUsers, Map<String, String> invalidUsers, String userStr) {
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        ConfluenceUser aUser = null;
        try {
            Thread.currentThread().setContextClassLoader(Session.class.getClassLoader());
            aUser = this.createUserViaExternalLdap(forSpace, userStr);
        }
        catch (Exception e) {
            LOG.error("Couldn't lookup LDAP user " + userStr + ": " + e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tcl);
        }
        if (aUser != null) {
            validUsers.add(aUser);
        } else {
            invalidUsers.put(userStr, INVALID_REASON);
        }
    }

    private ConfluenceUser createUserViaExternalLdap(Space forSpace, String username) throws LDAPException {
        if (!this.fUserManager.isCreative()) {
            LOG.error("Users can't be created right now: " + username);
            return null;
        }
        ICachedConfig config = this.fAos.getCachedConfig();
        String ldapCsvIds = config.getExtLdapDirectories();
        if (ldapCsvIds == null || ldapCsvIds.isEmpty()) {
            LOG.info("No external LDAP configs defined for user creation");
            return null;
        }
        CSUMLdapConfigEntity[] allLdapConfigs = this.fAos.getLdapConfigs();
        if (allLdapConfigs == null || allLdapConfigs.length <= 0) {
            return null;
        }
        HashSet<Long> selectedLdapDirectories = new HashSet<Long>();
        String csvAutoJoinGroups = config.getAutoJoinGroups();
        String[] autoJoinGroups = null;
        if (csvAutoJoinGroups != null) {
            autoJoinGroups = csvAutoJoinGroups.split(COMMA);
            for (int i = 0; i < autoJoinGroups.length; ++i) {
                autoJoinGroups[i] = autoJoinGroups[i].trim();
            }
        }
        String[] ldapCsvIdsArr = ldapCsvIds.split(COMMA);
        for (String atlToken : ldapCsvIdsArr) {
            selectedLdapDirectories.add(Long.valueOf(atlToken));
        }
        for (CSUMLdapConfigEntity anLdapConfig : allLdapConfigs) {
            if (!selectedLdapDirectories.contains(anLdapConfig.getID())) continue;
            LOG.info("Checking ext ldap: id=" + anLdapConfig.getID() + NAME_EQUAL + anLdapConfig.getLdapConfigName());
            LdapDetailsDTO dto = this.fAos.getLdapDto(anLdapConfig);
            LDAPLookupUtil lookupUtil = new LDAPLookupUtil(dto);
            List<LDAPUser> ldapResults = lookupUtil.searchFor("(" + dto.getLdapUserAttr() + "=" + username + ")");
            if (ldapResults == null || ldapResults.isEmpty()) {
                LOG.debug("Searched for user '" + username + "' in ldap repo #" + anLdapConfig.getID() + " but was not found through username attr: " + anLdapConfig.getUsernameAttr());
                continue;
            }
            LDAPUser ldapUser = ldapResults.get(0);
            if (ldapUser == null) continue;
            ConfluenceUser createdUser = this.createUser(forSpace, anLdapConfig, ldapUser);
            if (createdUser == null) {
                throw new LDAPException("Unable to create user from LDAP configuration: " + ldapUser.getUserId());
            }
            if (autoJoinGroups != null) {
                for (String autoJoinGroup : autoJoinGroups) {
                    try {
                        Group group = this.fGroupManager.getGroup(autoJoinGroup);
                        if (group != null) {
                            this.fGroupManager.addMembership(group, (User)createdUser);
                            this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.addUserToGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.success, forSpace, group.getName(), createdUser.getKey().getStringValue(), AuthenticatedUserThreadLocal.getUsername(), "auto-joined group", null, null);
                            continue;
                        }
                        this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.addUserToGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, forSpace, autoJoinGroup, createdUser.getKey().getStringValue(), AuthenticatedUserThreadLocal.getUsername(), "group not found", null, null);
                    }
                    catch (EntityException | IllegalArgumentException ee) {
                        this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.addUserToGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, forSpace, autoJoinGroup, createdUser.getKey().getStringValue(), AuthenticatedUserThreadLocal.getUsername(), ee.getLocalizedMessage(), null, null);
                    }
                }
            }
            return createdUser;
        }
        return null;
    }

    @Nullable
    private ConfluenceUser createUser(Space forSpace, CSUMLdapConfigEntity anLdapConfig, LDAPUser ldapUser) {
        String randomPassword = SecureRandomStringUtils.getInstance().randomAlphanumericString(22);
        DefaultUser userTemplate = new DefaultUser(ldapUser.getUserId(), ldapUser.getFullName(), ldapUser.getEmail());
        ConfluenceUser createdUser = this.fUserAccessor.createUser((User)userTemplate, Credential.unencrypted((String)randomPassword));
        if (createdUser != null) {
            LOG.info("Successfully created user [" + createdUser.getName() + "/ " + createdUser.getFullName() + "/ " + createdUser.getEmail() + "]");
            String summary = "Created user from external ldap [id=" + anLdapConfig.getID() + NAME_EQUAL + anLdapConfig.getLdapConfigName() + "]";
            this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.createUser, ICSUMActiveObjectService.CSUMAuditEventOutcome.success, forSpace, null, createdUser.getKey().getStringValue(), AuthenticatedUserThreadLocal.getUsername(), summary, null, null);
        }
        return createdUser;
    }

    OperationResult<Group> validateSpaceGroups(Space space, String ... spaceGroupsArr) throws EntityException {
        String[] cachedGroups = this.fCacheManager.getSpaceGroups(space);
        ArrayList<Group> valid = new ArrayList<Group>();
        HashMap<String, String> invalid = new HashMap<String, String>();
        try {
            for (String aSpaceGroup : spaceGroupsArr) {
                boolean groupMatch = false;
                for (String cachedGroup : cachedGroups) {
                    if (!cachedGroup.equalsIgnoreCase(aSpaceGroup.trim())) continue;
                    groupMatch = true;
                    break;
                }
                if (!groupMatch) {
                    invalid.put(aSpaceGroup, INVALID_REASON);
                    continue;
                }
                Group group = this.fGroupManager.getGroup(aSpaceGroup);
                if (group != null) {
                    valid.add(group);
                    continue;
                }
                invalid.put(aSpaceGroup, INVALID_REASON);
            }
        }
        catch (EntityException e) {
            LOG.error("Exception occurred during validation of groups for operation", (Throwable)e);
            throw e;
        }
        return new OperationResult<Group>(valid, invalid);
    }

    public List<User> getPagedSpaceGroupMembers(Space space, String groupName, int maxRows, int offset, String searchVal) throws AuthorizationException, EntityException, SpaceGroupPatternMismatchException {
        if (!this.fPermissionUtil.isAuthorized(space)) {
            CSUMAuditEntity failedDeleteEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.getUsersOrGroups, ICSUMActiveObjectService.CSUMAuditEventOutcome.unauthorized, space, null, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText(NOT_AUTHORISED), null, null);
            LOG.error(UNAUTHORISED_USER_ATTEMPT + AuthenticatedUserThreadLocal.getUsername() + " for adding users to groups. Audit event created with ID: " + failedDeleteEntity.getID());
            throw new AuthorizationException(this.fI18n.getText(NOT_PERMITTED));
        }
        if (!this.isSpaceGroup(space, groupName)) {
            CSUMAuditEntity auditEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.getUsersOrGroups, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, groupName, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText(NO_PATTERN_MATCH), null, null);
            LOG.error(USER_SPACE_GROUP_PATTERN_MISMATCH + AuthenticatedUserThreadLocal.getUsername() + " for retrieving Space Group members from group with original name: " + groupName + AUDIT_EVENT_CREATED_WITH_ID + auditEntity.getID());
            throw new SpaceGroupPatternMismatchException(this.fI18n.getText(NO_PATTERN_MATCH) + ": " + groupName);
        }
        ArrayList<User> memberList = new ArrayList<User>();
        Group group = this.fGroupManager.getGroup(groupName);
        if (group == null) {
            LOG.error("Unable to find user group with name: " + groupName);
            throw new EntityMissingException(this.fI18n.getText("error.group.not.found") + ": " + groupName);
        }
        Pager membersPager = this.fGroupManager.getMemberNames(group);
        if (!membersPager.isEmpty()) {
            ICSUMDataDefs.DISABLED_USER_HANDLING disabledUserHandling;
            boolean notLastPage = true;
            String disabledUserHandlingCacheCheck = this.fCacheManager.getCachedConfig().getDisabledUserHandling();
            ICSUMDataDefs.DISABLED_USER_HANDLING dISABLED_USER_HANDLING = disabledUserHandling = disabledUserHandlingCacheCheck != null ? ICSUMDataDefs.DISABLED_USER_HANDLING.valueOf(disabledUserHandlingCacheCheck) : ICSUMDataDefs.DISABLED_USER_HANDLING.show;
            do {
                List currentMemberPage;
                if ((currentMemberPage = membersPager.getCurrentPage()) != null && !currentMemberPage.isEmpty()) {
                    if (searchVal != null && !searchVal.isEmpty()) {
                        ArrayList<String> filteredMemberPage = new ArrayList<String>();
                        for (String member : currentMemberPage) {
                            User aUser = this.fUserManager.getUser(member);
                            if ((disabledUserHandling != ICSUMDataDefs.DISABLED_USER_HANDLING.hide || this.fUserAccessor.isDeactivated(aUser)) && disabledUserHandling != ICSUMDataDefs.DISABLED_USER_HANDLING.show || !aUser.getName().contains(searchVal)) continue;
                            filteredMemberPage.add(member);
                        }
                        this.addUsersToList(filteredMemberPage, memberList, disabledUserHandling, offset, maxRows);
                    } else {
                        this.addUsersToList(currentMemberPage, memberList, disabledUserHandling, offset, maxRows);
                    }
                }
                if (membersPager.onLastPage()) {
                    notLastPage = false;
                    continue;
                }
                membersPager.nextPage();
            } while (notLastPage);
        }
        return memberList;
    }

    public int getTotalGroupsCount(Space space) {
        String[] spaceGroups = this.fCacheManager.getSpaceGroups(space);
        int ret = spaceGroups.length;
        return ret;
    }

    public int getFilteredGroupsCount(Space space, String searchVal) {
        int ret = 0;
        String[] spaceGroups = this.fCacheManager.getSpaceGroups(space);
        if (searchVal != null && !searchVal.isEmpty()) {
            for (String spaceGroup : spaceGroups) {
                if (!spaceGroup.contains(searchVal)) continue;
                ++ret;
            }
        } else {
            ret = spaceGroups.length;
        }
        return ret;
    }

    public int getTotalMembersCount(String groupName) {
        int ret = 0;
        try {
            Group group = this.fGroupManager.getGroup(groupName);
            Pager membersPager = this.fGroupManager.getMemberNames(group);
            if (!membersPager.isEmpty()) {
                boolean notLastPage = true;
                do {
                    List currentMemberPage;
                    if ((currentMemberPage = membersPager.getCurrentPage()) != null && !currentMemberPage.isEmpty()) {
                        ret += currentMemberPage.size();
                    }
                    if (membersPager.onLastPage()) {
                        notLastPage = false;
                        continue;
                    }
                    membersPager.nextPage();
                } while (notLastPage);
            }
        }
        catch (EntityException e) {
            LOG.error("Unable to retrieve total group member count", (Throwable)e);
        }
        return ret;
    }

    public int getFilteredMembersCount(String groupName, String searchVal) {
        int ret = 0;
        try {
            Group group = this.fGroupManager.getGroup(groupName);
            Pager membersPager = this.fGroupManager.getMemberNames(group);
            if (!membersPager.isEmpty()) {
                boolean notLastPage = true;
                do {
                    List currentMemberPage;
                    if ((currentMemberPage = membersPager.getCurrentPage()) != null && !currentMemberPage.isEmpty()) {
                        int totalOnPage = searchVal != null && !searchVal.isEmpty() ? this.getFilterMemberPageCount(currentMemberPage, searchVal) : currentMemberPage.size();
                        ret += totalOnPage;
                    }
                    if (membersPager.onLastPage()) {
                        notLastPage = false;
                        continue;
                    }
                    membersPager.nextPage();
                } while (notLastPage);
            }
        }
        catch (EntityException e) {
            LOG.error("Unable to retrieve filtered member count", (Throwable)e);
        }
        return ret;
    }

    public int getFilterMemberPageCount(List<String> memberPage, String searchVal) throws EntityException {
        int ret = 0;
        for (String member : memberPage) {
            User aUser = this.fUserManager.getUser(member);
            String userName = aUser.getName();
            if (!searchVal.equals("")) {
                if (!userName.contains(searchVal)) continue;
                ++ret;
                continue;
            }
            ++ret;
        }
        return ret;
    }

    public List<User> getSpaceGroupMembers(Space space, String groupName) throws AuthorizationException, EntityException, SpaceGroupPatternMismatchException {
        if (!this.fPermissionUtil.isAuthorized(space)) {
            CSUMAuditEntity failedDeleteEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.getUsersOrGroups, ICSUMActiveObjectService.CSUMAuditEventOutcome.unauthorized, space, null, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText(NOT_AUTHORISED), null, null);
            LOG.error(UNAUTHORISED_USER_ATTEMPT + AuthenticatedUserThreadLocal.getUsername() + " for adding users to groups. Audit event created with ID: " + failedDeleteEntity.getID());
            throw new AuthorizationException(this.fI18n.getText(NOT_PERMITTED));
        }
        if (!this.isSpaceGroup(space, groupName)) {
            CSUMAuditEntity auditEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.getUsersOrGroups, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, groupName, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText(NO_PATTERN_MATCH), null, null);
            LOG.error(USER_SPACE_GROUP_PATTERN_MISMATCH + AuthenticatedUserThreadLocal.getUsername() + " for retrieving Space Group members from group with original name: " + groupName + AUDIT_EVENT_CREATED_WITH_ID + auditEntity.getID());
            throw new SpaceGroupPatternMismatchException(this.fI18n.getText(NO_PATTERN_MATCH) + ": " + groupName);
        }
        ArrayList<User> memberList = new ArrayList<User>();
        Group group = this.fGroupManager.getGroup(groupName);
        if (group == null) {
            LOG.error("Unable to find user group with name: " + groupName);
            throw new EntityMissingException(this.fI18n.getText("error.group.not.found") + ": " + groupName);
        }
        Pager membersPager = this.fGroupManager.getMemberNames(group);
        if (!membersPager.isEmpty()) {
            ICSUMDataDefs.DISABLED_USER_HANDLING disabledUserHandling;
            boolean notLastPage = true;
            String disabledUserHandlingCacheCheck = this.fCacheManager.getCachedConfig().getDisabledUserHandling();
            ICSUMDataDefs.DISABLED_USER_HANDLING dISABLED_USER_HANDLING = disabledUserHandling = disabledUserHandlingCacheCheck != null ? ICSUMDataDefs.DISABLED_USER_HANDLING.valueOf(disabledUserHandlingCacheCheck) : ICSUMDataDefs.DISABLED_USER_HANDLING.show;
            do {
                List currentMemberPage;
                if ((currentMemberPage = membersPager.getCurrentPage()) != null && !currentMemberPage.isEmpty()) {
                    this.addUsersToList(currentMemberPage, memberList, disabledUserHandling);
                }
                if (membersPager.onLastPage()) {
                    notLastPage = false;
                    continue;
                }
                membersPager.nextPage();
            } while (notLastPage);
        }
        return memberList;
    }

    public List<String> removeGroupMembers(Space space, @Nonnull String spaceGroupCsv, String userNameCsv, String membershipGroupsCsv, ConfluenceUser currentUser) throws AuthorizationException, SpaceGroupPatternMismatchException, EntityException, DuplicateException {
        ArrayList<String> failedToRemove = new ArrayList<String>();
        if (!this.fPermissionUtil.isAuthorized(space)) {
            CSUMAuditEntity failedDeleteEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeUserFromGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.unauthorized, space, null, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText(NOT_AUTHORISED), null, null);
            LOG.error(UNAUTHORISED_USER_ATTEMPT + AuthenticatedUserThreadLocal.getUsername() + " for removing Group members. Audit event created with ID: " + failedDeleteEntity.getID());
            throw new AuthorizationException(this.fI18n.getText(NOT_PERMITTED));
        }
        String[] spaceGroupNames = spaceGroupCsv.split(COMMA);
        Set<ConfluenceUser> usersToRemove = this.getUsersToRemove(userNameCsv, membershipGroupsCsv);
        this.validateSpaceGroups(space, spaceGroupNames);
        for (String spaceGroupName : spaceGroupNames) {
            Group spaceGroup;
            try {
                spaceGroup = this.fGroupManager.getGroup(spaceGroupName);
            }
            catch (EntityException ee) {
                this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeUserFromGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, spaceGroupName, null, AuthenticatedUserThreadLocal.getUsername(), ee.getLocalizedMessage(), null, null);
                LOG.error("removeGroupMembers() EntityException during getGroup [space=" + space.getKey() + SPACE_GROUP_NAME + spaceGroupName + USER_NAME_CSV + userNameCsv + ", " + membershipGroupsCsv + "] : " + ee.getLocalizedMessage(), (Throwable)ee);
                throw ee;
            }
            if (currentUser != null && !this.isCSVAddOrRemoveValid(spaceGroup, currentUser, space)) {
                CSUMAuditEntity auditEntity = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeUserFromGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, spaceGroupName, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText(NO_PATTERN_MATCH), null, null);
                LOG.error(USER_SPACE_GROUP_PATTERN_MISMATCH + AuthenticatedUserThreadLocal.getUsername() + " for removing Space Group members from group with original name: " + spaceGroupName + AUDIT_EVENT_CREATED_WITH_ID + auditEntity.getID());
                throw new SpaceGroupPatternMismatchException(this.fI18n.getText(NO_PATTERN_MATCH) + ": " + spaceGroupName);
            }
            if (!membershipGroupsCsv.isEmpty() || !userNameCsv.isEmpty()) {
                for (ConfluenceUser user : usersToRemove) {
                    if (this.fGroupManager.hasMembership(spaceGroup, (User)user)) {
                        try {
                            boolean isRemoveCurrentUserAllowed = this.fCacheManager.getCachedConfig().isRemoveUserFromPermGrpPerm();
                            if (isRemoveCurrentUserAllowed || !this.isCurrentUserToBeRemovedFromGlobalPermGroup(spaceGroup, user)) {
                                this.fGroupManager.removeMembership(spaceGroup, (User)user);
                                this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeUserFromGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.success, space, spaceGroup.getName(), user.getKey().getStringValue(), AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText("csum.auditing.operation.removeUserFromGroup"), null, null);
                                continue;
                            }
                            failedToRemove.add(user.getName());
                            this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeUserFromGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.unauthorized, space, spaceGroup.getName(), user.getKey().getStringValue(), AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText("csum.auditing.operation.removeUserFromGroup"), null, null);
                            continue;
                        }
                        catch (EntityException ee) {
                            this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeUserFromGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, spaceGroup.getName(), user.getKey().getStringValue(), AuthenticatedUserThreadLocal.getUsername(), ee.getLocalizedMessage(), null, null);
                            LOG.error("removeGroupMembers() EntityException during removeMembership() [space=" + space.getKey() + SPACE_GROUP_NAME + spaceGroupName + USER_NAME_CSV + userNameCsv + ", " + membershipGroupsCsv + "] : " + ee.getLocalizedMessage(), (Throwable)ee);
                            throw ee;
                        }
                        catch (Exception exc) {
                            this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeUserFromGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, spaceGroup.getName(), user.getKey().getStringValue(), AuthenticatedUserThreadLocal.getUsername(), exc.getLocalizedMessage(), null, null);
                            LOG.error("removeGroupMembers() Exception during removeMembership() [space=" + space.getKey() + SPACE_GROUP_NAME + spaceGroupName + USER_NAME_CSV + userNameCsv + ", " + membershipGroupsCsv + "] : " + exc.getLocalizedMessage(), (Throwable)exc);
                            throw exc;
                        }
                    }
                    failedToRemove.add(user.getName());
                }
                continue;
            }
            this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeUserFromGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, space, spaceGroupName, null, AuthenticatedUserThreadLocal.getUsername(), null, null, null);
        }
        return failedToRemove;
    }

    private boolean isCurrentUserToBeRemovedFromGlobalPermGroup(Group spaceGroup, ConfluenceUser user) {
        boolean result = false;
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        Collection globalGroups = this.fSpacePermissionManager.getGroupsWithPermissions(null);
        if (globalGroups.contains(spaceGroup) && user.getKey() != null && currentUser.getKey() != null && user.getKey().equals((Object)currentUser.getKey())) {
            result = true;
        }
        return result;
    }

    private Set<ConfluenceUser> getUsersToRemove(String userNameCsv, String membershipGroupsCsv) {
        HashSet<ConfluenceUser> usersToRemove = new HashSet<ConfluenceUser>();
        if (!membershipGroupsCsv.isEmpty()) {
            String[] groupNames;
            for (String groupName : groupNames = membershipGroupsCsv.split(COMMA)) {
                try {
                    Group group = this.fGroupManager.getGroup(groupName);
                    if (group == null) continue;
                    Iterable members = this.fUserAccessor.getMembers(group);
                    members.forEach(usersToRemove::add);
                }
                catch (EntityException ee) {
                    this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeUserFromGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.error, null, groupName, null, null, ee.getLocalizedMessage(), null, null);
                    LOG.error("Unable to locate group [" + groupName + "] " + ee.getLocalizedMessage(), (Throwable)ee);
                }
            }
        }
        if (!userNameCsv.isEmpty()) {
            String[] userNames;
            for (String userName : userNames = userNameCsv.split(COMMA)) {
                ConfluenceUser aUser = this.fUserAccessor.getUserByName(userName);
                if (aUser != null) {
                    usersToRemove.add(aUser);
                    continue;
                }
                String msg = "CSUM was not able to locate the user by name [" + userName + "], does the user actually exit in Confluence? If multiple users have been set, exclude this user and retry to narrow the identify problem users.";
                LOG.error(msg);
            }
        }
        return usersToRemove;
    }

    private void addUsersToList(List<String> currentMemberPage, List<User> memberList, ICSUMDataDefs.DISABLED_USER_HANDLING disabledUserHandling) throws EntityException {
        this.addUsersToList(currentMemberPage, memberList, disabledUserHandling, -1, -1);
    }

    private void addUsersToList(List<String> currentMemberPage, List<User> memberList, ICSUMDataDefs.DISABLED_USER_HANDLING disabledUserHandling, int offset, int maxRows) throws EntityException {
        if (offset >= 0 && maxRows >= 0) {
            int count = 0;
            for (int i = 0; i < maxRows; ++i) {
                if (offset + i >= currentMemberPage.size() || count >= maxRows) continue;
                String member = currentMemberPage.get(offset + i);
                User aUser = this.fUserManager.getUser(member);
                if ((disabledUserHandling != ICSUMDataDefs.DISABLED_USER_HANDLING.hide || this.fUserAccessor.isDeactivated(aUser)) && disabledUserHandling != ICSUMDataDefs.DISABLED_USER_HANDLING.show) continue;
                memberList.add(aUser);
                ++count;
            }
        } else {
            for (String member : currentMemberPage) {
                User aUser = this.fUserManager.getUser(member);
                if ((disabledUserHandling != ICSUMDataDefs.DISABLED_USER_HANDLING.hide || this.fUserAccessor.isDeactivated(aUser)) && disabledUserHandling != ICSUMDataDefs.DISABLED_USER_HANDLING.show) continue;
                memberList.add(aUser);
            }
        }
    }

    public List<String> performGroupSearch(@Nonnull String searchTerm, int max) throws EntityException {
        boolean exitLoop;
        Query<Group> query = this.buildGroupQuery(searchTerm);
        SearchResult searchResult = this.fUserAccessor.findGroups(query);
        Pager visibleGroups = searchResult.pager();
        ArrayList<String> matches = new ArrayList<String>();
        do {
            List currentPage = visibleGroups.getCurrentPage();
            for (Group group : currentPage) {
                matches.add(group.getName());
                if (matches.size() <= max) continue;
                break;
            }
            boolean bl = exitLoop = visibleGroups.onLastPage() || matches.size() == max;
            if (exitLoop) continue;
            visibleGroups.nextPage();
        } while (!exitLoop);
        return matches;
    }

    private Query<Group> buildGroupQuery(@Nonnull String searchTerm) {
        return new GroupNameTermQuery(searchTerm, "contains");
    }

    public List<SpaceSearchResult> searchForSpaces(String searchTerm, int pageLimit) {
        ArrayList<SpaceSearchResult> results = new ArrayList<SpaceSearchResult>();
        List<Space> spaces = this.fPermissionUtil.getSpacesAsSpaceAdminForUser();
        String term = searchTerm.toLowerCase();
        for (Space space : spaces) {
            if (space == null) continue;
            String spaceName = space.getName().toLowerCase();
            String spaceKey = space.getKey().toLowerCase();
            if (!spaceName.contains(term) && !spaceKey.contains(term) || results.size() >= pageLimit) continue;
            results.add(new SpaceSearchResult(space));
        }
        return results;
    }

    private boolean isCSVAddOrRemoveValid(Group group, ConfluenceUser currentUser, Space currentSpace) throws EntityException {
        boolean isValid = false;
        boolean inCurrentSpace = false;
        boolean dlgGroupNotInCurrentSpace = false;
        boolean adminUserAndNotDlgGroup = false;
        ICachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
        boolean groupAddRemovePermitted = cachedConfig.isGroupAddRemovePermitted();
        if (!groupAddRemovePermitted) {
            LOG.error("Group add remove is not enabled in CSUM system config");
            return isValid;
        }
        boolean areDlgActionsPermitted = cachedConfig.isDlgGrpActPerm();
        CSUMDelegatedGroupEntity[] currentUsersDelegatedGroups = this.fAos.getDelegatedGroupsForUser(currentUser);
        if (this.isSpaceGroup(currentSpace, group.getName())) {
            inCurrentSpace = true;
        }
        if (currentUsersDelegatedGroups != null && currentUsersDelegatedGroups.length != 0) {
            for (CSUMDelegatedGroupEntity delegatedGroup : currentUsersDelegatedGroups) {
                if (!delegatedGroup.getGroupName().equals(group.getName())) continue;
                dlgGroupNotInCurrentSpace = true;
                break;
            }
        }
        if (this.fPermissionUtil.isGlobalAdmin() && !dlgGroupNotInCurrentSpace) {
            adminUserAndNotDlgGroup = true;
        }
        if (dlgGroupNotInCurrentSpace && !areDlgActionsPermitted) {
            dlgGroupNotInCurrentSpace = false;
        }
        if (inCurrentSpace || dlgGroupNotInCurrentSpace || adminUserAndNotDlgGroup) {
            isValid = true;
        }
        return isValid;
    }

    public static class OperationResult<S> {
        public final List<S> successes;
        public final Map<String, String> failures;

        public OperationResult(List<S> success, Map<String, String> fail) {
            this.successes = success;
            this.failures = fail;
        }

        public Map<String, String> getFailures() {
            return this.failures;
        }

        public List<S> getSuccesses() {
            return this.successes;
        }
    }
}

