/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.rest;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.access.annotations.RequiresLicensedConfluenceAccess;
import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.pluginpeople.confluence.csum.ao.CSUMLdapConfigEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.LdapDetailsDTO;
import com.pluginpeople.confluence.csum.ldap.LDAPException;
import com.pluginpeople.confluence.csum.ldap.LDAPLookupUtil;
import com.pluginpeople.confluence.csum.ldap.LDAPQueryEncoder;
import com.pluginpeople.confluence.csum.ldap.LDAPUser;
import com.pluginpeople.confluence.csum.rest.AbstractCSUMRestResource;
import com.pluginpeople.confluence.csum.rest.beans.UserSearchResult;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.service.cache.ICachedConfig;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import com.pluginpeople.confluence.csum.util.UserUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ReadOnlyAccessAllowed
@Path(value="/spaceuser")
@RequiresLicensedConfluenceAccess
public class SpaceUserResource
extends AbstractCSUMRestResource {
    private static final Logger LOG = LogManager.getLogger(SpaceUserResource.class);
    private final CrowdService fCrowdService;
    private final ICSUMCacheManager fCacheManager;
    private final DirectoryInstanceLoader fDirectoryLoader;
    private final CrowdDirectoryService fCrowdDirectoryService;
    private final ICSUMActiveObjectService fActiveObjects;
    private final UserUtil fUserUtil;

    public SpaceUserResource(ICSUMCacheManager cacheManager, @ComponentImport CrowdService crowdService, @ComponentImport CrowdDirectoryService crowdDirectoryService, @ComponentImport DirectoryInstanceLoader directoryLoader, @ComponentImport SpaceManager spaceManager, @ComponentImport XsrfTokenService tokenService, CSUMPermissionUtil permissionUtil, ICSUMActiveObjectService aos, @ComponentImport PermissionManager permissionManager, UserUtil userUtil) {
        super(spaceManager, permissionUtil, tokenService, permissionManager);
        this.fCrowdService = crowdService;
        this.fCrowdDirectoryService = crowdDirectoryService;
        this.fDirectoryLoader = directoryLoader;
        this.fCacheManager = cacheManager;
        this.fActiveObjects = aos;
        this.fUserUtil = userUtil;
    }

    @GET
    @Path(value="/search")
    @Produces(value={"application/json"})
    public Response searchForUsers(@Context HttpServletRequest hsr, @QueryParam(value="query") String unsafeQuery, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="atl_token") String atlToken) {
        Response r;
        if (this.isUnauthorizedOrBadXsrfToken(hsr, spaceKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        long queryStart = System.currentTimeMillis();
        ICachedConfig config = this.fCacheManager.getCachedConfig();
        boolean isEnableSearch = config.isUserSearchEnabled();
        boolean isSelectDirectories = config.isSelectDirectories();
        if (isEnableSearch) {
            boolean disabledUsersHidden = false;
            ICachedConfig cachedConfig = this.fCacheManager.getCachedConfig();
            if (cachedConfig.getDisabledUserHandling().equalsIgnoreCase("hide")) {
                disabledUsersHidden = true;
            }
            ArrayList<UserSearchResult> jsonObjList = new ArrayList<UserSearchResult>();
            EntityQuery userQuery = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)unsafeQuery), Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)unsafeQuery), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)unsafeQuery)})).startingAt(0).returningAtMost(10);
            String csvIds = config.getUserDirectories();
            if (!isSelectDirectories || csvIds == null) {
                Iterable results = this.fCrowdService.search((Query)userQuery);
                for (User aUser : results) {
                    UserSearchResult o2 = new UserSearchResult(aUser.getName(), aUser.getDisplayName(), aUser.getEmailAddress());
                    jsonObjList.add(o2);
                }
            } else {
                User idsArr;
                HashSet<Long> selectedDirectories = new HashSet<Long>();
                for (User s : idsArr = csvIds.split(",")) {
                    selectedDirectories.add(Long.valueOf((String)s));
                }
                List allDirectories = this.fCrowdDirectoryService.findAllDirectories();
                for (Directory aDirectory : allDirectories) {
                    CSUMLdapConfigEntity[] name = aDirectory.getName();
                    if (aDirectory.isActive() && selectedDirectories.contains(aDirectory.getId())) {
                        LOG.debug("Using selected user repo for user search: id=" + aDirectory.getId() + ", name=" + aDirectory.getName() + ", impl=" + aDirectory.getImplementationClass());
                        try {
                            RemoteDirectory directoryInstance = this.fDirectoryLoader.getDirectory(aDirectory);
                            List directoryResults = directoryInstance.searchUsers(userQuery);
                            for (User aUser : directoryResults) {
                                UserSearchResult o3 = new UserSearchResult(aUser.getName(), aUser.getDisplayName(), aUser.getEmailAddress());
                                jsonObjList.add(o3);
                            }
                            continue;
                        }
                        catch (DirectoryInstantiationException e) {
                            LOG.error("Unable to load Internal Directory: ", (Throwable)e);
                            continue;
                        }
                        catch (OperationFailedException e) {
                            LOG.error("OperationFailedException : using Internal Directory: ", (Throwable)e);
                            continue;
                        }
                    }
                    LOG.error("Directory [" + (String)name + "] is not active right now.");
                }
            }
            if (config.isCreateUsersEnabled()) {
                String ldapCsvIds = config.getExtLdapDirectories();
                if (ldapCsvIds != null && !ldapCsvIds.isEmpty()) {
                    CSUMLdapConfigEntity[] allLdapConfigs = this.fActiveObjects.getLdapConfigs();
                    if (allLdapConfigs != null && allLdapConfigs.length > 0) {
                        String[] ldapCsvIdsArr;
                        HashSet<Long> selectedLdapDirectories = new HashSet<Long>();
                        for (String s : ldapCsvIdsArr = ldapCsvIds.split(",")) {
                            selectedLdapDirectories.add(Long.valueOf(s));
                        }
                        String safeQuery = LDAPQueryEncoder.encode(unsafeQuery);
                        for (CSUMLdapConfigEntity anLdapConfig : allLdapConfigs) {
                            if (!selectedLdapDirectories.contains(anLdapConfig.getID())) continue;
                            LOG.info("Checking ext ldap: id=" + anLdapConfig.getID() + ", name=" + anLdapConfig.getLdapConfigName());
                            LdapDetailsDTO dto = this.fActiveObjects.getLdapDto(anLdapConfig);
                            LDAPLookupUtil lookupUtil = new LDAPLookupUtil(dto);
                            try {
                                List<LDAPUser> ldapUserList = lookupUtil.searchWildcarded(safeQuery);
                                if (ldapUserList == null) continue;
                                ArrayList<LDAPUser> toRemove = new ArrayList<LDAPUser>();
                                if (!ldapUserList.isEmpty() && !jsonObjList.isEmpty()) {
                                    block11: for (LDAPUser ldapUser : ldapUserList) {
                                        for (UserSearchResult aFoundUser : jsonObjList) {
                                            if (aFoundUser.getEmail() == null || ldapUser.getEmail() == null || !aFoundUser.getEmail().equalsIgnoreCase(ldapUser.getEmail())) continue;
                                            toRemove.add(ldapUser);
                                            LOG.debug("Removing already existing ldap user with email: " + ldapUser.getEmail());
                                            continue block11;
                                        }
                                    }
                                }
                                if (!toRemove.isEmpty()) {
                                    LOG.debug("Removing " + toRemove.size() + " users from ldap results that already exist in user directories");
                                    ldapUserList.removeAll(toRemove);
                                }
                                for (LDAPUser ldapUser : ldapUserList) {
                                    UserSearchResult o4 = new UserSearchResult(ldapUser.getUserId(), ldapUser.getDisplayName(), ldapUser.getEmail());
                                    o4.setSource("LDAP");
                                    jsonObjList.add(o4);
                                }
                            }
                            catch (LDAPException e) {
                                LOG.error("LDAP problem: ", (Throwable)e);
                            }
                        }
                    }
                } else {
                    LOG.debug("Not querying external ldap, create users off");
                }
            }
            this.fUserUtil.removeDisabledUsers(disabledUsersHidden, jsonObjList);
            jsonObjList.sort(Comparator.comparing(o -> o.getUsername().toLowerCase()));
            UserSearchResult[] jsonObjArr = new UserSearchResult[jsonObjList.size()];
            jsonObjList.toArray(jsonObjArr);
            long queryEnd = System.currentTimeMillis();
            long duration = queryEnd - queryStart;
            if (duration > 5000L) {
                LOG.info("query took longer that 5 seconds: " + duration + "ms");
            } else {
                LOG.debug("query time for ...was" + duration + "+ms");
            }
            HashMap<String, UserSearchResult[]> result = new HashMap<String, UserSearchResult[]>();
            result.put("users", jsonObjArr);
            r = Response.ok(result).build();
        } else {
            HashMap<String, String[]> result = new HashMap<String, String[]>();
            result.put("users", new String[0]);
            r = Response.ok(result).build();
        }
        return r;
    }
}

