/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.util;

import com.pluginpeople.confluence.csum.ao.CSUMLdapConfigEntity;
import com.pluginpeople.confluence.csum.ldap.LDAPHydrationManager;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultAdLdapUtil {
    private final LDAPHydrationManager fLDAPHydrationManager;
    private static final Logger LOG = LogManager.getLogger(DefaultAdLdapUtil.class);
    private static final String LDAP_EXAMPLE_DIR = "csum/ldap-templates";

    @Autowired
    public DefaultAdLdapUtil(LDAPHydrationManager ldapHydrationManager) {
        this.fLDAPHydrationManager = ldapHydrationManager;
    }

    public String doCreateDefaultAdLdap() throws JAXBException, IOException {
        String ret = null;
        String resourceName = "example-ldap-activedirectory.xml";
        String asXml = null;
        try (InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("csum/ldap-templates/" + resourceName);){
            if (resourceAsStream != null) {
                LOG.info("Creating by Active Directory example");
                asXml = IOUtils.toString((InputStream)resourceAsStream, (Charset)StandardCharsets.UTF_8);
            }
        }
        if (asXml != null) {
            CSUMLdapConfigEntity configEntity = this.fLDAPHydrationManager.restoreLDAPFromXml(asXml);
            int fConfigId = configEntity.getID();
            boolean fIsEdit = false;
            ret = "input";
        } else {
            LOG.error("Failed to populate xml data structure");
        }
        return ret;
    }
}

