/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.util;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.search.page.Pager;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.util.IBadGroupNameFinder;
import com.pluginpeople.confluence.csum.util.OpStatus;
import com.pluginpeople.confluence.csum.util.SpaceGroupUtil;
import com.pluginpeople.confluence.csum.util.ToolRequest;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BadGroupNameFinderImpl
implements IBadGroupNameFinder,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(BadGroupNameFinderImpl.class);
    private static OpStatus fStatus = OpStatus.IDLE;
    private ICSUMActiveObjectService fAo;
    private GroupManager fGroupManager;
    private boolean fStop = false;
    private ConfluenceUser fUser;
    private int fFoundBadGroups = 0;
    private int fProcessed = 0;
    private String fError;
    private TransactionTemplate fTxTemplate;
    private SpaceGroupUtil fGroupUtil;

    @Autowired
    public BadGroupNameFinderImpl(ICSUMActiveObjectService ao, @ComponentImport GroupManager groupMgr, @ComponentImport TransactionTemplate txTemplate, SpaceGroupUtil groupUtil) {
        this.fAo = ao;
        this.fGroupManager = groupMgr;
        this.fTxTemplate = txTemplate;
        this.fGroupUtil = groupUtil;
    }

    @Override
    public ToolRequest launch(ConfluenceUser user) {
        ToolRequest request;
        if (!OpStatus.RUNNING.equals((Object)fStatus)) {
            new Thread(this.getRunnable(user), "CSUMBadGroupNameFinder").start();
            request = new ToolRequest(true, null);
        } else {
            request = new ToolRequest(false, "Bad space group name finder thread is already running on this node");
        }
        return request;
    }

    private Runnable getRunnable(final ConfluenceUser user) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (AuthenticatedUserThreadLocal.isAnonymousUser()) {
                    AuthenticatedUserThreadLocal.set((ConfluenceUser)user);
                }
                BadGroupNameFinderImpl.this.fStop = false;
                BadGroupNameFinderImpl.this.fUser = user;
                BadGroupNameFinderImpl.this.fFoundBadGroups = 0;
                BadGroupNameFinderImpl.this.fProcessed = 0;
                fStatus = OpStatus.RUNNING;
                try {
                    BadGroupNameFinderImpl.this.fTxTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                        public Object doInTransaction() {
                            BadGroupNameFinderImpl.this.fAo.deleteAllBadGroupEnts();
                            return null;
                        }
                    });
                    Pager groupPager = BadGroupNameFinderImpl.this.fGroupManager.getGroups();
                    do {
                        List groupList = groupPager.getCurrentPage();
                        Iterator iterator = groupList.iterator();
                        while (!BadGroupNameFinderImpl.this.fStop && iterator.hasNext()) {
                            BadGroupNameFinderImpl.this.fProcessed++;
                            Group group = (Group)iterator.next();
                            final String grpName = group.getName();
                            if (!BadGroupNameFinderImpl.this.containsUppercase(grpName)) continue;
                            BadGroupNameFinderImpl.this.fTxTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

                                public Object doInTransaction() {
                                    Space relatedSpace = BadGroupNameFinderImpl.this.fGroupUtil.getSpaceForGroup(grpName);
                                    if (relatedSpace != null) {
                                        LOG.debug("Found space-group with uppercase characters in name: " + grpName);
                                        BadGroupNameFinderImpl.this.fAo.createBadGroupEnt(grpName, relatedSpace.getKey());
                                        BadGroupNameFinderImpl.this.fFoundBadGroups++;
                                    }
                                    return null;
                                }
                            });
                            BadGroupNameFinderImpl.this.sleepThread(20);
                        }
                        if (!groupPager.onLastPage()) {
                            groupPager.nextPage();
                            continue;
                        }
                        BadGroupNameFinderImpl.this.fStop = true;
                    } while (!BadGroupNameFinderImpl.this.fStop);
                }
                catch (Exception ex) {
                    fStatus = OpStatus.ERROR;
                    BadGroupNameFinderImpl.this.fError = ex.getLocalizedMessage();
                    LOG.error("Unhandled exception occurred during running of CSUM bad space group name finder thread", (Throwable)ex);
                }
                finally {
                    if (!fStatus.equals((Object)OpStatus.ERROR)) {
                        fStatus = OpStatus.IDLE;
                        LOG.debug("CSUM bad group name finder completed without error and found " + BadGroupNameFinderImpl.this.fFoundBadGroups + " groups");
                    }
                }
            }
        };
    }

    private boolean containsUppercase(CharSequence cs) {
        if (cs != null && cs.length() > 0) {
            int len = cs.length();
            for (int i = 0; i < len; ++i) {
                if (!Character.isUpperCase(cs.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    private void sleepThread(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ie) {
            LOG.warn("Bad spacegroup name finder task thread interrupted!", (Throwable)ie);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void stop() {
        this.fStop = true;
    }

    public boolean isStop() {
        return this.fStop;
    }

    @Override
    public OpStatus getStatus() {
        return fStatus;
    }

    @Override
    public int getFoundCount() {
        return this.fFoundBadGroups;
    }

    @Override
    public int getProcessed() {
        return this.fProcessed;
    }

    @Override
    public String getError() {
        return this.fError;
    }

    @Override
    public ConfluenceUser getInitiatingUser() {
        return this.fUser;
    }

    public void destroy() {
        LOG.debug("Component being destroyed, stopping finder");
        this.fStop = true;
    }
}

