/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.ao.upgrades;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.pluginpeople.confluence.csum.ao.CSUMConfigEntity;
import com.pluginpeople.confluence.csum.legacy.CustomPermissionConfiguration;
import net.java.ao.DBParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V100ConfigMigrationUpgradeTask
implements ActiveObjectsUpgradeTask {
    static final Logger LOG = LoggerFactory.getLogger(V100ConfigMigrationUpgradeTask.class);
    static final ModelVersion VERSION = ModelVersion.valueOf((String)"100");
    private CustomPermissionConfiguration fConfig;

    public V100ConfigMigrationUpgradeTask(CustomPermissionConfiguration input) {
        this.fConfig = input;
    }

    public ModelVersion getModelVersion() {
        return VERSION;
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        if (currentVersion.isNewerThan(VERSION)) {
            return;
        }
        ao.migrate(new Class[]{CSUMConfigEntity.class});
        LOG.info("Migrating legacy config storage to ActiveObjects");
        try {
            this.migrateConfig(ao);
        }
        catch (Exception e) {
            LOG.error("Upgrade problem: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void migrateConfig(ActiveObjects ao) {
        if (this.fConfig != null) {
            try {
                CSUMConfigEntity config = (CSUMConfigEntity)ao.create(CSUMConfigEntity.class, new DBParam[0]);
                String pluginDown = this.fConfig.getPluginDown();
                boolean isDown = "YES".equals(pluginDown);
                config.setPluginDown(isDown);
                config.setPluginDownMsg(this.fConfig.getDownTimeMessage());
                String groupActionsPermittedStr = this.fConfig.getGroupActionsPermitted();
                boolean groupActionsDisabled = "NO".equals(groupActionsPermittedStr);
                config.setGroupActionsPermitted(!groupActionsDisabled);
                String groupAddRemovePermittedStr = this.fConfig.getGroupAddRemovePermitted();
                boolean groupAddRemoveDisabled = "NO".equals(groupAddRemovePermittedStr);
                config.setGroupAddRemovePermitted(!groupAddRemoveDisabled);
                String removeUserFromPermGrpPermittedStr = this.fConfig.getRemoveUserFromPermGrpPerm();
                boolean removeUserFromPermGrpPermitted = "NO".equals(removeUserFromPermGrpPermittedStr);
                config.setRemoveUserFromPermGrpPerm(!removeUserFromPermGrpPermitted);
                String grpDlgActPermStr = this.fConfig.getDlgGrpActPerm();
                boolean dlgGrpActDisabled = "NO".equals(grpDlgActPermStr);
                config.setDlgGrpActPerm(!dlgGrpActDisabled);
                String prefix = this.fConfig.getNewGroupNameCreationPrefixPattern();
                if (prefix != null) {
                    config.setGroupPrefixPattern(prefix);
                } else {
                    config.setGroupPrefixPattern("SPACEKEY-");
                }
                String suffix = this.fConfig.getNewGroupNameCreationSuffixPattern();
                if (suffix != null) {
                    config.setGroupSuffixPattern(suffix);
                } else {
                    config.setGroupSuffixPattern("");
                }
                String personalAllowed = this.fConfig.getPersonalSpaceAllowed();
                boolean isPersonalAllowed = "YES".equals(personalAllowed);
                config.setPersonalSpaceAllowed(isPersonalAllowed);
                String userSearch = this.fConfig.getUserSearchEnabled();
                boolean isUserSearchOff = "NO".equals(userSearch);
                config.setUserSearchEnabled(!isUserSearchOff);
                config.setUserManagerLocation(this.fConfig.getUserManagerLocation());
                config.setJiraRestPassword(this.fConfig.getJiraRestPassword());
                config.setJiraRestUrl(this.fConfig.getJiraRestUrl());
                config.setJiraRestUsername(this.fConfig.getJiraRestUsername());
                int maxGroups = 0;
                if (this.fConfig.getMaxGroupIDsLimit() != null) {
                    try {
                        maxGroups = Integer.parseInt(this.fConfig.getMaxGroupIDsLimit());
                    }
                    catch (NumberFormatException ex) {
                        LOG.error("MaxGroupIDsLimit is null or not integer, leaving field as 0");
                    }
                    config.setMaxGroupIDsLimit(maxGroups);
                }
                int maxUsers = 0;
                if (this.fConfig.getMaxUserIDsLimit() != null) {
                    try {
                        maxUsers = Integer.parseInt(this.fConfig.getMaxUserIDsLimit());
                    }
                    catch (NumberFormatException ex) {
                        LOG.error("MaxUserIDsLimit is null or not integer, leaving field as 0");
                    }
                    config.setMaxUserIDsLimit(maxUsers);
                }
                config.save();
                LOG.debug("Configuration migrated OK: id=" + config.getID());
            }
            catch (Exception e) {
                LOG.error("Failed to migrate CSUM Configuration to ActiveObjects store: " + e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }
}

