/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.task;

import com.atlassian.activeobjects.spi.ContextClassLoaderThreadFactory;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.search.page.Pager;
import com.pluginpeople.confluence.csum.ao.CSUMAuditEntity;
import com.pluginpeople.confluence.csum.ao.CSUMTaskEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.AuthorizationException;
import com.pluginpeople.confluence.csum.task.AbstractTask;
import com.pluginpeople.confluence.csum.task.AddUsersTask;
import com.pluginpeople.confluence.csum.task.CSVNotifyUser;
import com.pluginpeople.confluence.csum.task.CSVRecordLengthException;
import com.pluginpeople.confluence.csum.task.GroupRenameTask;
import com.pluginpeople.confluence.csum.task.RemoveUsersTask;
import com.pluginpeople.confluence.csum.task.TaskType;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import com.pluginpeople.confluence.csum.util.SpaceGroupUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskManager
implements DisposableBean {
    private static final String INFO_TYPE = "type";
    private static final String INFO_USER = "user";
    private static final String INFO_FILENAME = "filename";
    private static final String INFO_ID = "id";
    private static final String INFO_STATUS = "status";
    private static final String INFO_MESSAGE = "message";
    private static final String INFO_SUBMITTED = "submitted";
    private static final String INFO_LAST_ACTIVITY = "last_activity";
    private static final String INFO_ORIGINAL_GROUP_NAME = "original_group_name";
    private static final String INFO_NEW_GROUP_NAME = "new_group_name";
    private static final String INFO_FINISHED = "finished";
    private static final String INFO_UNSUCCESSFUL_TOTAL = "unsuccessful";
    private static final String INFO_SUCCESSFUL_TOTAL = "successful";
    private static final String INFO_UNSUCCESSFUL_LIST = "unsuccessful_list";
    private static final String INFO_SUCCESSFUL_LIST = "successful_list";
    private static final String HYPHEN = "-";
    private static final String CSUM = "CSUM";
    private static final Logger LOG = LoggerFactory.getLogger(TaskManager.class);
    private static final ClassLoader CLASS_LOADER = Thread.currentThread().getContextClassLoader();
    private static final ContextClassLoaderThreadFactory CONTEXT_CLASS_LOADER_THREAD_FACTORY = new ContextClassLoaderThreadFactory(CLASS_LOADER);
    private final UserManager fUserManager;
    private final TransactionTemplate fTxTemplate;
    private final GroupManager fGroupManager;
    private final SpaceGroupUtil fSpaceGroupUtil;
    private final CSVNotifyUser fCSVNotifyUser;
    private final I18nResolver fI18n;
    private final ICSUMActiveObjectService fAos;
    private final BootstrapManager fBootstrapManager;
    private final CSUMPermissionUtil fPermissionUtil;
    private final SpaceManager fSpaceManager;
    private final PageManager fPageManager;
    private final ContentPermissionManager fContentPermManager;
    private ThreadPoolExecutor fExecutor;
    private final ConcurrentMap<Integer, Future<?>> tracked = new ConcurrentHashMap();

    @Autowired
    public TaskManager(@ComponentImport TransactionTemplate template, @ComponentImport GroupManager groupMgr, SpaceGroupUtil util, ICSUMActiveObjectService ao, @ComponentImport I18nResolver i18n, CSVNotifyUser csvNotifyUser, @ComponentImport BootstrapManager bm, @ComponentImport PageManager pageManager, CSUMPermissionUtil permissionUtil, @ComponentImport SpaceManager spaceManager, @ComponentImport ContentPermissionManager contentPermManager, @ComponentImport UserManager userManager) {
        this.fTxTemplate = template;
        this.fGroupManager = groupMgr;
        this.fSpaceGroupUtil = util;
        this.fAos = ao;
        this.fI18n = i18n;
        this.fCSVNotifyUser = csvNotifyUser;
        this.fBootstrapManager = bm;
        this.fPermissionUtil = permissionUtil;
        this.fSpaceManager = spaceManager;
        this.fPageManager = pageManager;
        this.fContentPermManager = contentPermManager;
        this.fUserManager = userManager;
    }

    private ThreadPoolExecutor getExecutor() {
        if (this.fExecutor == null) {
            this.fExecutor = new ThreadPoolExecutor(2, 2, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10), new CSVThreadFactory(), new ThreadPoolExecutor.AbortPolicy());
            this.fExecutor.allowCoreThreadTimeOut(true);
        }
        return this.fExecutor;
    }

    private void taskStarted(int id) {
        LOG.debug("Task started: " + id);
        this.fTxTemplate.execute(() -> {
            CSUMTaskEntity taskEntity = this.fAos.getTaskEntity(id);
            if (taskEntity != null) {
                taskEntity.setStarted(Timestamp.valueOf(LocalDateTime.now()));
                taskEntity.setLatestActivity(Timestamp.valueOf(LocalDateTime.now()));
                taskEntity.setStatus("running");
                taskEntity.save();
            }
            return null;
        });
    }

    private void setTaskLastActivity(int id) {
        LOG.debug("Task last activity updated: " + id + "latest activity at:");
        this.fTxTemplate.execute(() -> {
            CSUMTaskEntity taskEntity = this.fAos.getTaskEntity(id);
            if (taskEntity != null) {
                taskEntity.setLatestActivity(Timestamp.valueOf(LocalDateTime.now()));
                taskEntity.save();
            }
            return null;
        });
    }

    private void csvTaskSuccess(int id) {
        LOG.info("Task completed: " + id);
        this.fTxTemplate.execute(() -> {
            CSUMTaskEntity taskEntity = this.fAos.getTaskEntity(id);
            if (taskEntity != null) {
                taskEntity.setFinished(Timestamp.valueOf(LocalDateTime.now()));
                taskEntity.setLatestActivity(Timestamp.valueOf(LocalDateTime.now()));
                if (!taskEntity.getStatus().equals("cancelled")) {
                    if (taskEntity.getUnsuccessfulTotal() > 0) {
                        taskEntity.setStatus("requires_attention");
                    } else if (taskEntity.getSuccessfulTotal() > 0) {
                        taskEntity.setStatus("success");
                    } else {
                        LOG.error("File did not contain valid user/group values in CSV format, usually due to incorrect delimiter set. Task id: " + id);
                        taskEntity.setStatus("rejected");
                    }
                }
                taskEntity.save();
            }
            return null;
        });
    }

    private void taskFailure(int id, Exception e) {
        String msgArgs;
        String msg;
        LOG.error("CSUM bulk task #" + id + " completed unsuccessfully: ", (Throwable)e);
        if (e instanceof CSVRecordLengthException) {
            msg = "csum.bulk.upload.error.recordlength";
            msgArgs = StringUtils.join((Object[])new String[]{String.valueOf(((CSVRecordLengthException)e).getExpectedLength()), String.valueOf(((CSVRecordLengthException)e).getActualLength())}, (char)',');
        } else {
            msg = e.getLocalizedMessage();
            msgArgs = null;
        }
        this.fTxTemplate.execute(() -> {
            CSUMTaskEntity taskEntity = this.fAos.getTaskEntity(id);
            if (taskEntity != null) {
                taskEntity.setStatus("failure");
                taskEntity.setMessage(msg);
                if (msgArgs != null && !msgArgs.isEmpty()) {
                    taskEntity.setMessageArgs(msgArgs);
                }
                taskEntity.setFinished(Timestamp.valueOf(LocalDateTime.now()));
                taskEntity.setLatestActivity(Timestamp.valueOf(LocalDateTime.now()));
                taskEntity.save();
            }
            return null;
        });
    }

    private void groupRenameTaskFailure(int id, Exception e, CSUMAuditEntity groupCreated, CSUMAuditEntity groupDeleted) {
        LOG.error("CSUM bulk task #" + id + " completed unsuccessfully: ", (Throwable)e);
        String msg = e.getLocalizedMessage();
        String msgArgs = null;
        this.fTxTemplate.execute(() -> {
            CSUMTaskEntity taskEntity = this.fAos.getTaskEntity(id);
            if (taskEntity != null) {
                taskEntity.setStatus("failure");
                taskEntity.setMessage(msg);
                if (msgArgs != null && !msgArgs.isEmpty()) {
                    taskEntity.setMessageArgs(msgArgs);
                }
                taskEntity.setFinished(Timestamp.valueOf(LocalDateTime.now()));
                taskEntity.setLatestActivity(Timestamp.valueOf(LocalDateTime.now()));
                taskEntity.save();
            }
            if (groupCreated.getEventOutcome().equals("queued")) {
                groupCreated.setEventOutcome(String.valueOf((Object)ICSUMActiveObjectService.CSUMAuditEventOutcome.error));
                groupCreated.save();
            }
            if (groupDeleted.getEventOutcome().equals("queued")) {
                groupDeleted.setEventOutcome(String.valueOf((Object)ICSUMActiveObjectService.CSUMAuditEventOutcome.error));
                groupDeleted.save();
            }
            return null;
        });
    }

    private void groupRenameTaskSuccess(int id) {
        LOG.info("Task completed: " + id);
        this.fTxTemplate.execute(() -> {
            CSUMTaskEntity taskEntity = this.fAos.getTaskEntity(id);
            if (taskEntity != null) {
                taskEntity.setFinished(Timestamp.valueOf(LocalDateTime.now()));
                taskEntity.setLatestActivity(Timestamp.valueOf(LocalDateTime.now()));
                if (!taskEntity.getStatus().equals("cancelled")) {
                    taskEntity.setStatus("success");
                }
                taskEntity.save();
            }
            return null;
        });
    }

    public void deleteUploadedFilesForSpace(Space validSpace) throws IOException {
        String filteredSpaceKey = this.filterSpaceKeyForFilename(validSpace.getKey());
        try {
            File fileStorageDirectory = this.getFileStorageDirectory();
            FileFilter fileFilter = file -> file.getName().startsWith(filteredSpaceKey);
            File[] files = fileStorageDirectory.listFiles(fileFilter);
            if (files != null && files.length > 0) {
                for (File fileToDelete : files) {
                    Files.deleteIfExists(fileToDelete.toPath());
                }
            }
        }
        catch (IOException e) {
            LOG.error("Exception during deletion of old uploaded csv files", (Throwable)e);
            throw e;
        }
    }

    public byte[] getLatestUploadedFile(Space validSpace, int taskId) throws IOException {
        byte[] ret = null;
        String filteredSpaceKey = this.filterSpaceKeyForFilename(validSpace.getKey());
        String fileNameToFind = filteredSpaceKey + HYPHEN + taskId;
        try {
            File matchingFile;
            File fileStorageDirectory = this.getFileStorageDirectory();
            if (fileStorageDirectory.exists() && (matchingFile = new File(fileStorageDirectory, fileNameToFind)).isFile()) {
                ret = Files.readAllBytes(matchingFile.toPath());
            }
        }
        catch (IOException e) {
            LOG.error("Unable to find latest uploaded file", (Throwable)e);
            throw e;
        }
        return ret;
    }

    public File storeFileFromRequest(Space validSpace, int entityId) throws IOException {
        String fileName = this.filterSpaceKeyForFilename(validSpace.getKey()) + HYPHEN + entityId;
        return new File(this.getFileStorageDirectory(), fileName);
    }

    private String filterSpaceKeyForFilename(String spaceKey) {
        StringBuilder sb = new StringBuilder();
        for (char c : spaceKey.toCharArray()) {
            if (!Character.isLetterOrDigit(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private void deleteLinkedFile(String filePath, int id) {
        block4: {
            if (filePath != null) {
                File file = new File(filePath);
                try {
                    if (file.exists()) {
                        Files.delete(file.toPath());
                    }
                }
                catch (IOException e) {
                    LOG.error("Exception during delete of related task file", (Throwable)e);
                    if (Thread.currentThread().isInterrupted()) break block4;
                    this.taskFailure(id, e);
                }
            }
        }
    }

    private void shutdown() {
        if (this.fExecutor != null) {
            LOG.debug("Shutting down bulk operation file processor");
            this.fExecutor.shutdown();
            try {
                if (!this.fExecutor.awaitTermination(20L, TimeUnit.SECONDS)) {
                    LOG.warn("Bulk operation file processor took more than 20s to shutdown, killing all tasks");
                    this.fExecutor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                this.fExecutor = null;
            }
        }
    }

    public boolean getActiveRenameTaskWithEitherGroup(Space space, String oldGroupName, String newGroupName) {
        CSUMTaskEntity[] existingTasks;
        boolean queueTask = true;
        for (CSUMTaskEntity task : existingTasks = this.fAos.queryRenameTaskForGroup(oldGroupName, newGroupName, space.getKey())) {
            if (task.getStatus().equals("running")) {
                int fifteenMinutes;
                long lastActivity = task.getLatestActivity().getTime() / 1000L;
                long currentTime = System.currentTimeMillis() / 1000L;
                if (currentTime - lastActivity >= (long)(fifteenMinutes = 900)) {
                    LOG.error("Task id: " + task.getID() + " has had no activity for at least 15 minutes. Failing task");
                    this.fTxTemplate.execute(() -> {
                        this.cancelTask(task.getID());
                        task.setStatus("failure");
                        task.save();
                        return null;
                    });
                    continue;
                }
                LOG.error("There is already a task running involving either or both the group(s) " + oldGroupName + " or " + newGroupName);
                queueTask = false;
                continue;
            }
            LOG.error("There is already a task queued involving either or both the group(s) " + oldGroupName + " or " + newGroupName);
            queueTask = false;
        }
        return queueTask;
    }

    public void queueTask(AbstractTask task, CSUMTaskEntity taskEntity, String oldGroupName, Space space, String newGroupName) {
        int id = taskEntity.getID();
        taskEntity.setStatus("queued");
        taskEntity.save();
        CSUMAuditEntity groupCreatedAudit = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.createGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.queued, space, newGroupName, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText("csum.auditing.operation.renameGroup"), null, null);
        CSUMAuditEntity groupDeletedAudit = this.fAos.createAuditEntity(ICSUMActiveObjectService.CSUMOperationType.removeGroup, ICSUMActiveObjectService.CSUMAuditEventOutcome.queued, space, oldGroupName, null, AuthenticatedUserThreadLocal.getUsername(), this.fI18n.getText("csum.auditing.operation.renameGroup"), null, null);
        try {
            Future<?> future = this.getExecutor().submit(() -> {
                try {
                    AuthenticatedUserThreadLocal.set((ConfluenceUser)task.getInitiatingUser());
                    task.setTxTemplate(this.fTxTemplate);
                    this.taskStarted(id);
                    long timeStart = System.currentTimeMillis();
                    Group originalGroup = null;
                    Group newRenamedGroup = null;
                    if (newGroupName != null) {
                        if (this.fGroupManager.getGroup(newGroupName) == null) {
                            newRenamedGroup = this.fGroupManager.createGroup(newGroupName);
                            this.fTxTemplate.execute(() -> {
                                groupCreatedAudit.setEventOutcome(String.valueOf((Object)ICSUMActiveObjectService.CSUMAuditEventOutcome.success));
                                groupCreatedAudit.save();
                                return null;
                            });
                            this.fSpaceGroupUtil.addSpaceGroupToCache(space, newGroupName);
                        } else {
                            newRenamedGroup = this.fGroupManager.getGroup(newGroupName);
                        }
                    }
                    if ((originalGroup = this.fGroupManager.getGroup(oldGroupName)) != null) {
                        this.transferPermissionsFromOldGroupToNew(oldGroupName, newRenamedGroup, id);
                        this.copyMembersFromOldGroupToNewGroup(originalGroup, newRenamedGroup);
                        this.removeMembersFromOldGroup(originalGroup);
                        this.fGroupManager.removeGroup(originalGroup);
                        this.fSpaceGroupUtil.removeSpaceGroupFromCache(space, oldGroupName);
                        this.fTxTemplate.execute(() -> {
                            groupDeletedAudit.setEventOutcome(String.valueOf((Object)ICSUMActiveObjectService.CSUMAuditEventOutcome.success));
                            groupDeletedAudit.save();
                            return null;
                        });
                    }
                    long timeEnd = System.currentTimeMillis();
                    long duration = timeEnd - timeStart;
                    LOG.debug("time taken: " + duration + "ms");
                    if (!Thread.currentThread().isInterrupted()) {
                        this.groupRenameTaskSuccess(id);
                    }
                }
                catch (EntityException e) {
                    LOG.error("Entity Exception: " + (Object)((Object)e));
                    this.groupRenameTaskFailure(id, (Exception)((Object)e), groupCreatedAudit, groupDeletedAudit);
                }
                catch (Exception e) {
                    LOG.error("Exception: " + e);
                    this.groupRenameTaskFailure(id, e, groupCreatedAudit, groupDeletedAudit);
                }
                finally {
                    this.tracked.remove(id);
                }
            });
            this.tracked.put(id, future);
            LOG.debug("number of tasks currently tracked: " + this.tracked.size());
        }
        catch (RejectedExecutionException e) {
            taskEntity.setStatus("rejected");
            taskEntity.save();
        }
    }

    private void copyMembersFromOldGroupToNewGroup(Group originalGroup, Group newRenamedGroup) throws EntityException {
        if (originalGroup != null) {
            Pager memberPager = this.fGroupManager.getMemberNames(originalGroup);
            for (String userStr : memberPager) {
                User user = this.fUserManager.getUser(userStr);
                if (user == null) continue;
                this.fGroupManager.addMembership(newRenamedGroup, user);
            }
        }
    }

    private void removeMembersFromOldGroup(Group originalGroup) throws EntityException {
        if (originalGroup != null) {
            Pager memberPager = this.fGroupManager.getMemberNames(originalGroup);
            for (String userStr : memberPager) {
                User user = this.fUserManager.getUser(userStr);
                if (user == null) continue;
                this.fGroupManager.removeMembership(originalGroup, user);
            }
        }
    }

    private void transferPermissionsFromOldGroupToNew(String oldGroupName, Group renamedGroup, int id) {
        try {
            List<SpacePermission> oldPermissions = this.fPermissionUtil.getPermissions(oldGroupName);
            this.assignGroupPermissions(oldPermissions, renamedGroup);
            this.assignPageContentPermissions(oldGroupName, renamedGroup, id);
            this.removeGroupPermissions(oldPermissions);
        }
        catch (Exception e) {
            LOG.error("Problem transferring Space/Page/Content permissions from Group: " + oldGroupName + " to renamed Group" + renamedGroup + "Task id: " + id);
            throw e;
        }
    }

    private void assignGroupPermissions(List<SpacePermission> origPermissions, Group renamed) {
        for (SpacePermission anOldPermission : origPermissions) {
            List<SpacePermission> groupRenamedToPermissions;
            SpacePermission newPermission = SpacePermission.createGroupSpacePermission((String)anOldPermission.getType(), (Space)anOldPermission.getSpace(), (String)renamed.getName());
            Space oldGroupsSpace = anOldPermission.getSpace();
            if (oldGroupsSpace == null || (groupRenamedToPermissions = this.fPermissionUtil.getPermissions(renamed.getName())).contains(newPermission)) continue;
            this.fTxTemplate.execute(() -> {
                this.fPermissionUtil.savePermission(newPermission);
                return null;
            });
        }
    }

    private void assignPageContentPermissions(String oldGroupName, Group newGroup, int id) {
        for (Space space : this.fSpaceManager.getAllSpaces()) {
            List currentPages = this.fPageManager.getPages(space, true);
            int pageCount = 0;
            for (Page page : currentPages) {
                this.fTxTemplate.execute(() -> {
                    Page pageToChange = this.fPageManager.getPage(space.getKey(), page.getTitle());
                    if (pageToChange != null) {
                        this.assignPagePermissions(oldGroupName, newGroup, pageToChange, "View");
                        this.assignPagePermissions(oldGroupName, newGroup, pageToChange, "Edit");
                        this.assignPagePermissions(oldGroupName, newGroup, pageToChange, "Share");
                        this.removePagePermissions(oldGroupName, pageToChange, "View");
                        this.removePagePermissions(oldGroupName, pageToChange, "Edit");
                        this.removePagePermissions(oldGroupName, pageToChange, "Share");
                    }
                    return null;
                });
                if (++pageCount != 20) continue;
                this.setTaskLastActivity(id);
                pageCount = 0;
            }
        }
    }

    private void assignPagePermissions(String oldGroupName, Group newGroup, Page page, String permission) {
        boolean permissionAlreadyExists = false;
        ContentPermissionSet permissionSet = page.getContentPermissionSet(permission);
        if (permissionSet != null) {
            for (ContentPermission contentPermission : permissionSet) {
                if (!contentPermission.isGroupPermission() || !contentPermission.getGroupName().equals(newGroup.getName())) continue;
                permissionAlreadyExists = true;
                break;
            }
            if (!permissionAlreadyExists) {
                for (ContentPermission contentPermission : permissionSet) {
                    if (!contentPermission.isGroupPermission() || !contentPermission.getGroupName().equals(oldGroupName)) continue;
                    page.addPermission(ContentPermission.createGroupPermission((String)permission, (String)newGroup.getName()));
                    break;
                }
            }
        }
    }

    private void removeGroupPermissions(List<SpacePermission> origPermissions) {
        for (SpacePermission anOldPermission : origPermissions) {
            this.fTxTemplate.execute(() -> {
                this.fPermissionUtil.removePermission(anOldPermission);
                return null;
            });
        }
    }

    private void removePagePermissions(String oldGroupName, Page page, String permission) {
        ArrayList<ContentPermission> toRemove = new ArrayList<ContentPermission>();
        ContentPermissionSet permissionSet = page.getContentPermissionSet(permission);
        if (permissionSet != null) {
            for (ContentPermission contentPermission : permissionSet) {
                if (!contentPermission.isGroupPermission() || !contentPermission.getGroupName().equals(oldGroupName)) continue;
                toRemove.add(contentPermission);
                break;
            }
        }
        for (ContentPermission perm : toRemove) {
            this.fContentPermManager.removeContentPermission(perm);
        }
    }

    public void queueTask(AbstractTask task, CSUMTaskEntity taskEntity, char delimiter) {
        int id = taskEntity.getID();
        taskEntity.setStatus("queued");
        taskEntity.save();
        try {
            Future<?> future = this.getExecutor().submit(() -> {
                try {
                    AuthenticatedUserThreadLocal.set((ConfluenceUser)task.getInitiatingUser());
                    task.setTxTemplate(this.fTxTemplate);
                    task.setDelimiter(delimiter);
                    this.taskStarted(id);
                    task.run(id);
                }
                catch (CSVRecordLengthException e) {
                    this.taskFailure(id, e);
                    LOG.error("CSV record length exception caught for task id: " + id + ". This could be due to CSV record size or delimiter. Exception: " + e);
                }
                catch (EntityException e) {
                    this.taskFailure(id, (Exception)((Object)e));
                    LOG.error("Entity exception caught for task id: " + id + ". This may be due to a group or user(s) not being found. Exception: " + (Object)((Object)e));
                }
                catch (AuthorizationException e) {
                    this.taskFailure(id, (Exception)((Object)e));
                    LOG.error("Authorization exception caught for task id: " + id + ". This could be due to initiating user not being authorized to add/remove users. Exception: " + (Object)((Object)e));
                }
                catch (Exception e) {
                    this.taskFailure(id, e);
                    LOG.error("Unhandled exception occurred during running of CSUM task. Task id: " + id, (Throwable)e);
                }
                finally {
                    if (!taskEntity.getStatus().equalsIgnoreCase("failure")) {
                        if (!Thread.currentThread().isInterrupted()) {
                            this.csvTaskSuccess(id);
                        } else {
                            this.taskFailure(id, new IllegalStateException("Cannot end task"));
                        }
                    }
                    if (task.willNotify()) {
                        this.sendNotification(id, task.getSpace());
                    }
                    this.tracked.remove(id);
                }
            });
            this.tracked.put(id, future);
            LOG.debug("number of tasks currently tracked: " + this.tracked.size());
        }
        catch (RejectedExecutionException e) {
            LOG.error("Rejected execution exception when attempting to create and queue this task. Task id: " + taskEntity.getID() + ". Exception: " + e);
            taskEntity.setStatus("rejected");
            taskEntity.save();
        }
    }

    private void sendNotification(int id, Space space) {
        this.fTxTemplate.execute(() -> {
            this.fCSVNotifyUser.sendNotificationEmail(id, space, this.getTaskInfo(id).get(INFO_MESSAGE).toString());
            return null;
        });
    }

    public Integer processTask(TaskType taskType, Space space, char delimiter, boolean willNotify, CSUMTaskEntity taskEntity) {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (currentUser != null) {
            if (taskType.equals(TaskType.ADD_GROUP_MEMBERS)) {
                AddUsersTask addUsersTask = new AddUsersTask(taskEntity.getFilePath(), currentUser, space, this.fGroupManager, this.fSpaceGroupUtil, this.fAos, willNotify);
                this.queueTask(addUsersTask, taskEntity, delimiter);
            } else if (taskType.equals(TaskType.REMOVE_GROUP_MEMBERS)) {
                RemoveUsersTask removeUsersTask = new RemoveUsersTask(taskEntity.getFilePath(), currentUser, space, this.fGroupManager, this.fSpaceGroupUtil, this.fAos, willNotify);
                this.queueTask(removeUsersTask, taskEntity, delimiter);
            }
        }
        return taskEntity.getID();
    }

    public Integer processTask(TaskType taskType, Space space, String oldGroupName, CSUMTaskEntity taskEntity, String newGroupName, ConfluenceUser currentUser) {
        if (taskType.equals(TaskType.GROUP_RENAME_PERMISSIONS_TRANSFER)) {
            GroupRenameTask groupRenameTask = new GroupRenameTask(currentUser, space);
            this.queueTask(groupRenameTask, taskEntity, oldGroupName, space, newGroupName);
        }
        return taskEntity.getID();
    }

    public void destroy() {
        this.shutdown();
    }

    public void deleteTaskRecord(int id) throws IOException {
        CSUMTaskEntity taskEntity;
        Future future = (Future)this.tracked.get(id);
        if (future != null) {
            this.cancelTask(id);
        }
        if ((taskEntity = this.fAos.getTaskEntity(id)) != null) {
            this.fAos.delete(taskEntity);
        }
    }

    public void cancelTask(int id) {
        this.fTxTemplate.execute(() -> {
            CSUMTaskEntity taskEntity;
            Future trackedFuture = (Future)this.tracked.get(id);
            if (trackedFuture != null && !trackedFuture.isCancelled()) {
                trackedFuture.cancel(true);
                LOG.info("CSUM bulk task cancelled: " + id);
                this.tracked.remove(id);
            }
            if ((taskEntity = this.fAos.getTaskEntity(id)) != null && taskEntity.getFinished() == null) {
                taskEntity.setStatus("cancelled");
                taskEntity.save();
                this.deleteLinkedFile(taskEntity.getFilePath(), taskEntity.getID());
            }
            return null;
        });
    }

    public CSUMTaskEntity[] getTaskRecords(Space validSpace) {
        if (validSpace != null) {
            return this.fAos.getTaskEntitiesForSpace(validSpace.getKey());
        }
        return new CSUMTaskEntity[0];
    }

    public Map<String, Object> getTaskInfo(int id) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        CSUMTaskEntity taskEntity = this.fAos.getTaskEntity(id);
        if (taskEntity != null) {
            info.put(INFO_TYPE, taskEntity.getTaskType());
            info.put(INFO_USER, taskEntity.getInitiatingUser());
            info.put(INFO_FILENAME, taskEntity.getFilename());
            info.put(INFO_ID, taskEntity.getID());
            info.put(INFO_STATUS, taskEntity.getStatus());
            String taskMsg = taskEntity.getMessage();
            this.getTaskMsgInfo(info, taskEntity, taskMsg);
            info.put(INFO_ORIGINAL_GROUP_NAME, taskEntity.getOriginalGroupName() != null ? taskEntity.getOriginalGroupName() : "");
            info.put(INFO_NEW_GROUP_NAME, taskEntity.getNewGroupName() != null ? taskEntity.getNewGroupName() : "");
            info.put(INFO_SUBMITTED, taskEntity.getSubmitted() != null ? taskEntity.getSubmitted().toString() : "");
            info.put(INFO_LAST_ACTIVITY, taskEntity.getLatestActivity() != null ? taskEntity.getLatestActivity().toString() : "");
            info.put(INFO_FINISHED, taskEntity.getFinished() != null ? taskEntity.getFinished().toString() : "");
            info.put(INFO_SUCCESSFUL_TOTAL, taskEntity.getSuccessfulTotal());
            info.put(INFO_SUCCESSFUL_LIST, taskEntity.getSuccessfulUsers() != null ? taskEntity.getSuccessfulUsers().trim() : "");
            info.put(INFO_UNSUCCESSFUL_TOTAL, taskEntity.getUnsuccessfulTotal());
            info.put(INFO_UNSUCCESSFUL_LIST, taskEntity.getUnsuccessfulUsers() != null ? taskEntity.getUnsuccessfulUsers().trim() : "");
        }
        return info;
    }

    private void getTaskMsgInfo(Map<String, Object> info, CSUMTaskEntity taskEntity, String taskMsg) {
        if (taskMsg != null) {
            String args = taskEntity.getMessageArgs();
            if (args != null) {
                String msg = this.fI18n.getText(taskMsg, (Serializable[])args.split(","));
                info.put(INFO_MESSAGE, StringEscapeUtils.unescapeHtml4((String)msg));
            } else {
                info.put(INFO_MESSAGE, taskMsg);
            }
        } else {
            info.put(INFO_MESSAGE, "");
        }
    }

    private File getFileStorageDirectory() throws IOException {
        File location = new File(this.fBootstrapManager.getSharedHome(), CSUM);
        if (!location.exists()) {
            Files.createDirectory(location.toPath(), new FileAttribute[0]);
        }
        return location;
    }

    private static class CSVThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        private CSVThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = CONTEXT_CLASS_LOADER_THREAD_FACTORY.newThread(r);
            t.setName("CSUM-CSV-Processor-" + this.threadNumber.getAndIncrement());
            return t;
        }
    }
}

