/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.rest;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.access.annotations.RequiresLicensedConfluenceAccess;
import com.atlassian.confluence.security.service.XsrfTokenService;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.fugue.Pair;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.RequiresXsrfCheck;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.impl.EntityMissingException;
import com.pluginpeople.confluence.csum.ao.CSUMTaskEntity;
import com.pluginpeople.confluence.csum.ao.ICSUMActiveObjectService;
import com.pluginpeople.confluence.csum.api.AuthorizationException;
import com.pluginpeople.confluence.csum.api.DuplicateException;
import com.pluginpeople.confluence.csum.api.GroupActionNotPermittedException;
import com.pluginpeople.confluence.csum.api.InvalidSpaceException;
import com.pluginpeople.confluence.csum.api.SpaceGroupPatternMismatchException;
import com.pluginpeople.confluence.csum.rest.AbstractCSUMRestResource;
import com.pluginpeople.confluence.csum.rest.beans.DataTableGroupList;
import com.pluginpeople.confluence.csum.rest.beans.DataTableUserList;
import com.pluginpeople.confluence.csum.rest.beans.ExceptionBean;
import com.pluginpeople.confluence.csum.service.cache.ICSUMCacheManager;
import com.pluginpeople.confluence.csum.task.TaskManager;
import com.pluginpeople.confluence.csum.task.TaskType;
import com.pluginpeople.confluence.csum.util.CSUMPermissionUtil;
import com.pluginpeople.confluence.csum.util.GroupUtil;
import com.pluginpeople.confluence.csum.util.SpaceGroupUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ReadOnlyAccessAllowed
@Path(value="/spacegroup")
@RequiresLicensedConfluenceAccess
public class SpaceGroupResource
extends AbstractCSUMRestResource {
    private static final Logger LOG = LoggerFactory.getLogger(SpaceGroupResource.class);
    private static final String NOT_AUTHORIZED_FOR_THIS_ACTION = " is not authorized for this action";
    private static final String SPACE_KEY = "Space key: ";
    private static final String IS_NOT_ASSOCIATED_WITH_GROUP = " is not associated with group: ";
    private static final String QUEUED = "queued";
    private static final String UPLOADING = "uploading";
    private static final String RUNNING = "running";
    private final ICSUMCacheManager fCacheManager;
    private final UserAccessor fUserAccessor;
    private final GroupManager fGm;
    private final GroupUtil fGroupUtil;
    private final SpaceGroupUtil fSpaceGroupUtil;
    private final I18nResolver fI18n;
    private final PluginAccessor fPluginAccessor;
    private final TaskManager fTaskManager;
    private final ICSUMActiveObjectService fAos;

    public SpaceGroupResource(@ComponentImport SpaceManager spaceManager, SpaceGroupUtil grpUtil, @ComponentImport I18nResolver i18n, @ComponentImport XsrfTokenService tokenService, ICSUMCacheManager cacheManager, CSUMPermissionUtil permissionUtil, @ComponentImport UserAccessor userAccessor, @ComponentImport GroupManager gm, GroupUtil groupUtil, @ComponentImport PermissionManager permissionManager, @ComponentImport PluginAccessor pluginAccessor, TaskManager taskManager, ICSUMActiveObjectService ao) {
        super(spaceManager, permissionUtil, tokenService, permissionManager, cacheManager);
        this.fPluginAccessor = pluginAccessor;
        this.fSpaceGroupUtil = grpUtil;
        this.fI18n = i18n;
        this.fCacheManager = cacheManager;
        this.fUserAccessor = userAccessor;
        this.fGm = gm;
        this.fGroupUtil = groupUtil;
        this.fTaskManager = taskManager;
        this.fAos = ao;
    }

    @GET
    @RequiresXsrfCheck
    @Path(value="/group")
    @Produces(value={"application/json"})
    public Response checkGroupExists(@Context HttpServletRequest hsr, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="groupName") String partialGroupName, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        if (this.isUnauthorizedOrBadXsrfToken(hsr, spaceKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Space validSpace = this.getValidSpaceFromSpaceKey(spaceKey);
        if (validSpace == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (partialGroupName == null) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        try {
            String groupName = this.fSpaceGroupUtil.computeSpaceGroupName(validSpace, partialGroupName);
            Group group = this.fGm.getGroup(groupName);
            if (group != null) {
                return Response.notModified().build();
            }
            response = Response.ok().build();
        }
        catch (EntityException e) {
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return response;
    }

    @POST
    @RequiresXsrfCheck
    @Path(value="/rename")
    @Produces(value={"application/json"})
    public Response renameSpaceGroup(@Context HttpServletRequest hsr, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="from") String oldGroupStr, @QueryParam(value="to") String newGroupStr, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        block12: {
            if (this.isUnauthorizedOrBadXsrfToken(hsr, spaceKey)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            if (this.invalidPrefixAndSuffix()) {
                LOG.error("Neither the prefix or suffix is set in the CSUM config");
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            Space validSpace = this.getValidSpaceFromSpaceKey(spaceKey);
            if (validSpace == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)spaceKey).build();
            }
            try {
                String newGroupName = this.fSpaceGroupUtil.computeSpaceGroupName(validSpace, newGroupStr);
                if (!this.fTaskManager.getActiveRenameTaskWithEitherGroup(validSpace, oldGroupStr, newGroupName)) {
                    return Response.notModified().build();
                }
                boolean renameValid = this.fSpaceGroupUtil.validateRenameGroupIsAllowed(validSpace, oldGroupStr);
                if (renameValid) {
                    ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
                    CSUMTaskEntity taskEntity = this.fAos.createTaskEntity(TaskType.GROUP_RENAME_PERMISSIONS_TRANSFER, validSpace.getKey(), currentUser.getName());
                    taskEntity.setOriginalGroupName(oldGroupStr);
                    taskEntity.setNewGroupName(newGroupName);
                    taskEntity.save();
                    Integer successfulTask = this.fTaskManager.processTask(TaskType.GROUP_RENAME_PERMISSIONS_TRANSFER, validSpace, oldGroupStr, taskEntity, newGroupName, currentUser);
                    if (successfulTask > 0) {
                        response = Response.ok((Object)newGroupStr, (String)"text/plain").build();
                    } else {
                        LOG.error("Group Rename Task did not process successfully, TaskEntity not created");
                        response = Response.serverError().build();
                    }
                    break block12;
                }
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            catch (SpaceGroupPatternMismatchException e) {
                LOG.error(SPACE_KEY + spaceKey + IS_NOT_ASSOCIATED_WITH_GROUP + oldGroupStr, (Throwable)e);
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)spaceKey).build();
            }
            catch (AuthorizationException | GroupActionNotPermittedException e) {
                LOG.error(AuthenticatedUserThreadLocal.getUsername() + NOT_AUTHORIZED_FOR_THIS_ACTION, e);
                ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)exceptionBean).build();
            }
            catch (EntityException e) {
                ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exceptionBean).build();
            }
            catch (Exception e) {
                LOG.error("Unhandled error when renaming " + oldGroupStr + " in space: " + spaceKey, (Throwable)e);
                ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
                response = Response.status((Response.Status)Response.Status.SEE_OTHER).entity((Object)exceptionBean).build();
            }
        }
        return response;
    }

    @GET
    @RequiresXsrfCheck
    @Path(value="/queuedTasks")
    @Produces(value={"application/json"})
    public Response spaceQueuedOrRunningGroupRenameTasks(@Context HttpServletRequest hsr, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="atl_token") String atlToken) {
        CSUMTaskEntity[] tasks;
        if (this.isUnauthorizedOrBadXsrfToken(hsr, spaceKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        boolean allTasksFinished = true;
        Space currentSpace = this.getValidSpaceFromSpaceKey(spaceKey);
        if (currentSpace == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        for (CSUMTaskEntity task : tasks = this.fTaskManager.getTaskRecords(currentSpace)) {
            if (!task.getTaskType().equals(TaskType.GROUP_RENAME_PERMISSIONS_TRANSFER.getName()) || !task.getStatus().equals(QUEUED) && !task.getStatus().equals(RUNNING)) continue;
            allTasksFinished = false;
            break;
        }
        Response response = allTasksFinished ? Response.ok((Object)Boolean.TRUE).build() : Response.ok((Object)Boolean.FALSE).build();
        return response;
    }

    @GET
    @RequiresXsrfCheck
    @Path(value="/groupTasksUnderway")
    @Produces(value={"application/json"})
    public Response anyTasksUnderwayForSpaceGroup(@Context HttpServletRequest hsr, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="groupName") String groupName, @QueryParam(value="atl_token") String atlToken) {
        if (this.isUnauthorizedOrBadXsrfToken(hsr, spaceKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Response response = null;
        Space currentSpace = this.getValidSpaceFromSpaceKey(spaceKey);
        if (currentSpace == null) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        } else {
            CSUMTaskEntity[] tasks;
            for (CSUMTaskEntity task : tasks = this.fTaskManager.getTaskRecords(currentSpace)) {
                boolean isGroupNameInvolved;
                boolean isRenameTask = task.getTaskType().equals(TaskType.GROUP_RENAME_PERMISSIONS_TRANSFER.getName());
                if (!isRenameTask) continue;
                boolean isTaskInProgress = task.getStatus().equals(QUEUED) || task.getStatus().equals(RUNNING) || task.getStatus().equals(UPLOADING);
                boolean bl = isGroupNameInvolved = task.getOriginalGroupName().equals(groupName) || task.getNewGroupName().equals(groupName);
                if (!isTaskInProgress || !isGroupNameInvolved) continue;
                response = Response.ok((Object)Boolean.TRUE).build();
                break;
            }
            if (response == null) {
                response = Response.ok((Object)Boolean.FALSE).build();
            }
        }
        return response;
    }

    @DELETE
    @RequiresXsrfCheck
    @Path(value="/delete")
    @Produces(value={"application/json"})
    public Response deleteSpaceGroup(@Context HttpServletRequest hsr, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="spaceGroup") String spaceGroup, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        if (this.isUnauthorizedOrBadXsrfToken(hsr, spaceKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Space validSpace = this.getValidSpaceFromSpaceKey(spaceKey);
        if (validSpace == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)spaceKey).build();
        }
        try {
            response = this.fSpaceGroupUtil.deleteSpaceGroup(validSpace, spaceGroup) ? Response.ok().build() : Response.notModified().build();
        }
        catch (EntityMissingException e) {
            ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exceptionBean).build();
        }
        catch (AuthorizationException e) {
            LOG.error(AuthenticatedUserThreadLocal.getUsername() + NOT_AUTHORIZED_FOR_THIS_ACTION, (Throwable)e);
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (GroupActionNotPermittedException e) {
            LOG.error("Group actions disabled in CSUM config for space: " + spaceKey, (Throwable)e);
            response = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
        catch (SpaceGroupPatternMismatchException e) {
            LOG.error(SPACE_KEY + spaceKey + IS_NOT_ASSOCIATED_WITH_GROUP + spaceGroup, (Throwable)e);
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)spaceKey).build();
        }
        catch (Exception e) {
            LOG.error("Unhandled error occurred when deleting space group: " + spaceGroup, (Throwable)e);
            ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
            response = Response.status((Response.Status)Response.Status.SEE_OTHER).entity((Object)exceptionBean).build();
        }
        return response;
    }

    @PUT
    @RequiresXsrfCheck
    @Path(value="/create")
    @Produces(value={"application/json"})
    public Response createSpaceGroup(@Context HttpServletRequest hsr, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="spaceGroup") String spaceGroup, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        if (this.isUnauthorizedOrBadXsrfToken(hsr, spaceKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Space validSpace = this.getValidSpaceFromSpaceKey(spaceKey);
        if (validSpace == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)spaceKey).build();
        }
        try {
            Group created = this.fSpaceGroupUtil.createSpaceGroup(validSpace, spaceGroup);
            response = created != null ? Response.ok().build() : Response.serverError().build();
        }
        catch (DuplicateException e) {
            LOG.error("space group " + spaceGroup + " already exists", (Throwable)e);
            response = Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
        }
        catch (AuthorizationException e) {
            LOG.error(AuthenticatedUserThreadLocal.getUsername() + NOT_AUTHORIZED_FOR_THIS_ACTION, (Throwable)e);
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (GroupActionNotPermittedException e) {
            LOG.error("Group actions disabled in CSUM config for space: " + spaceKey, (Throwable)e);
            response = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
        }
        catch (EntityException e) {
            LOG.error("Error fetching existing space groups", (Throwable)e);
            ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exceptionBean).build();
        }
        catch (Exception e) {
            LOG.error("Unhandled error occurred when creating space group: " + spaceGroup, (Throwable)e);
            ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
            response = Response.status((Response.Status)Response.Status.SEE_OTHER).entity((Object)exceptionBean).build();
        }
        return response;
    }

    @GET
    @RequiresXsrfCheck
    @Path(value="/groups")
    @Produces(value={"application/json"})
    public Response getSpaceGroups(@Context HttpServletRequest hsr, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="atl_token") String atlToken, @QueryParam(value="draw") int draw, @QueryParam(value="start") int start, @QueryParam(value="length") int length, @QueryParam(value="searchVal") String search, @QueryParam(value="isGroupProc") boolean isServerSideProcEnabled) {
        Response response;
        if (this.isUnauthorizedOrBadXsrfToken(hsr, spaceKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Space validSpace = this.getValidSpaceFromSpaceKey(spaceKey);
        if (validSpace == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            String[][] data;
            boolean reachedCacheSizeLimit;
            String[] spaceGroups = isServerSideProcEnabled && length > 0 ? this.fSpaceGroupUtil.getPagedSpaceGroupsFromCache(validSpace, length, start, search) : this.fSpaceGroupUtil.getSpaceGroupsFromCache(validSpace);
            if (spaceGroups != null) {
                reachedCacheSizeLimit = (spaceGroups = this.fSpaceGroupUtil.removeGlobalGroups(spaceGroups).toArray(new String[0])).length == this.fCacheManager.getCacheEntryGroupMaximum();
                data = new String[spaceGroups.length][];
                for (int i = 0; i < spaceGroups.length; ++i) {
                    data[i] = new String[]{spaceGroups[i]};
                }
            } else {
                LOG.error("Could not find spaceGroups using given SpaceKey:" + spaceKey);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            int totalRecords = this.fSpaceGroupUtil.getTotalGroupsCount(validSpace);
            int filteredRecords = this.fSpaceGroupUtil.getFilteredGroupsCount(validSpace, search);
            DataTableGroupList dataTableFormat = new DataTableGroupList(data, reachedCacheSizeLimit, draw, filteredRecords, totalRecords);
            response = Response.ok((Object)dataTableFormat).build();
        }
        catch (AuthorizationException e) {
            LOG.error(AuthenticatedUserThreadLocal.getUsername() + NOT_AUTHORIZED_FOR_THIS_ACTION, (Throwable)e);
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
        }
        return response;
    }

    @GET
    @RequiresXsrfCheck
    @Path(value="/groups/import")
    @Produces(value={"application/json"})
    public Response getSpaceGroupsForSpace(@Context HttpServletRequest hsr, @QueryParam(value="currentSpaceKey") String currentSpaceKey, @QueryParam(value="selectedSpace") String selectedSpaceKey, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        if (this.isUnauthorizedOrBadXsrfToken(hsr, currentSpaceKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Space currentSpace = this.getValidSpaceFromSpaceKey(currentSpaceKey);
        if (currentSpace == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Space selectedSpace = this.getValidSpaceFromSpaceKey(selectedSpaceKey);
        if (selectedSpace == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            String[] spaceGroups = this.fSpaceGroupUtil.getSpaceGroupsFromCache(selectedSpace);
            spaceGroups = this.fSpaceGroupUtil.removeGlobalGroups(spaceGroups).toArray(new String[0]);
            boolean reachedCacheSizeLimit = spaceGroups.length == this.fCacheManager.getCacheEntryGroupMaximum();
            String[][] data = new String[spaceGroups.length][];
            for (int i = 0; i < spaceGroups.length; ++i) {
                String members;
                Group group = this.fGm.getGroup(spaceGroups[i]);
                if (group != null) {
                    members = String.valueOf(this.fUserAccessor.getMemberNamesAsList(group).size());
                } else {
                    members = "Error fetching group info";
                    LOG.error("Error fetching groups members because the group could no be found in confluence");
                }
                data[i] = new String[]{spaceGroups[i], members};
            }
            DataTableGroupList dataTableFormat = new DataTableGroupList(data, reachedCacheSizeLimit);
            response = Response.ok((Object)dataTableFormat).build();
        }
        catch (AuthorizationException e) {
            LOG.error(AuthenticatedUserThreadLocal.getUsername() + NOT_AUTHORIZED_FOR_THIS_ACTION, (Throwable)e);
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
        }
        catch (Exception e) {
            LOG.error("There was an unexpected exception thrown trying to get groups for import for space: " + selectedSpaceKey, (Throwable)e);
            response = Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return response;
    }

    @GET
    @RequiresXsrfCheck
    @Path(value="/members")
    @Produces(value={"application/json"})
    public Response getGroupMembers(@Context HttpServletRequest hsr, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="spaceGroup") String spaceGroup, @QueryParam(value="atl_token") String atlToken, @QueryParam(value="highlightedGroup") String selectedGroup, @QueryParam(value="isUserProc") boolean isServerSideProcEnabled, @QueryParam(value="draw") int draw, @QueryParam(value="start") int offset, @QueryParam(value="length") int maxRows, @QueryParam(value="searchVal") String searchVal) {
        Response response;
        if (this.isUnauthorizedOrBadXsrfToken(hsr, spaceKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Space validSpace = this.getValidSpaceFromSpaceKey(spaceKey);
        if (validSpace == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            response = this.retrieveGroupMembers(spaceGroup, isServerSideProcEnabled, draw, offset, maxRows, searchVal, validSpace);
        }
        catch (EntityMissingException e) {
            LOG.error("Unable to get group or users for group: " + spaceGroup, (Throwable)e);
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
        }
        catch (EntityException e) {
            LOG.error("Unable to fetch group/users when getting group members for space group: " + spaceGroup, (Throwable)e);
            response = Response.serverError().entity((Object)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
        }
        catch (AuthorizationException e) {
            LOG.error(AuthenticatedUserThreadLocal.getUsername() + NOT_AUTHORIZED_FOR_THIS_ACTION, (Throwable)e);
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
        }
        catch (SpaceGroupPatternMismatchException e) {
            LOG.error("Problem with spacekey: " + spaceKey, (Throwable)e);
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
        }
        return response;
    }

    private Response retrieveGroupMembers(String spaceGroup, boolean isServerSideProcEnabled, int draw, int offset, int maxRows, String searchVal, Space aSpace) throws AuthorizationException, EntityException, SpaceGroupPatternMismatchException {
        Response response;
        if (this.serverSideGroupSelected(spaceGroup)) {
            List<User> memberList = isServerSideProcEnabled && maxRows > 0 ? this.fSpaceGroupUtil.getPagedSpaceGroupMembers(aSpace, spaceGroup, maxRows, offset, searchVal) : this.fSpaceGroupUtil.getSpaceGroupMembers(aSpace, spaceGroup);
            User[] arr = new User[memberList.size()];
            memberList.toArray(arr);
            int totalRecords = this.fSpaceGroupUtil.getTotalMembersCount(spaceGroup);
            int filteredRecords = this.fSpaceGroupUtil.getFilteredMembersCount(spaceGroup, searchVal);
            DataTableUserList dataTableFormat = new DataTableUserList(arr, this.fUserAccessor, this.fGm, this.fCacheManager, this.fGroupUtil, draw, totalRecords, filteredRecords);
            response = Response.ok((Object)dataTableFormat).build();
        } else {
            User[] arr = new User[]{};
            int filteredRecords = arr.length;
            int totalRecords = arr.length;
            DataTableUserList dataTableFormat = new DataTableUserList(arr, this.fUserAccessor, this.fGm, this.fCacheManager, this.fGroupUtil, draw, totalRecords, filteredRecords);
            response = Response.ok((Object)dataTableFormat).build();
        }
        return response;
    }

    @DELETE
    @RequiresXsrfCheck
    @Path(value="/member")
    @Produces(value={"application/json"})
    public Response removeUsersFromGroups(@Context HttpServletRequest hsr, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="spacegroups") String spaceGroups, @QueryParam(value="usernames") String spaceGroupMembers, @QueryParam(value="viamembership") String viaMembershipGroups, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        if (this.isUnauthorizedOrBadXsrfToken(hsr, spaceKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Space validSpace = this.getValidSpaceFromSpaceKey(spaceKey);
        if (validSpace == null) {
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)spaceKey).build();
        }
        if (spaceGroups == null || spaceGroupMembers == null && viaMembershipGroups == null) {
            LOG.error("Insufficient data: spaceKey=" + spaceKey + ", spaceGroups=" + spaceGroups + ", spaceGroupMembers=" + spaceGroupMembers + "}, viaMembershipGroups=" + viaMembershipGroups);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.fI18n.getText("space.not.found", new Serializable[]{spaceKey})).build();
        }
        try {
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            if (currentUser == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            List<String> failedToRemove = this.fSpaceGroupUtil.removeGroupMembers(validSpace, spaceGroups, spaceGroupMembers, viaMembershipGroups, currentUser);
            response = Response.ok(failedToRemove).build();
        }
        catch (AuthorizationException e) {
            LOG.error(AuthenticatedUserThreadLocal.getUsername() + NOT_AUTHORIZED_FOR_THIS_ACTION, (Throwable)e);
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (SpaceGroupPatternMismatchException e) {
            LOG.error("Problem with spacekey: " + spaceKey, (Throwable)e);
            response = Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
        }
        catch (EntityException e) {
            LOG.error("Could not find users/groups: " + spaceGroups + ", " + spaceGroupMembers, (Throwable)e);
            ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exceptionBean).build();
        }
        catch (Exception e) {
            LOG.error("Could not remove " + spaceGroupMembers + " from group: " + spaceGroups, (Throwable)e);
            ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
            response = Response.status((Response.Status)Response.Status.SEE_OTHER).entity((Object)exceptionBean).build();
        }
        return response;
    }

    @GET
    @RequiresXsrfCheck
    @Path(value="/search")
    @Produces(value={"application/json"})
    public Response searchForSpaceGroups(@Context HttpServletRequest hsr, @QueryParam(value="query") String query, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        if (this.isUnauthorizedOrBadXsrfToken(hsr, spaceKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Space aSpace = this.getValidSpaceFromSpaceKey(spaceKey);
        try {
            HashMap<String, HashSet<String>> result = new HashMap<String, HashSet<String>>();
            List<String> groupList = aSpace != null ? this.fSpaceGroupUtil.searchGroupCache(aSpace, query) : this.fSpaceGroupUtil.searchGroupsAvoidCache(query);
            String[] groupArr = new String[groupList.size()];
            groupList.toArray(groupArr);
            groupArr = this.fSpaceGroupUtil.removeGlobalGroups(groupArr).toArray(new String[0]);
            HashSet<String> finalGroups = new HashSet<String>(Arrays.asList(groupArr));
            result.put("groups", finalGroups);
            response = Response.ok(result).build();
        }
        catch (AuthorizationException e) {
            LOG.error(AuthenticatedUserThreadLocal.getUsername() + NOT_AUTHORIZED_FOR_THIS_ACTION, (Throwable)e);
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
        }
        catch (EntityException e) {
            LOG.error("Unable to get group with prefix: " + (query != null ? query : "null"), (Throwable)e);
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
        }
        return response;
    }

    @GET
    @RequiresXsrfCheck
    @Path(value="/searchall")
    @Produces(value={"application/json"})
    public Response searchAllGroups(@Context HttpServletRequest hsr, @DefaultValue(value="") @QueryParam(value="prefix") String groupPrefix, @QueryParam(value="spacekey") String spaceKey, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        if (this.isUnauthorizedOrBadXsrfToken(hsr, spaceKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            List<String> groupList = this.fSpaceGroupUtil.performGroupSearch(groupPrefix, 100);
            String[] groupArr = new String[groupList.size()];
            groupList.toArray(groupArr);
            groupArr = this.fSpaceGroupUtil.removeGlobalGroups(groupArr).toArray(new String[0]);
            HashSet<String> finalGroups = new HashSet<String>(Arrays.asList(groupArr));
            HashMap<String, HashSet<String>> result = new HashMap<String, HashSet<String>>();
            result.put("groups", finalGroups);
            response = Response.ok(result).build();
        }
        catch (EntityException e) {
            LOG.error("could not find group(s) with prefix: " + groupPrefix, (Throwable)e);
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)(((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getLocalizedMessage())).build();
        }
        catch (Exception e) {
            LOG.error("Error searching for group with search term: " + (groupPrefix != null ? groupPrefix : "null"), (Throwable)e);
            ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exceptionBean).build();
        }
        return response;
    }

    @PUT
    @RequiresXsrfCheck
    @Path(value="/addusers")
    @Produces(value={"application/json"})
    public Response addUsersToGroups(@Context HttpServletRequest hsr, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="spaceGroups") String spaceGroups, @FormParam(value="spaceUsers") String spaceUsers, @FormParam(value="importViaGroups") String importViaGroups, @QueryParam(value="atl_token") String atlToken) {
        Response response;
        if (this.isUnauthorizedOrBadXsrfToken(hsr, spaceKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.invalidPrefixAndSuffix()) {
            LOG.error("Neither the prefix or suffix is set in the CSUM config");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if ((spaceUsers == null || spaceUsers.trim().isEmpty()) && (importViaGroups == null || importViaGroups.trim().isEmpty()) || spaceGroups == null || spaceGroups.trim().isEmpty()) {
            LOG.error("No groups or users specified: spaceGroups=" + spaceGroups + ", importViaGroups = " + null + ", spaceUsers=" + null);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        Space validSpace = this.getValidSpaceFromSpaceKey(spaceKey);
        if (validSpace == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)spaceKey).build();
        }
        try {
            Pair<Map<String, String>, Map<String, String>> invalidUsersAndGroups = this.fSpaceGroupUtil.addUsersToGroups(validSpace, spaceGroups, spaceUsers, importViaGroups);
            response = Response.ok((Object)invalidUsersAndGroups.left()).build();
        }
        catch (AuthorizationException e) {
            LOG.error(AuthenticatedUserThreadLocal.getUsername() + NOT_AUTHORIZED_FOR_THIS_ACTION);
            ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
            response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)exceptionBean).build();
        }
        catch (EntityException e) {
            LOG.error("Unable to get group/user for : " + spaceGroups, (Throwable)e);
            ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
            response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exceptionBean).build();
        }
        catch (SpaceGroupPatternMismatchException e) {
            LOG.error(SPACE_KEY + spaceKey + IS_NOT_ASSOCIATED_WITH_GROUP, (Throwable)e);
            response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)spaceKey).build();
        }
        catch (Exception e) {
            LOG.error("Unhandled error when adding users: " + spaceUsers + " to groups: " + spaceGroups, (Throwable)e);
            ExceptionBean exceptionBean = new ExceptionBean(e, this.fPluginAccessor);
            response = Response.status((Response.Status)Response.Status.SEE_OTHER).entity((Object)exceptionBean).build();
        }
        return response;
    }

    @DELETE
    @RequiresXsrfCheck
    @Path(value="cache")
    @Produces(value={"application/json"})
    public Response clearSpaceCache(@Context HttpServletRequest hsr, @QueryParam(value="spaceKey") String spaceKey, @QueryParam(value="atl_token") String atlToken) {
        if (this.isUnauthorizedOrBadXsrfToken(hsr, spaceKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Space validSpace = this.getValidSpaceFromSpaceKey(spaceKey);
        if (validSpace == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        this.fCacheManager.deleteSpaceGroups(validSpace);
        return Response.ok().build();
    }

    private boolean serverSideGroupSelected(String spaceGroup) {
        return spaceGroup != null && !spaceGroup.equals("null");
    }

    private Space getValidSpaceFromSpaceKey(@QueryParam(value="spaceKey") String spaceKey) {
        Space validSpace = null;
        try {
            validSpace = this.getValidSpaceFromKey(spaceKey);
        }
        catch (InvalidSpaceException e) {
            LOG.error("Invalid Space, could not find Space using spacekey: " + spaceKey, (Throwable)e);
        }
        return validSpace;
    }
}

