/*
 * Decompiled with CFR 0.152.
 */
package com.pluginpeople.confluence.csum.ao.upgrades;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.ManagedCache;
import com.pluginpeople.confluence.csum.service.cache.CSUMConfigCacheEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V103KillOrphanedCachedConfig
implements ActiveObjectsUpgradeTask {
    static final Logger LOG = LoggerFactory.getLogger(V103KillOrphanedCachedConfig.class);
    static final ModelVersion VERSION = ModelVersion.valueOf((String)"103");
    private CacheManager fCacheMgr;

    public V103KillOrphanedCachedConfig(CacheManager cacheManager) {
        this.fCacheMgr = cacheManager;
    }

    public ModelVersion getModelVersion() {
        return VERSION;
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        if (currentVersion.isNewerThan(VERSION)) {
            return;
        }
        LOG.info("Checking for orphaned CSUM config cache");
        try {
            ManagedCache configCache = this.fCacheMgr.getManagedCache(CSUMConfigCacheEntry.class.getName() + ".cache");
            if (configCache != null) {
                LOG.info("Found orphaned CSUM config cache from previous installation, clearing");
                configCache.clear();
            }
        }
        catch (Exception e) {
            LOG.error("Upgrade problem: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

